/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.model.animator;

import com.iafenvoy.iceandfire.entity.SeaSerpentEntity;
import com.iafenvoy.iceandfire.render.model.animator.IceAndFireTabulaModelAnimator;
import com.iafenvoy.iceandfire.render.model.util.SeaSerpentAnimations;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import com.iafenvoy.uranus.client.model.AdvancedModelBox;
import com.iafenvoy.uranus.client.model.ITabulaModelAnimator;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.iafenvoy.uranus.client.model.util.TabulaModelHandlerHelper;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class SeaSerpentTabulaModelAnimator
extends IceAndFireTabulaModelAnimator<SeaSerpentEntity>
implements ITabulaModelAnimator<SeaSerpentEntity> {
    public final SeaSerpentAnimations[] swimPose = new SeaSerpentAnimations[]{SeaSerpentAnimations.SWIM1, SeaSerpentAnimations.SWIM3, SeaSerpentAnimations.SWIM4, SeaSerpentAnimations.SWIM6};

    public SeaSerpentTabulaModelAnimator() {
        super(SeaSerpentTabulaModelAnimator.resolve(SeaSerpentAnimations.T_POSE.getModelId()));
    }

    public void setRotationAngles(TabulaModel<SeaSerpentEntity> model, SeaSerpentEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        model.resetToDefaultPose();
        model.getCube((String)"BodyUpper").rotationPointY += 9.0f;
        model.animator.startAnimate((IAnimatedEntity)entity);
        this.animate(model, entity, limbSwing, limbSwingAmount, ageInTicks, rotationYaw, rotationPitch, scale);
        int currentIndex = entity.swimCycle / 10;
        int prevIndex = currentIndex - 1;
        if (prevIndex < 0) {
            prevIndex = 3;
        }
        TabulaModel<SeaSerpentEntity> prevPosition = SeaSerpentTabulaModelAnimator.resolve(this.swimPose[prevIndex].getModelId());
        TabulaModel<SeaSerpentEntity> currentPosition = SeaSerpentTabulaModelAnimator.resolve(this.swimPose[currentIndex].getModelId());
        if (prevPosition == null || currentPosition == null) {
            return;
        }
        float partialTicks = class_310.method_1551().method_60646().method_60637(false);
        float delta = (float)entity.swimCycle / 10.0f % 1.0f + partialTicks / 10.0f;
        for (AdvancedModelBox cube : model.getCubes().values()) {
            if (entity.jumpProgress > 0.0f && !this.isRotationEqual(cube, SeaSerpentTabulaModelAnimator.resolve(SeaSerpentAnimations.JUMPING2.getModelId()).getCube(cube.boxName))) {
                this.transitionTo(cube, SeaSerpentTabulaModelAnimator.resolve(SeaSerpentAnimations.JUMPING2.getModelId()).getCube(cube.boxName), entity.jumpProgress, 5.0f, false);
            }
            if (entity.wantJumpProgress > 0.0f && !this.isRotationEqual(cube, SeaSerpentTabulaModelAnimator.resolve(SeaSerpentAnimations.JUMPING1.getModelId()).getCube(cube.boxName))) {
                this.transitionTo(cube, SeaSerpentTabulaModelAnimator.resolve(SeaSerpentAnimations.JUMPING1.getModelId()).getCube(cube.boxName), entity.wantJumpProgress, 10.0f, false);
            }
            AdvancedModelBox prevPositionCube = prevPosition.getCube(cube.boxName);
            AdvancedModelBox currPositionCube = currentPosition.getCube(cube.boxName);
            float prevX = prevPositionCube.rotateAngleX;
            float prevY = prevPositionCube.rotateAngleY;
            float prevZ = prevPositionCube.rotateAngleZ;
            float x = currPositionCube.rotateAngleX;
            float y = currPositionCube.rotateAngleY;
            float z = currPositionCube.rotateAngleZ;
            this.addToRotateAngle(cube, limbSwingAmount, prevX + delta * this.distance(prevX, x), prevY + delta * this.distance(prevY, y), prevZ + delta * this.distance(prevZ, z));
        }
        if (entity.breathProgress > 0.0f) {
            this.progressRotation(model.getCube("Head"), entity.breathProgress, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
            this.progressRotation(model.getCube("HeadFront"), entity.breathProgress, (float)Math.toRadians(-20.0), 0.0f, 0.0f);
            this.progressRotation(model.getCube("Jaw"), entity.breathProgress, (float)Math.toRadians(60.0), 0.0f, 0.0f);
        }
        if (entity.jumpRot > 0.0f) {
            float jumpRot = entity.prevJumpRot + (entity.jumpRot - entity.prevJumpRot) * partialTicks;
            float turn = (float)entity.method_18798().field_1351 * -4.0f;
            model.getCube((String)"BodyUpper").rotateAngleX += (float)Math.toRadians(22.5f * turn) * jumpRot;
            model.getCube((String)"Tail1").rotateAngleX -= (float)Math.toRadians(turn) * jumpRot;
            model.getCube((String)"Tail2").rotateAngleX -= (float)Math.toRadians(turn) * jumpRot;
            model.getCube((String)"Tail3").rotateAngleX -= (float)Math.toRadians(turn) * jumpRot;
            model.getCube((String)"Tail4").rotateAngleX -= (float)Math.toRadians(turn) * jumpRot;
        }
        float prevRenderOffset = entity.field_6220 + (entity.field_6283 - entity.field_6220) * partialTicks;
        model.getCube((String)"Tail1").rotateAngleY += (entity.getPieceYaw(1, partialTicks) - prevRenderOffset) * ((float)Math.PI / 180);
        model.getCube((String)"Tail2").rotateAngleY += (entity.getPieceYaw(2, partialTicks) - prevRenderOffset) * ((float)Math.PI / 180);
        model.getCube((String)"Tail3").rotateAngleY += (entity.getPieceYaw(3, partialTicks) - prevRenderOffset) * ((float)Math.PI / 180);
        model.getCube((String)"Tail4").rotateAngleY += (entity.getPieceYaw(4, partialTicks) - prevRenderOffset) * ((float)Math.PI / 180);
        model.getCube((String)"BodyUpper").rotateAngleX -= rotationPitch * ((float)Math.PI / 180);
        if (!entity.isJumpingOutOfWater() || entity.method_5799()) {
            model.getCube((String)"Tail1").rotateAngleX -= (entity.getPiecePitch(1, partialTicks) - 0.0f) * ((float)Math.PI / 180);
            model.getCube((String)"Tail2").rotateAngleX -= (entity.getPiecePitch(2, partialTicks) - 0.0f) * ((float)Math.PI / 180);
            model.getCube((String)"Tail3").rotateAngleX -= (entity.getPiecePitch(3, partialTicks) - 0.0f) * ((float)Math.PI / 180);
            model.getCube((String)"Tail4").rotateAngleX -= (entity.getPiecePitch(4, partialTicks) - 0.0f) * ((float)Math.PI / 180);
        }
        model.animator.endAnimate();
    }

    public void progressRotation(AdvancedModelBox model, float progress, float rotX, float rotY, float rotZ) {
        model.rotateAngleX += progress * (rotX - model.defaultRotationX) / 20.0f;
        model.rotateAngleY += progress * (rotY - model.defaultRotationY) / 20.0f;
        model.rotateAngleZ += progress * (rotZ - model.defaultRotationZ) / 20.0f;
    }

    private void animate(TabulaModel<SeaSerpentEntity> model, SeaSerpentEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        if (model.animator.setAnimation(SeaSerpentEntity.ANIMATION_SPEAK)) {
            model.animator.startKeyframe(5);
            this.rotate(model.animator, model.getCube("Jaw"), 25.0f, 0.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.setStaticKeyframe(5);
            model.animator.resetKeyframe(5);
        }
        if (model.animator.setAnimation(SeaSerpentEntity.ANIMATION_BITE)) {
            model.animator.startKeyframe(5);
            this.moveToPose(model, SeaSerpentTabulaModelAnimator.resolve(SeaSerpentAnimations.BITE1.getModelId()));
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.moveToPose(model, SeaSerpentTabulaModelAnimator.resolve(SeaSerpentAnimations.BITE2.getModelId()));
            model.animator.endKeyframe();
            model.animator.setStaticKeyframe(2);
            model.animator.resetKeyframe(3);
        }
        if (model.animator.setAnimation(SeaSerpentEntity.ANIMATION_ROAR)) {
            model.animator.startKeyframe(10);
            this.moveToPose(model, SeaSerpentTabulaModelAnimator.resolve(SeaSerpentAnimations.ROAR1.getModelId()));
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, SeaSerpentTabulaModelAnimator.resolve(SeaSerpentAnimations.ROAR2.getModelId()));
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, SeaSerpentTabulaModelAnimator.resolve(SeaSerpentAnimations.ROAR3.getModelId()));
            model.animator.endKeyframe();
            model.animator.resetKeyframe(10);
        }
    }

    private static TabulaModel<SeaSerpentEntity> resolve(class_2960 id) {
        return TabulaModelHandlerHelper.getModel((class_2960)id);
    }
}

