/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.SirenEntity;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafStructurePieces;
import com.iafenvoy.iceandfire.registry.IafStructureTypes;
import com.iafenvoy.iceandfire.world.DangerousGeneration;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3532;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.minecraft.class_7151;

public class SirenIslandStructure
extends class_3195
implements DangerousGeneration {
    public static final MapCodec<SirenIslandStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SirenIslandStructure.method_42697((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, SirenIslandStructure::new));

    protected SirenIslandStructure(class_3195.class_7302 config) {
        super(config);
    }

    protected Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        if (context.comp_566().method_43058() >= (Double)IafCommonConfig.INSTANCE.worldGen.generateSirenIslandChance.getValue()) {
            return Optional.empty();
        }
        class_2470 blockRotation = class_2470.method_16548((class_5819)context.comp_566());
        class_2338 blockPos = this.method_42382(context, blockRotation);
        if (!this.isFarEnoughFromSpawn(blockPos)) {
            return Optional.empty();
        }
        return Optional.of(new class_3195.class_7150(blockPos, collector -> collector.method_35462((class_3443)new SirenIslandPiece(0, new class_3341(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260())))));
    }

    public class_7151<?> method_41618() {
        return (class_7151)IafStructureTypes.SIREN_ISLAND.get();
    }

    public static class SirenIslandPiece
    extends class_3443 {
        protected SirenIslandPiece(int length, class_3341 boundingBox) {
            super((class_3773)IafStructurePieces.SIREN_ISLAND.get(), length, boundingBox);
        }

        public SirenIslandPiece(class_6625 context, class_2487 nbt) {
            super((class_3773)IafStructurePieces.SIREN_ISLAND.get(), nbt);
        }

        protected void method_14943(class_6625 context, class_2487 nbt) {
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            class_2338 stonePos;
            float j;
            float i;
            if (!chunkBox.method_14662((class_2382)pivot)) {
                return;
            }
            int up = random.method_43048(4) + 1;
            class_2338 center = pivot.method_10086(up);
            int layer = 0;
            int sirens = 1 + random.method_43048(3);
            int radius = this.getRadius(up, up);
            this.field_15315 = new class_3341(center.method_10263() - radius, center.method_10264() - up, center.method_10260() - radius, center.method_10263() + radius, center.method_10264() + 1, center.method_10260() + radius);
            while (!world.method_8320(center).method_26225() && center.method_10264() >= world.method_31607()) {
                ++layer;
                for (i = 0.0f; i < (float)this.getRadius(layer, up); i += 0.5f) {
                    j = 0.0f;
                    while ((double)j < Math.PI * 2 * (double)i + (double)random.method_43048(2)) {
                        stonePos = class_2338.method_49637((double)Math.floor((float)center.method_10263() + class_3532.method_15374((float)j) * i + (float)random.method_43048(2)), (double)center.method_10264(), (double)Math.floor((float)center.method_10260() + class_3532.method_15362((float)j) * i + (float)random.method_43048(2)));
                        world.method_8652(stonePos, this.getStone(random), 3);
                        class_2338 upPos = stonePos.method_10084();
                        if (world.method_22347(upPos) && world.method_22347(upPos.method_10078()) && world.method_22347(upPos.method_10095()) && world.method_22347(upPos.method_10095().method_10078()) && random.method_43048(3) == 0 && sirens > 0) {
                            this.spawnSiren((class_5425)world, random, upPos.method_10095().method_10078());
                            --sirens;
                        }
                        j += 0.5f;
                    }
                }
                center = center.method_10074();
            }
            ++layer;
            for (i = 0.0f; i < (float)this.getRadius(layer, up); i += 0.5f) {
                j = 0.0f;
                while ((double)j < Math.PI * 2 * (double)i + (double)random.method_43048(2)) {
                    stonePos = class_2338.method_49637((double)Math.floor((float)center.method_10263() + class_3532.method_15374((float)j) * i + (float)random.method_43048(2)), (double)center.method_10264(), (double)Math.floor((float)center.method_10260() + class_3532.method_15362((float)j) * i + (float)random.method_43048(2)));
                    while (!world.method_8320(stonePos).method_26225() && stonePos.method_10264() >= 0) {
                        world.method_8652(stonePos, this.getStone(random), 3);
                        stonePos = stonePos.method_10074();
                    }
                    j += 0.5f;
                }
            }
        }

        private int getRadius(int layer, int up) {
            int MAX_ISLAND_RADIUS = 10;
            return layer > up ? (int)((double)layer * 0.25) + up : Math.min(layer, MAX_ISLAND_RADIUS);
        }

        private class_2680 getStone(class_5819 random) {
            int chance = random.method_43048(100);
            if (chance > 90) {
                return class_2246.field_9989.method_9564();
            }
            if (chance > 70) {
                return class_2246.field_10255.method_9564();
            }
            if (chance > 45) {
                return class_2246.field_10445.method_9564();
            }
            return class_2246.field_10340.method_9564();
        }

        private void spawnSiren(class_5425 worldIn, class_5819 rand, class_2338 position) {
            SirenEntity siren = new SirenEntity((class_1299<SirenEntity>)((class_1299)IafEntities.SIREN.get()), (class_1937)worldIn.method_8410());
            siren.setSinging(true);
            siren.setHairColor(rand.method_43048(2));
            siren.setSingingPose(rand.method_43048(2));
            siren.method_5641((double)position.method_10263() + 0.5, position.method_10264() + 1, (double)position.method_10260() + 0.5, rand.method_43057() * 360.0f, 0.0f);
            worldIn.method_8649((class_1297)siren);
        }
    }
}

