/*
 * Decompiled with CFR 0.152.
 */
package com.teampotato.potion_level_fix.datagen;

import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class ModLanguageProvider
extends LanguageProvider {
    public ModLanguageProvider(PackOutput output, String languages) {
        super(output, "potion_level_fix", languages);
    }

    public String intToRoman(int num) {
        String[] roman = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        int[] nums = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < nums.length && num >= 0; ++i) {
            while (nums[i] <= num) {
                num -= nums[i];
                res.append(roman[i]);
            }
        }
        return res.toString();
    }

    protected void addTranslations() {
        for (int i = 11; i <= 4000; ++i) {
            this.add("enchantment.level." + i, this.intToRoman(i));
            this.add("potion.potency." + i, this.intToRoman(i));
        }
    }
}

