/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.editor;

import cx.rain.mc.nbtedit.editor.NbtTree;
import cx.rain.mc.nbtedit.editor.TagReadingHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AccessibilityHelper {
    private static Minecraft getMinecraft() {
        return Minecraft.getInstance();
    }

    public static Component buildText(NbtTree.Node<?> node) {
        return Component.literal((String)node.getAsString());
    }

    public static Component buildNarration(NbtTree.Node<?> node) {
        return Component.translatable((String)"gui.nbtedit.title.tree_view_node.narration", (Object[])new Object[]{node.getAsString()});
    }

    @Nullable
    public static Tooltip buildTooltip(Player player, NbtTree.Node<?> node) {
        Object tag = node.getTag();
        boolean showPreview = false;
        String previewTitle = "";
        String previewNarrationTitle = "";
        MutableComponent previewContent = Component.empty();
        ItemStack item = TagReadingHelper.tryReadItem(player, tag);
        if (item != null) {
            showPreview = true;
            previewTitle = "gui.nbtedit.tooltip.preview_item";
            previewNarrationTitle = "gui.nbtedit.tooltip.preview_item.narration";
            List lines = item.getTooltipLines(Item.TooltipContext.of((Level)player.level()), player, (TooltipFlag)TooltipFlag.ADVANCED);
            for (int i = 0; i < lines.size(); ++i) {
                previewContent.append((Component)lines.get(i));
                if (i == lines.size() - 1) continue;
                previewContent.append("\n");
            }
        }
        UUID uuid = TagReadingHelper.tryReadUuid(tag);
        if (!showPreview && uuid != null) {
            showPreview = true;
            previewTitle = "gui.nbtedit.tooltip.preview_uuid";
            previewNarrationTitle = "gui.nbtedit.tooltip.preview_uuid.narration";
            previewContent.append(uuid.toString());
        }
        Component text = TagReadingHelper.tryReadText(player, tag);
        if (!showPreview && text != null) {
            showPreview = true;
            previewTitle = "gui.nbtedit.tooltip.preview_component";
            previewNarrationTitle = "gui.nbtedit.tooltip.preview_component.narration";
            previewContent.append(text);
        }
        if (showPreview) {
            MutableComponent preview = Component.translatable((String)previewTitle).append((Component)Component.literal((String)"\n").withStyle(ChatFormatting.RESET).append((Component)previewContent));
            MutableComponent previewNarration = Component.translatable((String)previewNarrationTitle).append((Component)Component.literal((String)"\n").withStyle(ChatFormatting.RESET).append((Component)previewContent));
            return Tooltip.create((Component)preview, (Component)previewNarration);
        }
        return null;
    }
}

