/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.fabric.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cx.rain.mc.nbtedit.api.command.ModPermissions;
import cx.rain.mc.nbtedit.api.config.IModConfig;
import cx.rain.mc.nbtedit.fabric.config.ConfigBean;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;

public class ModConfigImpl
implements IModConfig {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected File configDir;
    protected File configFile;
    protected ConfigBean config = new ConfigBean();

    public ModConfigImpl(File gameDir) {
        this.configDir = new File(gameDir, "config");
        this.configFile = new File(this.configDir, "nbtedit.json");
        if (!this.configDir.exists()) {
            this.configDir.mkdirs();
        }
        this.loadConfig();
    }

    private void loadConfig() {
        if (this.configFile.exists()) {
            try {
                this.config = (ConfigBean)GSON.fromJson(Files.readString(this.configFile.toPath()), ConfigBean.class);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.saveConfig();
    }

    private void saveConfig() {
        try {
            String json = GSON.toJson((Object)this.config);
            Files.writeString(this.configFile.toPath(), (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean isDebug() {
        return this.config.debug;
    }

    public Map<String, Integer> getPermissionsLevel() {
        return this.config.permissionsLevels;
    }

    public int getPermissionsLevel(ModPermissions permission) {
        return this.config.permissionsLevels.getOrDefault(permission.getName(), permission.getDefaultLevel());
    }
}

