/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.editor;

import com.mojang.serialization.DynamicOps;
import cx.rain.mc.nbtedit.NBTEdit;
import cx.rain.mc.nbtedit.editor.tag.TagParseHelper;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class TagReadingHelper {
    @Nullable
    public static ItemStack tryReadItem(Player player, @Nullable Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            try {
                ItemStack itemStack;
                Optional optional = ItemStack.CODEC.parse((DynamicOps)player.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compoundTag).result();
                if (optional.isPresent() && !(itemStack = (ItemStack)optional.get()).isEmpty()) {
                    return itemStack;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static UUID tryReadUuid(@Nullable Tag tag) {
        if (tag instanceof IntArrayTag) {
            IntArrayTag intArrayTag = (IntArrayTag)tag;
            try {
                return TagParseHelper.loadUuid((Tag)intArrayTag);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static Component tryReadText(Player player, @Nullable Tag tag) {
        if (tag instanceof StringTag) {
            StringTag stringTag = (StringTag)tag;
            return stringTag.asString().flatMap(s -> NBTEdit.getInstance().getRegistryContextSerializer().deserializeComponent((String)s)).orElse(null);
        }
        return null;
    }
}

