/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.gui.editor;

import cx.rain.mc.nbtedit.editor.AccessibilityHelper;
import cx.rain.mc.nbtedit.editor.EditorButton;
import cx.rain.mc.nbtedit.editor.NbtTree;
import cx.rain.mc.nbtedit.gui.component.AbstractComponent;
import cx.rain.mc.nbtedit.gui.editor.NbtTreeView;
import java.time.Duration;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class NbtTreeViewNode
extends AbstractComponent {
    public static final ResourceLocation WIDGET_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"textures/gui/widgets.png");
    public static final ResourceLocation ARROW_RIGHT = ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"editor/arrow_right");
    public static final ResourceLocation ARROW_DOWN = ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"editor/arrow_down");
    public static final ResourceLocation ARROW_RIGHT_HIGHLIGHTED = ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"editor/arrow_right_highlighted");
    public static final ResourceLocation ARROW_DOWN_HIGHLIGHTED = ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"editor/arrow_down_highlighted");
    private final NbtTreeView treeView;
    private final NbtTree.Node<?> node;

    public NbtTreeViewNode(int x, int y, NbtTree.Node<?> node, @NotNull NbtTreeView parent) {
        Objects.requireNonNull(Minecraft.getInstance().font);
        super(x, y, 0, 9, (Component)Component.empty());
        this.treeView = parent;
        this.node = node;
        this.setMessage(AccessibilityHelper.buildText(node));
        this.setWidth(this.getMinecraft().font.width((FormattedText)this.getMessage()) + 12);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setTooltip(AccessibilityHelper.buildTooltip((Player)this.getMinecraft().player, this.node));
        this.setTooltipDelay(Duration.ofMillis(200L));
    }

    @Override
    public NbtTreeView getParent() {
        return this.treeView;
    }

    public NbtTree.Node<?> getNode() {
        return this.node;
    }

    public boolean isMouseInsideText(double mouseX, double mouseY) {
        return mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX < (double)(this.getX() + this.getWidth()) && mouseY < (double)(this.getY() + this.getHeight());
    }

    public boolean isMouseInsideSpoiler(double mouseX, double mouseY) {
        return mouseX >= (double)(this.getX() - 9) && mouseY >= (double)this.getY() && mouseX < (double)this.getX() && mouseY < (double)(this.getY() + this.getHeight());
    }

    protected void updateWidgetNarration(NarrationElementOutput narration) {
        narration.add(NarratedElementType.TITLE, AccessibilityHelper.buildNarration(this.node));
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int color;
        boolean isSelected = this.getParent().getFocusedNode() != null && this.getParent().getFocusedNode() == this.getNode();
        boolean isTextHover = this.isMouseInsideText(mouseX, mouseY);
        boolean isSpoilerHover = this.isMouseInsideSpoiler(mouseX, mouseY);
        int n = isSelected ? -2039584 : (isTextHover ? -96 : (color = this.node.hasParent() ? -2039584 : -6250336));
        if (isSelected) {
            graphics.fill(this.getX() + 11, this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), Integer.MIN_VALUE);
        }
        ResourceLocation arrowSprite = this.node.shouldShowChildren() ? (isSpoilerHover ? ARROW_DOWN_HIGHLIGHTED : ARROW_DOWN) : (isSpoilerHover ? ARROW_RIGHT_HIGHLIGHTED : ARROW_RIGHT);
        if (this.node.hasChild()) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, arrowSprite, this.getX() - 9, this.getY(), 9, this.getHeight());
        }
        ResourceLocation tagSprite = EditorButton.ofTag(this.node.getTag()).getSprite();
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, tagSprite, this.getX() + 1, this.getY(), 9, this.getHeight());
        graphics.drawString(this.getMinecraft().font, this.getMessage(), this.getX() + 11, this.getY() + (this.getHeight() - 8) / 2, color);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.active && this.visible && (this.isMouseInsideText(mouseX, mouseY) || this.isMouseInsideSpoiler(mouseX, mouseY));
    }

    public void onClick(MouseButtonEvent event, boolean isDoubleClick) {
        if (this.isMouseInsideSpoiler(event.x(), event.y())) {
            this.node.setShowChildren(!this.node.shouldShowChildren());
            this.getParent().update(true);
        }
        if (this.isMouseInsideText(event.x(), event.y())) {
            this.getParent().setFocused(this);
            this.getParent().update(true);
        }
        super.onClick(event, isDoubleClick);
    }
}

