/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.editor;

import cx.rain.mc.nbtedit.editor.NbtTree;
import cx.rain.mc.nbtedit.editor.tag.TagParseHelper;
import java.util.Locale;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2489;
import net.minecraft.class_2491;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class NodeParser {
    public static String valueAsString(NbtTree.Node<?> node) {
        Object tag = node.getTag();
        return TagParseHelper.getValueAsString(tag);
    }

    public static <T extends class_2520> class_2520 getTag(NbtTree.Node<T> node, String value) {
        T tag = node.getTag();
        try {
            if (tag instanceof class_2481) {
                return class_2481.method_23233((byte)NodeParser.parseByte(value));
            }
            if (tag instanceof class_2516) {
                return class_2516.method_23254((short)NodeParser.parseShort(value));
            }
            if (tag instanceof class_2497) {
                return class_2497.method_23247((int)NodeParser.parseInt(value));
            }
            if (tag instanceof class_2503) {
                return class_2503.method_23251((long)NodeParser.parseLong(value));
            }
            if (tag instanceof class_2494) {
                return class_2494.method_23244((float)NodeParser.parseFloat(value));
            }
            if (tag instanceof class_2489) {
                return class_2489.method_23241((double)NodeParser.parseDouble(value));
            }
            if (tag instanceof class_2479) {
                return new class_2479(NodeParser.parseByteArray(value));
            }
            if (tag instanceof class_2495) {
                return new class_2495(NodeParser.parseIntArray(value));
            }
            if (tag instanceof class_2501) {
                return new class_2501(NodeParser.parseLongArray(value));
            }
            if (tag instanceof class_2519) {
                return class_2519.method_23256((String)value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return class_2491.field_21033;
    }

    public static byte parseByte(String s) {
        try {
            String c = s.toLowerCase(Locale.ROOT);
            if (c.endsWith("b")) {
                c = c.substring(0, c.length() - 1);
            }
            return Byte.parseByte(c);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static short parseShort(String s) {
        try {
            String c = s.toLowerCase(Locale.ROOT);
            if (c.endsWith("s")) {
                c = c.substring(0, c.length() - 1);
            }
            return Short.parseShort(c);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long parseLong(String s) {
        try {
            String c = s.toLowerCase(Locale.ROOT);
            if (c.endsWith("l")) {
                c = c.substring(0, c.length() - 1);
            }
            return Long.parseLong(c);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static float parseFloat(String s) {
        try {
            String c = s.toLowerCase(Locale.ROOT);
            if (c.endsWith("f")) {
                c = c.substring(0, c.length() - 1);
            }
            return Float.parseFloat(c);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static double parseDouble(String s) {
        try {
            String c = s.toLowerCase(Locale.ROOT);
            if (c.endsWith("d")) {
                c = c.substring(0, c.length() - 1);
            }
            return Double.parseDouble(c);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static byte[] parseByteArray(String s) {
        try {
            String[] input = s.split(",");
            byte[] arr = new byte[input.length];
            for (int i = 0; i < input.length; ++i) {
                String c = input[i].toLowerCase(Locale.ROOT).strip();
                if (c.endsWith("b")) {
                    c = c.substring(0, c.length() - 1);
                }
                arr[i] = NodeParser.parseByte(c);
            }
            return arr;
        }
        catch (NumberFormatException e) {
            return new byte[]{0};
        }
    }

    public static int[] parseIntArray(String s) {
        try {
            String[] input = s.split(",");
            int[] arr = new int[input.length];
            for (int i = 0; i < input.length; ++i) {
                String c = input[i].strip();
                arr[i] = NodeParser.parseInt(c);
            }
            return arr;
        }
        catch (NumberFormatException e) {
            return new int[]{0};
        }
    }

    public static long[] parseLongArray(String s) throws NumberFormatException {
        try {
            String[] input = s.split(",");
            long[] arr = new long[input.length];
            for (int i = 0; i < input.length; ++i) {
                String c = input[i].toLowerCase(Locale.ROOT).strip();
                if (c.endsWith("l")) {
                    c = c.substring(0, c.length() - 1);
                }
                arr[i] = NodeParser.parseInt(c);
            }
            return arr;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Not a valid long array");
        }
    }
}

