/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.gui.editor;

import cx.rain.mc.nbtedit.editor.NbtTree;
import cx.rain.mc.nbtedit.editor.NodeParser;
import cx.rain.mc.nbtedit.editor.TagReadingHelper;
import cx.rain.mc.nbtedit.editor.tag.TagParseHelper;
import cx.rain.mc.nbtedit.gui.component.ButtonComponent;
import cx.rain.mc.nbtedit.gui.component.EditBoxComponent;
import cx.rain.mc.nbtedit.gui.component.IComposedComponent;
import cx.rain.mc.nbtedit.gui.window.AbstractWindow;
import cx.rain.mc.nbtedit.gui.window.IWindowHolder;
import java.util.UUID;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_6381;
import net.minecraft.class_6382;

public class EditingWindow
extends AbstractWindow {
    public static final class_2960 TEXTURE = class_2960.method_60655((String)"nbtedit", (String)"window");
    public static final int WIDTH = 178;
    public static final int HEIGHT = 93;
    private final NbtTree.Node<?> node;
    private final boolean nameEditable;
    private final boolean valueEditable;
    private EditBoxComponent nameField;
    private EditBoxComponent valueField;
    private boolean parseAsUuid = false;

    public EditingWindow(int x, int y, NbtTree.Node<?> node, boolean nameEditable, boolean valueEditable) {
        super(x, y, 178, 93, (class_2561)class_2561.method_43471((String)"gui.nbtedit.title.editing_window"));
        this.node = node;
        this.nameEditable = nameEditable;
        this.valueEditable = valueEditable;
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (this.nameEditable && this.nameField != null) {
            this.nameField.method_25393();
        }
        if (this.valueEditable && this.valueField != null) {
            this.valueField.method_25393();
        }
    }

    @Override
    protected void createChildren() {
        String name = this.nameField == null ? this.node.getName() : this.nameField.method_1882();
        String value = this.valueField == null ? NodeParser.valueAsString(this.node) : this.valueField.method_1882();
        UUID uuid = TagReadingHelper.tryReadUuid(this.node.getTag());
        if (uuid != null) {
            value = uuid.toString();
            this.parseAsUuid = true;
        }
        this.clearChildren();
        this.nameField = new EditBoxComponent(this.getMinecraft().field_1772, this.method_46426() + 47, this.method_46427() + 20, 116, 15, (class_2561)class_2561.method_43471((String)"gui.nbtedit.edit_box.name"));
        this.nameField.method_1880(Integer.MAX_VALUE);
        this.nameField.method_1852(name);
        this.nameField.method_1888(this.nameEditable);
        this.nameField.field_22763 = this.nameEditable;
        this.nameField.method_1858(false);
        this.addChild(this.nameField);
        this.valueField = new EditBoxComponent(this.getMinecraft().field_1772, this.method_46426() + 47, this.method_46427() + 46, 116, 15, (class_2561)class_2561.method_43471((String)"gui.nbtedit.edit_box.value"));
        this.valueField.method_1880(Integer.MAX_VALUE);
        this.valueField.method_1852(value);
        this.valueField.method_1888(this.valueEditable);
        this.valueField.field_22763 = this.valueEditable;
        this.valueField.method_1858(false);
        this.addChild(this.valueField);
        ButtonComponent saveButton = ButtonComponent.getBuilder((class_2561)class_2561.method_43471((String)"gui.nbtedit.button.ok"), b -> this.onOk()).pos(this.method_46426() + 9, this.method_46427() + 62).size(75, 20).createNarration(n -> class_2561.method_43471((String)"gui.nbtedit.tooltip.button_ok")).build();
        this.addChild(saveButton);
        ButtonComponent cancelButton = ButtonComponent.getBuilder((class_2561)class_2561.method_43471((String)"gui.nbtedit.button.cancel"), b -> this.onCancel()).pos(this.method_46426() + 93, this.method_46427() + 62).size(75, 20).createNarration(n -> class_2561.method_43471((String)"gui.nbtedit.tooltip.button_cancel")).build();
        this.addChild(cancelButton);
    }

    private void onOk() {
        if (this.nameEditable) {
            this.node.setName(this.nameField.method_1882());
        }
        if (this.valueEditable) {
            if (this.parseAsUuid) {
                try {
                    UUID uuid = UUID.fromString(this.valueField.method_1882());
                    this.node.setTag(TagParseHelper.createUuid(uuid));
                }
                catch (Exception exception) {}
            } else {
                this.node.setTag(NodeParser.getTag(this.node, this.valueField.method_1882()));
            }
        }
        this.onCancel();
    }

    private void onCancel() {
        if (this.getParent() != null) {
            this.getParent().update();
            IComposedComponent iComposedComponent = this.getParent();
            if (iComposedComponent instanceof IWindowHolder) {
                IWindowHolder holder = (IWindowHolder)iComposedComponent;
                holder.closeWindow(this);
            }
        }
    }

    @Override
    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.method_52706(class_1921::method_62277, TEXTURE, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        if (!this.nameEditable) {
            guiGraphics.method_25294(this.method_46426() + 43, this.method_46427() + 16, this.method_46426() + 170, this.method_46427() + 31, Integer.MIN_VALUE);
        }
        if (!this.valueEditable) {
            guiGraphics.method_25294(this.method_46426() + 43, this.method_46427() + 43, this.method_46426() + 170, this.method_46427() + 59, Integer.MIN_VALUE);
        }
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43471((String)"gui.nbtedit.title.editing_window.narration"));
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onCancel();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }
}

