/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.gui.screen;

import cx.rain.mc.nbtedit.gui.component.AbstractComposedComponent;
import cx.rain.mc.nbtedit.gui.component.IComponent;
import cx.rain.mc.nbtedit.gui.component.IComposedComponent;
import cx.rain.mc.nbtedit.gui.window.IWindow;
import cx.rain.mc.nbtedit.gui.window.IWindowHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractScreen
extends class_437
implements IWindowHolder {
    private final Map<IWindow, Boolean> windows = new HashMap<IWindow, Boolean>();
    @Nullable
    private IWindow mutexWindow = null;
    @Nullable
    private IWindow focusedWindow = null;
    private final List<IComponent> children = new ArrayList<IComponent>();

    protected AbstractScreen(class_2561 title) {
        super(title);
    }

    @Override
    public AbstractComposedComponent getParent() {
        return null;
    }

    @Override
    public void setParent(@Nullable IComposedComponent parent) {
        throw new RuntimeException(new OperationNotSupportedException());
    }

    public void method_46421(int x) {
        throw new RuntimeException(new OperationNotSupportedException());
    }

    public void method_46419(int y) {
        throw new RuntimeException(new OperationNotSupportedException());
    }

    public int method_46426() {
        return 0;
    }

    public int method_46427() {
        return 0;
    }

    public int method_25368() {
        return this.field_22789;
    }

    public int method_25364() {
        return this.field_22790;
    }

    @Override
    public boolean method_49606() {
        return true;
    }

    @Override
    @NotNull
    public List<IWindow> getWindows() {
        return List.copyOf(this.windows.keySet());
    }

    @Override
    public void addWindow(@NotNull IWindow window, boolean mutex, boolean show) {
        this.addChild(window);
        this.windows.put(window, false);
        window.onOpen();
        if (mutex) {
            if (!this.hasMutexWindow()) {
                this.setMutexWindow(window);
            } else {
                throw new IllegalStateException();
            }
        }
        if (show) {
            this.show(window);
        }
    }

    @Override
    public void closeWindow(@NotNull IWindow window) {
        if (this.getMutexWindow() == window) {
            this.setMutexWindow(null);
        }
        if (this.getFocusedWindow() == window) {
            this.setFocusedWindow(null);
        }
        this.removeChild(window);
        this.windows.remove(window);
        window.onClose();
    }

    @Override
    public void show(@NotNull IWindow window) {
        if (!this.windows.get(window).booleanValue()) {
            this.windows.put(window, true);
            window.onShown();
        }
    }

    @Override
    public void hide(@NotNull IWindow window) {
        if (this.windows.get(window).booleanValue() && this.getMutexWindow() != window) {
            this.windows.put(window, false);
            window.onHidden();
        }
    }

    @Override
    @Nullable
    public IWindow getMutexWindow() {
        return this.mutexWindow;
    }

    @Override
    public void setMutexWindow(@Nullable IWindow window) {
        if (window != null && this.hasWindow(window)) {
            this.setFocusedWindow(window);
            this.mutexWindow = window;
        } else {
            this.mutexWindow = null;
        }
    }

    @Override
    @Nullable
    public IWindow getFocusedWindow() {
        return this.focusedWindow;
    }

    @Override
    public void setFocusedWindow(@Nullable IWindow window) {
        if (this.hasMutexWindow()) {
            this.method_25395(this.getMutexWindow());
            return;
        }
        this.method_25395(window);
        for (IWindow w : this.getWindows()) {
            w.method_25365(w == window);
        }
    }

    public void method_25395(@Nullable class_364 focused) {
        IWindow window;
        super.method_25395(focused);
        this.focusedWindow = focused instanceof IWindow ? (window = (IWindow)focused) : null;
    }

    @Override
    public void addChild(@NotNull IComponent child) {
        this.children.add(child);
        child.setParent(this);
        this.method_37063(child);
    }

    @Override
    public void removeChild(@NotNull IComponent child) {
        this.children.remove(child);
        child.setParent(null);
        this.method_37066(child);
    }

    @Override
    public List<IComponent> getChildren() {
        return List.copyOf(this.children);
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        return List.copyOf(this.getChildren());
    }

    protected void method_41843() {
        this.unInitialize();
        super.method_41843();
    }

    protected void method_25426() {
        super.method_25426();
        this.initialize();
    }

    @Override
    public void method_25393() {
        for (IComponent c : this.getChildren()) {
            c.method_25393();
        }
        super.method_25393();
    }

    protected abstract void createChildren();

    @Override
    public final void initialize() {
        this.createChildren();
        for (IComponent child : this.getChildren()) {
            child.initialize();
        }
    }

    @Override
    public void unInitialize() {
        for (IComponent child : this.getChildren()) {
            child.unInitialize();
        }
        this.closeWindows();
        this.clearChildren();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int maskedMouseX = this.hasMutexWindow() ? -1 : mouseX;
        int maskedMouseY = this.hasMutexWindow() ? -1 : mouseY;
        this.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_27534(this.field_22787.field_1772, this.field_22785, this.field_22789 / 2, 4, 0xFFFFFF);
        for (IComponent c : this.getChildren()) {
            if (c instanceof IWindow) continue;
            c.method_25394(guiGraphics, maskedMouseX, maskedMouseY, partialTick);
        }
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 500.0f);
        if (this.hasWindow()) {
            AbstractScreen.drawGrayishBackground(guiGraphics);
        }
        for (IWindow w : this.getWindows()) {
            if (w == this.getMutexWindow()) continue;
            w.method_25394(guiGraphics, maskedMouseX, maskedMouseY, partialTick);
        }
        if (this.hasMutexWindow()) {
            this.getMutexWindow().method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        guiGraphics.method_51448().method_22909();
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.hasMutexWindow()) {
            assert (this.getMutexWindow() != null);
            return this.getMutexWindow().method_25402(mouseX, mouseY, button);
        }
        return IWindowHolder.super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.hasMutexWindow()) {
            assert (this.getMutexWindow() != null);
            return this.getMutexWindow().method_25406(mouseX, mouseY, button);
        }
        return IWindowHolder.super.method_25406(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.hasMutexWindow()) {
            assert (this.getMutexWindow() != null);
            return this.getMutexWindow().method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        return IWindowHolder.super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.hasMutexWindow()) {
            assert (this.getMutexWindow() != null);
            return this.getMutexWindow().method_25401(mouseX, mouseY, scrollX, scrollY);
        }
        return IWindowHolder.super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.hasMutexWindow()) {
            assert (this.getMutexWindow() != null);
            return this.getMutexWindow().method_25404(keyCode, scanCode, modifiers);
        }
        return IWindowHolder.super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.hasMutexWindow()) {
            assert (this.getMutexWindow() != null);
            return this.getMutexWindow().method_16803(keyCode, scanCode, modifiers);
        }
        return IWindowHolder.super.method_16803(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_25400(char codePoint, int modifiers) {
        if (this.hasMutexWindow()) {
            assert (this.getMutexWindow() != null);
            return this.getMutexWindow().method_25400(codePoint, modifiers);
        }
        return IWindowHolder.super.method_25400(codePoint, modifiers);
    }

    public static void drawGrayishBackground(class_332 guiGraphics) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_23760().method_23761().translate(0.0f, 0.0f, -1.0f);
        guiGraphics.method_25296(0, 0, guiGraphics.method_51421(), guiGraphics.method_51443(), -1072689136, -804253680);
        guiGraphics.method_51448().method_23760().method_23761().translate(0.0f, 0.0f, 1.0f);
        guiGraphics.method_51448().method_22909();
    }
}

