/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.networking;

import cx.rain.mc.nbtedit.NBTEdit;
import cx.rain.mc.nbtedit.networking.NetworkEditingHelper;
import cx.rain.mc.nbtedit.networking.NetworkingHelper;
import cx.rain.mc.nbtedit.networking.packet.c2s.BlockEntityRaytraceResultPacket;
import cx.rain.mc.nbtedit.networking.packet.c2s.EntityRaytraceResultPacket;
import cx.rain.mc.nbtedit.networking.packet.c2s.ItemStackRaytraceResultPacket;
import cx.rain.mc.nbtedit.networking.packet.common.BlockEntityEditingPacket;
import cx.rain.mc.nbtedit.networking.packet.common.EntityEditingPacket;
import cx.rain.mc.nbtedit.networking.packet.common.ItemStackEditingPacket;
import cx.rain.mc.nbtedit.utility.LoggingHelper;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2748;
import net.minecraft.class_2749;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class NetworkServerHandler {
    public static void handleBlockEntityResult(class_3222 player, BlockEntityRaytraceResultPacket packet) {
        NetworkEditingHelper.editBlockEntity(player, packet.pos());
    }

    public static void handleEntityResult(class_3222 player, EntityRaytraceResultPacket packet) {
        NetworkEditingHelper.editEntity(player, packet.uuid());
    }

    public static void handleItemStackResult(class_3222 player, ItemStackRaytraceResultPacket packet) {
        NetworkEditingHelper.editItemStack(player, packet.itemStack());
    }

    public static void saveBlockEntity(class_3222 player, BlockEntityEditingPacket packet) {
        if (!NetworkingHelper.checkWritePermission(player)) {
            return;
        }
        class_2338 pos = packet.pos();
        if (!NetworkingHelper.checkPosLoaded(player, pos)) {
            return;
        }
        class_2487 tag = packet.tag();
        MinecraftServer server = player.method_5682();
        class_3218 level = player.method_51469();
        server.execute(() -> {
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity != null) {
                try {
                    blockEntity.method_58690(tag, (class_7225.class_7874)server.method_30611());
                    blockEntity.method_5431();
                    if (blockEntity.method_11002() && blockEntity.method_10997() instanceof class_3218) {
                        ((class_3218)blockEntity.method_10997()).method_14178().method_14128(pos);
                    }
                    NBTEdit.getInstance().getLogger().info("Player {} successfully edited the tag of a BlockEntity at {} {} {}.", new Object[]{player.method_5477().getString(), pos.method_10263(), pos.method_10264(), pos.method_10260()});
                    LoggingHelper.debugBlockEntityTag(pos, (class_2520)tag);
                    player.method_64398((class_2561)class_2561.method_43471((String)"message.nbtedit.saved.successful").method_27692(class_124.field_1060));
                }
                catch (Exception ex) {
                    player.method_64398((class_2561)class_2561.method_43471((String)"message.nbtedit.saving.failed.invalid_nbt").method_27692(class_124.field_1061));
                    NBTEdit.getInstance().getLogger().error("Player {} edited the tag of BlockEntity at XYZ {} {} {} and caused an exception!", new Object[]{player.method_5477().getString(), pos.method_10263(), pos.method_10264(), pos.method_10260()});
                    LoggingHelper.errorParsingTag(ex, (class_2520)tag);
                }
            } else {
                NBTEdit.getInstance().getLogger().info("Player {} tried to edit a non-existent BlockEntity at {} {} {}.", new Object[]{player.method_5477(), pos.method_10263(), pos.method_10264(), pos.method_10260()});
                player.method_64398((class_2561)class_2561.method_43471((String)"message.nbtedit.saving.failed.block_entity_not_exists").method_27692(class_124.field_1061));
            }
        });
    }

    public static void saveEntity(class_3222 player, EntityEditingPacket packet) {
        if (!NetworkingHelper.checkWritePermission(player)) {
            return;
        }
        class_2487 tag = packet.tag();
        UUID entityUuid = packet.uuid();
        MinecraftServer server = player.method_5682();
        class_3218 level = player.method_51469();
        server.execute(() -> {
            class_1297 entity = level.method_66347(entityUuid);
            if (entity != null) {
                if (entity instanceof class_1657 && entity != player && !NetworkingHelper.checkEditOnPlayerPermission(player)) {
                    NBTEdit.getInstance().getLogger().info("Player {} tried to use nbtedit on a player which is not allowed", (Object)player.method_5477().getString());
                    return;
                }
                try {
                    class_1934 prevGameMode = null;
                    if (entity instanceof class_3222) {
                        prevGameMode = ((class_3222)entity).field_13974.method_14257();
                    }
                    entity.method_5651(tag);
                    NBTEdit.getInstance().getLogger().info("Player {} edited the tag of Entity with UUID {} .", (Object)player.method_5477().getString(), (Object)entityUuid);
                    LoggingHelper.debugEntityTag(entityUuid, (class_2520)tag);
                    if (entity instanceof class_3222) {
                        class_3222 targetPlayer = (class_3222)entity;
                        targetPlayer.method_14235((class_1703)targetPlayer.field_7498);
                        class_1934 gameMode = targetPlayer.field_13974.method_14257();
                        if (prevGameMode != gameMode) {
                            targetPlayer.method_7336(gameMode);
                        }
                        targetPlayer.field_13987.method_14364((class_2596)new class_2749(targetPlayer.method_6032(), targetPlayer.method_7344().method_7586(), targetPlayer.method_7344().method_7589()));
                        targetPlayer.field_13987.method_14364((class_2596)new class_2748(targetPlayer.field_7510, targetPlayer.field_7495, targetPlayer.field_7520));
                        targetPlayer.method_7355();
                        targetPlayer.method_5814(targetPlayer.method_23317(), targetPlayer.method_23318(), targetPlayer.method_23321());
                    }
                    player.method_64398((class_2561)class_2561.method_43471((String)"message.nbtedit.saved.successful").method_27692(class_124.field_1060));
                }
                catch (Exception ex) {
                    player.method_64398((class_2561)class_2561.method_43471((String)"message.nbtedit.saving.failed.invalid_nbt").method_27692(class_124.field_1061));
                    NBTEdit.getInstance().getLogger().error("Player {} edited the tag of entity {} and caused an exception!", (Object)player.method_5477().getString(), (Object)entityUuid);
                    LoggingHelper.errorParsingTag(ex, (class_2520)tag);
                }
            } else {
                NBTEdit.getInstance().getLogger().info("Player {} tried to edit a non-existent entity {}.", (Object)player.method_5477(), (Object)entityUuid);
                player.method_64398((class_2561)class_2561.method_43471((String)"message.nbtedit.saving.failed.entity_not_exists").method_27692(class_124.field_1061));
            }
        });
    }

    public static void saveItemStack(class_3222 player, ItemStackEditingPacket packet) {
        if (!NetworkingHelper.checkWritePermission(player)) {
            return;
        }
        class_2487 tag = packet.tag();
        class_1799 itemStack = packet.itemStack();
        MinecraftServer server = player.method_5682();
        server.execute(() -> {
            try {
                class_1799 item = (class_1799)class_1799.method_57360((class_7225.class_7874)server.method_30611(), (class_2520)tag).orElseThrow();
                player.method_6122(class_1268.field_5808, item);
                NBTEdit.getInstance().getLogger().info("Player {} successfully edited the tag of a ItemStack named {}.", (Object)player.method_5477().getString(), (Object)itemStack.method_7954().getString());
                LoggingHelper.debugItemStackTag((class_1657)player, (class_2520)tag);
                player.method_64398((class_2561)class_2561.method_43471((String)"message.nbtedit.saved.successful").method_27692(class_124.field_1060));
            }
            catch (Exception ex) {
                player.method_64398((class_2561)class_2561.method_43471((String)"message.nbtedit.saving.failed.invalid_nbt").method_27692(class_124.field_1061));
                NBTEdit.getInstance().getLogger().error("Player {} edited the tag of ItemStack named {} and caused an exception!", (Object)player.method_5477().getString(), (Object)itemStack.method_7954().getString());
                LoggingHelper.errorParsingTag(ex, (class_2520)tag);
            }
        });
    }
}

