/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.editor;

import cx.rain.mc.nbtedit.editor.NbtTree;
import cx.rain.mc.nbtedit.editor.tag.TagParseHelper;
import java.util.Locale;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NodeParser {
    public static String valueAsString(NbtTree.Node<?> node) {
        Object tag = node.getTag();
        return TagParseHelper.getValueAsString(tag);
    }

    public static <T extends Tag> Tag getTag(NbtTree.Node<T> node, String value) {
        T tag = node.getTag();
        try {
            if (tag instanceof ByteTag) {
                return ByteTag.valueOf((byte)NodeParser.parseByte(value));
            }
            if (tag instanceof ShortTag) {
                return ShortTag.valueOf((short)NodeParser.parseShort(value));
            }
            if (tag instanceof IntTag) {
                return IntTag.valueOf((int)NodeParser.parseInt(value));
            }
            if (tag instanceof LongTag) {
                return LongTag.valueOf((long)NodeParser.parseLong(value));
            }
            if (tag instanceof FloatTag) {
                return FloatTag.valueOf((float)NodeParser.parseFloat(value));
            }
            if (tag instanceof DoubleTag) {
                return DoubleTag.valueOf((double)NodeParser.parseDouble(value));
            }
            if (tag instanceof ByteArrayTag) {
                return new ByteArrayTag(NodeParser.parseByteArray(value));
            }
            if (tag instanceof IntArrayTag) {
                return new IntArrayTag(NodeParser.parseIntArray(value));
            }
            if (tag instanceof LongArrayTag) {
                return new LongArrayTag(NodeParser.parseLongArray(value));
            }
            if (tag instanceof StringTag) {
                return StringTag.valueOf((String)value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return EndTag.INSTANCE;
    }

    public static byte parseByte(String s) {
        try {
            String c = s.toLowerCase(Locale.ROOT);
            if (c.endsWith("b")) {
                c = c.substring(0, c.length() - 1);
            }
            return Byte.parseByte(c);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static short parseShort(String s) {
        try {
            String c = s.toLowerCase(Locale.ROOT);
            if (c.endsWith("s")) {
                c = c.substring(0, c.length() - 1);
            }
            return Short.parseShort(c);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long parseLong(String s) {
        try {
            String c = s.toLowerCase(Locale.ROOT);
            if (c.endsWith("l")) {
                c = c.substring(0, c.length() - 1);
            }
            return Long.parseLong(c);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static float parseFloat(String s) {
        try {
            String c = s.toLowerCase(Locale.ROOT);
            if (c.endsWith("f")) {
                c = c.substring(0, c.length() - 1);
            }
            return Float.parseFloat(c);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static double parseDouble(String s) {
        try {
            String c = s.toLowerCase(Locale.ROOT);
            if (c.endsWith("d")) {
                c = c.substring(0, c.length() - 1);
            }
            return Double.parseDouble(c);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static byte[] parseByteArray(String s) {
        try {
            String[] input = s.split(",");
            byte[] arr = new byte[input.length];
            for (int i = 0; i < input.length; ++i) {
                String c = input[i].toLowerCase(Locale.ROOT).strip();
                if (c.endsWith("b")) {
                    c = c.substring(0, c.length() - 1);
                }
                arr[i] = NodeParser.parseByte(c);
            }
            return arr;
        }
        catch (NumberFormatException e) {
            return new byte[]{0};
        }
    }

    public static int[] parseIntArray(String s) {
        try {
            String[] input = s.split(",");
            int[] arr = new int[input.length];
            for (int i = 0; i < input.length; ++i) {
                String c = input[i].strip();
                arr[i] = NodeParser.parseInt(c);
            }
            return arr;
        }
        catch (NumberFormatException e) {
            return new int[]{0};
        }
    }

    public static long[] parseLongArray(String s) throws NumberFormatException {
        try {
            String[] input = s.split(",");
            long[] arr = new long[input.length];
            for (int i = 0; i < input.length; ++i) {
                String c = input[i].toLowerCase(Locale.ROOT).strip();
                if (c.endsWith("l")) {
                    c = c.substring(0, c.length() - 1);
                }
                arr[i] = NodeParser.parseInt(c);
            }
            return arr;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Not a valid long array");
        }
    }
}

