/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.neoforge.command;

import cx.rain.mc.nbtedit.api.command.IModPermission;
import cx.rain.mc.nbtedit.api.command.ModPermissions;
import cx.rain.mc.nbtedit.neoforge.config.ModConfigImpl;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="nbtedit")
public class ModPermissionImpl
implements IModPermission {
    public static final Map<ModPermissions, PermissionNode<Boolean>> NODES = new HashMap<ModPermissions, PermissionNode<Boolean>>();

    private static PermissionNode<Boolean> bool(String name, int defaultLevel) {
        return new PermissionNode("nbtedit", name, PermissionTypes.BOOLEAN, (player, uuid, context) -> player != null && player.hasPermissions(defaultLevel), new PermissionDynamicContextKey[0]);
    }

    @SubscribeEvent
    public static void registerPermission(PermissionGatherEvent.Nodes event) {
        for (ModPermissions p : ModPermissions.values()) {
            PermissionNode<Boolean> node = ModPermissionImpl.bool(p.getName(), (Integer)ModConfigImpl.PERMISSION_LEVELS.get((Object)p).get());
            NODES.put(p, node);
            event.addNodes(new PermissionNode[]{node});
        }
    }

    @Override
    public boolean hasPermission(@NotNull CommandSourceStack sourceStack, @NotNull ModPermissions permission) {
        ServerPlayer serverPlayer = sourceStack.getPlayer();
        if (serverPlayer instanceof ServerPlayer) {
            ServerPlayer player = serverPlayer;
            return this.hasPermission(player, permission);
        }
        return sourceStack.hasPermission(permission.getDefaultLevel());
    }

    @Override
    public boolean hasPermission(@NotNull ServerPlayer player, @NotNull ModPermissions permission) {
        return (Boolean)PermissionAPI.getPermission((ServerPlayer)player, NODES.get((Object)permission), (PermissionDynamicContext[])new PermissionDynamicContext[0]);
    }
}

