/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.networking;

import cx.rain.mc.nbtedit.NBTEdit;
import cx.rain.mc.nbtedit.networking.NetworkEditingHelper;
import cx.rain.mc.nbtedit.networking.NetworkingHelper;
import cx.rain.mc.nbtedit.networking.packet.c2s.BlockEntityRaytraceResultPacket;
import cx.rain.mc.nbtedit.networking.packet.c2s.EntityRaytraceResultPacket;
import cx.rain.mc.nbtedit.networking.packet.c2s.ItemStackRaytraceResultPacket;
import cx.rain.mc.nbtedit.networking.packet.common.BlockEntityEditingPacket;
import cx.rain.mc.nbtedit.networking.packet.common.EntityEditingPacket;
import cx.rain.mc.nbtedit.networking.packet.common.ItemStackEditingPacket;
import cx.rain.mc.nbtedit.utility.LoggingHelper;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.ValueInput;

public class NetworkServerHandler {
    public static void handleBlockEntityResult(ServerPlayer player, BlockEntityRaytraceResultPacket packet) {
        NetworkEditingHelper.editBlockEntity(player, packet.pos());
    }

    public static void handleEntityResult(ServerPlayer player, EntityRaytraceResultPacket packet) {
        NetworkEditingHelper.editEntity(player, packet.uuid());
    }

    public static void handleItemStackResult(ServerPlayer player, ItemStackRaytraceResultPacket packet) {
        NetworkEditingHelper.editItemStack(player, packet.itemStack());
    }

    public static void saveBlockEntity(ServerPlayer player, BlockEntityEditingPacket packet) {
        if (!NetworkingHelper.checkWritePermission(player)) {
            return;
        }
        BlockPos pos = packet.pos();
        if (!NetworkingHelper.checkPosLoaded(player, pos)) {
            return;
        }
        CompoundTag tag = packet.tag();
        MinecraftServer server = player.getServer();
        ServerLevel level = player.level();
        server.execute(() -> {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity != null) {
                try {
                    ValueInput input = NBTEdit.getInstance().getRegistryContextSerializer().createTagValueInput(tag);
                    blockEntity.loadWithComponents(input);
                    blockEntity.setChanged();
                    if (blockEntity.hasLevel() && blockEntity.getLevel() instanceof ServerLevel) {
                        ((ServerLevel)blockEntity.getLevel()).getChunkSource().blockChanged(pos);
                    }
                    NBTEdit.getInstance().getLogger().info("Player {} successfully edited the tag of a BlockEntity at {} {} {}.", new Object[]{player.getName().getString(), pos.getX(), pos.getY(), pos.getZ()});
                    LoggingHelper.debugBlockEntityTag(pos, (Tag)tag);
                    player.sendSystemMessage((Component)Component.translatable((String)"message.nbtedit.saved.successful").withStyle(ChatFormatting.GREEN));
                }
                catch (Exception ex) {
                    player.sendSystemMessage((Component)Component.translatable((String)"message.nbtedit.saving.failed.invalid_nbt").withStyle(ChatFormatting.RED));
                    NBTEdit.getInstance().getLogger().error("Player {} edited the tag of BlockEntity at XYZ {} {} {} and caused an exception!", new Object[]{player.getName().getString(), pos.getX(), pos.getY(), pos.getZ()});
                    LoggingHelper.errorParsingTag(ex, (Tag)tag);
                }
            } else {
                NBTEdit.getInstance().getLogger().info("Player {} tried to edit a non-existent BlockEntity at {} {} {}.", new Object[]{player.getName(), pos.getX(), pos.getY(), pos.getZ()});
                player.sendSystemMessage((Component)Component.translatable((String)"message.nbtedit.saving.failed.block_entity_not_exists").withStyle(ChatFormatting.RED));
            }
        });
    }

    public static void saveEntity(ServerPlayer player, EntityEditingPacket packet) {
        if (!NetworkingHelper.checkWritePermission(player)) {
            return;
        }
        CompoundTag tag = packet.tag();
        UUID entityUuid = packet.uuid();
        MinecraftServer server = player.getServer();
        ServerLevel level = player.level();
        server.execute(() -> {
            Entity entity = level.getEntity(entityUuid);
            if (entity != null) {
                if (entity instanceof Player && entity != player && !NetworkingHelper.checkEditOnPlayerPermission(player)) {
                    NBTEdit.getInstance().getLogger().info("Player {} tried to use nbtedit on a player which is not allowed", (Object)player.getName().getString());
                    return;
                }
                try {
                    GameType prevGameMode = null;
                    if (entity instanceof ServerPlayer) {
                        prevGameMode = ((ServerPlayer)entity).gameMode.getGameModeForPlayer();
                    }
                    ValueInput input = NBTEdit.getInstance().getRegistryContextSerializer().createTagValueInput(tag);
                    entity.load(input);
                    NBTEdit.getInstance().getLogger().info("Player {} edited the tag of Entity with UUID {} .", (Object)player.getName().getString(), (Object)entityUuid);
                    LoggingHelper.debugEntityTag(entityUuid, (Tag)tag);
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer targetPlayer = (ServerPlayer)entity;
                        targetPlayer.initMenu((AbstractContainerMenu)targetPlayer.inventoryMenu);
                        GameType gameMode = targetPlayer.gameMode.getGameModeForPlayer();
                        if (prevGameMode != gameMode) {
                            targetPlayer.setGameMode(gameMode);
                        }
                        targetPlayer.connection.send((Packet)new ClientboundSetHealthPacket(targetPlayer.getHealth(), targetPlayer.getFoodData().getFoodLevel(), targetPlayer.getFoodData().getSaturationLevel()));
                        targetPlayer.connection.send((Packet)new ClientboundSetExperiencePacket(targetPlayer.experienceProgress, targetPlayer.totalExperience, targetPlayer.experienceLevel));
                        targetPlayer.onUpdateAbilities();
                        targetPlayer.setPos(targetPlayer.getX(), targetPlayer.getY(), targetPlayer.getZ());
                    }
                    player.sendSystemMessage((Component)Component.translatable((String)"message.nbtedit.saved.successful").withStyle(ChatFormatting.GREEN));
                }
                catch (Exception ex) {
                    player.sendSystemMessage((Component)Component.translatable((String)"message.nbtedit.saving.failed.invalid_nbt").withStyle(ChatFormatting.RED));
                    NBTEdit.getInstance().getLogger().error("Player {} edited the tag of entity {} and caused an exception!", (Object)player.getName().getString(), (Object)entityUuid);
                    LoggingHelper.errorParsingTag(ex, (Tag)tag);
                }
            } else {
                NBTEdit.getInstance().getLogger().info("Player {} tried to edit a non-existent entity {}.", (Object)player.getName(), (Object)entityUuid);
                player.sendSystemMessage((Component)Component.translatable((String)"message.nbtedit.saving.failed.entity_not_exists").withStyle(ChatFormatting.RED));
            }
        });
    }

    public static void saveItemStack(ServerPlayer player, ItemStackEditingPacket packet) {
        if (!NetworkingHelper.checkWritePermission(player)) {
            return;
        }
        CompoundTag tag = packet.tag();
        ItemStack itemStack = packet.itemStack();
        MinecraftServer server = player.getServer();
        server.execute(() -> {
            try {
                ItemStack item = NBTEdit.getInstance().getRegistryContextSerializer().deserializeItemStack(tag);
                player.setItemInHand(InteractionHand.MAIN_HAND, item);
                NBTEdit.getInstance().getLogger().info("Player {} successfully edited the tag of a ItemStack named {}.", (Object)player.getName().getString(), (Object)itemStack.getDisplayName().getString());
                LoggingHelper.debugItemStackTag((Player)player, (Tag)tag);
                player.sendSystemMessage((Component)Component.translatable((String)"message.nbtedit.saved.successful").withStyle(ChatFormatting.GREEN));
            }
            catch (Exception ex) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.nbtedit.saving.failed.invalid_nbt").withStyle(ChatFormatting.RED));
                NBTEdit.getInstance().getLogger().error("Player {} edited the tag of ItemStack named {} and caused an exception!", (Object)player.getName().getString(), (Object)itemStack.getDisplayName().getString());
                LoggingHelper.errorParsingTag(ex, (Tag)tag);
            }
        });
    }
}

