/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.utility;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import cx.rain.mc.nbtedit.utility.NBTEditProblemReporter;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;

public class RegistryContextSerializer {
    private final RegistryOps<Tag> nbtRegistryOps;
    private final RegistryOps<JsonElement> jsonRegistryOps;
    private final Function<CompoundTag, ValueInput> tagValueInputFactory;
    private final Supplier<TagValueOutput> tagValueOutputFactory;

    public RegistryContextSerializer(RegistryAccess registryAccess) {
        this.nbtRegistryOps = registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        this.jsonRegistryOps = registryAccess.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        this.tagValueInputFactory = tag -> TagValueInput.create((ProblemReporter)NBTEditProblemReporter.TAG_DESERIALIZE, (HolderLookup.Provider)registryAccess, (CompoundTag)tag);
        this.tagValueOutputFactory = () -> TagValueOutput.createWithContext((ProblemReporter)NBTEditProblemReporter.TAG_SERIALIZE, (HolderLookup.Provider)registryAccess);
    }

    public RegistryOps<Tag> getNbtRegistryOps() {
        return this.nbtRegistryOps;
    }

    public Optional<String> serializeComponent(Component component) {
        return ComponentSerialization.CODEC.encodeStart(this.jsonRegistryOps, (Object)component).resultOrPartial().map(JsonElement::toString);
    }

    public Optional<Component> deserializeComponent(String str) {
        try {
            JsonObject json = GsonHelper.parse((String)str);
            return ComponentSerialization.CODEC.parse(this.jsonRegistryOps, (Object)json).resultOrPartial();
        }
        catch (JsonParseException ex) {
            return Optional.empty();
        }
    }

    public CompoundTag serializeItemStack(ItemStack stack) {
        return (CompoundTag)ItemStack.CODEC.encodeStart(this.getNbtRegistryOps(), (Object)stack).map(t -> (CompoundTag)t).getOrThrow();
    }

    public ItemStack deserializeItemStack(CompoundTag tag) {
        return (ItemStack)ItemStack.CODEC.parse(this.getNbtRegistryOps(), (Object)tag).getOrThrow();
    }

    public TagValueOutput createTagValueOutput() {
        return this.tagValueOutputFactory.get();
    }

    public ValueInput createTagValueInput(CompoundTag tag) {
        return this.tagValueInputFactory.apply(tag);
    }
}

