/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.networking;

import cx.rain.mc.nbtedit.NBTEditPlatform;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class NetworkingHelper {
    public static boolean checkReadPermission(ServerPlayer player) {
        boolean result = NBTEditPlatform.getPermission().canOpenEditor(player);
        if (!result) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.nbtedit.no_permission").withStyle(ChatFormatting.RED));
        }
        return result;
    }

    public static boolean checkWritePermission(ServerPlayer player) {
        boolean result = NBTEditPlatform.getPermission().canSave(player);
        if (!result) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.nbtedit.no_permission").withStyle(ChatFormatting.RED));
        }
        return result;
    }

    public static boolean checkEditOnPlayerPermission(ServerPlayer player) {
        boolean result = NBTEditPlatform.getPermission().canEditOnPlayer(player);
        if (!result) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.nbtedit.cannot_edit_other_player").withStyle(ChatFormatting.RED));
        }
        return result;
    }

    public static boolean checkPosLoaded(ServerPlayer player, BlockPos pos) {
        boolean result = player.level().isLoaded(pos);
        if (!result) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.nbtedit.not_loaded").withStyle(ChatFormatting.RED));
        }
        return result;
    }
}

