/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.editor;

import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public enum EditorButton {
    BYTE(0, "message.nbtedit.nbt_type.byte", ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"tag_type/byte")),
    SHORT(1, "message.nbtedit.nbt_type.short", ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"tag_type/short")),
    INT(2, "message.nbtedit.nbt_type.int", ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"tag_type/int")),
    LONG(3, "message.nbtedit.nbt_type.long", ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"tag_type/long")),
    FLOAT(4, "message.nbtedit.nbt_type.float", ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"tag_type/float")),
    DOUBLE(5, "message.nbtedit.nbt_type.double", ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"tag_type/double")),
    BYTE_ARRAY(6, "message.nbtedit.nbt_type.byte_array", ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"tag_type/byte_array")),
    STRING(7, "message.nbtedit.nbt_type.string", ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"tag_type/string")),
    LIST(8, "message.nbtedit.nbt_type.list", ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"tag_type/list")),
    COMPOUND(9, "message.nbtedit.nbt_type.compound", ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"tag_type/compound")),
    INT_ARRAY(10, "message.nbtedit.nbt_type.int_array", ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"tag_type/int_array")),
    LONG_ARRAY(11, "message.nbtedit.nbt_type.long_array", ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"tag_type/long_array")),
    EDIT(12, "gui.nbtedit.button.edit", ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"editor/edit")),
    DELETE(13, "gui.nbtedit.button.delete", ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"editor/delete")),
    PASTE(14, "gui.nbtedit.button.paste", ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"editor/paste")),
    CUT(15, "gui.nbtedit.button.cut", ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"editor/cut")),
    COPY(16, "gui.nbtedit.button.copy", ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"editor/copy"));

    private final int id;
    private final Component name;
    private final ResourceLocation sprite;

    private EditorButton(int id, String name, ResourceLocation sprite) {
        this.id = id;
        this.name = Component.translatable((String)name);
        this.sprite = sprite;
    }

    public int getId() {
        return this.id;
    }

    public ResourceLocation getSprite() {
        return this.sprite;
    }

    public Component getName() {
        return this.name;
    }

    public static EditorButton of(int id) {
        for (EditorButton v : EditorButton.values()) {
            if (v.getId() != id) continue;
            return v;
        }
        return BYTE;
    }

    public static EditorButton ofTag(Tag t) {
        return switch (t.getId()) {
            case 1 -> BYTE;
            case 2 -> SHORT;
            case 3 -> INT;
            case 4 -> LONG;
            case 5 -> FLOAT;
            case 6 -> DOUBLE;
            case 7 -> BYTE_ARRAY;
            case 8 -> STRING;
            case 9 -> LIST;
            case 10 -> COMPOUND;
            case 11 -> INT_ARRAY;
            case 12 -> LONG_ARRAY;
            default -> throw new IllegalStateException("Unexpected value: " + t.getId());
        };
    }
}

