/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.gui.component;

import cx.rain.mc.nbtedit.gui.component.AbstractComposedComponent;
import cx.rain.mc.nbtedit.gui.component.IComponent;
import cx.rain.mc.nbtedit.gui.component.ScrollBar;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class ScrollableViewport
extends AbstractComposedComponent {
    private final int scrollBarWidth;
    private ScrollBar verticalScrollBar = null;
    private ScrollBar horizontalScrollBar = null;
    private int contentWidth = 0;
    private int contentHeight = 0;

    public ScrollableViewport(int x, int y, int width, int height) {
        this(x, y, width, height, 6);
    }

    public ScrollableViewport(int x, int y, int width, int height, int scrollBarWidth) {
        super(x, y, width, height, (Component)Component.empty());
        this.scrollBarWidth = scrollBarWidth;
    }

    @Override
    public void update() {
        super.update();
        this.createChildren();
    }

    @Override
    protected void createChildren() {
        this.contentWidth = 0;
        this.contentHeight = 0;
        for (IComponent c : this.getChildren()) {
            int cw = c.getX() + c.getWidth();
            int ch = c.getY() + c.getHeight();
            if (this.contentWidth < cw) {
                this.contentWidth = cw;
            }
            if (this.contentHeight >= ch) continue;
            this.contentHeight = ch;
        }
        if (this.contentHeight > this.getHeight()) {
            int amount = this.verticalScrollBar != null ? this.verticalScrollBar.getScrollAmount() : 0;
            this.verticalScrollBar = new ScrollBar(this.getX() + this.getWidth() - this.getScrollBarWidth(), this.getY(), this.getScrollBarWidth(), this.getHeight(), d -> {}, this.contentHeight);
            this.verticalScrollBar.setScrollAmount(amount);
        }
        if (this.contentWidth > this.getWidth()) {
            int amount = this.horizontalScrollBar != null ? this.horizontalScrollBar.getScrollAmount() : 0;
            this.horizontalScrollBar = new ScrollBar(this.getX(), this.getY() + this.getHeight() - this.getScrollBarWidth(), this.getWidth() - (this.shouldShowVerticalBar() ? this.getScrollBarWidth() : 0), this.getScrollBarWidth(), d -> {}, this.contentWidth, true);
            this.horizontalScrollBar.setScrollAmount(amount);
        }
    }

    public boolean shouldShowVerticalBar() {
        return this.contentHeight > this.getHeight() && this.verticalScrollBar != null;
    }

    public boolean shouldShowHorizontalBar() {
        return this.contentWidth > this.getWidth() && this.horizontalScrollBar != null;
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int maskedMouseX = (int)this.getMaskedX(mouseX);
        int maskedMouseY = (int)this.getMaskedY(mouseY);
        int maxX = this.getX() + this.getWidth() - (this.shouldShowVerticalBar() ? this.getScrollBarWidth() : 0);
        int maxY = this.getY() + this.getHeight() - (this.shouldShowHorizontalBar() ? this.getScrollBarWidth() : 0);
        guiGraphics.pose().pushMatrix();
        guiGraphics.enableScissor(this.getX(), this.getY(), maxX, maxY);
        guiGraphics.pose().translate((float)(this.getX() - this.getScrollXOffset()), (float)(this.getY() - this.getScrollYOffset()));
        super.renderWidget(guiGraphics, maskedMouseX, maskedMouseY, partialTick);
        guiGraphics.disableScissor();
        guiGraphics.pose().popMatrix();
        if (this.shouldShowVerticalBar()) {
            this.verticalScrollBar.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.shouldShowHorizontalBar()) {
            this.horizontalScrollBar.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public int getScrollBarWidth() {
        return this.scrollBarWidth;
    }

    public int getScrollXOffset() {
        return this.shouldShowHorizontalBar() ? this.horizontalScrollBar.getScrollAmount() : 0;
    }

    public void setScrollXOffset(int value) {
        if (this.shouldShowHorizontalBar()) {
            this.horizontalScrollBar.setScrollAmount(value);
        }
    }

    public int getScrollYOffset() {
        return this.shouldShowVerticalBar() ? this.verticalScrollBar.getScrollAmount() : 0;
    }

    public void setScrollYOffset(int value) {
        if (this.shouldShowVerticalBar()) {
            this.verticalScrollBar.setScrollAmount(value);
        }
    }

    private double getMaskedX(double rawX) {
        return rawX - (double)this.getX() + (double)this.getScrollXOffset();
    }

    private double getMaskedY(double rawY) {
        return rawY - (double)this.getY() + (double)this.getScrollYOffset();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.shouldShowVerticalBar() && this.verticalScrollBar.isMouseOver(mouseX, mouseY)) {
            return this.verticalScrollBar.mouseClicked(mouseX, mouseY, button);
        }
        if (this.shouldShowHorizontalBar() && this.horizontalScrollBar.isMouseOver(mouseX, mouseY)) {
            return this.horizontalScrollBar.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(this.getMaskedX(mouseX), this.getMaskedY(mouseY), button);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.shouldShowVerticalBar() && this.verticalScrollBar.isMouseOver(mouseX, mouseY)) {
            return this.verticalScrollBar.mouseReleased(mouseX, mouseY, button);
        }
        if (this.shouldShowHorizontalBar() && this.horizontalScrollBar.isMouseOver(mouseX, mouseY)) {
            return this.horizontalScrollBar.mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(this.getMaskedX(mouseX), this.getMaskedY(mouseY), button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.shouldShowVerticalBar() && this.verticalScrollBar.isScrolling() && deltaY != 0.0) {
            return this.verticalScrollBar.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (this.shouldShowHorizontalBar() && this.horizontalScrollBar.isScrolling() && deltaX != 0.0) {
            return this.horizontalScrollBar.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.mouseDragged(this.getMaskedX(mouseX), this.getMaskedY(mouseY), button, deltaX, deltaY);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.shouldShowVerticalBar() && scrollY != 0.0) {
            return this.verticalScrollBar.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        if (this.shouldShowHorizontalBar() && scrollX != 0.0) {
            return this.horizontalScrollBar.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        return super.mouseScrolled(mouseX - (double)this.getX() + (double)this.getScrollXOffset(), mouseY - (double)this.getY() + (double)this.getScrollYOffset(), scrollX, scrollY);
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.shouldShowVerticalBar() && this.verticalScrollBar.isHoveredOrFocused()) {
            return this.verticalScrollBar.keyReleased(keyCode, scanCode, modifiers);
        }
        if (this.shouldShowHorizontalBar() && this.horizontalScrollBar.isHoveredOrFocused()) {
            return this.horizontalScrollBar.keyReleased(keyCode, scanCode, modifiers);
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }
}

