/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.gui.editor;

import cx.rain.mc.nbtedit.editor.EditorButton;
import cx.rain.mc.nbtedit.gui.component.ButtonComponent;
import java.time.Duration;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;

public class EditorButtonComponent
extends ButtonComponent {
    private final EditorButton button;

    public EditorButtonComponent(EditorButton id, int x, int y, Component message, Button.OnPress onPressed) {
        super(x, y, 9, 9, message, onPressed, DEFAULT_NARRATION);
        this.button = id;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (active) {
            this.setTooltip(Tooltip.create((Component)this.getMessage(), (Component)this.createNarrationMessage()));
            this.setTooltipDelay(Duration.ofMillis(200L));
        } else {
            this.setTooltip(null);
        }
    }

    public boolean isHover(int mouseX, int mouseY) {
        return this.isActive() && mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.getWidth() && mouseY < this.getY() + this.getHeight();
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.isHover(mouseX, mouseY)) {
            graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), -2130706433);
        }
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.button.getSprite(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        if (this.isActive()) {
            graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), Integer.MIN_VALUE);
        }
    }
}

