/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.gui.editor;

import cx.rain.mc.nbtedit.editor.NbtTree;
import cx.rain.mc.nbtedit.gui.component.AbstractComposedComponent;
import cx.rain.mc.nbtedit.gui.component.IComposedComponent;
import cx.rain.mc.nbtedit.gui.editor.NbtTreeViewNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class NbtTreeView
extends AbstractComposedComponent {
    private final List<NbtTreeViewNode> nodes = new ArrayList<NbtTreeViewNode>();
    private final NbtTree tree;
    private final Consumer<NbtTreeView> onFocusedUpdated;
    public static final int START_X = 10;
    public static final int START_Y = 2;
    public static final int NODE_GAP_X = 10;
    public static final int NODE_GAP_Y;
    private int nodeOffsetX = 0;
    private int nodeOffsetY = 0;
    private int maxWidth = 0;
    private int maxHeight = 0;

    public NbtTreeView(NbtTree tree, int x, int y, Consumer<NbtTreeView> onFocusedUpdated) {
        super(x, y, 100, 100, (Component)Component.translatable((String)"gui.nbtedit.title.tree_view"));
        this.tree = tree;
        this.onFocusedUpdated = onFocusedUpdated;
    }

    @Override
    public void setFocused(@Nullable GuiEventListener focused) {
        super.setFocused(focused);
        if (focused instanceof NbtTreeViewNode) {
            this.onFocusedUpdated.accept(this);
        }
    }

    @Nullable
    public NbtTreeViewNode getFocusedChild() {
        GuiEventListener guiEventListener = this.getFocused();
        if (guiEventListener instanceof NbtTreeViewNode) {
            NbtTreeViewNode node = (NbtTreeViewNode)guiEventListener;
            return node;
        }
        return null;
    }

    public void setFocusedNode(@Nullable NbtTree.Node<?> node) {
        this.setFocused(null);
        if (node != null) {
            for (NbtTreeViewNode n : this.nodes) {
                if (n.getNode() != node) continue;
                this.setFocused(n);
                break;
            }
        }
    }

    @Nullable
    public NbtTree.Node<?> getFocusedNode() {
        NbtTreeViewNode c = this.getFocusedChild();
        return c != null ? c.getNode() : null;
    }

    public void update(boolean callParent) {
        if (callParent) {
            IComposedComponent parent = this.getParent();
            if (parent != null) {
                this.getParent().update();
            }
        } else {
            this.update();
        }
    }

    @Override
    public void update() {
        this.unInitialize();
        this.initialize();
        super.update();
    }

    @Override
    protected void createChildren() {
        this.nodeOffsetX = 10;
        this.nodeOffsetY = 2;
        this.maxWidth = 0;
        this.maxHeight = 0;
        this.addNodes(this.tree.getRoot());
        this.setFocusedNode(this.getFocusedNode());
        this.setWidth(this.maxWidth);
        this.setHeight(this.maxHeight);
    }

    @Override
    public void unInitialize() {
        this.nodes.clear();
        super.unInitialize();
    }

    private void addNodes(NbtTree.Node<?> root) {
        int h;
        NbtTreeViewNode node = new NbtTreeViewNode(this.nodeOffsetX, this.nodeOffsetY, root, this);
        this.nodes.add(node);
        this.addChild(node);
        int w = node.getX() + node.getWidth();
        if (w > this.maxWidth) {
            this.maxWidth = w;
        }
        if ((h = node.getY() + node.getHeight()) > this.maxHeight) {
            this.maxHeight = h;
        }
        this.nodeOffsetY += NODE_GAP_Y;
        if (root.shouldShowChildren()) {
            this.nodeOffsetX += 10;
            for (NbtTree.Node<Tag> child : root.getChildren()) {
                this.addNodes(child);
            }
            this.nodeOffsetX -= 10;
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    static {
        Objects.requireNonNull(Minecraft.getInstance().font);
        NODE_GAP_Y = 9 + 2;
    }
}

