/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.utility;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import cx.rain.mc.nbtedit.utility.NBTEditProblemReporter;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;

public class RegistryContextSerializeHelper {
    public static RegistryOps<Tag> getNbtRegistryOps(RegistryAccess registryAccess) {
        return registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
    }

    public static RegistryOps<JsonElement> getJsonRegistryOps(RegistryAccess registryAccess) {
        return registryAccess.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
    }

    public static Optional<String> serializeComponent(RegistryAccess registryAccess, Component component) {
        return ComponentSerialization.CODEC.encodeStart(RegistryContextSerializeHelper.getJsonRegistryOps(registryAccess), (Object)component).resultOrPartial().map(JsonElement::toString);
    }

    public static Optional<Component> deserializeComponent(RegistryAccess registryAccess, String str) {
        try {
            JsonObject json = GsonHelper.parse((String)str);
            return ComponentSerialization.CODEC.parse(RegistryContextSerializeHelper.getJsonRegistryOps(registryAccess), (Object)json).resultOrPartial();
        }
        catch (JsonParseException ex) {
            return Optional.empty();
        }
    }

    public static Optional<CompoundTag> serializeItemStack(RegistryAccess registryAccess, ItemStack stack) {
        return ItemStack.CODEC.encodeStart(RegistryContextSerializeHelper.getNbtRegistryOps(registryAccess), (Object)stack).map(t -> (CompoundTag)t).resultOrPartial();
    }

    public static Optional<ItemStack> deserializeItemStack(RegistryAccess registryAccess, CompoundTag tag) {
        return ItemStack.CODEC.parse(RegistryContextSerializeHelper.getNbtRegistryOps(registryAccess), (Object)tag).resultOrPartial();
    }

    public static TagValueOutput createTagValueOutput(RegistryAccess registryAccess) {
        return TagValueOutput.createWithContext((ProblemReporter)NBTEditProblemReporter.TAG_SERIALIZE, (HolderLookup.Provider)registryAccess);
    }

    public static ValueInput createTagValueInput(RegistryAccess registryAccess, CompoundTag tag) {
        return TagValueInput.create((ProblemReporter)NBTEditProblemReporter.TAG_DESERIALIZE, (HolderLookup.Provider)registryAccess, (CompoundTag)tag);
    }
}

