/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit;

import cx.rain.mc.nbtedit.NBTEditPlatform;
import cx.rain.mc.nbtedit.utility.RegistryContextSerializer;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Properties;
import net.minecraft.SharedConstants;
import net.minecraft.core.RegistryAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NBTEdit {
    public static final String MODID = "nbtedit";
    public static final String NAME = "In-game NBTEdit Reborn";
    public static final String VERSION;
    public static final OffsetDateTime BUILD_TIME;
    private static NBTEdit INSTANCE;
    private final Logger logger = LoggerFactory.getLogger((String)"In-game NBTEdit Reborn");
    private RegistryContextSerializer registryContextSerializer;

    public NBTEdit() {
        INSTANCE = this;
        this.logger.info("Loading NBTEdit ver: {} on mc {}, build at {}", new Object[]{VERSION, SharedConstants.getCurrentVersion().name(), BUILD_TIME != null ? BUILD_TIME : "B.C. 3200"});
        NBTEditPlatform.onServerStarted(server -> {
            this.registryContextSerializer = new RegistryContextSerializer((RegistryAccess)server.registryAccess());
        });
    }

    public static NBTEdit getInstance() {
        return INSTANCE;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public RegistryContextSerializer getRegistryContextSerializer() {
        if (this.registryContextSerializer == null) {
            throw new IllegalStateException("RegistryContextSerializer has not been initialized");
        }
        return this.registryContextSerializer;
    }

    static {
        OffsetDateTime buildTime;
        Properties properties = new Properties();
        String version = "";
        try {
            properties.load(NBTEdit.class.getResourceAsStream("/build_info.properties"));
            version = properties.getProperty("build_version");
            buildTime = OffsetDateTime.parse(properties.getProperty("build_time"));
        }
        catch (IOException ex) {
            version = "Unknown";
            buildTime = null;
        }
        VERSION = version;
        BUILD_TIME = buildTime;
    }
}

