/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.editor;

import net.minecraft.network.chat.Component;

public enum NbtType {
    BYTE(1, "message.nbtedit.nbt_type.byte", "Byte"),
    SHORT(2, "message.nbtedit.nbt_type.short", "Short"),
    INT(3, "message.nbtedit.nbt_type.int", "Int"),
    LONG(4, "message.nbtedit.nbt_type.long", "Long"),
    FLOAT(5, "message.nbtedit.nbt_type.float", "Float"),
    DOUBLE(6, "message.nbtedit.nbt_type.double", "Double"),
    BYTE_ARRAY(7, "message.nbtedit.nbt_type.byte_array", "ByteArray"),
    STRING(8, "message.nbtedit.nbt_type.string", "String"),
    LIST(9, "message.nbtedit.nbt_type.list", "List"),
    COMPOUND(10, "message.nbtedit.nbt_type.compound", "Compound"),
    INT_ARRAY(11, "message.nbtedit.nbt_type.int_array", "IntArray"),
    LONG_ARRAY(12, "message.nbtedit.nbt_type.long_array", "LongArray");

    private final int id;
    private final Component name;
    private final String tagName;

    private NbtType(int id, String name, String tagName) {
        this.id = id;
        this.name = Component.translatable((String)name);
        this.tagName = tagName;
    }

    public int getId() {
        return this.id;
    }

    public Component getName() {
        return this.name;
    }

    public String getTagName() {
        return this.tagName;
    }

    public static NbtType of(int id) {
        for (NbtType v : NbtType.values()) {
            if (v.getId() != id) continue;
            return v;
        }
        return BYTE;
    }

    public static NbtType ofButtonId(int id) {
        return NbtType.of(id + 1);
    }
}

