/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.gui.component;

import cx.rain.mc.nbtedit.gui.component.AbstractComponent;
import cx.rain.mc.nbtedit.gui.component.IScrollHandler;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ScrollBar
extends AbstractComponent {
    private static final WidgetSprites BACKGROUND_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"widget/text_field"), ResourceLocation.withDefaultNamespace((String)"widget/text_field_highlighted"));
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/scroller");
    private final int scrollUnit;
    private final boolean horizontal;
    private final IScrollHandler toScroll;
    private final int contentLength;
    private int scrollAmount;
    private boolean dragging;

    public ScrollBar(int x, int y, int width, int height, IScrollHandler toScroll, int contentLength) {
        this(x, y, width, height, toScroll, contentLength, false);
    }

    public ScrollBar(int x, int y, int width, int height, IScrollHandler toScroll, int contentLength, boolean horizontal) {
        super(x, y, width, height, (Component)Component.translatable((String)"gui.nbtedit.title.scroll_bar"));
        Objects.requireNonNull(this.getMinecraft().font);
        this.scrollUnit = 9 + 2;
        this.scrollAmount = 0;
        this.dragging = false;
        this.horizontal = horizontal;
        this.toScroll = toScroll;
        this.contentLength = contentLength;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public boolean isVertical() {
        return !this.horizontal;
    }

    public int getPrimaryStart() {
        if (this.isHorizontal()) {
            return this.getX();
        }
        return this.getY();
    }

    public int getPrimaryLength() {
        if (this.isHorizontal()) {
            return this.getWidth();
        }
        return this.getHeight();
    }

    public double getScrollRate() {
        return Mth.clamp((double)((double)this.scrollAmount / (double)(this.contentLength - this.getPrimaryLength())), (double)0.0, (double)1.0);
    }

    public void setScrollRate(double scrollRate) {
        double actual = Mth.clamp((double)scrollRate, (double)0.0, (double)1.0);
        int newScrollAmount = (int)(actual * (double)(this.contentLength - this.getPrimaryLength()));
        this.setScrollAmount(newScrollAmount);
    }

    private int getScrollBarLength() {
        return Mth.clamp((int)((int)((float)(this.getPrimaryLength() * this.getPrimaryLength()) / (float)this.contentLength)), (int)32, (int)this.getPrimaryLength());
    }

    private int getMaxScrollAmount() {
        return this.contentLength - this.getPrimaryLength();
    }

    public int getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(int amount) {
        this.scrollAmount = Mth.clamp((int)amount, (int)0, (int)this.getMaxScrollAmount());
    }

    private void addScrollAmount(int value) {
        this.setScrollAmount(this.getScrollAmount() + value);
        this.toScroll.onScroll(value);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ResourceLocation resourceLocation = BACKGROUND_SPRITES.get(false, false);
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, resourceLocation, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        int barLength = this.getScrollBarLength();
        int barOffset = (int)(this.getScrollRate() * (double)(this.getPrimaryLength() - barLength));
        if (this.isHorizontal()) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SCROLLER_SPRITE, this.getX() + barOffset, this.getY(), barLength, this.getHeight());
        } else {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SCROLLER_SPRITE, this.getX(), this.getY() + barOffset, this.getWidth(), barLength);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)Component.translatable((String)"gui.nbtedit.title.scroll_bar.narration"));
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        if (this.isMouseOver(event.x(), event.y())) {
            this.dragging = true;
            return true;
        }
        return super.mouseClicked(event, isDoubleClick);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        if (event.button() == 0) {
            this.dragging = false;
        }
        return super.mouseReleased(event);
    }

    public boolean mouseDragged(MouseButtonEvent event, double mouseX, double mouseY) {
        if (this.isActive() && this.dragging) {
            double dragPrimary;
            double mousePrimary = this.isVertical() ? mouseY : mouseX;
            double d = dragPrimary = this.isVertical() ? event.y() : event.x();
            if (mousePrimary < (double)this.getPrimaryStart()) {
                this.addScrollAmount(-this.scrollUnit);
            } else if (mousePrimary > (double)(this.getPrimaryStart() + this.getPrimaryLength())) {
                this.addScrollAmount(this.scrollUnit);
            } else {
                int d2 = Mth.clamp((int)(this.getMaxScrollAmount() / (this.getPrimaryLength() - this.getScrollBarLength())), (int)0, (int)1);
                this.addScrollAmount((int)(dragPrimary * (double)d2));
            }
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        double scrollPrimary = this.isVertical() ? scrollY : scrollX;
        this.addScrollAmount((int)((double)this.scrollUnit * -scrollPrimary));
        return true;
    }

    public boolean keyReleased(KeyEvent event) {
        if (this.isHoveredOrFocused()) {
            if (event.key() == 265) {
                this.addScrollAmount(-this.scrollUnit);
                return true;
            }
            if (event.key() == 264) {
                this.addScrollAmount(this.scrollUnit);
                return true;
            }
        }
        return super.keyReleased(event);
    }
}

