/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.gui.screen;

import cx.rain.mc.nbtedit.gui.component.AbstractComposedComponent;
import cx.rain.mc.nbtedit.gui.component.IComponent;
import cx.rain.mc.nbtedit.gui.component.IComposedComponent;
import cx.rain.mc.nbtedit.gui.window.IWindow;
import cx.rain.mc.nbtedit.gui.window.IWindowHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractScreen
extends Screen
implements IWindowHolder {
    private final Map<IWindow, Boolean> windows = new HashMap<IWindow, Boolean>();
    @Nullable
    private IWindow mutexWindow = null;
    @Nullable
    private IWindow focusedWindow = null;
    private final List<IComponent> children = new ArrayList<IComponent>();

    protected AbstractScreen(Component title) {
        super(title);
    }

    @Override
    public AbstractComposedComponent getParent() {
        return null;
    }

    @Override
    public void setParent(@Nullable IComposedComponent parent) {
        throw new RuntimeException(new OperationNotSupportedException());
    }

    public void setX(int x) {
        throw new RuntimeException(new OperationNotSupportedException());
    }

    public void setY(int y) {
        throw new RuntimeException(new OperationNotSupportedException());
    }

    public int getX() {
        return 0;
    }

    public int getY() {
        return 0;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isHovered() {
        return true;
    }

    @Override
    @NotNull
    public List<IWindow> getWindows() {
        return List.copyOf(this.windows.keySet());
    }

    @Override
    public void addWindow(@NotNull IWindow window, boolean mutex, boolean show) {
        this.addChild(window);
        this.windows.put(window, false);
        window.onOpen();
        if (mutex) {
            if (!this.hasMutexWindow()) {
                this.setMutexWindow(window);
            } else {
                throw new IllegalStateException();
            }
        }
        if (show) {
            this.show(window);
        }
    }

    @Override
    public void closeWindow(@NotNull IWindow window) {
        if (this.getMutexWindow() == window) {
            this.setMutexWindow(null);
        }
        if (this.getFocusedWindow() == window) {
            this.setFocusedWindow(null);
        }
        this.removeChild(window);
        this.windows.remove(window);
        window.onClose();
    }

    @Override
    public void show(@NotNull IWindow window) {
        if (!this.windows.get(window).booleanValue()) {
            this.windows.put(window, true);
            window.onShown();
        }
    }

    @Override
    public void hide(@NotNull IWindow window) {
        if (this.windows.get(window).booleanValue() && this.getMutexWindow() != window) {
            this.windows.put(window, false);
            window.onHidden();
        }
    }

    @Override
    @Nullable
    public IWindow getMutexWindow() {
        return this.mutexWindow;
    }

    @Override
    public void setMutexWindow(@Nullable IWindow window) {
        if (window != null && this.hasWindow(window)) {
            this.setFocusedWindow(window);
            this.mutexWindow = window;
        } else {
            this.mutexWindow = null;
        }
    }

    @Override
    @Nullable
    public IWindow getFocusedWindow() {
        return this.focusedWindow;
    }

    @Override
    public void setFocusedWindow(@Nullable IWindow window) {
        if (this.hasMutexWindow()) {
            this.setFocused(this.getMutexWindow());
            return;
        }
        this.setFocused(window);
        for (IWindow w : this.getWindows()) {
            w.setFocused(w == window);
        }
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        IWindow window;
        super.setFocused(focused);
        this.focusedWindow = focused instanceof IWindow ? (window = (IWindow)focused) : null;
    }

    @Override
    public void addChild(@NotNull IComponent child) {
        this.children.add(child);
        child.setParent(this);
        this.addRenderableWidget(child);
    }

    @Override
    public void removeChild(@NotNull IComponent child) {
        this.children.remove(child);
        child.setParent(null);
        this.removeWidget(child);
    }

    @Override
    public List<IComponent> getChildren() {
        return List.copyOf(this.children);
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return List.copyOf(this.getChildren());
    }

    protected void rebuildWidgets() {
        this.unInitialize();
        super.rebuildWidgets();
    }

    protected void init() {
        super.init();
        this.initialize();
    }

    @Override
    public void tick() {
        for (IComponent c : this.getChildren()) {
            c.tick();
        }
        super.tick();
    }

    protected abstract void createChildren();

    @Override
    public final void initialize() {
        this.createChildren();
        for (IComponent child : this.getChildren()) {
            child.initialize();
        }
    }

    @Override
    public void unInitialize() {
        for (IComponent child : this.getChildren()) {
            child.unInitialize();
        }
        this.closeWindows();
        this.clearChildren();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int maskedMouseX = this.hasMutexWindow() ? -1 : mouseX;
        int maskedMouseY = this.hasMutexWindow() ? -1 : mouseY;
        guiGraphics.drawCenteredString(this.minecraft.font, this.title, this.width / 2, 4, -1);
        for (IComponent c : this.getChildren()) {
            if (c instanceof IWindow) continue;
            c.render(guiGraphics, maskedMouseX, maskedMouseY, partialTick);
        }
        guiGraphics.pose().pushMatrix();
        if (this.hasWindow()) {
            AbstractScreen.drawGrayishBackground(guiGraphics);
        }
        for (IWindow w : this.getWindows()) {
            if (w == this.getMutexWindow()) continue;
            w.render(guiGraphics, maskedMouseX, maskedMouseY, partialTick);
        }
        if (this.hasMutexWindow()) {
            this.getMutexWindow().render(guiGraphics, mouseX, mouseY, partialTick);
        }
        guiGraphics.pose().popMatrix();
    }

    @Override
    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        if (this.hasMutexWindow()) {
            assert (this.getMutexWindow() != null);
            return this.getMutexWindow().mouseClicked(event, isDoubleClick);
        }
        return IWindowHolder.super.mouseClicked(event, isDoubleClick);
    }

    @Override
    public boolean mouseReleased(MouseButtonEvent event) {
        if (this.hasMutexWindow()) {
            assert (this.getMutexWindow() != null);
            return this.getMutexWindow().mouseReleased(event);
        }
        return IWindowHolder.super.mouseReleased(event);
    }

    @Override
    public boolean mouseDragged(MouseButtonEvent event, double mouseX, double mouseY) {
        if (this.hasMutexWindow()) {
            assert (this.getMutexWindow() != null);
            return this.getMutexWindow().mouseDragged(event, mouseX, mouseY);
        }
        return IWindowHolder.super.mouseDragged(event, mouseX, mouseY);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.hasMutexWindow()) {
            assert (this.getMutexWindow() != null);
            return this.getMutexWindow().mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        return IWindowHolder.super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    public boolean keyPressed(KeyEvent event) {
        if (this.hasMutexWindow()) {
            assert (this.getMutexWindow() != null);
            return this.getMutexWindow().keyPressed(event);
        }
        return IWindowHolder.super.keyPressed(event);
    }

    @Override
    public boolean keyReleased(KeyEvent event) {
        if (this.hasMutexWindow()) {
            assert (this.getMutexWindow() != null);
            return this.getMutexWindow().keyReleased(event);
        }
        return IWindowHolder.super.keyReleased(event);
    }

    @Override
    public boolean charTyped(CharacterEvent event) {
        if (this.hasMutexWindow()) {
            assert (this.getMutexWindow() != null);
            return this.getMutexWindow().charTyped(event);
        }
        return IWindowHolder.super.charTyped(event);
    }

    public static void drawGrayishBackground(GuiGraphics guiGraphics) {
        guiGraphics.pose().pushMatrix();
        guiGraphics.fillGradient(0, 0, guiGraphics.guiWidth(), guiGraphics.guiHeight(), -1072689136, -804253680);
        guiGraphics.pose().popMatrix();
    }
}

