/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import cx.rain.mc.nbtedit.NBTEdit;
import cx.rain.mc.nbtedit.NBTEditPlatform;
import cx.rain.mc.nbtedit.api.command.ModPermissions;
import cx.rain.mc.nbtedit.networking.NetworkEditingHelper;
import cx.rain.mc.nbtedit.networking.packet.s2c.RaytracePacket;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class NBTEditCommand {
    public static final LiteralArgumentBuilder<CommandSourceStack> NBTEDIT = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nbtedit").requires(source -> NBTEditPlatform.getPermission().hasPermission((CommandSourceStack)source, ModPermissions.USE))).executes(NBTEditCommand::onUse)).then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entity()).executes(NBTEditCommand::onEntity))).then(Commands.argument((String)"block", (ArgumentType)BlockPosArgument.blockPos()).executes(NBTEditCommand::onBlockEntity))).then(Commands.literal((String)"me").executes(NBTEditCommand::onEntityMe))).then(Commands.literal((String)"hand").executes(NBTEditCommand::onItemHand));

    private static int onUse(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        NBTEditPlatform.getNetworking().sendTo(player, new RaytracePacket());
        NBTEdit.getInstance().getLogger().info("Player {} issued command /nbtedit.", (Object)player.getName().getString());
        return 1;
    }

    private static int onEntity(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Entity entity = EntityArgument.getEntity(context, (String)"entity");
        NBTEdit.getInstance().getLogger().info("Player {} issued command /nbtedit with an entity.", (Object)player.getName().getString());
        NetworkEditingHelper.editEntity(player, entity.getUUID());
        return 1;
    }

    private static int onBlockEntity(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        BlockPos pos = BlockPosArgument.getBlockPos(context, (String)"block");
        NBTEdit.getInstance().getLogger().info("Player {} issued command /nbtedit with an block at XYZ: {} {} {}.", new Object[]{player.getName().getString(), pos.getX(), pos.getY(), pos.getZ()});
        NetworkEditingHelper.editBlockEntity(player, pos);
        return 1;
    }

    private static int onEntityMe(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        NBTEdit.getInstance().getLogger().info("Player {} issued command /nbtedit to edit itself.", (Object)player.getName().getString());
        NetworkEditingHelper.editEntity(player, player.getUUID());
        return 1;
    }

    private static int onItemHand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        NBTEdit.getInstance().getLogger().info("Player {} issued command /nbtedit to edit hand.", (Object)player.getName().getString());
        ItemStack stack = player.getMainHandItem();
        NetworkEditingHelper.editItemStack(player, stack);
        return 1;
    }
}

