/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.editor;

import cx.rain.mc.nbtedit.editor.NbtTree;
import cx.rain.mc.nbtedit.editor.NbtType;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class EditorHelper {
    public static Tag newTag(int buttonId) {
        return switch (buttonId) {
            case 0 -> ByteTag.valueOf((byte)0);
            case 1 -> ShortTag.valueOf((short)0);
            case 2 -> IntTag.valueOf((int)0);
            case 3 -> LongTag.valueOf((long)0L);
            case 4 -> FloatTag.valueOf((float)0.0f);
            case 5 -> DoubleTag.valueOf((double)0.0);
            case 6 -> new ByteArrayTag(new byte[0]);
            case 7 -> StringTag.valueOf((String)"");
            case 8 -> new ListTag();
            case 9 -> new CompoundTag();
            case 10 -> new IntArrayTag(new int[0]);
            case 11 -> new LongArrayTag(new long[0]);
            default -> null;
        };
    }

    public static String newTagName(int buttonId, NbtTree.Node<?> parent) {
        NbtType type = NbtType.ofButtonId(buttonId);
        if (!parent.hasChild()) {
            return String.valueOf((Object)type) + " 1";
        }
        for (int i = 1; i <= parent.getChildren().size() + 1; ++i) {
            String name = type.getTagName() + " " + i;
            if (!EditorHelper.isNameValidInNode(name, parent)) continue;
            return name;
        }
        return String.valueOf((Object)type) + " INF";
    }

    public static boolean isNameValidInNode(String name, NbtTree.Node<?> parent) {
        for (NbtTree.Node<Tag> node : parent.getChildren()) {
            if (!node.getName().equals(name)) continue;
            return false;
        }
        return true;
    }
}

