/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.editor.tag;

import com.mojang.serialization.DynamicOps;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagParseHelper {
    public static <C extends Tag> TagType<C> getTagType(byte type) {
        return switch (type) {
            case 0 -> EndTag.TYPE;
            case 1 -> ByteTag.TYPE;
            case 2 -> ShortTag.TYPE;
            case 3 -> IntTag.TYPE;
            case 4 -> LongTag.TYPE;
            case 5 -> FloatTag.TYPE;
            case 6 -> DoubleTag.TYPE;
            case 7 -> ByteArrayTag.TYPE;
            case 8 -> StringTag.TYPE;
            case 9 -> ListTag.TYPE;
            case 10 -> CompoundTag.TYPE;
            case 11 -> IntArrayTag.TYPE;
            case 12 -> LongArrayTag.TYPE;
            default -> throw new IllegalStateException("Unexpected value: " + type);
        };
    }

    @Nullable
    public static <C extends Tag> C getAs(@NotNull CompoundTag parent, @NotNull String name, byte type) {
        if (!parent.contains(name)) {
            return null;
        }
        Tag tag = parent.get(name);
        if (tag == null) {
            return null;
        }
        return (C)(switch (type) {
            case 1 -> tag.asByte().map(ByteTag::valueOf).orElse(null);
            case 2 -> tag.asShort().map(ShortTag::valueOf).orElse(null);
            case 3 -> tag.asInt().map(IntTag::valueOf).orElse(null);
            case 4 -> tag.asLong().map(LongTag::valueOf).orElse(null);
            case 5 -> tag.asFloat().map(FloatTag::valueOf).orElse(null);
            case 6 -> tag.asDouble().map(DoubleTag::valueOf).orElse(null);
            case 7 -> tag.asByteArray().map(ByteArrayTag::new).orElse(null);
            case 8 -> tag.asString().map(StringTag::valueOf).orElse(null);
            case 9 -> tag.asList().orElse(null);
            case 10 -> tag.asCompound().orElse(null);
            case 11 -> tag.asIntArray().map(IntArrayTag::new).orElse(null);
            case 12 -> tag.asLongArray().map(LongArrayTag::new).orElse(null);
            default -> throw new IllegalStateException("Unexpected value: " + type);
        });
    }

    public static byte getListElementType(@NotNull ListTag list) {
        byte type = 0;
        for (Tag e : list) {
            byte c = e.getId();
            if (type == 0) {
                type = c;
                continue;
            }
            if (type == c) continue;
            return 10;
        }
        return type;
    }

    public static String getAsString(@NotNull Tag tag) {
        return tag.toString();
    }

    public static String getValueAsString(@NotNull Tag tag) {
        Tag tag2 = tag;
        Objects.requireNonNull(tag2);
        Tag tag3 = tag2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ByteTag.class, ShortTag.class, IntTag.class, LongTag.class, FloatTag.class, DoubleTag.class, StringTag.class, ByteArrayTag.class, IntArrayTag.class, LongArrayTag.class}, (Object)tag3, n)) {
            case 0: {
                ByteTag b = (ByteTag)tag3;
                return Byte.toString(b.byteValue());
            }
            case 1: {
                ShortTag s = (ShortTag)tag3;
                return Short.toString(s.shortValue());
            }
            case 2: {
                IntTag i = (IntTag)tag3;
                return Integer.toString(i.intValue());
            }
            case 3: {
                LongTag l = (LongTag)tag3;
                return Long.toString(l.longValue());
            }
            case 4: {
                FloatTag f = (FloatTag)tag3;
                return Float.toString(f.floatValue());
            }
            case 5: {
                DoubleTag d = (DoubleTag)tag3;
                return Double.toString(d.doubleValue());
            }
            case 6: {
                StringTag s = (StringTag)tag3;
                return s.value();
            }
            case 7: {
                ByteArrayTag ba = (ByteArrayTag)tag3;
                StringBuilder s = new StringBuilder();
                for (byte b : ba.getAsByteArray()) {
                    s.append(b).append(", ");
                }
                return s.toString();
            }
            case 8: {
                IntArrayTag ia = (IntArrayTag)tag3;
                StringBuilder s = new StringBuilder();
                for (int i : ia.getAsIntArray()) {
                    s.append(i).append(", ");
                }
                return s.toString();
            }
            case 9: {
                LongArrayTag la = (LongArrayTag)tag3;
                StringBuilder s = new StringBuilder();
                for (long l : la.getAsLongArray()) {
                    s.append(l).append(", ");
                }
                return s.toString();
            }
        }
        return "";
    }

    public static void putUuid(@NotNull CompoundTag tag, @NotNull String name, @NotNull UUID uuid) {
        tag.store(name, UUIDUtil.CODEC, (Object)uuid);
    }

    @Nullable
    public static UUID getUuid(@NotNull CompoundTag tag, @NotNull String name) {
        return tag.read(name, UUIDUtil.CODEC).orElse(null);
    }

    @Nullable
    public static UUID loadUuid(@NotNull Tag tag) {
        return (UUID)UUIDUtil.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).mapOrElse(u -> u, e -> null);
    }

    @Nullable
    public static Tag createUuid(@NotNull UUID uuid) {
        return (Tag)UUIDUtil.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)uuid).mapOrElse(i -> i, e -> null);
    }
}

