/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.gui;

import cx.rain.mc.nbtedit.editor.ClipboardHelper;
import cx.rain.mc.nbtedit.editor.EditorButton;
import cx.rain.mc.nbtedit.editor.EditorHelper;
import cx.rain.mc.nbtedit.editor.NbtTree;
import cx.rain.mc.nbtedit.gui.component.ButtonComponent;
import cx.rain.mc.nbtedit.gui.component.ScrollableViewport;
import cx.rain.mc.nbtedit.gui.editor.EditingWindow;
import cx.rain.mc.nbtedit.gui.editor.EditorButtonComponent;
import cx.rain.mc.nbtedit.gui.editor.NbtTreeView;
import cx.rain.mc.nbtedit.gui.screen.AbstractScreen;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class EditorScreen
extends AbstractScreen {
    private final NbtTree tree;
    private final Consumer<CompoundTag> onSave;
    private final boolean readOnly;
    private ScrollableViewport treeViewport;
    private NbtTreeView treeView;
    private final EditorButtonComponent[] editorButtons = new EditorButtonComponent[17];
    private long lastClickTime = 0L;

    public EditorScreen(CompoundTag tag, Component title, Consumer<CompoundTag> onSave, boolean readOnly) {
        super((Component)(readOnly ? Component.translatable((String)"gui.nbtedit.title.editor.read_only").append(title) : title));
        this.onSave = onSave;
        this.readOnly = readOnly;
        this.tree = NbtTree.root(tag);
    }

    @Override
    protected void createChildren() {
        ButtonComponent saveButton;
        this.width = this.minecraft.getWindow().getGuiScaledWidth();
        this.height = this.minecraft.getWindow().getGuiScaledHeight();
        this.treeViewport = new ScrollableViewport(0, 40, this.width, this.height - 76);
        this.treeView = new NbtTreeView(this.tree, 0, 0, v -> this.updateButtons());
        this.treeViewport.addChild(this.treeView);
        this.addChild(this.treeViewport);
        if (!this.readOnly) {
            saveButton = ButtonComponent.getBuilder((Component)Component.translatable((String)"gui.nbtedit.button.save"), b -> this.onSave()).pos(this.width / 4 - 100, this.height - 27).size(200, 20).createNarration(c -> ((MutableComponent)c.get()).append((Component)Component.translatable((String)"gui.nbtedit.tooltip.button_save"))).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.nbtedit.tooltip.button_save"))).build();
        } else {
            saveButton = ButtonComponent.getBuilder((Component)Component.translatable((String)"gui.nbtedit.button.save"), b -> {}).pos(this.width / 4 - 100, this.height - 27).size(200, 20).createNarration(c -> ((MutableComponent)c.get()).append((Component)Component.translatable((String)"gui.nbtedit.tooltip.button_save.disabled"))).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.nbtedit.tooltip.button_save.disabled"))).build();
            saveButton.active = false;
        }
        this.addChild(saveButton);
        ButtonComponent quitButton = ButtonComponent.getBuilder((Component)Component.translatable((String)"gui.nbtedit.button.quit"), b -> this.onQuit()).pos(this.width * 3 / 4 - 100, this.height - 27).size(200, 20).createNarration(c -> ((MutableComponent)c.get()).append((Component)Component.translatable((String)"gui.nbtedit.tooltip.button_quit"))).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.nbtedit.tooltip.button_quit"))).build();
        this.addChild(quitButton);
        this.initButtons();
        this.update(false);
    }

    @Override
    public void update() {
        this.treeViewport.update();
        this.updateButtons();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBlurredBackground(guiGraphics);
        this.renderMenuBackground(guiGraphics, 0, 0, this.width, 40);
        this.renderMenuBackground(guiGraphics, 0, this.height - 35, this.width, this.height);
    }

    private void initButtons() {
        int xLoc = 18;
        int yLoc = 15;
        this.buildButton(EditorButton.COPY, xLoc, yLoc, b -> this.onCopy());
        this.buildButton(EditorButton.CUT, xLoc += 15, yLoc, b -> this.onCut());
        this.buildButton(EditorButton.PASTE, xLoc += 15, yLoc, b -> this.onPaste());
        this.buildButton(EditorButton.DELETE, xLoc += 15, yLoc, b -> this.onDelete());
        this.buildButton(EditorButton.EDIT, xLoc += 54, yLoc, b -> this.onEdit());
        xLoc = 18;
        yLoc = 27;
        int i = 0;
        while (i < 12) {
            int id = i++;
            this.buildAddButton(EditorButton.of(id), xLoc, yLoc, b -> this.onAddButtonsClick(id));
            xLoc += 9;
        }
        this.updateButtons();
    }

    private void buildButton(EditorButton button, int x, int y, Button.OnPress onPress) {
        EditorButtonComponent b = new EditorButtonComponent(button, x, y, button.getName(), onPress);
        this.addButton(button.getId(), b);
    }

    private void buildAddButton(EditorButton button, int x, int y, Button.OnPress onPress) {
        EditorButtonComponent b = new EditorButtonComponent(button, x, y, (Component)Component.translatable((String)"gui.nbtedit.button.add", (Object[])new Object[]{button.getName().getString()}), onPress);
        this.addButton(button.getId(), b);
    }

    private void addButton(int id, EditorButtonComponent button) {
        this.editorButtons[id] = button;
        this.addChild(button);
    }

    protected void onEdit() {
        if (!this.editorButtons[12].active) {
            return;
        }
        this.doEdit();
        this.update(false);
    }

    protected void onDelete() {
        this.doDelete();
        this.update(true);
    }

    protected void onPaste() {
        this.doPaste();
        this.update(true);
    }

    protected void onCut() {
        this.doCopy();
        this.doDelete();
        this.update(true);
    }

    protected void onCopy() {
        this.doCopy();
        this.update(false);
    }

    protected void onAddButtonsClick(int id) {
        NbtTree.Node<?> focused;
        if (id >= 0 && id <= 12 && (focused = this.treeView.getFocusedNode()) != null) {
            focused.setShowChildren(true);
            Tag tag = EditorHelper.newTag(id);
            if (focused.getTag() instanceof ListTag) {
                if (tag != null) {
                    NbtTree.Node<Tag> newChild = focused.newChild("", tag);
                    this.treeView.setFocusedNode(newChild);
                }
            } else if (tag != null) {
                NbtTree.Node<Tag> newChild = focused.newChild(EditorHelper.newTagName(id, focused), tag);
                this.treeView.setFocusedNode(newChild);
            }
        }
        this.update(true);
    }

    private void onSave() {
        this.doSave();
        this.doClose();
    }

    private void onQuit() {
        this.doClose();
    }

    public void updateButtons() {
        if (this.readOnly) {
            this.inactiveAllButtons();
            return;
        }
        EditorButtonComponent editButton = this.editorButtons[12];
        EditorButtonComponent deleteButton = this.editorButtons[13];
        EditorButtonComponent pasteButton = this.editorButtons[14];
        EditorButtonComponent cutButton = this.editorButtons[15];
        EditorButtonComponent copyButton = this.editorButtons[16];
        NbtTree.Node<?> nodeToFocus = this.treeView.getFocusedNode();
        if (nodeToFocus == null) {
            this.inactiveAllButtons();
        } else if (nodeToFocus.getTag() instanceof CompoundTag) {
            this.activeAllButtons();
            editButton.active = nodeToFocus.hasParent() && !(nodeToFocus.getParent().getTag() instanceof ListTag);
            deleteButton.active = nodeToFocus != this.tree.getRoot();
            cutButton.active = nodeToFocus != this.tree.getRoot();
            pasteButton.active = ClipboardHelper.getNode() != null;
        } else if (nodeToFocus.getTag() instanceof ListTag) {
            if (nodeToFocus.hasChild()) {
                byte elementType = nodeToFocus.getChildren().get(0).getTag().getId();
                this.inactiveAllButtons();
                this.editorButtons[elementType - 1].setActive(true);
                editButton.active = !(nodeToFocus.getParent().getTag() instanceof ListTag);
                deleteButton.setActive(true);
                copyButton.setActive(true);
                cutButton.setActive(true);
                pasteButton.active = ClipboardHelper.getNode() != null && ClipboardHelper.getNode().getTag().getId() == elementType;
            } else {
                this.activeAllButtons();
                editButton.active = !(nodeToFocus.getParent().getTag() instanceof ListTag);
                pasteButton.active = ClipboardHelper.getNode() != null;
            }
        } else {
            this.inactiveAllButtons();
            editButton.setActive(true);
            deleteButton.setActive(true);
            copyButton.setActive(true);
            cutButton.setActive(true);
        }
    }

    private void activeAllButtons() {
        for (int i = 0; i < 17; ++i) {
            this.editorButtons[i].setActive(true);
        }
    }

    private void inactiveAllButtons() {
        for (int i = 0; i < 17; ++i) {
            this.editorButtons[i].setActive(false);
        }
    }

    private void update(boolean centerFocused) {
        this.update();
    }

    public void doEdit() {
        if (this.hasMutexWindow()) {
            return;
        }
        NbtTree.Node<?> focused = this.treeView.getFocusedNode();
        Object tag = focused.getTag();
        Object parent = focused.getParent().getTag();
        EditingWindow editor = new EditingWindow((this.width - 178) / 2, (this.height - 93) / 2, focused, !(parent instanceof ListTag), !(tag instanceof CompoundTag) && !(tag instanceof ListTag));
        this.addWindow(editor, true, true);
    }

    private void doCopy() {
        NbtTree.Node<?> node = this.treeView.getFocusedNode();
        if (node != null) {
            Object obj = node.getTag();
            if (obj instanceof ListTag) {
                ListTag list = (ListTag)obj;
                ClipboardHelper.setNode(NbtTree.Node.root(list));
            } else {
                obj = node.getTag();
                if (obj instanceof CompoundTag) {
                    CompoundTag compound = (CompoundTag)obj;
                    ClipboardHelper.setNode(NbtTree.Node.root(compound));
                } else {
                    ClipboardHelper.setNode(node);
                }
            }
        } else {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.VILLAGER_NO, (float)1.0f));
        }
    }

    private void doPaste() {
        NbtTree.Node<?> focused = this.treeView.getFocusedNode();
        if (focused != null) {
            Object tag = focused.getTag();
            if (!(tag instanceof CompoundTag) && !(tag instanceof CollectionTag)) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.VILLAGER_NO, (float)1.0f));
                return;
            }
            NbtTree.Node<?> toPaste = ClipboardHelper.getNode();
            if (toPaste != null) {
                focused.setShowChildren(true);
                if (focused.getTag() instanceof ListTag) {
                    toPaste.setName("");
                } else {
                    String name = "Paste";
                    List<NbtTree.Node<Tag>> children = focused.getChildren();
                    for (int i = 1; i < children.size(); ++i) {
                        NbtTree.Node<Tag> child = children.get(i);
                        if (EditorHelper.isNameValidInNode(name, child)) continue;
                        toPaste.setName("Paste " + i);
                    }
                }
                focused.addChild(toPaste);
                this.treeView.setFocusedNode(toPaste);
                this.update(true);
            }
        } else {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.VILLAGER_NO, (float)1.0f));
        }
    }

    public void doDelete() {
        NbtTree.Node<?> focused = this.treeView.getFocusedNode();
        if (focused != null) {
            NbtTree.Node<?> parent = focused.getParent();
            parent.removeChild(focused);
            this.treeView.setFocusedNode(parent);
            this.update(true);
        }
    }

    private void doSave() {
        this.onSave.accept(this.tree.toCompound());
    }

    private void doClose() {
        this.minecraft.setScreen(null);
        this.minecraft.cursorEntered();
    }

    @Override
    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        if (this.treeView.getFocusedChild() != null && Util.getMillis() - this.lastClickTime <= 250L) {
            this.onEdit();
            return true;
        }
        this.lastClickTime = Util.getMillis();
        return super.mouseClicked(event, isDoubleClick);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.lastClickTime = 0L;
        super.mouseMoved(mouseX, mouseY);
    }

    @Override
    public boolean keyPressed(KeyEvent event) {
        int keyCode = event.key();
        int modifiers = event.modifiers();
        if (!this.hasWindow()) {
            if (keyCode == 67 && modifiers == 2) {
                if (this.getFocused() != null) {
                    this.doCopy();
                    this.update(true);
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                } else {
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.VILLAGER_NO, (float)1.0f));
                }
                return true;
            }
            if (keyCode == 86 && modifiers == 2) {
                if (this.getFocused() != null) {
                    this.doPaste();
                    this.update(true);
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                } else {
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.VILLAGER_NO, (float)1.0f));
                }
                return true;
            }
            if (keyCode == 88 && modifiers == 2) {
                if (this.getFocused() != null) {
                    this.doCopy();
                    this.doDelete();
                    this.update(true);
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                } else {
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.VILLAGER_NO, (float)1.0f));
                }
                return true;
            }
            if (keyCode == 68 && modifiers == 2 || keyCode == 261) {
                if (this.getFocused() != null) {
                    this.doDelete();
                    this.update(true);
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                } else {
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.VILLAGER_NO, (float)1.0f));
                }
                return true;
            }
            if (keyCode == 257) {
                if (this.getFocused() != null) {
                    this.onEdit();
                } else {
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.VILLAGER_NO, (float)1.0f));
                }
                return true;
            }
            if (keyCode == 256) {
                this.onQuit();
                return true;
            }
        }
        return super.keyPressed(event);
    }
}

