/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.utility.client;

import cx.rain.mc.nbtedit.NBTEditPlatform;
import cx.rain.mc.nbtedit.networking.packet.c2s.BlockEntityRaytraceResultPacket;
import cx.rain.mc.nbtedit.networking.packet.c2s.EntityRaytraceResultPacket;
import cx.rain.mc.nbtedit.networking.packet.c2s.ItemStackRaytraceResultPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RayTraceHelper {
    public static void doRayTrace() {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        float partialTicks = minecraft.getDeltaTracker().getGameTimeDeltaPartialTick(true);
        HitResult result = RayTraceHelper.pick((Entity)player, player.blockInteractionRange(), player.entityInteractionRange(), partialTicks);
        if (result.getType() == HitResult.Type.BLOCK) {
            BlockHitResult block = (BlockHitResult)result;
            NBTEditPlatform.getNetworking().sendToServer(new BlockEntityRaytraceResultPacket(block.getBlockPos()));
        } else if (result.getType() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)result).getEntity();
            NBTEditPlatform.getNetworking().sendToServer(new EntityRaytraceResultPacket(entity.getUUID(), entity.getId()));
        } else if (!player.getMainHandItem().isEmpty()) {
            NBTEditPlatform.getNetworking().sendToServer(new ItemStackRaytraceResultPacket(player.getMainHandItem()));
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"message.nbtedit.nothing_to_edit").withStyle(ChatFormatting.RED), false);
        }
    }

    @NotNull
    private static HitResult pick(Entity entity, double blockInteractionRange, double entityInteractionRange, float partialTick) {
        AABB box;
        double d = Math.max(blockInteractionRange, entityInteractionRange);
        double e = Mth.square((double)d);
        Vec3 eye = entity.getEyePosition(partialTick);
        HitResult hitResult = entity.pick(d, partialTick, false);
        double f = hitResult.getLocation().distanceToSqr(eye);
        if (hitResult.getType() != HitResult.Type.MISS) {
            e = f;
            d = Math.sqrt(f);
        }
        Vec3 view = entity.getViewVector(partialTick);
        Vec3 eyeView = eye.add(view.x * d, view.y * d, view.z * d);
        EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)eye, (Vec3)eyeView, (AABB)(box = entity.getBoundingBox().expandTowards(view.scale(d)).inflate(1.0)), __ -> true, (double)e);
        return entityHitResult != null && entityHitResult.getLocation().distanceToSqr(eye) < f ? RayTraceHelper.filterHitResult((HitResult)entityHitResult, eye, entityInteractionRange) : RayTraceHelper.filterHitResult(hitResult, eye, blockInteractionRange);
    }

    private static HitResult filterHitResult(HitResult hitResult, Vec3 pos, double blockInteractionRange) {
        Vec3 hit = hitResult.getLocation();
        if (!hit.closerThan((Position)pos, blockInteractionRange)) {
            Direction direction = Direction.getApproximateNearest((double)(hit.x - pos.x), (double)(hit.y - pos.y), (double)(hit.z - pos.z));
            return BlockHitResult.miss((Vec3)hit, (Direction)direction, (BlockPos)BlockPos.containing((Position)hit));
        }
        return hitResult;
    }
}

