/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.networking;

import cx.rain.mc.nbtedit.NBTEdit;
import cx.rain.mc.nbtedit.NBTEditPlatform;
import cx.rain.mc.nbtedit.networking.NetworkingHelper;
import cx.rain.mc.nbtedit.networking.packet.common.BlockEntityEditingPacket;
import cx.rain.mc.nbtedit.networking.packet.common.EntityEditingPacket;
import cx.rain.mc.nbtedit.networking.packet.common.ItemStackEditingPacket;
import cx.rain.mc.nbtedit.utility.RegistryContextSerializer;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;

public class NetworkEditingHelper {
    public static void editBlockEntity(ServerPlayer player, BlockPos pos) {
        player.getServer().execute(() -> {
            if (!NetworkingHelper.checkReadPermission(player)) {
                return;
            }
            if (!NetworkingHelper.checkPosLoaded(player, pos)) {
                return;
            }
            NBTEdit.getInstance().getLogger().debug("Player {} requested BlockEntity at {} {} {}.", new Object[]{player.getName().getString(), pos.getX(), pos.getY(), pos.getZ()});
            BlockEntity blockEntity = player.level().getBlockEntity(pos);
            if (blockEntity == null) {
                player.createCommandSourceStack().sendFailure((Component)Component.translatable((String)"message.nbtedit.target_is_not_block_entity").withStyle(ChatFormatting.RED));
                return;
            }
            player.sendSystemMessage((Component)Component.translatable((String)"message.nbtedit.editing.block_entity", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).withStyle(ChatFormatting.GREEN));
            CompoundTag tag = blockEntity.saveWithFullMetadata((HolderLookup.Provider)player.getServer().registryAccess());
            NBTEditPlatform.getNetworking().sendTo(player, new BlockEntityEditingPacket(tag, NBTEditPlatform.getPermission().isReadOnly(player), pos));
        });
    }

    public static void editEntity(ServerPlayer player, UUID entityUuid) {
        player.getServer().execute(() -> {
            if (!NetworkingHelper.checkReadPermission(player)) {
                return;
            }
            Entity entity = player.level().getEntity(entityUuid);
            assert (entity != null);
            if (entity instanceof Player && entity != player && !NetworkingHelper.checkEditOnPlayerPermission(player)) {
                NBTEdit.getInstance().getLogger().info("Player {} tried to use nbtedit on a player which is not allowed.", (Object)player.getName().getString());
                return;
            }
            NBTEdit.getInstance().getLogger().debug("Player {} is editing entity {}.", (Object)player.getName().getString(), player == entity ? "themself" : entity.getUUID());
            player.sendSystemMessage((Component)Component.translatable((String)"message.nbtedit.editing.entity", (Object[])new Object[]{entityUuid.toString()}).withStyle(ChatFormatting.GREEN));
            RegistryContextSerializer serializer = NBTEdit.getInstance().getRegistryContextSerializer();
            TagValueOutput output = serializer.createTagValueOutput();
            if (entity instanceof Player) {
                entity.saveWithoutId((ValueOutput)output);
            } else {
                entity.saveAsPassenger((ValueOutput)output);
            }
            NBTEditPlatform.getNetworking().sendTo(player, new EntityEditingPacket(output.buildResult(), NBTEditPlatform.getPermission().isReadOnly(player), entity.getUUID(), entity.getId()));
        });
    }

    public static void editItemStack(ServerPlayer player, ItemStack stack) {
        player.getServer().execute(() -> {
            if (!NetworkingHelper.checkReadPermission(player)) {
                return;
            }
            if (stack.isEmpty()) {
                player.sendSystemMessage((Component)Component.literal((String)"message.nbtedit.nothing_to_edit").withStyle(ChatFormatting.RED));
                return;
            }
            NBTEdit.getInstance().getLogger().debug("Player {} is editing ItemStack named {}.", (Object)player.getName().getString(), (Object)stack.getDisplayName().getString());
            player.sendSystemMessage((Component)Component.translatable((String)"message.nbtedit.editing.item_stack", (Object[])new Object[]{stack.getDisplayName().getString()}).withStyle(ChatFormatting.GREEN));
            CompoundTag tag = NBTEdit.getInstance().getRegistryContextSerializer().serializeItemStack(stack);
            NBTEditPlatform.getNetworking().sendTo(player, new ItemStackEditingPacket(tag, NBTEditPlatform.getPermission().isReadOnly(player), stack));
        });
    }
}

