/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.utility;

import cx.rain.mc.nbtedit.NBTEdit;
import cx.rain.mc.nbtedit.NBTEditPlatform;
import cx.rain.mc.nbtedit.editor.tag.TagParseHelper;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;

public class LoggingHelper {
    private static Logger getLogger() {
        return NBTEdit.getInstance().getLogger();
    }

    private static boolean isDebug() {
        return NBTEditPlatform.getConfig().isDebug();
    }

    public static void errorParsingTag(Throwable ex, Tag tag) {
        LoggingHelper.getLogger().warn("Parse failed! Check tag structure.");
        if (LoggingHelper.isDebug()) {
            LoggingHelper.getLogger().debug("Runtime error while parsing tag.\nData: {}\nException: {}.", (Object)TagParseHelper.getAsString(tag), (Object)new RuntimeException(ex));
        }
    }

    public static void debugEntityTag(UUID uuid, Tag tag) {
        if (LoggingHelper.isDebug()) {
            LoggingHelper.getLogger().debug("New NBT of Entity {} is {}.", (Object)uuid, (Object)TagParseHelper.getAsString(tag));
        }
    }

    public static void debugBlockEntityTag(BlockPos pos, Tag tag) {
        if (LoggingHelper.isDebug()) {
            LoggingHelper.getLogger().debug("New NBT of BlockEntity at ({},{},{}) is {}.", new Object[]{pos.getX(), pos.getY(), pos.getZ(), TagParseHelper.getAsString(tag)});
        }
    }

    public static void debugItemStackTag(Player player, Tag tag) {
        if (LoggingHelper.isDebug()) {
            LoggingHelper.getLogger().debug("New NBT of ItemStack on {}'s hand is {}.", (Object)player.getName(), (Object)TagParseHelper.getAsString(tag));
        }
    }
}

