/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.editor;

import com.google.common.base.Strings;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import cx.rain.mc.nbtedit.editor.tag.TagParseHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;

public class NbtTree {
    private final Node<CompoundTag> rootNode;

    private NbtTree(Node<CompoundTag> root) {
        this.rootNode = root;
    }

    public static NbtTree root(CompoundTag tag) {
        return new NbtTree(Node.root(tag));
    }

    public CompoundTag toCompound() {
        return this.compoundNodeToTag(this.rootNode);
    }

    public Node<CompoundTag> getRoot() {
        return this.rootNode;
    }

    private CompoundTag compoundNodeToTag(Node<?> node) {
        CompoundTag tag = new CompoundTag();
        for (Node<Tag> child : node.getChildren()) {
            String name = child.getName();
            Tag childTag = child.getTag();
            if (childTag instanceof CompoundTag) {
                tag.put(name, (Tag)this.compoundNodeToTag(child));
                continue;
            }
            if (childTag instanceof ListTag) {
                tag.put(name, (Tag)this.listNodeToTag(child));
                continue;
            }
            tag.put(name, childTag);
        }
        return tag;
    }

    private ListTag listNodeToTag(Node<?> node) {
        ListTag tag = new ListTag();
        for (Node<Tag> child : node.getChildren()) {
            Tag childTag = child.getTag();
            if (childTag instanceof CompoundTag) {
                tag.add((Object)this.compoundNodeToTag(child));
                continue;
            }
            if (childTag instanceof ListTag) {
                tag.add((Object)this.listNodeToTag(child));
                continue;
            }
            tag.add((Object)childTag);
        }
        return tag;
    }

    public static class Node<T extends Tag> {
        private String name;
        private T nbtTag;
        private Node<? extends Tag> parent = null;
        private final List<Node<Tag>> children = new ArrayList<Node<Tag>>();
        private boolean shouldShowChildren = false;
        public static final String TAG_NAME = "name";
        public static final String TAG_TYPE = "type";
        public static final String TAG_LIST_TYPE = "elementType";
        public static final String TAG_VALUE = "value";

        private Node(T tag) {
            this("", tag);
        }

        private Node(String name, T tag) {
            this(name, tag, null);
        }

        private Node(String name, T tag, Node<?> parentTag) {
            this.name = name;
            this.nbtTag = tag;
            this.parent = parentTag;
            this.walkThough((Tag)tag);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public T getTag() {
            return this.nbtTag;
        }

        public void setTag(Tag tag) {
            this.nbtTag = tag;
        }

        private void walkThough(Tag tag) {
            if (tag instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)tag;
                for (Map.Entry entry : compound.tags.entrySet()) {
                    this.newChild((String)entry.getKey(), (Tag)entry.getValue());
                }
            }
            if (tag instanceof ListTag) {
                ListTag list = (ListTag)tag;
                for (Tag item : list.list) {
                    this.newChild(item);
                }
            }
        }

        public static <T extends Tag> Node<T> root(T tag) {
            return new Node<T>(tag);
        }

        protected void newChild(Tag tag) {
            this.newChild("", tag);
        }

        public Node<Tag> newChild(String name, Tag tag) {
            Node<Tag> newChild = new Node<Tag>(name, tag, this);
            this.children.add(newChild);
            return newChild;
        }

        public void addChild(Node<T> node) {
            this.children.add(node);
            node.setParent(this);
        }

        private void setParent(Node<T> parent) {
            this.parent = parent;
        }

        public void removeChild(int index) {
            this.children.remove(index);
        }

        public void removeChild(Node<?> node) {
            this.children.remove(node);
        }

        public boolean hasChild() {
            return !this.children.isEmpty();
        }

        public List<Node<Tag>> getChildren() {
            return this.children;
        }

        public boolean hasParent() {
            return this.parent != null;
        }

        public boolean isRoot() {
            return !this.hasParent();
        }

        public Node<?> getParent() {
            return this.parent;
        }

        public boolean shouldShowChildren() {
            return this.shouldShowChildren;
        }

        public void setShowChildren(boolean value) {
            this.shouldShowChildren = value;
            if (!value) {
                for (Node<Tag> c : this.getChildren()) {
                    c.setShowChildren(false);
                }
            }
        }

        public String getAsString() {
            String name = this.getName();
            T tag = this.getTag();
            if (tag instanceof CompoundTag) {
                return (Strings.isNullOrEmpty((String)name) ? "(CompoundTag)" : name) + ": ";
            }
            if (tag instanceof ListTag) {
                return (Strings.isNullOrEmpty((String)name) ? "(ListTag)" : name) + ": ";
            }
            String s = TagParseHelper.getValueAsString(tag);
            return Strings.isNullOrEmpty((String)name) ? s : name + ": " + s;
        }

        public static Node<Tag> fromString(String data) {
            try {
                CompoundTag tag = TagParser.parseCompoundFully((String)data);
                Optional nameOptional = tag.getString(TAG_NAME);
                Optional typeOptional = tag.getByte(TAG_TYPE);
                if (nameOptional.isEmpty() || typeOptional.isEmpty()) {
                    return null;
                }
                String name = (String)nameOptional.get();
                Byte type = (Byte)typeOptional.get();
                if (!tag.contains(name)) {
                    return null;
                }
                Object t = TagParseHelper.getAs(tag, name, type);
                return new Node<Tag>(name, (Tag)t);
            }
            catch (CommandSyntaxException | IllegalStateException ignored) {
                return null;
            }
        }

        public String asString() {
            CompoundTag tag = new CompoundTag();
            tag.putString(TAG_NAME, this.name);
            tag.put(TAG_VALUE, this.nbtTag);
            tag.putByte(TAG_TYPE, this.nbtTag.getId());
            T t = this.nbtTag;
            if (t instanceof ListTag) {
                ListTag listTag = (ListTag)t;
                tag.putByte(TAG_LIST_TYPE, TagParseHelper.getListElementType(listTag));
            }
            return TagParseHelper.getAsString((Tag)tag);
        }
    }
}

