/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.gui.editor;

import cx.rain.mc.nbtedit.editor.NbtTree;
import cx.rain.mc.nbtedit.editor.NodeParser;
import cx.rain.mc.nbtedit.editor.TagReadingHelper;
import cx.rain.mc.nbtedit.editor.tag.TagParseHelper;
import cx.rain.mc.nbtedit.gui.component.ButtonComponent;
import cx.rain.mc.nbtedit.gui.component.EditBoxComponent;
import cx.rain.mc.nbtedit.gui.component.IComposedComponent;
import cx.rain.mc.nbtedit.gui.window.AbstractWindow;
import cx.rain.mc.nbtedit.gui.window.IWindowHolder;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class EditingWindow
extends AbstractWindow {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nbtedit", (String)"window");
    public static final int WIDTH = 178;
    public static final int HEIGHT = 93;
    private final NbtTree.Node<?> node;
    private final boolean nameEditable;
    private final boolean valueEditable;
    private EditBoxComponent nameField;
    private EditBoxComponent valueField;
    private boolean parseAsUuid = false;

    public EditingWindow(int x, int y, NbtTree.Node<?> node, boolean nameEditable, boolean valueEditable) {
        super(x, y, 178, 93, (Component)Component.translatable((String)"gui.nbtedit.title.editing_window"));
        this.node = node;
        this.nameEditable = nameEditable;
        this.valueEditable = valueEditable;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.nameEditable && this.nameField != null) {
            this.nameField.tick();
        }
        if (this.valueEditable && this.valueField != null) {
            this.valueField.tick();
        }
    }

    @Override
    protected void createChildren() {
        String name = this.nameField == null ? this.node.getName() : this.nameField.getValue();
        String value = this.valueField == null ? NodeParser.valueAsString(this.node) : this.valueField.getValue();
        UUID uuid = TagReadingHelper.tryReadUuid(this.node.getTag());
        if (uuid != null) {
            value = uuid.toString();
            this.parseAsUuid = true;
        }
        this.clearChildren();
        this.nameField = new EditBoxComponent(this.getMinecraft().font, this.getX() + 47, this.getY() + 20, 116, 15, (Component)Component.translatable((String)"gui.nbtedit.edit_box.name"));
        this.nameField.setMaxLength(Integer.MAX_VALUE);
        this.nameField.setValue(name);
        this.nameField.setEditable(this.nameEditable);
        this.nameField.active = this.nameEditable;
        this.nameField.setBordered(false);
        this.addChild(this.nameField);
        this.valueField = new EditBoxComponent(this.getMinecraft().font, this.getX() + 47, this.getY() + 46, 116, 15, (Component)Component.translatable((String)"gui.nbtedit.edit_box.value"));
        this.valueField.setMaxLength(Integer.MAX_VALUE);
        this.valueField.setValue(value);
        this.valueField.setEditable(this.valueEditable);
        this.valueField.active = this.valueEditable;
        this.valueField.setBordered(false);
        this.addChild(this.valueField);
        ButtonComponent saveButton = ButtonComponent.getBuilder((Component)Component.translatable((String)"gui.nbtedit.button.ok"), b -> this.onOk()).pos(this.getX() + 9, this.getY() + 62).size(75, 20).createNarration(n -> Component.translatable((String)"gui.nbtedit.tooltip.button_ok")).build();
        this.addChild(saveButton);
        ButtonComponent cancelButton = ButtonComponent.getBuilder((Component)Component.translatable((String)"gui.nbtedit.button.cancel"), b -> this.onCancel()).pos(this.getX() + 93, this.getY() + 62).size(75, 20).createNarration(n -> Component.translatable((String)"gui.nbtedit.tooltip.button_cancel")).build();
        this.addChild(cancelButton);
    }

    private void onOk() {
        if (this.nameEditable) {
            this.node.setName(this.nameField.getValue());
        }
        if (this.valueEditable) {
            if (this.parseAsUuid) {
                try {
                    UUID uuid = UUID.fromString(this.valueField.getValue());
                    this.node.setTag(TagParseHelper.createUuid(uuid));
                }
                catch (Exception exception) {}
            } else {
                this.node.setTag(NodeParser.getTag(this.node, this.valueField.getValue()));
            }
        }
        this.onCancel();
    }

    private void onCancel() {
        if (this.getParent() != null) {
            this.getParent().update();
            IComposedComponent iComposedComponent = this.getParent();
            if (iComposedComponent instanceof IWindowHolder) {
                IWindowHolder holder = (IWindowHolder)iComposedComponent;
                holder.closeWindow(this);
            }
        }
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, TEXTURE, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        if (!this.nameEditable) {
            guiGraphics.fill(this.getX() + 43, this.getY() + 16, this.getX() + 170, this.getY() + 31, Integer.MIN_VALUE);
        }
        if (!this.valueEditable) {
            guiGraphics.fill(this.getX() + 43, this.getY() + 43, this.getX() + 170, this.getY() + 59, Integer.MIN_VALUE);
        }
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)Component.translatable((String)"gui.nbtedit.title.editing_window.narration"));
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onCancel();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

