/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.gui.editor;

import cx.rain.mc.nbtedit.editor.NbtTree;
import cx.rain.mc.nbtedit.gui.component.AbstractComposedComponent;
import cx.rain.mc.nbtedit.gui.editor.NbtTreeViewNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class NbtTreeView
extends AbstractComposedComponent {
    private final List<NbtTreeViewNode> nodes = new ArrayList<NbtTreeViewNode>();
    private final NbtTree tree;
    private final Consumer<NbtTreeView> onFocusedUpdated;
    public static final int START_X = 10;
    public static final int START_Y = 2;
    public static final int NODE_GAP_X = 10;
    public static final int NODE_GAP_Y;
    private int nodeOffsetX = 0;
    private int nodeOffsetY = 0;
    private int maxWidth = 0;
    private int maxHeight = 0;

    public NbtTreeView(NbtTree tree, int x, int y, Consumer<NbtTreeView> onFocusedUpdated) {
        super(x, y, 100, 100, (class_2561)class_2561.method_43471((String)"gui.nbtedit.title.tree_view"));
        this.tree = tree;
        this.onFocusedUpdated = onFocusedUpdated;
    }

    @Override
    public void method_25395(@Nullable class_364 focused) {
        super.method_25395(focused);
        if (focused instanceof NbtTreeViewNode) {
            this.onFocusedUpdated.accept(this);
        }
    }

    @Nullable
    public NbtTreeViewNode getFocusedChild() {
        class_364 class_3642 = this.method_25399();
        if (class_3642 instanceof NbtTreeViewNode) {
            NbtTreeViewNode node = (NbtTreeViewNode)class_3642;
            return node;
        }
        return null;
    }

    public void setFocusedNode(@Nullable NbtTree.Node<?> node) {
        this.method_25395(null);
        if (node != null) {
            for (NbtTreeViewNode n : this.nodes) {
                if (n.getNode() != node) continue;
                this.method_25395(n);
                break;
            }
        }
    }

    @Nullable
    public NbtTree.Node<?> getFocusedNode() {
        NbtTreeViewNode c = this.getFocusedChild();
        return c != null ? c.getNode() : null;
    }

    public void update(boolean callParent) {
        if (callParent) {
            this.getParent().update();
        } else {
            this.update();
        }
    }

    @Override
    public void update() {
        this.unInitialize();
        this.initialize();
        super.update();
    }

    @Override
    protected void createChildren() {
        this.nodeOffsetX = 10;
        this.nodeOffsetY = 2;
        this.maxWidth = 0;
        this.maxHeight = 0;
        this.addNodes(this.tree.getRoot());
        this.setFocusedNode(this.getFocusedNode());
        this.method_25358(this.maxWidth);
        this.method_53533(this.maxHeight);
    }

    @Override
    public void unInitialize() {
        this.nodes.clear();
        super.unInitialize();
    }

    private void addNodes(NbtTree.Node<?> root) {
        int h;
        NbtTreeViewNode node = new NbtTreeViewNode(this.nodeOffsetX, this.nodeOffsetY, root, this);
        this.nodes.add(node);
        this.addChild(node);
        int w = node.method_46426() + node.method_25368();
        if (w > this.maxWidth) {
            this.maxWidth = w;
        }
        if ((h = node.method_46427() + node.method_25364()) > this.maxHeight) {
            this.maxHeight = h;
        }
        this.nodeOffsetY += NODE_GAP_Y;
        if (root.shouldShowChildren()) {
            this.nodeOffsetX += 10;
            for (NbtTree.Node<class_2520> child : root.getChildren()) {
                this.addNodes(child);
            }
            this.nodeOffsetX -= 10;
        }
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    static {
        Objects.requireNonNull(class_310.method_1551().field_1772);
        NODE_GAP_Y = 9 + 2;
    }
}

