/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.utility;

import cx.rain.mc.nbtedit.NBTEdit;
import cx.rain.mc.nbtedit.NBTEditPlatform;
import cx.rain.mc.nbtedit.editor.tag.TagParseHelper;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2520;
import org.slf4j.Logger;

public class LoggingHelper {
    private static Logger getLogger() {
        return NBTEdit.getInstance().getLogger();
    }

    private static boolean isDebug() {
        return NBTEditPlatform.getConfig().isDebug();
    }

    public static void errorParsingTag(Throwable ex, class_2520 tag) {
        LoggingHelper.getLogger().warn("Parse failed! Check tag structure.");
        if (LoggingHelper.isDebug()) {
            LoggingHelper.getLogger().debug("Runtime error while parsing tag.\nData: {}\nException: {}.", (Object)TagParseHelper.getAsString(tag), (Object)new RuntimeException(ex));
        }
    }

    public static void debugEntityTag(UUID uuid, class_2520 tag) {
        if (LoggingHelper.isDebug()) {
            LoggingHelper.getLogger().debug("New NBT of Entity {} is {}.", (Object)uuid, (Object)TagParseHelper.getAsString(tag));
        }
    }

    public static void debugBlockEntityTag(class_2338 pos, class_2520 tag) {
        if (LoggingHelper.isDebug()) {
            LoggingHelper.getLogger().debug("New NBT of BlockEntity at ({},{},{}) is {}.", new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260(), TagParseHelper.getAsString(tag)});
        }
    }

    public static void debugItemStackTag(class_1657 player, class_2520 tag) {
        if (LoggingHelper.isDebug()) {
            LoggingHelper.getLogger().debug("New NBT of ItemStack on {}'s hand is {}.", (Object)player.method_5477(), (Object)TagParseHelper.getAsString(tag));
        }
    }
}

