/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import cx.rain.mc.nbtedit.NBTEdit;
import cx.rain.mc.nbtedit.NBTEditPlatform;
import cx.rain.mc.nbtedit.api.command.ModPermissions;
import cx.rain.mc.nbtedit.networking.NetworkEditingHelper;
import cx.rain.mc.nbtedit.networking.packet.s2c.RaytracePacket;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_3222;

public class NBTEditCommand {
    public static final LiteralArgumentBuilder<class_2168> NBTEDIT = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"nbtedit").requires(source -> NBTEditPlatform.getPermission().hasPermission((class_2168)source, ModPermissions.USE))).executes(NBTEditCommand::onUse)).then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(NBTEditCommand::onEntity))).then(class_2170.method_9244((String)"block", (ArgumentType)class_2262.method_9698()).executes(NBTEditCommand::onBlockEntity))).then(class_2170.method_9247((String)"me").executes(NBTEditCommand::onEntityMe))).then(class_2170.method_9247((String)"hand").executes(NBTEditCommand::onItemHand));

    private static int onUse(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        NBTEditPlatform.getNetworking().sendTo(player, new RaytracePacket());
        NBTEdit.getInstance().getLogger().info("Player {} issued command /nbtedit.", (Object)player.method_5477().getString());
        return 1;
    }

    private static int onEntity(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_1297 entity = class_2186.method_9313(context, (String)"entity");
        NBTEdit.getInstance().getLogger().info("Player {} issued command /nbtedit with an entity.", (Object)player.method_5477().getString());
        NetworkEditingHelper.editEntity(player, entity.method_5667());
        return 1;
    }

    private static int onBlockEntity(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_2338 pos = class_2262.method_48299(context, (String)"block");
        NBTEdit.getInstance().getLogger().info("Player {} issued command /nbtedit with an block at XYZ: {} {} {}.", new Object[]{player.method_5477().getString(), pos.method_10263(), pos.method_10264(), pos.method_10260()});
        NetworkEditingHelper.editBlockEntity(player, pos);
        return 1;
    }

    private static int onEntityMe(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        NBTEdit.getInstance().getLogger().info("Player {} issued command /nbtedit to edit itself.", (Object)player.method_5477().getString());
        NetworkEditingHelper.editEntity(player, player.method_5667());
        return 1;
    }

    private static int onItemHand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        NBTEdit.getInstance().getLogger().info("Player {} issued command /nbtedit to edit hand.", (Object)player.method_5477().getString());
        class_1799 stack = player.method_6047();
        NetworkEditingHelper.editItemStack(player, stack);
        return 1;
    }
}

