/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.fabric;

import cx.rain.mc.nbtedit.NBTEdit;
import cx.rain.mc.nbtedit.api.command.IModPermission;
import cx.rain.mc.nbtedit.api.config.IModConfig;
import cx.rain.mc.nbtedit.api.netowrking.IModNetworking;
import cx.rain.mc.nbtedit.fabric.command.FabricPermissionApiImpl;
import cx.rain.mc.nbtedit.fabric.command.VanillaPermissionImpl;
import cx.rain.mc.nbtedit.fabric.config.ModConfigImpl;
import cx.rain.mc.nbtedit.fabric.networking.ModNetworkingImpl;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.server.MinecraftServer;

public class NBTEditPlatformImpl {
    private static final ModNetworkingImpl NETWORKING = new ModNetworkingImpl();
    private static final ModConfigImpl CONFIG = new ModConfigImpl(FabricLoader.getInstance().getGameDir().toFile());
    private static final IModPermission PERMISSION;

    public static IModNetworking getNetworking() {
        return NETWORKING;
    }

    public static IModConfig getConfig() {
        return CONFIG;
    }

    public static IModPermission getPermission() {
        return PERMISSION;
    }

    public static void onServerStarted(Consumer<MinecraftServer> consumer) {
        ServerLifecycleEvents.SERVER_STARTED.register(consumer::accept);
    }

    static {
        IModPermission impl = null;
        try {
            if (FabricLoader.getInstance().isModLoaded("fabric-permissions-api-v0")) {
                impl = new FabricPermissionApiImpl(CONFIG);
                NBTEdit.getInstance().getLogger().info("Fabric Permissions API detected, using it.");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (impl == null) {
            impl = new VanillaPermissionImpl(CONFIG);
        }
        PERMISSION = impl;
    }
}

