/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.gui;

import cx.rain.mc.nbtedit.editor.ClipboardHelper;
import cx.rain.mc.nbtedit.editor.EditorButton;
import cx.rain.mc.nbtedit.editor.EditorHelper;
import cx.rain.mc.nbtedit.editor.NbtTree;
import cx.rain.mc.nbtedit.gui.component.ButtonComponent;
import cx.rain.mc.nbtedit.gui.component.ScrollableViewport;
import cx.rain.mc.nbtedit.gui.editor.EditingWindow;
import cx.rain.mc.nbtedit.gui.editor.EditorButtonComponent;
import cx.rain.mc.nbtedit.gui.editor.NbtTreeView;
import cx.rain.mc.nbtedit.gui.screen.AbstractScreen;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7919;

public class EditorScreen
extends AbstractScreen {
    private final NbtTree tree;
    private final Consumer<class_2487> onSave;
    private final boolean readOnly;
    private ScrollableViewport treeViewport;
    private NbtTreeView treeView;
    private final EditorButtonComponent[] editorButtons = new EditorButtonComponent[17];
    private long lastClickTime = 0L;

    public EditorScreen(class_2487 tag, class_2561 title, Consumer<class_2487> onSave, boolean readOnly) {
        super((class_2561)(readOnly ? class_2561.method_43471((String)"gui.nbtedit.title.editor.read_only").method_10852(title) : title));
        this.onSave = onSave;
        this.readOnly = readOnly;
        this.tree = NbtTree.root(tag);
    }

    @Override
    protected void createChildren() {
        ButtonComponent saveButton;
        this.field_22789 = this.field_22787.method_22683().method_4486();
        this.field_22790 = this.field_22787.method_22683().method_4502();
        this.treeViewport = new ScrollableViewport(0, 40, this.field_22789, this.field_22790 - 76, 15);
        this.treeView = new NbtTreeView(this.tree, 0, 0, v -> this.updateButtons());
        this.treeViewport.addChild(this.treeView);
        this.addChild(this.treeViewport);
        if (!this.readOnly) {
            saveButton = ButtonComponent.getBuilder((class_2561)class_2561.method_43471((String)"gui.nbtedit.button.save"), b -> this.onSave()).pos(this.field_22789 / 4 - 100, this.field_22790 - 27).size(200, 20).createNarration(c -> ((class_5250)c.get()).method_10852((class_2561)class_2561.method_43471((String)"gui.nbtedit.tooltip.button_save"))).tooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.nbtedit.tooltip.button_save"))).build();
        } else {
            saveButton = ButtonComponent.getBuilder((class_2561)class_2561.method_43471((String)"gui.nbtedit.button.save"), b -> {}).pos(this.field_22789 / 4 - 100, this.field_22790 - 27).size(200, 20).createNarration(c -> ((class_5250)c.get()).method_10852((class_2561)class_2561.method_43471((String)"gui.nbtedit.tooltip.button_save.disabled"))).tooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.nbtedit.tooltip.button_save.disabled"))).build();
            saveButton.field_22763 = false;
        }
        this.addChild(saveButton);
        ButtonComponent quitButton = ButtonComponent.getBuilder((class_2561)class_2561.method_43471((String)"gui.nbtedit.button.quit"), b -> this.onQuit()).pos(this.field_22789 * 3 / 4 - 100, this.field_22790 - 27).size(200, 20).createNarration(c -> ((class_5250)c.get()).method_10852((class_2561)class_2561.method_43471((String)"gui.nbtedit.tooltip.button_quit"))).tooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.nbtedit.tooltip.button_quit"))).build();
        this.addChild(quitButton);
        this.initButtons();
        this.update(false);
    }

    @Override
    public void update() {
        this.treeViewport.update();
        this.updateButtons();
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_57734(guiGraphics);
        this.method_57736(guiGraphics, 0, 0, this.field_22789, 40);
        this.method_57736(guiGraphics, 0, this.field_22790 - 35, this.field_22789, this.field_22790);
    }

    private void initButtons() {
        int xLoc = 18;
        int yLoc = 15;
        this.buildButton(EditorButton.COPY, xLoc, yLoc, b -> this.onCopy());
        this.buildButton(EditorButton.CUT, xLoc += 15, yLoc, b -> this.onCut());
        this.buildButton(EditorButton.PASTE, xLoc += 15, yLoc, b -> this.onPaste());
        this.buildButton(EditorButton.DELETE, xLoc += 15, yLoc, b -> this.onDelete());
        this.buildButton(EditorButton.EDIT, xLoc += 54, yLoc, b -> this.onEdit());
        xLoc = 18;
        yLoc = 27;
        int i = 0;
        while (i < 12) {
            int id = i++;
            this.buildAddButton(EditorButton.of(id), xLoc, yLoc, b -> this.onAddButtonsClick(id));
            xLoc += 9;
        }
        this.updateButtons();
    }

    private void buildButton(EditorButton button, int x, int y, class_4185.class_4241 onPress) {
        EditorButtonComponent b = new EditorButtonComponent(button, x, y, button.getName(), onPress);
        this.addButton(button.getId(), b);
    }

    private void buildAddButton(EditorButton button, int x, int y, class_4185.class_4241 onPress) {
        EditorButtonComponent b = new EditorButtonComponent(button, x, y, (class_2561)class_2561.method_43469((String)"gui.nbtedit.button.add", (Object[])new Object[]{button.getName().getString()}), onPress);
        this.addButton(button.getId(), b);
    }

    private void addButton(int id, EditorButtonComponent button) {
        this.editorButtons[id] = button;
        this.addChild(button);
    }

    protected void onEdit() {
        if (!this.editorButtons[12].field_22763) {
            return;
        }
        this.doEdit();
        this.update(false);
    }

    protected void onDelete() {
        this.doDelete();
        this.update(true);
    }

    protected void onPaste() {
        this.doPaste();
        this.update(true);
    }

    protected void onCut() {
        this.doCopy();
        this.doDelete();
        this.update(true);
    }

    protected void onCopy() {
        this.doCopy();
        this.update(false);
    }

    protected void onAddButtonsClick(int id) {
        NbtTree.Node<?> focused;
        if (id >= 0 && id <= 12 && (focused = this.treeView.getFocusedNode()) != null) {
            focused.setShowChildren(true);
            class_2520 tag = EditorHelper.newTag(id);
            if (focused.getTag() instanceof class_2499) {
                if (tag != null) {
                    NbtTree.Node<class_2520> newChild = focused.newChild("", tag);
                    this.treeView.setFocusedNode(newChild);
                }
            } else if (tag != null) {
                NbtTree.Node<class_2520> newChild = focused.newChild(EditorHelper.newTagName(id, focused), tag);
                this.treeView.setFocusedNode(newChild);
            }
        }
        this.update(true);
    }

    private void onSave() {
        this.doSave();
        this.doClose();
    }

    private void onQuit() {
        this.doClose();
    }

    public void updateButtons() {
        if (this.readOnly) {
            this.inactiveAllButtons();
            return;
        }
        EditorButtonComponent editButton = this.editorButtons[12];
        EditorButtonComponent deleteButton = this.editorButtons[13];
        EditorButtonComponent pasteButton = this.editorButtons[14];
        EditorButtonComponent cutButton = this.editorButtons[15];
        EditorButtonComponent copyButton = this.editorButtons[16];
        NbtTree.Node<?> nodeToFocus = this.treeView.getFocusedNode();
        if (nodeToFocus == null) {
            this.inactiveAllButtons();
        } else if (nodeToFocus.getTag() instanceof class_2487) {
            this.activeAllButtons();
            editButton.field_22763 = nodeToFocus.hasParent() && !(nodeToFocus.getParent().getTag() instanceof class_2499);
            deleteButton.field_22763 = nodeToFocus != this.tree.getRoot();
            cutButton.field_22763 = nodeToFocus != this.tree.getRoot();
            pasteButton.field_22763 = ClipboardHelper.getNode() != null;
        } else if (nodeToFocus.getTag() instanceof class_2499) {
            if (nodeToFocus.hasChild()) {
                byte elementType = nodeToFocus.getChildren().get(0).getTag().method_10711();
                this.inactiveAllButtons();
                this.editorButtons[elementType - 1].setActive(true);
                editButton.field_22763 = !(nodeToFocus.getParent().getTag() instanceof class_2499);
                deleteButton.setActive(true);
                copyButton.setActive(true);
                cutButton.setActive(true);
                pasteButton.field_22763 = ClipboardHelper.getNode() != null && ClipboardHelper.getNode().getTag().method_10711() == elementType;
            } else {
                this.activeAllButtons();
                editButton.field_22763 = !(nodeToFocus.getParent().getTag() instanceof class_2499);
                pasteButton.field_22763 = ClipboardHelper.getNode() != null;
            }
        } else {
            this.inactiveAllButtons();
            editButton.setActive(true);
            deleteButton.setActive(true);
            copyButton.setActive(true);
            cutButton.setActive(true);
        }
    }

    private void activeAllButtons() {
        for (int i = 0; i < 17; ++i) {
            this.editorButtons[i].setActive(true);
        }
    }

    private void inactiveAllButtons() {
        for (int i = 0; i < 17; ++i) {
            this.editorButtons[i].setActive(false);
        }
    }

    private void update(boolean centerFocused) {
        this.update();
    }

    public void doEdit() {
        if (this.hasMutexWindow()) {
            return;
        }
        NbtTree.Node<?> focused = this.treeView.getFocusedNode();
        Object tag = focused.getTag();
        Object parent = focused.getParent().getTag();
        EditingWindow editor = new EditingWindow((this.field_22789 - 178) / 2, (this.field_22790 - 93) / 2, focused, !(parent instanceof class_2499), !(tag instanceof class_2487) && !(tag instanceof class_2499));
        this.addWindow(editor, true, true);
    }

    private void doCopy() {
        NbtTree.Node<?> node = this.treeView.getFocusedNode();
        if (node != null) {
            Object obj = node.getTag();
            if (obj instanceof class_2499) {
                class_2499 list = (class_2499)obj;
                ClipboardHelper.setNode(NbtTree.Node.root(list));
            } else {
                obj = node.getTag();
                if (obj instanceof class_2487) {
                    class_2487 compound = (class_2487)obj;
                    ClipboardHelper.setNode(NbtTree.Node.root(compound));
                } else {
                    ClipboardHelper.setNode(node);
                }
            }
        } else {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15008, (float)1.0f));
        }
    }

    private void doPaste() {
        NbtTree.Node<?> focused = this.treeView.getFocusedNode();
        if (focused != null) {
            Object tag = focused.getTag();
            if (!(tag instanceof class_2487) && !(tag instanceof class_2483)) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15008, (float)1.0f));
                return;
            }
            NbtTree.Node<?> toPaste = ClipboardHelper.getNode();
            if (toPaste != null) {
                focused.setShowChildren(true);
                if (focused.getTag() instanceof class_2499) {
                    toPaste.setName("");
                } else {
                    String name = "Paste";
                    List<NbtTree.Node<class_2520>> children = focused.getChildren();
                    for (int i = 1; i < children.size(); ++i) {
                        NbtTree.Node<class_2520> child = children.get(i);
                        if (EditorHelper.isNameValidInNode(name, child)) continue;
                        toPaste.setName("Paste " + i);
                    }
                }
                focused.addChild(toPaste);
                this.treeView.setFocusedNode(toPaste);
                this.update(true);
            }
        } else {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15008, (float)1.0f));
        }
    }

    public void doDelete() {
        NbtTree.Node<?> focused = this.treeView.getFocusedNode();
        if (focused != null) {
            NbtTree.Node<?> parent = focused.getParent();
            parent.removeChild(focused);
            this.treeView.setFocusedNode(parent);
            this.update(true);
        }
    }

    private void doSave() {
        this.onSave.accept(this.tree.toCompound());
    }

    private void doClose() {
        this.field_22787.method_1507(null);
        this.field_22787.method_30133();
    }

    @Override
    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        if (this.treeView.getFocusedChild() != null && class_156.method_658() - this.lastClickTime <= 250L) {
            this.onEdit();
            return true;
        }
        this.lastClickTime = class_156.method_658();
        return super.method_25402(event, isDoubleClick);
    }

    public void method_16014(double mouseX, double mouseY) {
        this.lastClickTime = 0L;
        super.method_16014(mouseX, mouseY);
    }

    @Override
    public boolean method_25404(class_11908 event) {
        int keyCode = event.comp_4795();
        int modifiers = event.comp_4797();
        if (!this.hasWindow()) {
            if (keyCode == 67 && modifiers == 2) {
                if (this.method_25399() != null) {
                    this.doCopy();
                    this.update(true);
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                } else {
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15008, (float)1.0f));
                }
                return true;
            }
            if (keyCode == 86 && modifiers == 2) {
                if (this.method_25399() != null) {
                    this.doPaste();
                    this.update(true);
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                } else {
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15008, (float)1.0f));
                }
                return true;
            }
            if (keyCode == 88 && modifiers == 2) {
                if (this.method_25399() != null) {
                    this.doCopy();
                    this.doDelete();
                    this.update(true);
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                } else {
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15008, (float)1.0f));
                }
                return true;
            }
            if (keyCode == 68 && modifiers == 2 || keyCode == 261) {
                if (this.method_25399() != null) {
                    this.doDelete();
                    this.update(true);
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                } else {
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15008, (float)1.0f));
                }
                return true;
            }
            if (keyCode == 257) {
                if (this.method_25399() != null) {
                    this.onEdit();
                } else {
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15008, (float)1.0f));
                }
                return true;
            }
            if (keyCode == 256) {
                this.onQuit();
                return true;
            }
        }
        return super.method_25404(event);
    }
}

