/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.gui.component;

import cx.rain.mc.nbtedit.gui.component.AbstractComponent;
import cx.rain.mc.nbtedit.gui.component.IScrollHandler;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8666;

public class ScrollBar
extends AbstractComponent {
    private static final class_8666 BACKGROUND_SPRITES = new class_8666(class_2960.method_60656((String)"widget/text_field"), class_2960.method_60656((String)"widget/text_field_highlighted"));
    private static final class_2960 SCROLLER_SPRITE = class_2960.method_60656((String)"widget/scroller");
    private final int scrollUnit;
    private final boolean horizontal;
    private final IScrollHandler toScroll;
    private final int contentLength;
    private int scrollAmount;
    private boolean dragging;

    public ScrollBar(int x, int y, int width, int height, IScrollHandler toScroll, int contentLength) {
        this(x, y, width, height, toScroll, contentLength, false);
    }

    public ScrollBar(int x, int y, int width, int height, IScrollHandler toScroll, int contentLength, boolean horizontal) {
        super(x, y, width, height, (class_2561)class_2561.method_43471((String)"gui.nbtedit.title.scroll_bar"));
        Objects.requireNonNull(this.getMinecraft().field_1772);
        this.scrollUnit = 9 + 2;
        this.scrollAmount = 0;
        this.dragging = false;
        this.horizontal = horizontal;
        this.toScroll = toScroll;
        this.contentLength = contentLength;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public boolean isVertical() {
        return !this.horizontal;
    }

    public int getPrimaryStart() {
        if (this.isHorizontal()) {
            return this.method_46426();
        }
        return this.method_46427();
    }

    public int getPrimaryLength() {
        if (this.isHorizontal()) {
            return this.method_25368();
        }
        return this.method_25364();
    }

    public double getScrollRate() {
        return class_3532.method_15350((double)((double)this.scrollAmount / (double)(this.contentLength - this.getPrimaryLength())), (double)0.0, (double)1.0);
    }

    public void setScrollRate(double scrollRate) {
        double actual = class_3532.method_15350((double)scrollRate, (double)0.0, (double)1.0);
        int newScrollAmount = (int)(actual * (double)(this.contentLength - this.getPrimaryLength()));
        this.setScrollAmount(newScrollAmount);
    }

    private int getScrollBarLength() {
        return class_3532.method_15340((int)((int)((float)(this.getPrimaryLength() * this.getPrimaryLength()) / (float)this.contentLength)), (int)32, (int)this.getPrimaryLength());
    }

    private int getMaxScrollAmount() {
        return this.contentLength - this.getPrimaryLength();
    }

    public int getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(int amount) {
        this.scrollAmount = class_3532.method_15340((int)amount, (int)0, (int)this.getMaxScrollAmount());
    }

    private void addScrollAmount(int value) {
        this.setScrollAmount(this.getScrollAmount() + value);
        this.toScroll.onScroll(value);
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_2960 resourceLocation = BACKGROUND_SPRITES.method_52729(false, false);
        guiGraphics.method_52706(class_10799.field_56883, resourceLocation, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        int barLength = this.getScrollBarLength();
        int barOffset = (int)(this.getScrollRate() * (double)(this.getPrimaryLength() - barLength));
        if (this.isHorizontal()) {
            guiGraphics.method_52706(class_10799.field_56883, SCROLLER_SPRITE, this.method_46426() + barOffset, this.method_46427(), barLength, this.method_25364());
        } else {
            guiGraphics.method_52706(class_10799.field_56883, SCROLLER_SPRITE, this.method_46426(), this.method_46427() + barOffset, this.method_25368(), barLength);
        }
    }

    protected void method_47399(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43471((String)"gui.nbtedit.title.scroll_bar.narration"));
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        if (this.method_25405(event.comp_4798(), event.comp_4799())) {
            this.dragging = true;
            return true;
        }
        return super.method_25402(event, isDoubleClick);
    }

    public boolean method_25406(class_11909 event) {
        if (event.method_74245() == 0) {
            this.dragging = false;
        }
        return super.method_25406(event);
    }

    public boolean method_25403(class_11909 event, double mouseX, double mouseY) {
        if (this.method_37303() && this.dragging) {
            double dragPrimary;
            double mousePrimary = this.isVertical() ? mouseY : mouseX;
            double d = dragPrimary = this.isVertical() ? event.comp_4799() : event.comp_4798();
            if (mousePrimary < (double)this.getPrimaryStart()) {
                this.addScrollAmount(-this.scrollUnit);
            } else if (mousePrimary > (double)(this.getPrimaryStart() + this.getPrimaryLength())) {
                this.addScrollAmount(this.scrollUnit);
            } else {
                int d2 = class_3532.method_15340((int)(this.getMaxScrollAmount() / (this.getPrimaryLength() - this.getScrollBarLength())), (int)0, (int)1);
                this.addScrollAmount((int)(dragPrimary * (double)d2));
            }
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        double scrollPrimary = this.isVertical() ? scrollY : scrollX;
        this.addScrollAmount((int)((double)this.scrollUnit * -scrollPrimary));
        return true;
    }

    public boolean method_16803(class_11908 event) {
        if (this.method_25367()) {
            if (event.comp_4795() == 265) {
                this.addScrollAmount(-this.scrollUnit);
                return true;
            }
            if (event.comp_4795() == 264) {
                this.addScrollAmount(this.scrollUnit);
                return true;
            }
        }
        return super.method_16803(event);
    }
}

