/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.dailydad.handler;

import com.mojang.text2speech.Narrator;
import com.mrbysco.dailydad.client.RenderHelper;
import com.mrbysco.dailydad.config.JokeEnum;
import com.mrbysco.dailydad.platform.Services;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class JokeHandler {
    private static MutableComponent joke = null;

    public static void onScreenOpen(Screen screen) {
        JokeEnum jokeEnum = Services.PLATFORM.getJokeType();
        if (jokeEnum == JokeEnum.LOADING && (screen instanceof ConnectScreen || screen instanceof LevelLoadingScreen)) {
            Services.PLATFORM.getJokeAsync((joke, component) -> {
                JokeHandler.joke = component;
            });
        }
    }

    public static void onDrawScreen(Screen screen, GuiGraphics guiGraphics) {
        if (joke == null) {
            return;
        }
        if (Services.PLATFORM.getJokeType() == JokeEnum.LOADING && (screen instanceof ConnectScreen || screen instanceof LevelLoadingScreen)) {
            Font font = Minecraft.getInstance().font;
            Objects.requireNonNull(font);
            int height = 9;
            RenderHelper.renderJoke(guiGraphics, (Component)joke, 6, height);
        }
    }

    public static void onLoggedIn(@Nullable Player player) {
        if (player != null) {
            JokeEnum jokeEnum = Services.PLATFORM.getJokeType();
            if (jokeEnum == JokeEnum.CHAT || jokeEnum == JokeEnum.TTS) {
                Services.PLATFORM.getJokeAsync((joke, component) -> Minecraft.getInstance().execute(() -> {
                    if (jokeEnum == JokeEnum.TTS) {
                        Narrator.getNarrator().say("Daily Dad says: " + joke, true, (float)Services.PLATFORM.getTTSVolume());
                    }
                    player.displayClientMessage((Component)Component.literal((String)"<DailyDad> ").withStyle(ChatFormatting.GOLD).append((Component)component), false);
                }));
            }
            JokeHandler.joke = null;
        }
    }

    public static void onPlayerRespawn(Player oldPlayer, Player newPlayer) {
        if (Services.PLATFORM.getJokeUponRespawn() && oldPlayer.isDeadOrDying()) {
            JokeEnum jokeEnum = Services.PLATFORM.getJokeType();
            if (jokeEnum != JokeEnum.LOADING) {
                Services.PLATFORM.getJokeAsync((joke, component) -> Minecraft.getInstance().execute(() -> {
                    if (jokeEnum == JokeEnum.TTS) {
                        Narrator.getNarrator().say("Daily Dad says: " + joke, true, (float)Services.PLATFORM.getTTSVolume());
                    }
                    newPlayer.displayClientMessage((Component)Component.literal((String)"<DailyDad> ").withStyle(ChatFormatting.GOLD).append((Component)component), false);
                }));
            }
            JokeHandler.joke = null;
        }
    }
}

