/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.db.TownyDataSource;
import com.palmergames.bukkit.towny.event.teleport.CancelledTownyTeleportEvent;
import com.palmergames.bukkit.towny.event.townblockstatus.NationZoneTownBlockStatusEvent;
import com.palmergames.bukkit.towny.exceptions.KeyAlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.tasks.TeleportWarmupTimerTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.ProximityUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.MathUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownyAPI {
    private static TownyAPI instance;
    private final TownyUniverse townyUniverse = TownyUniverse.getInstance();

    private TownyAPI() {
    }

    @Nullable
    public Location getTownSpawnLocation(Player player) {
        Resident resident = this.townyUniverse.getResident(player.getUniqueId());
        if (resident == null) {
            return null;
        }
        if (resident.hasTown()) {
            return resident.getTownOrNull().getSpawnOrNull();
        }
        return null;
    }

    @Nullable
    public Location getNationSpawnLocation(Player player) {
        Resident resident = this.townyUniverse.getResident(player.getUniqueId());
        if (resident == null || !resident.hasNation()) {
            return null;
        }
        return resident.getNationOrNull().getSpawnOrNull();
    }

    @Nullable
    public Town getResidentTownOrNull(Resident resident) {
        return resident.getTownOrNull();
    }

    @Nullable
    public Nation getResidentNationOrNull(Resident resident) {
        if (resident.hasNation()) {
            return resident.getTownOrNull().getNationOrNull();
        }
        return null;
    }

    @Nullable
    public Nation getTownNationOrNull(Town town) {
        return town.getNationOrNull();
    }

    @Nullable
    public Nation getNation(String name) {
        return TownyUniverse.getInstance().getNation(name);
    }

    @Nullable
    public Nation getNation(UUID uuid) {
        return TownyUniverse.getInstance().getNation(uuid);
    }

    public List<Nation> getNations(String[] names) {
        return Arrays.stream(names).filter(Objects::nonNull).map(this.townyUniverse::getNation).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Nation> getNations(List<UUID> uuids) {
        ArrayList<Nation> matches = new ArrayList<Nation>();
        for (UUID uuid : uuids) {
            Nation n = this.townyUniverse.getNation(uuid);
            if (n == null) continue;
            matches.add(n);
        }
        return matches;
    }

    public List<Nation> getNations(UUID[] uuids) {
        return this.getNations(Stream.of(uuids).collect(Collectors.toList()));
    }

    @Nullable
    public Resident getResident(String name) {
        return TownyUniverse.getInstance().getResident(name);
    }

    @Nullable
    public Resident getResident(UUID uuid) {
        return TownyUniverse.getInstance().getResident(uuid);
    }

    @Nullable
    public Resident getResident(Player player) {
        return this.getResident(player.getUniqueId());
    }

    @NotNull
    @Contract(value="null -> fail")
    public Resident getResidentOrThrow(@Nullable Player player) throws TownyException {
        Resident resident;
        Resident resident2 = resident = player == null ? null : this.getResident(player);
        if (resident == null) {
            throw new TownyException(Translatable.of("msg_err_resident_unknown", player != null ? player.getName() : "'null'"));
        }
        return resident;
    }

    public List<Resident> getResidents(String[] names) {
        return Arrays.stream(names).filter(Objects::nonNull).map(this.townyUniverse::getResident).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Resident> getResidents(UUID[] uuids) {
        return Arrays.stream(uuids).filter(Objects::nonNull).map(this.townyUniverse::getResident).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Resident> getResidents() {
        return new ArrayList<Resident>(this.townyUniverse.getResidents());
    }

    public List<Resident> getResidentsWithoutTown() {
        ArrayList<Resident> residentFilter = new ArrayList<Resident>();
        for (Resident resident : this.getResidents()) {
            if (resident.hasTown()) continue;
            residentFilter.add(resident);
        }
        return residentFilter;
    }

    @Nullable
    public Town getTown(String name) {
        return TownyUniverse.getInstance().getTown(name);
    }

    @Nullable
    public Town getTown(UUID uuid) {
        return TownyUniverse.getInstance().getTown(uuid);
    }

    public List<Town> getTowns(String[] names) {
        return Arrays.stream(names).filter(Objects::nonNull).map(this.townyUniverse::getTown).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Town> getTowns(List<UUID> uuids) {
        ArrayList<Town> matches = new ArrayList<Town>();
        for (UUID uuid : uuids) {
            Town t = this.townyUniverse.getTown(uuid);
            if (t == null) continue;
            matches.add(t);
        }
        return matches;
    }

    public List<Town> getTowns(UUID[] uuids) {
        return this.getTowns(Stream.of(uuids).collect(Collectors.toList()));
    }

    public Player getPlayer(Resident resident) {
        if (resident.isNPC()) {
            return null;
        }
        Player player = null;
        if (resident.hasUUID()) {
            player = BukkitTools.getPlayer(resident.getUUID());
        }
        if (player == null) {
            player = BukkitTools.getPlayerExact(resident.getName());
        }
        return player;
    }

    @Nullable
    public UUID getPlayerUUID(Resident resident) {
        if (resident.isNPC()) {
            return null;
        }
        if (resident.hasUUID()) {
            return resident.getUUID();
        }
        Player player = BukkitTools.getPlayerExact(resident.getName());
        if (player != null) {
            return player.getUniqueId();
        }
        return null;
    }

    public List<Player> getOnlinePlayers(ResidentList owner) {
        ArrayList<Player> players = new ArrayList<Player>(Bukkit.getOnlinePlayers());
        players.removeIf(player -> !owner.hasResident(player.getName()));
        return players;
    }

    public List<Player> getOnlinePlayersInTown(Town town) {
        return this.getOnlinePlayers(town);
    }

    public List<Player> getOnlinePlayersInNation(Nation nation) {
        return this.getOnlinePlayers(nation);
    }

    public List<Player> getOnlinePlayersAlliance(Nation nation) {
        ArrayList<Player> players = new ArrayList<Player>(this.getOnlinePlayers(nation));
        if (!nation.getAllies().isEmpty()) {
            for (Nation nations : nation.getAllies()) {
                players.addAll(this.getOnlinePlayers(nations));
            }
        }
        return players;
    }

    public boolean isWilderness(Block block) {
        return this.isWilderness(WorldCoord.parseWorldCoord(block));
    }

    public boolean isWilderness(Location location) {
        return this.isWilderness(WorldCoord.parseWorldCoord(location));
    }

    public boolean isWilderness(WorldCoord worldCoord) {
        TownBlock townBlock = worldCoord.getTownBlockOrNull();
        return townBlock == null || !townBlock.hasTown();
    }

    public boolean isPVP(Location location) {
        return !this.isTownyWorld(location.getWorld()) || !CombatUtil.preventPvP(this.getTownyWorld(location.getWorld()), this.getTownBlock(location));
    }

    public boolean areMobsEnabled(Location location) {
        TownyWorld townyWorld = this.getTownyWorld(location.getWorld());
        return !townyWorld.isUsingTowny() || this.isWilderness(location) ? townyWorld.hasWildernessMobs() : townyWorld.isForceTownMobs() || this.getTownBlock((Location)location).getPermissions().mobs || this.getTown(location).isAdminEnabledMobs();
    }

    public boolean isTownyWorld(World world) {
        TownyWorld townyWorld = this.getTownyWorld(world);
        return townyWorld != null && townyWorld.isUsingTowny();
    }

    @Nullable
    public TownyWorld getTownyWorld(String worldName) {
        return this.townyUniverse.getWorld(worldName);
    }

    @Nullable
    public TownyWorld getTownyWorld(UUID worldUUID) {
        return this.townyUniverse.getWorld(worldUUID);
    }

    @Nullable
    public TownyWorld getTownyWorld(World world) {
        return this.getTownyWorld(world.getUID());
    }

    @Nullable
    public Town getTown(Location location) {
        WorldCoord worldCoord = WorldCoord.parseWorldCoord(location);
        return worldCoord.getTownOrNull();
    }

    @Nullable
    public Town getTownOrNull(TownBlock townBlock) {
        return townBlock.getTownOrNull();
    }

    @Nullable
    public Resident getResidentOrNull(TownBlock townBlock) {
        return townBlock.getResidentOrNull();
    }

    public String getTownName(Player player) {
        Town town = this.getTown(player);
        return town != null ? town.getName() : "";
    }

    @Nullable
    public String getTownName(Location location) {
        Town town = this.getTown(location);
        return town != null ? town.getName() : null;
    }

    @Nullable
    public UUID getTownUUID(Location location) {
        Town town = this.getTown(location);
        return town != null ? town.getUUID() : null;
    }

    public List<Town> getTowns() {
        return new ArrayList<Town>(this.townyUniverse.getTowns());
    }

    public List<Nation> getNations() {
        return new ArrayList<Nation>(this.townyUniverse.getNations());
    }

    public List<Town> getTownsWithoutNation() {
        ArrayList<Town> townFilter = new ArrayList<Town>();
        for (Town town : this.getTowns()) {
            if (town.hasNation()) continue;
            townFilter.add(town);
        }
        return townFilter;
    }

    @Nullable
    public TownBlock getTownBlock(Location location) {
        WorldCoord worldCoord;
        try {
            worldCoord = WorldCoord.parseWorldCoord(location);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
        return worldCoord.getTownBlockOrNull();
    }

    @Nullable
    public TownBlock getTownBlock(@NotNull Player player) {
        return WorldCoord.parseWorldCoord(player.getLocation()).getTownBlockOrNull();
    }

    @Nullable
    public TownBlock getTownBlock(WorldCoord wc) {
        return wc.getTownBlockOrNull();
    }

    public Collection<TownBlock> getTownBlocks() {
        return this.townyUniverse.getTownBlocks().values();
    }

    public TownyDataSource getDataSource() {
        return this.townyUniverse.getDataSource();
    }

    public List<Resident> getOnlineResidents(ResidentList owner) {
        ArrayList<Resident> onlineResidents = new ArrayList<Resident>();
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            for (Resident resident : owner.getResidents()) {
                if (!resident.getName().equalsIgnoreCase(player.getName())) continue;
                onlineResidents.add(resident);
            }
        }
        return onlineResidents;
    }

    public void requestTeleport(Player player, Location spawnLoc) {
        this.requestTeleport(player, spawnLoc, 0);
    }

    public void requestTeleport(Player player, Location spawnLoc, int cooldown) {
        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (resident != null) {
            TeleportWarmupTimerTask.requestTeleport(resident, spawnLoc, cooldown);
        }
    }

    public void abortTeleportRequest(Resident resident) {
        this.abortTeleportRequest(resident, CancelledTownyTeleportEvent.CancelledTeleportReason.UNKNOWN);
    }

    public void abortTeleportRequest(Resident resident, CancelledTownyTeleportEvent.CancelledTeleportReason reason) {
        TeleportWarmupTimerTask.abortTeleportRequest(resident, reason);
    }

    public void registerCustomDataField(CustomDataField<?> field) throws KeyAlreadyRegisteredException {
        this.townyUniverse.addCustomCustomDataField(field);
    }

    public boolean isNationZone(Location location) {
        if (!this.isWilderness(location)) {
            return false;
        }
        PlayerCache.TownBlockStatus status = this.hasNationZone(location);
        return status.equals((Object)PlayerCache.TownBlockStatus.NATION_ZONE);
    }

    public PlayerCache.TownBlockStatus hasNationZone(Location location) {
        return this.hasNationZone(WorldCoord.parseWorldCoord(location));
    }

    public PlayerCache.TownBlockStatus hasNationZone(WorldCoord worldCoord) {
        int nationZoneRadius;
        TownBlock nearestTownblock = Optional.ofNullable(worldCoord.getTownyWorld()).map(world -> world.getClosestTownblockWithNationFromCoord(worldCoord)).orElse(null);
        if (nearestTownblock == null) {
            return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
        }
        Town nearestTown = nearestTownblock.getTownOrNull();
        if (nearestTown == null || !nearestTown.hasNation()) {
            return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
        }
        if (TownySettings.getNationZonesWarDisables() && nearestTown.getNationOrNull().hasActiveWar()) {
            return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
        }
        if (!nearestTown.isCapital() && TownySettings.getNationZonesCapitalsOnly()) {
            return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
        }
        if (!nearestTown.isNationZoneEnabled()) {
            return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
        }
        int distance = (int)MathUtil.distance(worldCoord.getX(), nearestTownblock.getX(), worldCoord.getZ(), nearestTownblock.getZ());
        if (distance <= (nationZoneRadius = nearestTown.getNationZoneSize())) {
            if (BukkitTools.isEventCancelled(new NationZoneTownBlockStatusEvent(nearestTown))) {
                return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
            }
            return PlayerCache.TownBlockStatus.NATION_ZONE;
        }
        return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
    }

    public void addTranslations(Plugin plugin, Map<String, Map<String, String>> translations) {
        Translation.addTranslations(translations);
        Towny.getPlugin().getLogger().info("Loaded additional language files for plugin: " + plugin.getName());
    }

    public static TownyAPI getInstance() {
        if (instance == null) {
            instance = new TownyAPI();
        }
        return instance;
    }

    public static List<String> getTownyObjectStartingWith(String arg, String type) {
        return BaseCommand.getTownyStartingWith(arg, type);
    }

    public static List<String> filterByStartOrGetTownyObjectStartingWith(List<String> filters, String arg, String type) {
        return BaseCommand.filterByStartOrGetTownyStartingWith(filters, arg, type);
    }

    public static List<String> getTownResidentNamesOfPlayerStartingWith(Player player, String str) {
        return BaseCommand.getTownResidentNamesOfPlayerStartingWith(player, str);
    }

    public static List<String> getResidentsOfTownStartingWith(String townName, String str) {
        return BaseCommand.getResidentsOfTownStartingWith(townName, str);
    }

    public static List<String> getResidentsWithoutTownStartingWith(String str) {
        return BaseCommand.getResidentsWithoutTownStartingWith(str);
    }

    @Nullable
    public Town getTown(@NotNull Player player) {
        Resident resident = this.getResident(player);
        return resident == null ? null : resident.getTownOrNull();
    }

    @Nullable
    public Nation getNation(@NotNull Player player) {
        Resident resident = this.getResident(player);
        return resident == null ? null : resident.getNationOrNull();
    }

    public void testPlotOwnerOrThrow(@NotNull Resident resident, @NotNull TownBlock townBlock) throws TownyException {
        boolean isAdmin = resident.isAdmin();
        boolean isMayor = resident.hasPermissionNode(PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode());
        if (townBlock.hasResident()) {
            boolean isMayorInTheirOwnTown;
            boolean bl = isMayorInTheirOwnTown = isMayor && resident.hasTown() && resident.getTownOrNull() == townBlock.getTownOrNull();
            if (isAdmin || isMayorInTheirOwnTown || townBlock.hasResident(resident)) {
                return;
            }
            throw new TownyException(Translatable.of("msg_area_not_own"));
        }
        boolean asMayorInUnowned = resident.hasPermissionNode(PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYORINUNOWNED.getNode());
        boolean isSameTown = townBlock.getTownOrNull().hasResident(resident);
        if (isSameTown && !isMayor && !asMayorInUnowned) {
            throw new TownyException(Translatable.of("msg_not_mayor_ass"));
        }
        if (!isSameTown && !isAdmin) {
            throw new TownyException(Translatable.of("msg_err_not_part_town"));
        }
    }

    public void testTownClaimOrThrow(Town town, WorldCoord coordToClaim, boolean outpost, boolean newTown) throws TownyException {
        if (newTown) {
            ProximityUtil.allowTownHomeBlockOrThrow(coordToClaim.getTownyWorld(), coordToClaim, town, true);
        }
        ProximityUtil.allowTownClaimOrThrow(coordToClaim.getTownyWorld(), coordToClaim, town, outpost);
    }

    public void testTownUnclaimOrThrow(Town town, WorldCoord coordToUnclaim) throws TownyException {
        ProximityUtil.allowTownUnclaimOrThrow(coordToUnclaim.getTownyWorld(), coordToUnclaim, town);
    }
}

