/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.ChunkNotification;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.asciimap.WildernessMapEvent;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translator;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.map.TownyMapData;
import com.palmergames.bukkit.towny.utils.TownyComponents;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Compass;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TownyAsciiMap {
    private static final int MAP_WIDTH_UPPER_BOUNDS = 27;
    private static final int MAP_HEIGHT_UPPER_BOUNDS = 18;
    private static final int MAP_LOWER_BOUNDS = 7;
    public static int lineWidth = TownyAsciiMap.sanitizeLineWidth(Integer.valueOf(ConfigNodes.ASCII_MAP_WIDTH.getDefault()));
    public static int halfLineWidth = lineWidth / 2;
    public static String defaultSymbol = TownBlockType.RESIDENTIAL.getAsciiMapKey();
    public static String forSaleSymbol = ConfigNodes.ASCII_MAP_SYMBOLS_FORSALE.getDefault();
    public static String homeSymbol = ConfigNodes.ASCII_MAP_SYMBOLS_HOME.getDefault();
    public static String outpostSymbol = ConfigNodes.ASCII_MAP_SYMBOLS_OUTPOST.getDefault();
    public static String wildernessSymbol = ConfigNodes.ASCII_MAP_SYMBOLS_WILDERNESS.getDefault();

    public static void initialize() {
        TownyAsciiMap.readSymbolsFromConfig();
    }

    private static void readSymbolsFromConfig() {
        defaultSymbol = TownBlockType.RESIDENTIAL.getAsciiMapKey();
        forSaleSymbol = TownyAsciiMap.parseSymbol(TownySettings.forSaleMapSymbol());
        homeSymbol = TownyAsciiMap.parseSymbol(TownySettings.homeBlockMapSymbol());
        outpostSymbol = TownyAsciiMap.parseSymbol(TownySettings.outpostMapSymbol());
        wildernessSymbol = TownyAsciiMap.parseSymbol(TownySettings.wildernessMapSymbol());
        lineWidth = TownyAsciiMap.sanitizeLineWidth(TownySettings.asciiMapWidth());
        halfLineWidth = lineWidth / 2;
    }

    public static Component[] generateHelp(Player player) {
        Translator translator = Translator.locale((CommandSender)player);
        return new Component[]{((TextComponent)((TextComponent)Component.text((String)"  ").append((Component)Component.text((String)wildernessSymbol, (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)" = ", (TextColor)NamedTextColor.GRAY))).append(translator.component("towny_map_unclaimed").color((TextColor)NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text((String)"  ").append((Component)Component.text((String)defaultSymbol, (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)" = ", (TextColor)NamedTextColor.GRAY))).append(translator.component("towny_map_claimed").color((TextColor)NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text((String)"  ").append((Component)Component.text((String)forSaleSymbol, (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)" = ", (TextColor)NamedTextColor.GRAY))).append(translator.component("towny_map_forsale").color((TextColor)NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text((String)"  ").append((Component)Component.text((String)defaultSymbol, (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)" = ", (TextColor)NamedTextColor.GRAY))).append(translator.component("towny_map_yourtown").color((TextColor)NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text((String)"  ").append((Component)Component.text((String)defaultSymbol, (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)" = ", (TextColor)NamedTextColor.GRAY))).append(translator.component("towny_map_yourplot").color((TextColor)NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text((String)"  ").append((Component)Component.text((String)defaultSymbol, (TextColor)NamedTextColor.DARK_GREEN))).append((Component)Component.text((String)" = ", (TextColor)NamedTextColor.GRAY))).append(translator.component("towny_map_ally").color((TextColor)NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text((String)"  ").append((Component)Component.text((String)defaultSymbol, (TextColor)NamedTextColor.DARK_RED))).append((Component)Component.text((String)" = ", (TextColor)NamedTextColor.GRAY))).append(translator.component("towny_map_enemy").color((TextColor)NamedTextColor.GRAY))};
    }

    public static Component[] generateCompass(Player player) {
        Compass.Point dir = Compass.getCompassPointForDirection(player.getLocation().getYaw());
        return new Component[]{Component.text((String)"  -----  ", (TextColor)NamedTextColor.BLACK), Component.text((String)"  -----  ", (TextColor)NamedTextColor.BLACK), ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"  -", (TextColor)NamedTextColor.BLACK).append((Component)Component.text((String)(dir == Compass.Point.NW ? "\\" : "-"), (TextColor)(dir == Compass.Point.NW ? NamedTextColor.GOLD : NamedTextColor.BLACK)))).append((Component)Component.text((String)"N", (TextColor)(dir == Compass.Point.N ? NamedTextColor.GOLD : NamedTextColor.WHITE)))).append((Component)Component.text((String)(dir == Compass.Point.NE ? "/" : "-"), (TextColor)(dir == Compass.Point.NE ? NamedTextColor.GOLD : NamedTextColor.BLACK)))).append((Component)Component.text((String)"-  ", (TextColor)NamedTextColor.BLACK)), ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"  -", (TextColor)NamedTextColor.BLACK).append((Component)Component.text((String)"W", (TextColor)(dir == Compass.Point.W ? NamedTextColor.GOLD : NamedTextColor.WHITE)))).append((Component)Component.text((String)"+", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"E", (TextColor)(dir == Compass.Point.E ? NamedTextColor.GOLD : NamedTextColor.WHITE)))).append((Component)Component.text((String)"-  ", (TextColor)NamedTextColor.BLACK)), ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"  -", (TextColor)NamedTextColor.BLACK).append((Component)Component.text((String)(dir == Compass.Point.SW ? "/" : "-"), (TextColor)(dir == Compass.Point.SW ? NamedTextColor.GOLD : NamedTextColor.BLACK)))).append((Component)Component.text((String)"S", (TextColor)(dir == Compass.Point.S ? NamedTextColor.GOLD : NamedTextColor.WHITE)))).append((Component)Component.text((String)(dir == Compass.Point.SE ? "\\" : "-"), (TextColor)(dir == Compass.Point.SE ? NamedTextColor.GOLD : NamedTextColor.BLACK)))).append((Component)Component.text((String)"-  ", (TextColor)NamedTextColor.BLACK))};
    }

    public static void generateAndSend(Towny plugin, Player player, int lineHeight) {
        lineHeight = TownyAsciiMap.sanitizeLineHeight(lineHeight);
        Resident resident = TownyAPI.getInstance().getResident(player);
        if (resident == null) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_registered"));
            return;
        }
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(player.getWorld());
        World bukkitWorld = player.getWorld();
        if (world == null || bukkitWorld == null) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_configured"));
            return;
        }
        if (!world.isUsingTowny()) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_set_use_towny_off"));
            return;
        }
        WorldCoord pos = WorldCoord.parseWorldCoord(player.getLocation());
        Translator translator = Translator.locale((CommandSender)player);
        int halfLineHeight = lineHeight / 2;
        TextComponent[][] townyMap = new TextComponent[lineWidth][lineHeight];
        int y = 0;
        for (int tby = pos.getX() + (lineWidth - halfLineWidth - 1); tby >= pos.getX() - halfLineWidth; --tby) {
            int x = 0;
            for (int tbx = pos.getZ() - halfLineHeight; tbx <= pos.getZ() + (lineHeight - halfLineHeight - 1); ++tbx) {
                townyMap[y][x] = (TextComponent)Component.empty().color((TextColor)NamedTextColor.WHITE);
                WorldCoord wc = new WorldCoord(bukkitWorld, tby, tbx);
                TownBlock townblock = wc.getTownBlockOrNull();
                if (townblock != null) {
                    Town town = townblock.getTownOrNull();
                    if (x == halfLineHeight && y == halfLineWidth) {
                        townyMap[y][x] = (TextComponent)townyMap[y][x].color((TextColor)NamedTextColor.GOLD);
                    } else if (townblock.hasResident(resident)) {
                        townyMap[y][x] = (TextComponent)townyMap[y][x].color((TextColor)NamedTextColor.YELLOW);
                    } else if (resident.hasTown()) {
                        if (town.hasResident(resident)) {
                            townyMap[y][x] = (TextComponent)townyMap[y][x].color((TextColor)NamedTextColor.GREEN);
                        } else if (resident.hasNation()) {
                            Nation resNation = resident.getNationOrNull();
                            if (resNation.hasTown(town)) {
                                townyMap[y][x] = (TextComponent)townyMap[y][x].color((TextColor)NamedTextColor.DARK_GREEN);
                            } else if (town.hasNation()) {
                                Nation townBlockNation = town.getNationOrNull();
                                if (resNation.hasAlly(townBlockNation)) {
                                    townyMap[y][x] = (TextComponent)townyMap[y][x].color((TextColor)NamedTextColor.GREEN);
                                } else if (resNation.hasEnemy(townBlockNation)) {
                                    townyMap[y][x] = (TextComponent)townyMap[y][x].color((TextColor)NamedTextColor.DARK_RED);
                                }
                            }
                        }
                    }
                    if ((x != halfLineHeight || y != halfLineWidth) && townblock.getData().hasColour()) {
                        townyMap[y][x] = (TextComponent)townyMap[y][x].color((TextColor)townblock.getData().getColour());
                    }
                    townyMap[y][x] = townblock.getPlotPrice() != -1.0 || townblock.hasPlotObjectGroup() && townblock.getPlotObjectGroup().getPrice() != -1.0 ? townyMap[y][x].content(forSaleSymbol) : (townblock.isHomeBlock() ? townyMap[y][x].content(homeSymbol) : (townblock.isOutpost() ? townyMap[y][x].content(outpostSymbol) : townyMap[y][x].content(townblock.getType().getAsciiMapKey())));
                    TextComponent residentComponent = Component.empty();
                    TextComponent forSaleComponent = Component.empty();
                    TextComponent claimedAtComponent = Component.empty();
                    TextComponent groupComponent = Component.empty();
                    TextComponent districtComponent = Component.empty();
                    if (TownyEconomyHandler.isActive()) {
                        double cost;
                        double d = cost = townblock.hasPlotObjectGroup() ? townblock.getPlotObjectGroup().getPrice() : townblock.getPlotPrice();
                        if (cost > -1.0) {
                            forSaleComponent = TownyComponents.miniMessage(String.format(ChunkNotification.forSaleNotificationFormat, TownyAsciiMap.getOwner(townblock), TownyEconomyHandler.getFormattedBalance(cost)).replaceAll("[\\[\\]]", "") + " " + translator.of("msg_click_purchase")).color((TextColor)NamedTextColor.YELLOW).append((Component)Component.newline());
                        }
                    }
                    if (townblock.getClaimedAt() > 0L) {
                        claimedAtComponent = translator.component("msg_plot_perm_claimed_at").color((TextColor)NamedTextColor.DARK_GREEN).append((Component)Component.space()).append((Component)Component.text((String)TownyFormatter.registeredFormat.format(townblock.getClaimedAt()), (TextColor)NamedTextColor.GREEN)).append((Component)Component.newline());
                    }
                    if (townblock.hasPlotObjectGroup()) {
                        groupComponent = translator.component("map_hover_plot_group").color((TextColor)NamedTextColor.DARK_GREEN).append(Component.text((String)townblock.getPlotObjectGroup().getFormattedName(), (TextColor)NamedTextColor.GREEN).append(translator.component("map_hover_plot_group_size").color((TextColor)NamedTextColor.DARK_GREEN).append(translator.component("map_hover_plots", townblock.getPlotObjectGroup().getTownBlocks().size()).color((TextColor)NamedTextColor.GREEN).append((Component)Component.newline()))));
                    }
                    if (townblock.hasDistrict()) {
                        districtComponent = translator.component("map_hover_district").color((TextColor)NamedTextColor.DARK_GREEN).append(Component.text((String)townblock.getDistrict().getFormattedName(), (TextColor)NamedTextColor.GREEN).append(translator.component("map_hover_plot_group_size").color((TextColor)NamedTextColor.DARK_GREEN).append(translator.component("map_hover_plots", townblock.getDistrict().getTownBlocks().size()).color((TextColor)NamedTextColor.GREEN).append((Component)Component.newline()))));
                    }
                    if (townblock.hasResident()) {
                        residentComponent = Component.text((String)(" (" + townblock.getResidentOrNull().getName() + ")"), (TextColor)NamedTextColor.GREEN);
                    }
                    Component townComponent = translator.component("status_town").color((TextColor)NamedTextColor.DARK_GREEN).append((Component)Component.space()).append((Component)Component.text((String)town.getName(), (TextColor)NamedTextColor.GREEN)).append((Component)residentComponent).append((Component)Component.text((String)(" (" + tby + ", " + tbx + ")"), (TextColor)NamedTextColor.WHITE)).append((Component)Component.newline());
                    Component plotTypeComponent = translator.component("status_plot_type").color((TextColor)NamedTextColor.DARK_GREEN).append((Component)Component.space()).append((Component)Component.text((String)townblock.getType().getName(), (TextColor)NamedTextColor.GREEN)).append((Component)Component.newline());
                    Component hoverComponent = townComponent.append(plotTypeComponent).append((Component)districtComponent).append((Component)groupComponent).append((Component)forSaleComponent).append((Component)claimedAtComponent).append(translator.component("towny_map_detailed_information").color((TextColor)NamedTextColor.DARK_GREEN));
                    ClickEvent clickEvent = forSaleComponent.equals((Object)Component.empty()) ? ClickEvent.runCommand((String)("/towny:plot info " + tby + " " + tbx)) : ClickEvent.runCommand((String)("/towny:plot claim " + world.getName() + " x" + tby + " z" + tbx));
                    townyMap[y][x] = (TextComponent)((TextComponent)townyMap[y][x].hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverComponent))).clickEvent(clickEvent);
                } else {
                    String clickCommand;
                    TextComponent hoverText;
                    String symbol;
                    townyMap[y][x] = x == halfLineHeight && y == halfLineWidth ? (TextComponent)townyMap[y][x].color((TextColor)NamedTextColor.GOLD) : (TextComponent)townyMap[y][x].color((TextColor)NamedTextColor.DARK_GRAY);
                    if (TownyAsciiMap.getWildernessMapDataMap().containsKey(wc) && !TownyAsciiMap.getWildernessMapDataMap().get(wc).isOld()) {
                        TownyMapData mapData = TownyAsciiMap.getWildernessMapDataMap().get(wc);
                        symbol = mapData.getSymbol();
                        hoverText = mapData.getHoverText();
                        clickCommand = mapData.getClickCommand();
                    } else {
                        TownyAsciiMap.getWildernessMapDataMap().remove(wc);
                        WildernessMapEvent wildMapEvent = new WildernessMapEvent(wc);
                        BukkitTools.fireEvent(wildMapEvent);
                        symbol = wildMapEvent.getMapSymbol();
                        hoverText = wildMapEvent.getHoverText();
                        clickCommand = wildMapEvent.getClickCommand();
                        TownyAsciiMap.getWildernessMapDataMap().put(wc, new TownyMapData(wc, symbol, hoverText, clickCommand));
                        plugin.getScheduler().runAsyncLater(() -> {
                            if (TownyAsciiMap.getWildernessMapDataMap().containsKey(wc) && TownyAsciiMap.getWildernessMapDataMap().get(wc).isOld()) {
                                TownyAsciiMap.getWildernessMapDataMap().remove(wc);
                            }
                        }, 700L);
                    }
                    townyMap[y][x] = (TextComponent)((TextComponent)townyMap[y][x].content(symbol).clickEvent(ClickEvent.runCommand((String)clickCommand))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverText));
                }
                ++x;
            }
            ++y;
        }
        Component[] compass = TownyAsciiMap.generateCompass(player);
        TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(translator.of("towny_map_header") + "\u00a7f(" + String.valueOf(pos) + ")"));
        Component[] map = new Component[lineHeight];
        Component[] help = TownyAsciiMap.generateHelp(player);
        int lineCount = 0;
        for (int my = 0; my < lineHeight; ++my) {
            map[lineCount] = Component.empty().append(compass[lineCount < compass.length ? lineCount : 0]);
            for (int mx = lineWidth - 1; mx >= 0; --mx) {
                map[lineCount] = map[lineCount].append((Component)townyMap[mx][my]);
            }
            if (lineCount < help.length) {
                map[lineCount] = map[lineCount].append(help[lineCount]);
            }
            ++lineCount;
        }
        for (Component component : map) {
            player.sendMessage(component);
        }
        TownBlock townblock = pos.getTownBlockOrNull();
        TownyMessaging.sendMsg((CommandSender)player, translator.of("status_towny_map_town_line", townblock != null && townblock.hasTown() ? townblock.getTownOrNull() : translator.of("status_no_town"), townblock != null && townblock.hasResident() ? townblock.getResidentOrNull() : translator.of("status_no_town")));
    }

    private static int sanitizeLineHeight(int asciiMapHeight) {
        asciiMapHeight = Math.max(7, asciiMapHeight);
        asciiMapHeight = Math.min(18, asciiMapHeight);
        return asciiMapHeight;
    }

    private static int sanitizeLineWidth(int asciiMapWidth) {
        asciiMapWidth = Math.max(7, asciiMapWidth);
        if ((asciiMapWidth = Math.min(27, asciiMapWidth)) % 2 == 0) {
            ++asciiMapWidth;
        }
        return asciiMapWidth;
    }

    private static Map<WorldCoord, TownyMapData> getWildernessMapDataMap() {
        return TownyUniverse.getInstance().getWildernessMapDataMap();
    }

    public static String parseSymbol(String symbol) {
        if (symbol.startsWith("\\u")) {
            return TownyAsciiMap.parseUnicode(symbol);
        }
        return symbol.substring(0, 1);
    }

    private static String parseUnicode(String symbol) {
        return String.valueOf(Character.toChars(Integer.parseInt(symbol.substring(2))));
    }

    private static String getOwner(TownBlock townblock) {
        return townblock.hasResident() ? townblock.getResidentOrNull().getName() : townblock.getTownOrNull().getName();
    }

    static {
        TownySettings.addReloadListener(NamespacedKey.fromString((String)"towny:ascii-map-symbols"), config -> TownyAsciiMap.readSymbolsFromConfig());
    }
}

