/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.economy.TownyPreTransactionEvent;
import com.palmergames.bukkit.towny.object.Government;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.towny.object.economy.TownyServerAccount;
import com.palmergames.bukkit.towny.object.economy.adapter.EconomyAdapter;
import com.palmergames.bukkit.towny.object.economy.provider.EconomyProvider;
import com.palmergames.bukkit.towny.object.economy.provider.ReserveEconomyProvider;
import com.palmergames.bukkit.towny.object.economy.provider.VaultEconomyProvider;
import com.palmergames.bukkit.towny.object.economy.provider.VaultUnlockedEconomyProvider;
import com.palmergames.bukkit.towny.object.economy.transaction.Transaction;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.JavaUtil;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import net.tnemc.core.Reserve;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownyEconomyHandler {
    private static Towny plugin = null;
    private static EconomyAdapter economy = null;
    private static EconomyProvider provider = null;
    private static String version = "";
    private static final Executor ECONOMY_EXECUTOR = runnable -> {
        if (TownySettings.isEconomyAsync() && plugin.getScheduler().isTickThread()) {
            plugin.getScheduler().runAsync(runnable);
        } else if (!TownySettings.isEconomyAsync() && !plugin.getScheduler().isTickThread()) {
            plugin.getScheduler().run(runnable);
        } else {
            runnable.run();
        }
    };
    private static final Set<String> USE_V2_UUID = JavaUtil.make(new HashSet(), set -> set.add("EssentialsX Economy"));

    @Deprecated
    public static String getServerAccount() {
        return TownyServerAccount.ACCOUNT.getName();
    }

    @Nullable
    public static UUID getTownyObjectUUID(String accountName) {
        return Optional.ofNullable(TownyEconomyHandler.getTownyObjectAccount(accountName)).map(Account::getUUID).orElse(null);
    }

    @Nullable
    public static Account getTownyObjectAccount(String accountName) {
        if (accountName.equalsIgnoreCase(TownyServerAccount.ACCOUNT.getName())) {
            return TownyServerAccount.ACCOUNT;
        }
        if (accountName.startsWith(TownySettings.getNPCPrefix())) {
            String name = accountName.substring(TownySettings.getNPCPrefix().length());
            Resident resident = TownyAPI.getInstance().getResident(name);
            return resident != null ? resident.getAccount() : null;
        }
        if (accountName.startsWith(TownySettings.getTownAccountPrefix())) {
            String name = accountName.substring(TownySettings.getTownAccountPrefix().length());
            Town town = TownyAPI.getInstance().getTown(name);
            return town != null ? town.getAccount() : null;
        }
        if (accountName.startsWith(TownySettings.getNationAccountPrefix())) {
            String name = accountName.substring(TownySettings.getNationAccountPrefix().length());
            Nation nation = TownyAPI.getInstance().getNation(name);
            return nation != null ? nation.getAccount() : null;
        }
        return null;
    }

    public static void initialize(Towny plugin) {
        TownyEconomyHandler.plugin = plugin;
    }

    public static EcoType getType() {
        return provider == null ? EcoType.NONE : provider.economyType();
    }

    public static boolean isActive() {
        return TownyEconomyHandler.getType() != EcoType.NONE && TownySettings.isUsingEconomy() && economy != null;
    }

    public static String getVersion() {
        return version;
    }

    public static boolean setupEconomy() {
        if (TownyEconomyHandler.vaultUnlockedPresent()) {
            provider = new VaultUnlockedEconomyProvider();
            if (provider.mainAdapter() == null) {
                provider = new VaultEconomyProvider();
            }
        } else if (TownyEconomyHandler.vaultPresent()) {
            provider = new VaultEconomyProvider();
        } else if (plugin.getServer().getPluginManager().isPluginEnabled("Reserve")) {
            provider = new ReserveEconomyProvider((Reserve)plugin.getServer().getPluginManager().getPlugin("Reserve"));
        }
        if (provider != null && (economy = provider.mainAdapter()) != null) {
            version = economy.name() + " via " + provider.name();
            if (provider.isLegacy()) {
                version = version + " (Legacy)";
            }
            return true;
        }
        return false;
    }

    private static boolean vaultUnlockedPresent() {
        Plugin vault = plugin.getServer().getPluginManager().getPlugin("Vault");
        return vault != null && vault.isEnabled() && JavaUtil.classExists("net.milkbowl.vault2.economy.Economy");
    }

    private static boolean vaultPresent() {
        Plugin vault = plugin.getServer().getPluginManager().getPlugin("Vault");
        return vault != null && vault.isEnabled() && JavaUtil.classExists("net.milkbowl.vault.economy.Economy");
    }

    @Deprecated
    public static void removeAccount(String accountName) {
        Account account = TownyEconomyHandler.getTownyObjectAccount(accountName);
        if (account != null) {
            TownyEconomyHandler.removeAccount(account);
        }
    }

    public static void removeAccount(Account account) {
        economy.deleteAccount(account);
    }

    public static double getBalance(@NotNull Account account) {
        TownyEconomyHandler.checkNewAccount(account);
        return economy.getBalance(account);
    }

    @Deprecated
    public static double getBalance(String accountName, World world) {
        Account account = TownyEconomyHandler.getTownyObjectAccount(accountName);
        return account == null ? 0.0 : TownyEconomyHandler.getBalance(account);
    }

    @Deprecated
    public static boolean hasEnough(String accountName, double amount, World world) {
        Account account = TownyEconomyHandler.getTownyObjectAccount(accountName);
        return account != null && TownyEconomyHandler.hasEnough(account, amount);
    }

    public static boolean hasEnough(Account account, double amount) {
        return TownyEconomyHandler.getBalance(account) >= amount;
    }

    private static boolean runPreChecks(Transaction transaction) {
        TownyPreTransactionEvent preEvent = new TownyPreTransactionEvent(transaction);
        if (BukkitTools.isEventCancelled(preEvent) && transaction.getSendingPlayer() != null) {
            TownyMessaging.sendErrorMsg(transaction.getSendingPlayer(), preEvent.getCancelMessage());
            return false;
        }
        if (transaction.hasReceiverAccount()) {
            TownyEconomyHandler.checkNewAccount(transaction.getReceivingAccount());
        }
        if (transaction.hasSenderAccount()) {
            TownyEconomyHandler.checkNewAccount(transaction.getSendingAccount());
        }
        return true;
    }

    @Deprecated
    public static boolean subtract(String accountName, double amount, World world) {
        Account account = TownyEconomyHandler.getTownyObjectAccount(accountName);
        return account != null && TownyEconomyHandler.subtract(account, amount);
    }

    public static boolean subtract(Account account, double amount) {
        if (!TownyEconomyHandler.runPreChecks(Transaction.subtract(amount).paidBy(account).build())) {
            return false;
        }
        return economy.subtract(account, amount);
    }

    @Deprecated
    public static boolean add(String accountName, double amount, World world) {
        Account account = TownyEconomyHandler.getTownyObjectAccount(accountName);
        return account != null && TownyEconomyHandler.add(account, amount);
    }

    public static boolean add(Account account, double amount) {
        if (!TownyEconomyHandler.runPreChecks(Transaction.add(amount).paidTo(account).build())) {
            return false;
        }
        return economy.add(account, amount);
    }

    @Deprecated
    public static boolean setBalance(String accountName, double amount, World world) {
        Account account = TownyEconomyHandler.getTownyObjectAccount(accountName);
        return account != null && TownyEconomyHandler.setBalance(account, amount);
    }

    public static boolean setBalance(Account account, double amount) {
        TownyEconomyHandler.checkNewAccount(account);
        return economy.setBalance(account, amount);
    }

    public static String getFormattedBalance(double balance) {
        if (!TownyEconomyHandler.isActive()) {
            return String.valueOf(balance);
        }
        String formattedBalance = economy.getFormattedBalance(balance);
        if (formattedBalance != null) {
            return Colors.translateColorCodes(formattedBalance);
        }
        return Colors.translateColorCodes(String.format("%.2f", balance));
    }

    private static void checkNewAccount(Account account) {
        if (!economy.hasAccount(account)) {
            economy.newAccount(account);
        }
    }

    public static boolean hasAccount(Account account) {
        return economy.hasAccount(account);
    }

    @Deprecated
    public static boolean hasAccount(String accountName) {
        Account account = TownyEconomyHandler.getTownyObjectAccount(accountName);
        return account != null && TownyEconomyHandler.hasAccount(account);
    }

    @Deprecated
    public static boolean isEssentials() {
        return TownyEconomyHandler.getVersion().startsWith("EssentialsX Economy") || TownyEconomyHandler.getVersion().startsWith("Essentials Economy");
    }

    public static Executor economyExecutor() {
        return ECONOMY_EXECUTOR;
    }

    @ApiStatus.Internal
    public static EconomyProvider getProvider() {
        return provider;
    }

    @ApiStatus.Internal
    @Nullable
    public static EconomyAdapter activeAdapter() {
        return economy;
    }

    @ApiStatus.Internal
    public static UUID modifyNPCUUID(UUID uuid) {
        if (economy != null && USE_V2_UUID.contains(economy.name())) {
            return JavaUtil.changeUUIDVersion(uuid, 2);
        }
        int version = TownySettings.getInt(ConfigNodes.ECO_ADVANCED_NPC_UUID_VERSION);
        if (version < 0 || version > 15) {
            return uuid;
        }
        return JavaUtil.changeUUIDVersion(uuid, version);
    }

    public static boolean canRenameAccounts() {
        return TownyEconomyHandler.getType().equals((Object)EcoType.VAULTUNLOCKED);
    }

    public static void rename(Government gov, String newName) {
        if (TownyEconomyHandler.getType().equals((Object)EcoType.VAULTUNLOCKED)) {
            economy.renameAccount(gov.getAccount(), newName);
        }
    }

    public static enum EcoType {
        NONE,
        VAULT,
        RESERVE,
        VAULTUNLOCKED;

    }
}

