/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.statusscreen.NationStatusScreenEvent;
import com.palmergames.bukkit.towny.event.statusscreen.ResidentStatusScreenEvent;
import com.palmergames.bukkit.towny.event.statusscreen.TownBlockStatusScreenEvent;
import com.palmergames.bukkit.towny.event.statusscreen.TownStatusScreenEvent;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Government;
import com.palmergames.bukkit.towny.object.Nameable;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.SpawnLocation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownBlockTypeCache;
import com.palmergames.bukkit.towny.object.TownBlockTypeHandler;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.Translator;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.object.statusscreens.StatusScreen;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.MoneyUtil;
import com.palmergames.bukkit.towny.utils.NationUtil;
import com.palmergames.bukkit.towny.utils.OutpostUtil;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.towny.utils.TownRuinUtil;
import com.palmergames.bukkit.towny.utils.TownyComponents;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.StringMgmt;
import com.palmergames.util.TimeTools;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class TownyFormatter {
    public static final SimpleDateFormat lastOnlineFormat = new SimpleDateFormat("MMMMM dd '@' HH:mm");
    public static final SimpleDateFormat lastOnlineFormatIncludeYear = new SimpleDateFormat("MMMMM dd yyyy");
    public static final SimpleDateFormat registeredFormat = new SimpleDateFormat("MMM d yyyy");
    public static final SimpleDateFormat fullDateFormat = new SimpleDateFormat("MMMMM dd yyyy '@' HH:mm");
    public static final String listPrefixFormat = "%3$s%1$s %4$s[%2$d]%3$s:%5$s ";
    public static final String keyValueFormat = "%s%s %s%s";
    public static final String keyFormat = "%s%s";
    public static final String hoverFormat = "%s[%s%s%s]";
    public static final String bracketFormat = " %1$s[%2$s %3$s%1$s]";

    public static void initialize() {
    }

    public static StatusScreen getStatus(TownBlock townBlock, Player player) {
        StatusScreen screen = new StatusScreen((CommandSender)player);
        Translator translator = Translator.locale((CommandSender)player);
        Town town = townBlock.getTownOrNull();
        TownyWorld world = townBlock.getWorld();
        boolean preventPVP = CombatUtil.preventPvP(world, townBlock);
        TownyObject owner = townBlock.hasResident() ? townBlock.getResidentOrNull() : town;
        screen.addComponentOf("townblock_title", ChatTools.formatTitle("(" + townBlock.getCoord().toString() + ") " + owner.getFormattedName() + (TownyFormatter.playerIsOnlineAndVisible(owner.getName(), (CommandSender)player) ? translator.of("online") : "")));
        if (townBlock.getClaimedAt() > 0L) {
            screen.addComponentOf("claimedat", TownyFormatter.colourKeyValue(translator.of("msg_plot_perm_claimed_at"), registeredFormat.format(townBlock.getClaimedAt())));
        }
        if (!townBlock.getType().equals(TownBlockType.RESIDENTIAL)) {
            screen.addComponentOf("townblock_plotType", TownyFormatter.colourKeyValue(translator.of("status_plot_type"), townBlock.getType().toString()));
        }
        screen.addComponentOf("perm", TownyFormatter.colourKeyValue(translator.of("status_perm"), owner instanceof Resident ? townBlock.getPermissions().getColourString().replace("n", "t") : townBlock.getPermissions().getColourString().replace("f", "r")));
        screen.addComponentOf("pvp", TownyFormatter.colourKeyValue(translator.of("status_pvp"), !preventPVP ? translator.of("status_on") : translator.of("status_off")));
        screen.addComponentOf("explosion", TownyFormatter.colourKeyValue(translator.of("explosions"), world.isForceExpl() || townBlock.getPermissions().explosion ? translator.of("status_on") : translator.of("status_off")));
        screen.addComponentOf("firespread", TownyFormatter.colourKeyValue(translator.of("firespread"), world.isForceFire() || townBlock.getPermissions().fire ? translator.of("status_on") : translator.of("status_off")));
        screen.addComponentOf("mobspawns", TownyFormatter.colourKeyValue(translator.of("mobspawns"), world.isForceTownMobs() || townBlock.getPermissions().mobs || town.isAdminEnabledMobs() ? translator.of("status_on") : translator.of("status_off")));
        if (townBlock.hasDistrict()) {
            screen.addComponentOf("district", TownyFormatter.colourKey(translator.of("status_district_name_and_size", townBlock.getDistrict().getName(), townBlock.getDistrict().getTownBlocks().size())));
        }
        if (townBlock.hasPlotObjectGroup()) {
            screen.addComponentOf("plotgroup", TownyFormatter.colourKey(translator.of("status_plot_group_name_and_size", townBlock.getPlotObjectGroup().getName(), townBlock.getPlotObjectGroup().getTownBlocks().size())));
        }
        if (townBlock.getTrustedResidents().size() > 0) {
            screen.addComponentOf("trusted", TownyFormatter.getFormattedTownyObjects(translator.of("status_trustedlist"), new ArrayList<TownyObject>(townBlock.getTrustedResidents())));
        }
        if (TownyEconomyHandler.isActive()) {
            screen.addComponentOf("plottax", TownyFormatter.colourKeyValue(translator.of("status_townblock_plottax"), townBlock.isTaxed() ? TownyFormatter.formatMoney(townBlock.getPlotTax()) : translator.of("status_townblock_untaxed")));
        }
        if (townBlock.hasMinTownMembershipDays() && townBlock.hasMaxTownMembershipDays()) {
            screen.addComponentOf("minAndMaxJoinDate", TownyFormatter.colourKey(translator.of("status_townblock_max_and_minjoindays", townBlock.getMinTownMembershipDays(), townBlock.getMaxTownMembershipDays())));
        } else if (townBlock.hasMinTownMembershipDays()) {
            screen.addComponentOf("minJoinDate", TownyFormatter.colourKey(translator.of("status_townblock_minjoindays", townBlock.getMinTownMembershipDays())));
        } else if (townBlock.hasMaxTownMembershipDays()) {
            screen.addComponentOf("maxJoinDate", TownyFormatter.colourKey(translator.of("status_townblock_maxjoindays", townBlock.getMaxTownMembershipDays())));
        }
        List<Component> fields = TownyFormatter.getExtraFields(townBlock);
        if (!fields.isEmpty()) {
            screen.addComponentOf("extraFields", TownyFormatter.getExtraFieldsComponent(fields));
        }
        BukkitTools.fireEvent(new TownBlockStatusScreenEvent(screen, townBlock));
        return screen;
    }

    public static StatusScreen getStatus(Resident resident, CommandSender sender) {
        List<Component> fields;
        StatusScreen screen = new StatusScreen(sender);
        Translator translator = Translator.locale(sender);
        boolean onlineAndVisible = TownyFormatter.playerIsOnlineAndVisible(resident.getName(), sender);
        screen.addComponentOf("title", ChatTools.formatTitle(resident.getFormattedName() + (onlineAndVisible ? translator.of("online2") : "")));
        if (!resident.getAbout().isEmpty()) {
            screen.addComponentOf("about", TownyFormatter.colourKeyValue(translator.of("status_about"), resident.getAbout()));
        }
        screen.addComponentOf("registered", TownyFormatter.getResidentRegisteredLine(resident, translator));
        if (!resident.isNPC()) {
            screen.addComponentOf("lastonline", TownyFormatter.getResidentLastOnline(resident, onlineAndVisible, translator));
        }
        String townLine = TownyFormatter.colourKeyValue(translator.of("status_town"), (String)(!resident.hasTown() ? translator.of("status_no_town") : resident.getTownOrNull().getFormattedName() + TownyFormatter.formatPopulationBrackets(resident.getTownOrNull().getResidents().size())));
        if (!resident.hasTown()) {
            screen.addComponentOf("town", townLine);
        } else {
            Town town = resident.getTownOrNull();
            List<String> residents = TownyFormatter.getFormattedNames(town.getResidents());
            if (residents.size() > 34) {
                TownyFormatter.shortenOverLengthList(residents, 35, translator);
            }
            screen.addComponentOf("town", townLine, HoverEvent.showText((Component)TownyComponents.miniMessage(Colors.translateColorCodes(String.format(TownySettings.getPAPIFormattingTown(), town.getFormattedName()))).append((Component)Component.newline()).append(TownyComponents.miniMessage(TownyFormatter.getResidentJoinedTownDate(resident, translator))).append((Component)Component.newline()).append(TownyComponents.miniMessage(TownyFormatter.colourKeyValue(translator.of("rank_list_mayor"), Optional.ofNullable(town.getMayor()).map(Resident::getFormattedName).orElse("null")))).append((Component)Component.newline()).append(TownyComponents.miniMessage(TownyFormatter.colourKeyValue(translator.of("res_list"), StringMgmt.join(residents, ", ")))).append((Component)Component.newline()).append(translator.component("status_hover_click_for_more"))), ClickEvent.runCommand((String)("/towny:town " + town.getName())));
        }
        if (resident.hasNation()) {
            Nation nation = resident.getNationOrNull();
            List<String> towns = TownyFormatter.getFormattedNames(nation.getTowns());
            if (towns.size() > 10) {
                TownyFormatter.shortenOverLengthList(towns, 11, translator);
            }
            screen.addComponentOf("nation", TownyFormatter.colourKeyValue(translator.of("status_town_nation"), nation.getName() + TownyFormatter.formatPopulationBrackets(nation.getTowns().size())), HoverEvent.showText((Component)TownyComponents.miniMessage(Colors.translateColorCodes(String.format(TownySettings.getPAPIFormattingNation(), nation.getFormattedName()))).append((Component)Component.newline()).append(TownyComponents.miniMessage(TownyFormatter.colourKeyValue(translator.of("status_nation_king"), nation.getCapital().getMayor().getFormattedName()))).append((Component)Component.newline()).append(TownyComponents.miniMessage(TownyFormatter.colourKeyValue(translator.of("town_plu"), StringMgmt.join(towns, ", ")))).append((Component)Component.newline()).append(translator.component("status_hover_click_for_more"))), ClickEvent.runCommand((String)("/towny:nation " + nation.getName())));
        }
        if (TownyEconomyHandler.isActive()) {
            screen.addComponentOf("bank", TownyFormatter.colourKeyValue(translator.of("status_bank"), resident.getAccount().getHoldingFormattedBalance()), HoverEvent.showText((Component)translator.component("status_hover_click_for_more")), ClickEvent.runCommand((String)("/towny:resident tax " + resident.getName())));
        }
        screen.addComponentOf("ownsXPlots", TownyFormatter.colourKey(translator.of("owner_of_x_plots", resident.getTownBlocks().size())));
        screen.addComponentOf("perm", TownyFormatter.colourKeyValue(translator.of("status_perm"), resident.getPermissions().getColourString().replace("n", "t")));
        screen.addComponentOf("pvp", TownyFormatter.colourKeyValue(translator.of("status_pvp"), resident.getPermissions().pvp ? translator.of("status_on") : translator.of("status_off")));
        screen.addComponentOf("explosions", TownyFormatter.colourKeyValue(translator.of("explosions"), resident.getPermissions().explosion ? translator.of("status_on") : translator.of("status_off")));
        screen.addComponentOf("firespread", TownyFormatter.colourKeyValue(translator.of("firespread"), resident.getPermissions().fire ? translator.of("status_on") : translator.of("status_off")));
        screen.addComponentOf("mobspawns", TownyFormatter.colourKeyValue(translator.of("mobspawns"), resident.getPermissions().mobs ? translator.of("status_on") : translator.of("status_off")));
        if (resident.isNPC()) {
            screen.addComponentOf("npcstatus", translator.of("msg_status_npc", resident.getName()));
            List<Component> fields2 = TownyFormatter.getExtraFields(resident);
            if (!fields2.isEmpty()) {
                TextComponent comp = Component.empty();
                for (Component fieldComp : fields2) {
                    comp = (TextComponent)((TextComponent)comp.append((Component)Component.newline())).append(fieldComp);
                }
                screen.addComponentOf("extraFields", (Component)comp);
            }
            return screen;
        }
        List<Town> townEmbassies = resident.getEmbassyTowns();
        if (townEmbassies.size() > 0) {
            screen.addComponentOf("embassiesInTowns", TownyFormatter.getFormattedTownyObjects(translator.of("status_embassy_town"), new ArrayList<TownyObject>(townEmbassies)));
        }
        if (resident.hasTown() && !resident.getTownRanks().isEmpty()) {
            screen.addComponentOf("townRanks", TownyFormatter.colourKeyValue(translator.of("status_town_ranks"), StringMgmt.capitalize(StringMgmt.join(resident.getTownRanks(), ", "))));
        }
        if (resident.hasNation() && !resident.getNationRanks().isEmpty()) {
            screen.addComponentOf("nationRanks", TownyFormatter.colourKeyValue(translator.of("status_nation_ranks"), StringMgmt.capitalize(StringMgmt.join(resident.getNationRanks(), ", "))));
        }
        if (resident.isJailed()) {
            screen.addComponentOf("jailLine", TownyFormatter.getResidentJailedLine(resident, translator));
        }
        if (resident.getFriends() != null && !resident.getFriends().isEmpty()) {
            screen.addComponentOf("friendsLine", TownyFormatter.getFormattedTownyObjects(translator.of("status_friends"), new ArrayList<TownyObject>(resident.getFriends())));
        }
        if (!(fields = TownyFormatter.getExtraFields(resident)).isEmpty()) {
            screen.addComponentOf("extraFields", TownyFormatter.getExtraFieldsComponent(fields));
        }
        BukkitTools.fireEvent(new ResidentStatusScreenEvent(screen, resident));
        return screen;
    }

    public static StatusScreen getStatus(Town town, CommandSender sender) {
        Translator translator = Translator.locale(sender);
        StatusScreen screen = new StatusScreen(sender);
        TownyWorld world = town.getHomeblockWorld();
        screen.addComponentOf("title", ChatTools.formatTitle(town));
        List<String> sub = TownyFormatter.getTownSubtitle(town, world, translator);
        if (!sub.isEmpty()) {
            screen.addComponentOf("subtitle", ChatTools.formatSubTitle(StringMgmt.join(sub, " ")));
        }
        if (town.getBoard() != null && !town.getBoard().isEmpty()) {
            screen.addComponentOf("board", TownyFormatter.colourKeyValue(translator.of("status_town_board"), town.getBoard()));
        }
        if (town.getRegistered() != 0L) {
            screen.addComponentOf("registered", TownyFormatter.colourKeyValue(translator.of("status_founded"), registeredFormat.format(town.getRegistered())));
        }
        screen.addComponentOf("founder", TownyFormatter.colourKeyValue(translator.of("status_founded_by"), town.getFounder()));
        if (!town.hasUnlimitedClaims()) {
            screen.addComponentOf("townblocks", TownyFormatter.colourKeyValue(translator.of("status_town_size"), translator.of("status_fractions", town.getTownBlocks().size(), TownySettings.getMaxTownBlocks(town))) + (TownySettings.isSellingBonusBlocks(town) ? TownyFormatter.colourBracketElement(translator.of("status_town_size_bought"), translator.of("status_fractions", town.getPurchasedBlocks(), TownySettings.getMaxPurchasedBlocks(town))) : "") + (town.getBonusBlocks() > 0 ? TownyFormatter.colourBracketElement(translator.of("status_town_size_bonus"), String.valueOf(town.getBonusBlocks())) : "") + (TownySettings.getNationBonusBlocks(town) > 0 ? TownyFormatter.colourBracketElement(translator.of("status_town_size_nationbonus"), String.valueOf(TownySettings.getNationBonusBlocks(town))) : ""));
        } else {
            screen.addComponentOf("townblocks", TownyFormatter.colourKeyValue(translator.of("status_town_size"), translator.of("status_fractions", town.getTownBlocks().size(), town.getMaxTownBlocksAsAString())));
        }
        if (town.isPublic() || TownySettings.isWebMapLinkShownForNonPublicTowns()) {
            Object[] objectArray = new Object[1];
            objectArray[0] = TownySettings.getTownDisplaysXYZ() ? (town.hasSpawn() ? BukkitTools.convertCoordtoXYZ(town.getSpawnOrNull()) : translator.of("status_no_town")) : (town.hasHomeBlock() ? town.getHomeBlockOrNull().getCoord().toString() : translator.of("status_no_town"));
            Component homeComponent = TownyComponents.miniMessage(translator.of("status_home_element", objectArray));
            String webUrl = TownyFormatter.formatWebUrl(town);
            if (!webUrl.isEmpty()) {
                homeComponent = homeComponent.clickEvent(ClickEvent.openUrl((String)webUrl)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)translator.component("msg_view_on_web")));
            }
            screen.addComponentOf("home", homeComponent);
        }
        if (TownySettings.isAllowingOutposts()) {
            OutpostUtil.addOutpostComponent(town, screen, translator);
        }
        screen.addComponentOf("perm", TownyFormatter.colourKeyValue(translator.of("status_perm"), town.getPermissions().getColourString().replace("f", "r")));
        screen.addComponentOf("explosion", TownyFormatter.colourKeyValue(translator.of("explosions"), town.isExplosion() || world.isForceExpl() ? translator.of("status_on") : translator.of("status_off")));
        screen.addComponentOf("firespread", TownyFormatter.colourKeyValue(translator.of("firespread"), town.isFire() || world.isForceFire() ? translator.of("status_on") : translator.of("status_off")));
        screen.addComponentOf("mobspawns", TownyFormatter.colourKeyValue(translator.of("mobspawns"), town.hasMobs() || town.isAdminEnabledMobs() || world.isForceTownMobs() ? translator.of("status_on") : translator.of("status_off")));
        if (TownySettings.getTownRuinsEnabled() && town.isRuined()) {
            TownRuinUtil.addRuinedComponents(town, screen, translator);
        } else {
            List<String> residents;
            if (TownyEconomyHandler.isActive()) {
                MoneyUtil.addTownMoneyComponents(town, translator, screen);
            }
            if (town.getMayor() != null) {
                screen.addComponentOf("mayor", TownyFormatter.colourKeyValue(translator.of("rank_list_mayor"), town.getMayor().getFormattedName()), HoverEvent.showText((Component)translator.component("registered_last_online", registeredFormat.format(town.getMayor().getRegistered()), lastOnlineFormatIncludeYear.format(town.getMayor().getLastOnline())).append((Component)Component.newline()).append(translator.component("status_hover_click_for_more"))), ClickEvent.runCommand((String)("/towny:resident " + town.getMayor().getName())));
            } else {
                screen.addComponentOf("mayor", TownyFormatter.colourKeyValue(translator.of("rank_list_mayor"), translator.of("status_no_town")));
            }
            if (town.hasNation()) {
                NationUtil.addNationComponenents(town, screen, translator);
            }
            screen.addComponentOf("newline", (Component)Component.newline());
            List<String> ranklist = TownyFormatter.getRanks(town, translator);
            if (ranklist.size() > 0) {
                screen.addComponentOf("townranks", TownyFormatter.colourHoverKey(translator.of("status_rank_list")), HoverEvent.showText((Component)TownyComponents.miniMessage(String.join((CharSequence)"\n", ranklist)).append((Component)Component.newline()).append(translator.component("status_hover_click_for_more"))), ClickEvent.runCommand((String)("/towny:town ranklist " + town.getName())));
            }
            if ((residents = TownyFormatter.getFormattedNames(town.getResidents())).size() > 34) {
                TownyFormatter.shortenOverLengthList(residents, 35, translator);
            }
            screen.addComponentOf("residents", TownyFormatter.colourHoverKey(translator.of("res_list")), HoverEvent.showText((Component)TownyComponents.miniMessage(TownyFormatter.getFormattedStrings(translator.of("res_list"), residents, town.getResidents().size())).append((Component)Component.newline()).append(translator.component("status_hover_click_for_more"))), ClickEvent.runCommand((String)("/towny:town reslist " + town.getName())));
            TextComponent text = Component.empty();
            Map<TownBlockType, Integer> cache = town.getTownBlockTypeCache().getCache(TownBlockTypeCache.CacheType.ALL);
            for (TownBlockType type : TownBlockTypeHandler.getTypes().values()) {
                int value = cache.getOrDefault(type, 0);
                text = (TextComponent)text.append(TownyComponents.miniMessage(TownyFormatter.colourKeyValue(translator.of("status_plot_hover", type.getFormattedName()), String.valueOf(value))).append((Component)Component.newline()));
            }
            text = (TextComponent)text.append(translator.component("status_hover_click_for_more"));
            screen.addComponentOf("plots", TownyFormatter.colourHoverKey(translator.of("status_plot_string")), HoverEvent.showText((Component)text), ClickEvent.runCommand((String)("/towny:town plots " + town.getName())));
        }
        List<Component> fields = TownyFormatter.getExtraFields(town);
        if (!fields.isEmpty()) {
            screen.addComponentOf("extraFields", TownyFormatter.getExtraFieldsComponent(fields));
        }
        BukkitTools.fireEvent(new TownStatusScreenEvent(screen, town));
        return screen;
    }

    public static StatusScreen getStatus(Nation nation, CommandSender sender) {
        List<Component> fields;
        List<String> sanctionedTowns;
        List<String> enemies;
        List<String> towns;
        long registered;
        StatusScreen screen = new StatusScreen(sender);
        Translator translator = Translator.locale(sender);
        screen.addComponentOf("nation_title", ChatTools.formatTitle(nation));
        List<String> sub = TownyFormatter.getNationSubtitle(nation, translator);
        if (!sub.isEmpty()) {
            screen.addComponentOf("subtitle", ChatTools.formatSubTitle(StringMgmt.join(sub, " ")));
        }
        if (nation.getBoard() != null && !nation.getBoard().isEmpty()) {
            screen.addComponentOf("board", TownyFormatter.colourKeyValue(translator.of("status_town_board"), nation.getBoard()));
        }
        if ((registered = nation.getRegistered()) != 0L) {
            screen.addComponentOf("registered", TownyFormatter.colourKeyValue(translator.of("status_founded"), registeredFormat.format(nation.getRegistered())));
        }
        if (TownyEconomyHandler.isActive()) {
            MoneyUtil.addNationMoneyComponentsToScreen(nation, translator, screen);
        }
        if (nation.isPublic()) {
            Component homeComponent = translator.component("status_home_element", nation.hasSpawn() ? Coord.parseCoord(nation.getSpawnOrNull()).toString() : translator.of("status_no_town"));
            String webUrl = TownyFormatter.formatWebUrl(nation);
            if (!webUrl.isEmpty()) {
                homeComponent = homeComponent.clickEvent(ClickEvent.openUrl((String)webUrl)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)translator.component("msg_view_on_web")));
            }
            screen.addComponentOf("home", homeComponent);
        }
        if (nation.getNumTowns() > 0 && nation.hasCapital() && nation.getCapital().hasMayor()) {
            Resident king = nation.getCapital().getMayor();
            screen.addComponentOf("king", TownyFormatter.colourKeyValue(translator.of("status_nation_king"), king.getFormattedName()), HoverEvent.showText((Component)translator.component("registered_last_online", TownyFormatter.getFormattedResidentRegistration(king), lastOnlineFormatIncludeYear.format(king.getLastOnline())).append((Component)Component.newline()).append(translator.component("status_hover_click_for_more"))), ClickEvent.runCommand((String)("/towny:resident " + king.getName())));
            Town capital = nation.getCapital();
            List<String> residents = TownyFormatter.getFormattedNames(capital.getResidents());
            if (residents.size() > 34) {
                TownyFormatter.shortenOverLengthList(residents, 35, translator);
            }
            screen.addComponentOf("capital", TownyFormatter.colourKeyValue(translator.of("status_capital"), nation.getCapital().getFormattedName()), HoverEvent.showText((Component)TownyComponents.miniMessage(Colors.translateColorCodes(String.format(TownySettings.getPAPIFormattingTown(), capital.getFormattedName()))).append((Component)Component.newline()).append(TownyComponents.miniMessage(TownyFormatter.colourKeyValue(translator.of("rank_list_mayor"), king.getFormattedName()))).append((Component)Component.newline()).append(TownyComponents.miniMessage(TownyFormatter.colourKeyValue(translator.of("res_list"), StringMgmt.join(residents, ", ")))).append((Component)Component.newline()).append(translator.component("status_hover_click_for_more"))), ClickEvent.runCommand((String)("/towny:town " + capital.getName())));
            if (TownySettings.getNationZonesEnabled()) {
                screen.addComponentOf("nationzone", TownyFormatter.colourKeyValue(translator.of("status_nation_zone_size"), String.valueOf(nation.getNationZoneSize())));
            }
        }
        screen.addComponentOf("newline", (Component)Component.newline());
        List<String> ranklist = TownyFormatter.getRanks(nation, translator);
        if (ranklist.size() > 0) {
            screen.addComponentOf("nationranks", TownyFormatter.colourHoverKey(translator.of("status_rank_list")), HoverEvent.showText((Component)TownyComponents.miniMessage(String.join((CharSequence)"\n", ranklist)).append((Component)Component.newline()).append(translator.component("status_hover_click_for_more"))), ClickEvent.runCommand((String)("/towny:nation ranklist " + nation.getName())));
        }
        if ((towns = TownyFormatter.getFormattedNames(nation.getTowns())).size() > 10) {
            TownyFormatter.shortenOverLengthList(towns, 11, translator);
        }
        screen.addComponentOf("towns", TownyFormatter.colourHoverKey(translator.of("status_nation_towns")), HoverEvent.showText((Component)TownyComponents.miniMessage(TownyFormatter.getFormattedStrings(translator.of("status_nation_towns"), towns, nation.getTowns().size())).append((Component)Component.newline()).append(translator.component("status_hover_click_for_more"))), ClickEvent.runCommand((String)("/towny:nation townlist " + nation.getName())));
        List<String> allies = TownyFormatter.getFormattedNames(nation.getAllies());
        if (allies.size() > 10) {
            TownyFormatter.shortenOverLengthList(allies, 11, translator);
        }
        if (allies.size() > 0) {
            screen.addComponentOf("allies", TownyFormatter.colourHoverKey(translator.of("status_nation_allies")), HoverEvent.showText((Component)TownyComponents.miniMessage(TownyFormatter.getFormattedStrings(translator.of("status_nation_allies"), allies, nation.getAllies().size())).append((Component)Component.newline()).append(translator.component("status_hover_click_for_more"))), ClickEvent.runCommand((String)("/towny:nation allylist " + nation.getName())));
        }
        if ((enemies = TownyFormatter.getFormattedNames(nation.getEnemies())).size() > 10) {
            TownyFormatter.shortenOverLengthList(enemies, 11, translator);
        }
        if (enemies.size() > 0) {
            screen.addComponentOf("enemies", TownyFormatter.colourHoverKey(translator.of("status_nation_enemies")), HoverEvent.showText((Component)TownyComponents.miniMessage(TownyFormatter.getFormattedStrings(translator.of("status_nation_enemies"), enemies, nation.getEnemies().size())).append((Component)Component.newline()).append(translator.component("status_hover_click_for_more"))), ClickEvent.runCommand((String)("/towny:nation enemylist " + nation.getName())));
        }
        if ((sanctionedTowns = TownyFormatter.getFormattedNames(nation.getSanctionedTowns())).size() > 10) {
            TownyFormatter.shortenOverLengthList(sanctionedTowns, 11, translator);
        }
        if (sanctionedTowns.size() > 0) {
            screen.addComponentOf("sanctionedtowns", TownyFormatter.colourHoverKey(translator.of("status_nation_sanctioned_towns")), HoverEvent.showText((Component)TownyComponents.miniMessage(TownyFormatter.getFormattedStrings(translator.of("status_nation_sanctioned_towns"), sanctionedTowns, nation.getSanctionedTowns().size())).append((Component)Component.newline()).append(translator.component("status_hover_click_for_more"))), ClickEvent.runCommand((String)("/towny:nation sanctiontown list " + nation.getName())));
        }
        if (!(fields = TownyFormatter.getExtraFields(nation)).isEmpty()) {
            screen.addComponentOf("extraFields", TownyFormatter.getExtraFieldsComponent(fields));
        }
        BukkitTools.fireEvent(new NationStatusScreenEvent(screen, nation));
        return screen;
    }

    public static StatusScreen getStatus(TownyWorld world, CommandSender sender) {
        StatusScreen screen = new StatusScreen(sender);
        Translator translator = Translator.locale(sender);
        screen.addComponentOf("townyworld_title", ChatTools.formatTitle(world.getFormattedName()));
        screen.addComponentOf("subtitle", ChatTools.formatSubTitle(StringMgmt.join(TownyFormatter.getWorldSubtitle(world, translator), " ")));
        if (!world.isUsingTowny()) {
            screen.addComponentOf("not_using_towny", translator.of("msg_set_use_towny_off"));
        } else {
            screen.addComponentOf("war_allowed", TownyFormatter.colourKey(world.isWarAllowed() ? translator.of("msg_set_war_allowed_on") : translator.of("msg_set_war_allowed_off")));
            screen.addComponentOf("pvp", TownyFormatter.colourKeyValue(translator.of("status_world_forcepvp"), world.isForcePVP() ? translator.of("status_on") : translator.of("status_off")) + translator.of("status_splitter") + TownyFormatter.colourKeyValue(translator.of("status_world_friendlyfire"), world.isFriendlyFireEnabled() ? translator.of("status_on") : translator.of("status_off")));
            screen.addComponentOf("fire", TownyFormatter.colourKeyValue(translator.of("status_world_fire"), world.isFire() ? translator.of("status_on") : translator.of("status_off")) + translator.of("status_splitter") + TownyFormatter.colourKeyValue(translator.of("status_world_forcefire"), world.isForceFire() ? translator.of("status_forced") : translator.of("status_adjustable")));
            screen.addComponentOf("explosions", TownyFormatter.colourKeyValue(translator.of("explosions"), world.isExpl() ? translator.of("status_on") : translator.of("status_off")) + translator.of("status_splitter") + TownyFormatter.colourKeyValue(translator.of("status_world_forceexplosion"), world.isForceExpl() ? translator.of("status_forced") : translator.of("status_adjustable")));
            screen.addComponentOf("mobs", TownyFormatter.colourKeyValue(translator.of("status_world_worldmobs"), world.hasWorldMobs() ? translator.of("status_on") : translator.of("status_off")) + translator.of("status_splitter") + TownyFormatter.colourKeyValue(translator.of("status_world_wildernessmobs"), world.hasWildernessMobs() ? translator.of("status_on") : translator.of("status_off")));
            screen.addComponentOf("townmobs", TownyFormatter.colourKeyValue(translator.of("status_world_forcetownmobs"), world.isForceTownMobs() ? translator.of("status_forced") : translator.of("status_adjustable")));
            screen.addComponentOf("unclaim_revert", TownyFormatter.colourKeyValue("\n" + translator.of("status_world_unclaimrevert"), world.isUsingPlotManagementRevert() ? translator.of("status_on_good") : translator.of("status_off_bad")) + translator.of("status_splitter") + TownyFormatter.colourKeyValue(translator.of("status_world_jailing"), world.isJailingEnabled() ? translator.of("status_on_good") : translator.of("status_off_bad")));
            screen.addComponentOf("explosion_reverts", TownyFormatter.colourKeyValue(translator.of("status_world_explrevert_entity"), world.isUsingPlotManagementWildEntityRevert() ? translator.of("status_on_good") : translator.of("status_off_bad")) + translator.of("status_splitter") + TownyFormatter.colourKeyValue(translator.of("status_world_explrevert_block"), world.isUsingPlotManagementWildBlockRevert() ? translator.of("status_on_good") : translator.of("status_off_bad")));
            screen.addComponentOf("plot_clear", TownyFormatter.colourKeyValue(translator.of("status_plot_clear_deletion"), (String)(world.isUsingPlotManagementMayorDelete() ? translator.of("status_on") + "\u00a7a (see /towny plotclearblocks)" : translator.of("status_off"))));
            screen.addComponentOf("wilderness", TownyFormatter.colourKey(world.getFormattedUnclaimedZoneName() + ": \n"));
            screen.addComponentOf("perms1", "    " + (world.getUnclaimedZoneBuild() != false ? "\u00a7a" : "\u00a7c") + translator.of("build") + "\u00a78, " + (world.getUnclaimedZoneDestroy() != false ? "\u00a7a" : "\u00a7c") + translator.of("destroy") + "\u00a78, " + (world.getUnclaimedZoneSwitch() != false ? "\u00a7a" : "\u00a7c") + translator.of("switch") + "\u00a78, " + (world.getUnclaimedZoneItemUse() != false ? "\u00a7a" : "\u00a7c") + translator.of("item_use"));
            screen.addComponentOf("perms2", "    " + TownyFormatter.colourKey(translator.of("status_world_ignoredblocks") + "\u00a7a see /towny wildsblocks"));
            List<Component> fields = TownyFormatter.getExtraFields(world);
            if (!fields.isEmpty()) {
                screen.addComponentOf("extraFields", TownyFormatter.getExtraFieldsComponent(fields));
            }
        }
        return screen;
    }

    public static String colourKeyValue(String key, String value) {
        return String.format(keyValueFormat, Translation.of("status_format_key_value_key"), key, Translation.of("status_format_key_value_value"), value);
    }

    public static Component colourKeyValue(Component key, Component value) {
        return Translatable.of("status_format_key_value_key").append(key).append(" ").append(Translatable.of("status_format_key_value_value").append(value)).component();
    }

    public static String colourKey(String key) {
        return String.format(keyFormat, Translation.of("status_format_key_value_key"), key);
    }

    public static String colourValue(String value) {
        return Translation.of("status_format_key_value_value") + value;
    }

    public static String colourKeyImportant(String key) {
        return String.format(keyFormat, Translation.of("status_format_key_important"), key);
    }

    public static String colourBracketElement(String key, String value) {
        return String.format(bracketFormat, Translation.of("status_format_bracket_element"), key, value);
    }

    public static String colourHoverKey(String key) {
        return String.format(hoverFormat, Translation.of("status_format_hover_bracket_colour"), Translation.of("status_format_hover_key"), key, Translation.of("status_format_hover_bracket_colour"));
    }

    public static String formatPopulationBrackets(int size) {
        return String.format(" %s[%s]", Translation.of("status_format_list_2"), size);
    }

    private static String getResidentRegisteredLine(Resident resident, Translator translator) {
        return !resident.isNPC() ? TownyFormatter.colourKeyValue(translator.of("status_registered"), TownyFormatter.getFormattedResidentRegistration(resident)) : TownyFormatter.colourKeyValue(translator.of("npc_created"), TownyFormatter.getFormattedResidentRegistration(resident));
    }

    public static String getFormattedResidentRegistration(Resident resident) {
        return registeredFormat.format(resident.getRegistered());
    }

    private static Component getResidentLastOnline(Resident resident, boolean onlineAndVisible, Translator translator) {
        String hoverText = TownyFormatter.colourValue(TownyFormatter.sameYear(resident) ? lastOnlineFormat.format(resident.getLastOnline()) : lastOnlineFormatIncludeYear.format(resident.getLastOnline()));
        return TownyFormatter.colourKeyValue(translator.component(onlineAndVisible ? "status_onlinesince" : "status_lastonline"), TimeTools.formatRelativeTime(resident.getLastOnline()).component(translator.locale()).hoverEvent((HoverEventSource)HoverEvent.showText((Component)TownyComponents.miniMessage(hoverText))).clickEvent(ClickEvent.openUrl((String)("https://time.is/" + resident.getLastOnline()))));
    }

    private static String getResidentJoinedTownDate(Resident resident, Translator translator) {
        return TownyFormatter.colourKeyValue(translator.of("status_joined_town"), resident.getJoinedTownAt() > 0L ? lastOnlineFormatIncludeYear.format(resident.getJoinedTownAt()) : translator.of("status_unknown"));
    }

    private static boolean sameYear(Resident resident) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(resident.getLastOnline());
        int currentYear = cal.get(1);
        cal.setTimeInMillis(System.currentTimeMillis());
        int lastOnlineYear = cal.get(1);
        return currentYear == lastOnlineYear;
    }

    private static String getResidentJailedLine(Resident resident, Translator translator) {
        Object jailLine = TownyFormatter.colourKeyValue(translator.of("status_jailed"), resident.isJailed() ? translator.of("status_bad_yes") : translator.of("status_good_no"));
        if (resident.isJailed()) {
            jailLine = (String)jailLine + TownyFormatter.colourKey(translator.of("jailed_in_town", resident.getJailTown().getName()));
        }
        if (resident.isJailed() && resident.hasJailTime()) {
            jailLine = (String)jailLine + TownyFormatter.colourKey(translator.of("msg_jailed_for_x_hours", resident.getJailHours()));
        }
        return jailLine;
    }

    private static List<String> getRanks(Government gov, Translator translator) {
        Town town;
        ArrayList<String> ranklist = new ArrayList<String>();
        ArrayList<Resident> residents = new ArrayList<Resident>(gov.getResidents());
        List<String> ranks = gov instanceof Nation ? TownyPerms.getNationRanks() : TownyPerms.getTownRanks();
        ArrayList<Resident> residentWithRank = new ArrayList<Resident>();
        for (String rank : ranks) {
            for (Resident r : residents) {
                if (gov instanceof Nation && r.getNationRanks() != null && r.getNationRanks().contains(rank)) {
                    residentWithRank.add(r);
                }
                if (!(gov instanceof Town) || r.getTownRanks() == null || !r.getTownRanks().contains(rank)) continue;
                residentWithRank.add(r);
            }
            if (!residentWithRank.isEmpty()) {
                ranklist.add(TownyFormatter.getFormattedTownyObjects(StringMgmt.capitalize(rank), new ArrayList<TownyObject>(residentWithRank)));
            }
            residentWithRank.clear();
        }
        if (gov instanceof Town && (town = (Town)gov).getTrustedResidents().size() > 0) {
            ranklist.add(TownyFormatter.getFormattedTownyObjects(translator.of("status_trustedlist"), new ArrayList<TownyObject>(town.getTrustedResidents())));
        }
        return ranklist;
    }

    private static String[] shortenOverlengthArray(String[] array, int i, Translator translator) {
        String[] entire = array;
        array = new String[i + 1];
        System.arraycopy(entire, 0, array, 0, i);
        array[i] = translator.of("status_town_reslist_overlength");
        return array;
    }

    public static void shortenOverLengthList(List<String> list, int i, Translator translator) {
        list.subList(Math.min(i, list.size() - 1), list.size() - 1).clear();
        list.add(translator.of("status_town_reslist_overlength"));
    }

    private static String formatMoney(double money) {
        return TownyEconomyHandler.getFormattedBalance(money);
    }

    public static List<String> getTownSubtitle(Town town, TownyWorld world, Translator translator) {
        ArrayList<String> sub = new ArrayList<String>();
        if (town.isCapital()) {
            sub.add(translator.of("status_title_capital"));
        }
        if (!town.isAdminDisabledPVP() && (town.isPVP() || world.isForcePVP())) {
            sub.add(translator.of("status_title_pvp"));
        }
        if (town.isOpen()) {
            sub.add(translator.of("status_title_open"));
        }
        if (town.isPublic()) {
            sub.add(translator.of("status_public"));
        }
        if (town.isNeutral()) {
            sub.add(translator.of("status_town_title_peaceful"));
        }
        if (town.isConquered()) {
            sub.add(translator.of("msg_conquered"));
        }
        if (town.isForSale()) {
            sub.add(translator.of("status_forsale", TownyFormatter.formatMoney(town.getForSalePrice())));
        }
        return sub;
    }

    public static List<String> getNationSubtitle(Nation nation, Translator translator) {
        ArrayList<String> sub = new ArrayList<String>();
        if (nation.isOpen()) {
            sub.add(translator.of("status_title_open"));
        }
        if (nation.isPublic()) {
            sub.add(translator.of("status_public"));
        }
        if (nation.isNeutral()) {
            sub.add(translator.of("status_town_title_peaceful"));
        }
        return sub;
    }

    private static List<String> getWorldSubtitle(TownyWorld world, Translator translator) {
        ArrayList<String> sub = new ArrayList<String>();
        if (world.isPVP() || world.isForcePVP()) {
            sub.add(translator.of("status_title_pvp"));
        }
        if (world.isClaimable()) {
            sub.add(translator.of("status_world_claimable"));
        } else {
            sub.add(translator.of("status_world_noclaims"));
        }
        return sub;
    }

    public static List<Component> getExtraFields(TownyObject to) {
        if (!to.hasMeta()) {
            return Collections.emptyList();
        }
        ArrayList<Component> extraFields = new ArrayList<Component>();
        for (CustomDataField<?> cdf : to.getMetadata()) {
            NamedTextColor kvColor;
            if (!cdf.shouldDisplayInStatus()) continue;
            Component newAdd = cdf.getLabelAsComp();
            if (newAdd.style().color() == null && (kvColor = Colors.toNamedTextColor(Translation.of("status_format_key_value_key"))) != null) {
                newAdd = newAdd.color((TextColor)kvColor);
            }
            newAdd = newAdd.append(Component.text((String)": ").mergeStyle(newAdd)).append(cdf.formatValueAsComp());
            extraFields.add(newAdd);
        }
        return extraFields;
    }

    private static Component getExtraFieldsComponent(List<Component> fields) {
        TextComponent comp = Component.empty();
        boolean first = true;
        for (Component fieldComp : fields) {
            if (!first) {
                comp = comp.append((Component)Component.newline());
            }
            comp = comp.append(fieldComp);
            first = false;
        }
        return comp;
    }

    private static boolean playerIsOnlineAndVisible(String name, CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return BukkitTools.isOnline(name) && BukkitTools.playerCanSeePlayer(player, BukkitTools.getPlayerExact(name));
        }
        if (sender instanceof ConsoleCommandSender) {
            return BukkitTools.isOnline(name);
        }
        return false;
    }

    public static String getFormattedOnlineResidents(String prefix, ResidentList residentList, Player player) {
        return TownyFormatter.getFormattedTownyObjects(prefix, new ArrayList<TownyObject>(ResidentUtil.getOnlineResidentsViewable(player, residentList)));
    }

    public static String getFormattedTownyObjects(String prefix, List<TownyObject> objectlist) {
        return String.format(listPrefixFormat, prefix, objectlist.size(), Translation.of("status_format_list_1"), Translation.of("status_format_list_2"), Translation.of("status_format_list_3")) + StringMgmt.join(TownyFormatter.getFormattedTownyNames(objectlist), ", ");
    }

    public static String getFormattedStrings(String prefix, List<String> list) {
        return String.format(listPrefixFormat, prefix, list.size(), Translation.of("status_format_list_1"), Translation.of("status_format_list_2"), Translation.of("status_format_list_3")) + StringMgmt.join(list, ", ");
    }

    public static String getFormattedStrings(String prefix, List<String> list, int size) {
        return String.format(listPrefixFormat, prefix, size, Translation.of("status_format_list_1"), Translation.of("status_format_list_2"), Translation.of("status_format_list_3")) + StringMgmt.join(list, ", ");
    }

    public static List<String> getFormattedTownyNames(List<TownyObject> objs) {
        ArrayList<String> names = new ArrayList<String>();
        for (TownyObject obj : objs) {
            names.add(Colors.translateColorCodes(objs.size() < 20 ? obj.getFormattedName() : obj.getName()) + "<reset>");
        }
        return names;
    }

    public static String[] getFormattedNames(TownyObject[] objs) {
        ArrayList<CallSite> names = new ArrayList<CallSite>();
        for (TownyObject obj : objs) {
            names.add((CallSite)((Object)(Colors.translateColorCodes(obj.getFormattedName()) + "<reset>")));
        }
        return names.toArray(new String[0]);
    }

    public static List<String> getFormattedNames(Collection<? extends Nameable> objects) {
        ArrayList<String> names = new ArrayList<String>(objects.size());
        for (Nameable nameable : objects) {
            names.add(Colors.translateColorCodes(nameable.getFormattedName()) + "<reset>");
        }
        return names;
    }

    public static List<String> getTaxStatus(Resident resident, Translator translator) {
        Town town;
        ArrayList<String> out = new ArrayList<String>();
        boolean taxExempt = TownyPerms.getResidentPerms(resident).get("towny.tax_exempt") == Boolean.TRUE;
        double plotTax = 0.0;
        double townTax = 0.0;
        out.add(ChatTools.formatTitle(translator.of("status_resident_tax_title", resident.getName())));
        out.add(TownyFormatter.colourKey(translator.of("owner_of_x_plots", resident.getTownBlocks().size())));
        if (resident.hasTown()) {
            town = TownyAPI.getInstance().getResidentTownOrNull(resident);
            if (taxExempt) {
                out.add(TownyFormatter.colourKey(translator.of("status_res_taxexempt")));
            } else {
                townTax = town.isTaxPercentage() ? Math.min(resident.getAccount().getHoldingBalance() * town.getTaxes() / 100.0, town.getMaxPercentTaxAmount()) : town.getTaxes();
                out.add(TownyFormatter.colourKeyValue(translator.of("status_res_tax"), TownyFormatter.formatMoney(townTax)));
            }
        }
        if (resident.getTownBlocks().size() > 0) {
            for (TownBlock townBlock : new ArrayList<TownBlock>(resident.getTownBlocks())) {
                town = townBlock.getTownOrNull();
                if (town == null || taxExempt && town.hasResident(resident)) continue;
                plotTax += townBlock.getType().getTax(town);
            }
            out.add(TownyFormatter.colourKeyValue(translator.of("status_res_plottax"), TownyFormatter.formatMoney(plotTax)));
        }
        out.add(TownyFormatter.colourKeyValue(translator.of("status_res_totaltax"), TownyFormatter.formatMoney(townTax + plotTax)));
        return out;
    }

    public static List<String> getRanksForTown(Town town, Translator translator) {
        ArrayList<String> ranklist = new ArrayList<String>();
        ranklist.add(ChatTools.formatTitle(translator.of("rank_list_title", town.getFormattedName())));
        ranklist.add(TownyFormatter.colourKeyValue(translator.of("rank_list_mayor"), town.getMayor().getFormattedName()));
        ranklist.addAll(TownyFormatter.getRanks(town, translator));
        return ranklist;
    }

    public static List<String> getRanksForNation(Nation nation, Translator translator) {
        ArrayList<String> ranklist = new ArrayList<String>();
        ranklist.add(ChatTools.formatTitle(translator.of("rank_list_title", nation.getFormattedName())));
        ranklist.add(TownyFormatter.colourKeyValue(translator.of("status_nation_king"), nation.getKing().getFormattedName()));
        ranklist.addAll(TownyFormatter.getRanks(nation, translator));
        return ranklist;
    }

    public static String getTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("hh:mm aa");
        return sdf.format(System.currentTimeMillis());
    }

    private static String formatWebUrl(SpawnLocation spawnLocation) {
        String webUrl = "";
        if (TownySettings.isUsingWebMapStatusScreens() && spawnLocation.hasSpawn() && !TownySettings.getWebMapUrl().isEmpty()) {
            webUrl = TownySettings.getWebMapUrl().replaceAll("\\{world}", TownyFormatter.getWorldSlugForMapURL(spawnLocation.getSpawnOrNull().getWorld())).replaceAll("\\{x}", "" + spawnLocation.getSpawnOrNull().getBlockX()).replaceAll("\\{y}", "" + (TownySettings.getWebMapUrl().contains("\\{z}") ? spawnLocation.getSpawnOrNull().getBlockY() : spawnLocation.getSpawnOrNull().getBlockZ())).replaceAll("\\{z}", "" + spawnLocation.getSpawnOrNull().getBlockZ());
        }
        return webUrl;
    }

    private static String getWorldSlugForMapURL(World world) {
        return TownySettings.isUsingWorldKeyForWorldName() ? world.getKey().toString() : world.getName();
    }
}

