/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.economy.Account;
import java.io.File;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.CompositeFilter;
import org.apache.logging.log4j.core.filter.LevelMatchFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;

public final class TownyLogger {
    private static final Logger LOGGER_MONEY = LogManager.getLogger((String)"Towny-Money");
    private static Appender townyDebugAppender;

    private TownyLogger() {
    }

    public static void initialize() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        String logFolderName = TownyUniverse.getInstance().getRootFolder() + File.separator + "logs";
        FileAppender townyMainAppender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(logFolderName + File.separator + "towny.log").setName("Towny-Main-Log")).withAppend(TownySettings.isAppendingToLog()).setIgnoreExceptions(false)).withBufferedIo(false)).withBufferSize(0)).withLocking(false).setConfiguration(config)).setLayout((Layout)PatternLayout.newBuilder().withCharset(StandardCharsets.UTF_8).withPattern("%d{dd MMM yyyy HH:mm:ss} [%t]: %m%n").withConfiguration(config).build())).build();
        FileAppender townyMoneyAppender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(logFolderName + File.separator + "money.csv").setName("Towny-Money")).withAppend(TownySettings.isAppendingToLog()).setIgnoreExceptions(false)).withBufferedIo(false)).withBufferSize(0)).withLocking(false).setConfiguration(config)).setLayout((Layout)PatternLayout.newBuilder().withCharset(StandardCharsets.UTF_8).withPattern("%d{dd MMM yyyy HH:mm:ss},%m%n").withConfiguration(config).build())).build();
        townyDebugAppender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(logFolderName + File.separator + "debug.log").setName("Towny-Debug")).withAppend(TownySettings.isAppendingToLog()).setIgnoreExceptions(false)).withBufferedIo(false)).withBufferSize(0)).withLocking(false).setConfiguration(config)).setLayout((Layout)PatternLayout.newBuilder().withCharset(StandardCharsets.UTF_8).withPattern("%d{dd MMM yyyy HH:mm:ss} [%t]: %m%n").withConfiguration(config).build())).build();
        townyMainAppender.start();
        townyDebugAppender.start();
        townyMoneyAppender.start();
        LoggerConfig townyMainConfig = LoggerConfig.createLogger((boolean)true, (Level)Level.ALL, (String)"Towny", null, (AppenderRef[])new AppenderRef[0], null, (Configuration)config, null);
        townyMainConfig.addAppender((Appender)townyMainAppender, Level.INFO, null);
        config.addLogger("Towny", townyMainConfig);
        LoggerConfig townyMoneyConfig = LoggerConfig.createLogger((boolean)false, (Level)Level.ALL, (String)"Towny-Money", null, (AppenderRef[])new AppenderRef[0], null, (Configuration)config, null);
        townyMoneyConfig.addAppender((Appender)townyMoneyAppender, Level.ALL, null);
        config.addLogger("Towny-Money", townyMoneyConfig);
        ctx.updateLoggers();
        TownyLogger.refreshDebugLogger();
    }

    public static void refreshDebugLogger() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        LoggerConfig loggerConfig = ctx.getConfiguration().getLoggerConfig("Towny");
        Appender console = ctx.getConfiguration().getAppender("TerminalConsole");
        if (TownySettings.getDebug()) {
            loggerConfig.removeAppender("Towny-Debug");
            loggerConfig.removeAppender("TerminalConsole");
            loggerConfig.addAppender(townyDebugAppender, Level.DEBUG, null);
            loggerConfig.addAppender(console, Level.DEBUG, (Filter)CompositeFilter.createFilters((Filter[])new Filter[]{((LevelMatchFilter.Builder)((LevelMatchFilter.Builder)LevelMatchFilter.newBuilder().setLevel(Level.DEBUG).setOnMatch(Filter.Result.ACCEPT)).setOnMismatch(Filter.Result.DENY)).build(), ((LevelMatchFilter.Builder)((LevelMatchFilter.Builder)LevelMatchFilter.newBuilder().setLevel(Level.TRACE).setOnMatch(Filter.Result.ACCEPT)).setOnMismatch(Filter.Result.DENY)).build()}));
        } else {
            loggerConfig.removeAppender("Towny-Debug");
            loggerConfig.removeAppender("TerminalConsole");
        }
        ctx.updateLoggers();
    }

    public static void logMoneyTransaction(Account a, double amount, Account b, String reason) {
        String sender = a == null ? "None" : a.getName();
        String receiver = b == null ? "None" : b.getName();
        if (reason == null) {
            LOGGER_MONEY.info(String.format("%s,%s,%s,%s", "Unknown Reason", sender, amount, receiver));
        } else {
            LOGGER_MONEY.info(String.format("%s,%s,%s,%s", reason, sender, amount, receiver));
        }
    }

    public static void logMoneyTransaction(String a, double amount, String b, String reason) {
        if (reason == null) {
            LOGGER_MONEY.info(String.format("%s,%s,%s,%s", "Unknown Reason", a, amount, b));
        } else {
            LOGGER_MONEY.info(String.format("%s,%s,%s,%s", reason, a, amount, b));
        }
    }
}

