/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteSender;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.Translator;
import com.palmergames.bukkit.towny.object.comparators.ComparatorType;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.object.statusscreens.StatusScreen;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.utils.TownyComponents;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.Pair;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class TownyMessaging {
    private static final Logger LOGGER = LogManager.getLogger((String)"Towny");

    public static void sendErrorMsg(String msg) {
        LOGGER.warn(Colors.strip("Error: " + msg));
    }

    public static void sendErrorMsg(Object sender, String msg) {
        if (sender == null || msg == null || msg.isEmpty()) {
            return;
        }
        if (sender instanceof CommandSender) {
            CommandSender toSend = (CommandSender)sender;
            TownyMessaging.sendMessage((Object)toSend, Translatable.of("default_towny_prefix").stripColors(sender instanceof ConsoleCommandSender).append("\u00a74" + msg).forLocale(toSend));
        } else if (sender instanceof TownyObject) {
            TownyObject townySender = (TownyObject)sender;
            if (townySender instanceof Resident) {
                Resident resident = (Resident)townySender;
                TownyMessaging.sendMessage((Object)resident, Translation.of("default_towny_prefix") + "\u00a74" + msg);
            } else if (townySender instanceof Town) {
                Town town = (Town)townySender;
                TownyMessaging.sendPrefixedTownMessage(town, "\u00a74" + msg);
            } else if (townySender instanceof Nation) {
                Nation nation = (Nation)townySender;
                TownyMessaging.sendPrefixedNationMessage(nation, "\u00a74" + msg);
            }
        } else {
            TownyMessaging.sendErrorMsg(String.format("Unsupported TownyMessaging#sendErrorMsg sender class type: %s", sender.getClass().getName()));
        }
        TownyMessaging.sendDevMsg(msg);
    }

    public static void sendMsg(String msg) {
        LOGGER.info(Colors.strip(msg));
    }

    public static void sendMsg(CommandSender sender, String msg) {
        if (sender == null || msg == null || msg.isEmpty()) {
            return;
        }
        if (sender instanceof Player) {
            Player p = (Player)sender;
            TownyMessaging.sendMessage((Object)p, Translatable.of("default_towny_prefix").forLocale((CommandSender)p) + "\u00a7a" + msg);
        } else if (sender instanceof ConsoleCommandSender) {
            TownyMessaging.sendMessage((Object)sender, Translatable.of("default_towny_prefix").stripColors(true).defaultLocale() + Colors.strip(msg));
        } else {
            TownyMessaging.sendMessage((Object)sender, Translatable.of("default_towny_prefix").forLocale(sender) + "\u00a7a" + msg);
        }
        TownyMessaging.sendDevMsg(msg);
    }

    public static void sendDevMsg(String msg) {
        Player townyDev;
        if (TownySettings.isDevMode() && (townyDev = BukkitTools.getPlayerExact(TownySettings.getDevName())) != null) {
            TownyMessaging.sendMessage((Object)townyDev, Translatable.of("default_towny_prefix").forLocale((CommandSender)townyDev) + " DevMode: \u00a74" + msg);
        }
    }

    public static void sendDevMsg(String[] msg) {
        for (String line : msg) {
            TownyMessaging.sendDevMsg(line);
        }
    }

    public static void sendDebugMsg(String msg) {
        if (TownySettings.getDebug()) {
            LOGGER.debug(Colors.strip(msg));
        }
        TownyMessaging.sendDevMsg(msg);
    }

    public static void sendMessage(Object sender, String line) {
        if (line.isEmpty()) {
            return;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            player.sendMessage(TownyComponents.miniMessage(line));
        } else if (sender instanceof CommandSender) {
            CommandSender commandSender = (CommandSender)sender;
            commandSender.sendPlainMessage(Colors.strip(line));
        } else if (sender instanceof Resident) {
            Resident resident = (Resident)sender;
            resident.sendMessage(TownyComponents.miniMessage(line));
        }
    }

    public static void sendMessage(Object sender, List<String> lines) {
        TownyMessaging.sendMessage(sender, lines.toArray(new String[0]));
    }

    public static void sendMessage(Object sender, String[] lines) {
        for (String line : lines) {
            TownyMessaging.sendMessage(sender, line);
        }
    }

    public static void sendGlobalMessage(String line) {
        LOGGER.info(Colors.strip("[Global Message] " + line));
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || !TownyAPI.getInstance().isTownyWorld(player.getWorld())) continue;
            TownyMessaging.sendMessage((Object)player, Translation.of("default_towny_prefix") + line);
        }
    }

    public static void sendPlainGlobalMessage(String line) {
        LOGGER.info(Colors.strip("[Global Message] " + line));
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || !TownyAPI.getInstance().isTownyWorld(player.getWorld())) continue;
            TownyMessaging.sendMessage((Object)player, line);
        }
    }

    public static void sendPrefixedTownMessage(Town town, String line) {
        LOGGER.info(Colors.strip("[Town Msg] " + StringMgmt.remUnderscore(town.getName()) + ": " + line));
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(town)) {
            TownyMessaging.sendMessage((Object)player, Translation.of("default_town_prefix", StringMgmt.remUnderscore(town.getName())) + line);
        }
    }

    public static void sendPrefixedNationMessage(Nation nation, String line) {
        LOGGER.info(Colors.strip("[Nation Msg] " + StringMgmt.remUnderscore(nation.getName()) + ": " + line));
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(nation)) {
            TownyMessaging.sendMessage((Object)player, Translation.of("default_nation_prefix", StringMgmt.remUnderscore(nation.getName())) + line);
        }
    }

    public static void sendTownBoard(CommandSender sender, Town town) {
        String tbColor1 = Translation.of("townboard_message_colour_1");
        String tbColor2 = Translation.of("townboard_message_colour_2");
        TownyMessaging.sendMessage((Object)sender, tbColor1 + "[" + StringMgmt.remUnderscore(town.getName()) + "] " + tbColor2 + town.getBoard());
    }

    public static void sendNationBoard(CommandSender sender, Nation nation) {
        String nbColor1 = Translation.of("nationboard_message_colour_1");
        String nbColor2 = Translation.of("nationboard_message_colour_2");
        TownyMessaging.sendMessage((Object)sender, nbColor1 + "[" + StringMgmt.remUnderscore(nation.getName()) + "] " + nbColor2 + nation.getBoard());
    }

    public static void sendTitleMessageToResident(Resident resident, String title, String subtitle, int duration) {
        Player player = resident.getPlayer();
        if (player == null) {
            return;
        }
        TownyMessaging.sendTitle(player, title, subtitle, duration);
    }

    public static void sendTitleMessageToResident(Resident resident, String title, String subtitle) {
        TownyMessaging.sendTitleMessageToResident(resident, title, subtitle, 70);
    }

    public static void sendTitleMessageToTown(Town town, String title, String subtitle, int duration) {
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(town)) {
            TownyMessaging.sendTitle(player, title, subtitle, duration);
        }
    }

    public static void sendTitleMessageToTown(Town town, String title, String subtitle) {
        TownyMessaging.sendTitleMessageToTown(town, title, subtitle, 70);
    }

    public static void sendTitleMessageToNation(Nation nation, String title, String subtitle, int duration) {
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(nation)) {
            TownyMessaging.sendTitle(player, title, subtitle, duration);
        }
    }

    public static void sendTitleMessageToNation(Nation nation, String title, String subtitle) {
        TownyMessaging.sendTitleMessageToNation(nation, title, subtitle, 70);
    }

    public static void sendTitle(Player player, String title, String subtitle, int duration) {
        player.sendTitle(title.isEmpty() ? " " : title, subtitle.isEmpty() ? " " : subtitle, 10, duration, 10);
    }

    public static void sendTitle(Player player, String title, String subtitle) {
        TownyMessaging.sendTitle(player, title, subtitle, 70);
    }

    public static void sendRequestMessage(CommandSender player, Invite invite) {
        Translator translator = Translator.locale(player);
        String senderName = invite.getSender().getName();
        InviteSender inviteSender = invite.getSender();
        if (inviteSender instanceof Town) {
            Town town = (Town)inviteSender;
            String firstline = town.hasNation() ? translator.of("invitation_prefix") + translator.of("you_have_been_invited_to_join3", Colors.colorTown(senderName), Colors.colorNation(town.getNationOrNull())) : translator.of("invitation_prefix") + translator.of("you_have_been_invited_to_join2", Colors.colorTown(senderName));
            String confirmline = TownySettings.getAcceptCommand() + " " + senderName;
            String cancelline = TownySettings.getDenyCommand() + " " + senderName;
            TownyMessaging.sendInvitationMessage(player, firstline, confirmline, cancelline);
        }
        if (invite.getSender() instanceof Nation) {
            String cancelline;
            String confirmline;
            String firstline;
            if (invite.getReceiver() instanceof Town) {
                firstline = translator.of("invitation_prefix") + translator.of("your_town_has_been_invited_to_join_nation", Colors.colorNation(senderName));
                confirmline = "t invite accept " + senderName;
                cancelline = "t invite deny " + senderName;
                TownyMessaging.sendInvitationMessage(player, firstline, confirmline, cancelline);
            }
            if (invite.getReceiver() instanceof Nation) {
                firstline = translator.of("invitation_prefix") + translator.of("you_have_been_requested_to_ally2", Colors.colorNation(senderName));
                confirmline = "n ally accept " + senderName;
                cancelline = "n ally deny " + senderName;
                TownyMessaging.sendInvitationMessage(player, firstline, confirmline, cancelline);
            }
        }
    }

    public static void sendInvitationMessage(CommandSender player, String firstline, String confirmline, String cancelline) {
        Translator translator = Translator.locale(player);
        NamedTextColor acceptColour = Colors.toNamedTextColor(TownySettings.getConfirmationCommandYesColour()) != null ? Colors.toNamedTextColor(TownySettings.getConfirmationCommandYesColour()) : NamedTextColor.GREEN;
        NamedTextColor denyColour = Colors.toNamedTextColor(TownySettings.getConfirmationCommandNoColour()) != null ? Colors.toNamedTextColor(TownySettings.getConfirmationCommandNoColour()) : NamedTextColor.RED;
        TextComponent confirmComponent = (TextComponent)((TextComponent)((TextComponent)Component.text((String)String.format(TownySettings.getConfirmationCommandFormat(), confirmline)).color((TextColor)acceptColour)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)translator.component("msg_confirmation_spigot_click_accept", confirmline, "/" + confirmline)))).clickEvent(ClickEvent.runCommand((String)("/towny:" + confirmline)));
        TextComponent cancelComponent = (TextComponent)((TextComponent)((TextComponent)Component.text((String)String.format(TownySettings.getConfirmationCommandFormat(), cancelline)).color((TextColor)denyColour)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)translator.component("msg_confirmation_spigot_click_cancel", cancelline, "/" + cancelline)))).clickEvent(ClickEvent.runCommand((String)("/towny:" + cancelline)));
        player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)firstline).append((Component)Component.newline())).append((Component)confirmComponent)).append((Component)Component.space())).append((Component)cancelComponent));
    }

    public static void sendConfirmationMessage(CommandSender sender, Confirmation confirmation) {
        Translator translator = Translator.locale(sender);
        Component firstLineComponent = translator.component("confirmation_prefix").append(confirmation.getTitle().locale(sender).component());
        Component lastLineComponent = translator.component("this_message_will_expire2", confirmation.getDuration());
        NamedTextColor acceptColour = Colors.toNamedTextColor(TownySettings.getConfirmationCommandYesColour()) != null ? Colors.toNamedTextColor(TownySettings.getConfirmationCommandYesColour()) : NamedTextColor.GREEN;
        NamedTextColor denyColour = Colors.toNamedTextColor(TownySettings.getConfirmationCommandNoColour()) != null ? Colors.toNamedTextColor(TownySettings.getConfirmationCommandNoColour()) : NamedTextColor.RED;
        Component confirmComponent = ((TextComponent)Component.text((String)String.format(TownySettings.getConfirmationCommandFormat(), confirmation.getConfirmCommand()), (TextColor)acceptColour).hoverEvent((HoverEventSource)HoverEvent.showText((Component)translator.component("msg_confirmation_spigot_click_accept", confirmation.getConfirmCommand(), "/" + confirmation.getConfirmCommand())))).clickEvent(ClickEvent.runCommand((String)("/" + confirmation.getPluginPrefix() + ":" + confirmation.getConfirmCommand())));
        Component cancelComponent = ((TextComponent)Component.text((String)String.format(TownySettings.getConfirmationCommandFormat(), confirmation.getCancelCommand()), (TextColor)denyColour).hoverEvent((HoverEventSource)HoverEvent.showText((Component)translator.component("msg_confirmation_spigot_click_cancel", confirmation.getCancelCommand(), "/" + confirmation.getCancelCommand())))).clickEvent(ClickEvent.runCommand((String)("/" + confirmation.getPluginPrefix() + ":" + confirmation.getCancelCommand())));
        sender.sendMessage(firstLineComponent.append((Component)Component.newline()).append(confirmComponent).append((Component)Component.space()).append(cancelComponent).append((Component)Component.newline()).append(lastLineComponent));
    }

    public static void sendTownList(CommandSender sender, List<Pair<UUID, Component>> towns, ComparatorType compType, int page, int total) {
        Translator translator = Translator.locale(sender);
        int iMax = Math.min(page * 10, towns.size());
        Component[] townsformatted = page * 10 > towns.size() ? new Component[towns.size() % 10] : new Component[10];
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            townsformatted[i % 10] = towns.get(i).value();
        }
        CommandSender audience = sender;
        TownyMessaging.sendMessage((Object)sender, ChatTools.formatTitle(translator.of("town_plu")));
        TownyMessaging.sendMessage((Object)sender, "\u00a73" + translator.of("town_name") + (String)(TownySettings.isTownListRandom() ? "" : "\u00a78 - \u00a7b" + translator.of(compType.getName())));
        for (Component textComponent : townsformatted) {
            audience.sendMessage(textComponent);
        }
        Component pageFooter = TownyMessaging.getPageNavigationFooter("towny:town list", page, compType.getCommandString(), total, translator);
        audience.sendMessage(pageFooter);
    }

    public static Component getPageNavigationFooter(String prefix, int page, String arg, int total, Translator translator) {
        Component backButton = ((TextComponent)Component.text((String)"<<<", (TextColor)NamedTextColor.GOLD).clickEvent(ClickEvent.runCommand((String)("/" + prefix + " " + (String)(arg.isEmpty() ? "" : arg + " ") + (page - 1))))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)translator.component("msg_hover_previous_page")));
        Component forwardButton = ((TextComponent)Component.text((String)">>>", (TextColor)NamedTextColor.GOLD).clickEvent(ClickEvent.runCommand((String)("/" + prefix + " " + (String)(arg.isEmpty() ? "" : arg + " ") + (page + 1))))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)translator.component("msg_hover_next_page")));
        Component pageText = ((TextComponent)Component.text((String)"   ").append(translator.component("list_page", page, total))).append((Component)Component.text((String)"   "));
        if (page == 1 && page == total) {
            backButton = backButton.clickEvent(null).hoverEvent(null).color((TextColor)NamedTextColor.DARK_GRAY);
            forwardButton = forwardButton.clickEvent(null).hoverEvent(null).color((TextColor)NamedTextColor.DARK_GRAY);
        } else if (page == 1) {
            backButton = backButton.clickEvent(null).hoverEvent(null).color((TextColor)NamedTextColor.DARK_GRAY);
        } else if (page == total) {
            forwardButton = forwardButton.clickEvent(null).hoverEvent(null).color((TextColor)NamedTextColor.DARK_GRAY);
        }
        return backButton.append(pageText).append(forwardButton);
    }

    public static void sendNationList(CommandSender sender, List<Pair<UUID, Component>> nations, ComparatorType compType, int page, int total) {
        Translator translator = Translator.locale(sender);
        int iMax = Math.min(page * 10, nations.size());
        Component[] nationsformatted = page * 10 > nations.size() ? new Component[nations.size() % 10] : new Component[10];
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            nationsformatted[i % 10] = nations.get(i).value();
        }
        TownyMessaging.sendMessage((Object)sender, ChatTools.formatTitle(translator.of("nation_plu")));
        TownyMessaging.sendMessage((Object)sender, "\u00a73" + translator.of("nation_name") + "\u00a78 - \u00a7b" + translator.of(compType.getName()));
        CommandSender audience = sender;
        for (Component textComponent : nationsformatted) {
            audience.sendMessage(textComponent);
        }
        Component pageFooter = TownyMessaging.getPageNavigationFooter("towny:nation list", page, compType.getCommandString(), total, translator);
        audience.sendMessage(pageFooter);
    }

    public static void sendOutpostList(Player player, Town town, int page, int total) {
        Translator translator = Translator.locale((CommandSender)player);
        int outpostsCount = town.getAllOutpostSpawns().size();
        int iMax = Math.min(page * 10, outpostsCount);
        List<Location> outposts = town.getAllOutpostSpawns();
        TextComponent[] outpostsFormatted = page * 10 > outpostsCount ? new TextComponent[outpostsCount % 10] : new TextComponent[10];
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            Location outpost = outposts.get(i);
            TownBlock tb = TownyAPI.getInstance().getTownBlock(outpost);
            if (tb == null) continue;
            String name = !tb.hasPlotObjectGroup() ? tb.getName() : tb.getPlotObjectGroup().getName();
            TextComponent dash = Component.text((String)" - ", (TextColor)NamedTextColor.DARK_GRAY);
            TextComponent line = (TextComponent)((TextComponent)Component.text((String)Integer.toString(i + 1), (TextColor)NamedTextColor.GOLD).clickEvent(ClickEvent.runCommand((String)("/towny:town outpost " + (i + 1))))).append((Component)dash);
            TextComponent outpostName = Component.text((String)name, (TextColor)NamedTextColor.GREEN);
            TextComponent worldName = Component.text((String)Optional.ofNullable(outpost.getWorld()).map(w -> w.getName()).orElse("null"), (TextColor)NamedTextColor.BLUE);
            TextComponent coords = Component.text((String)("(" + outpost.getBlockX() + "," + outpost.getBlockZ() + ")"), (TextColor)NamedTextColor.BLUE);
            if (!name.equalsIgnoreCase("")) {
                line = (TextComponent)((TextComponent)line.append((Component)outpostName)).append((Component)dash);
            }
            line = (TextComponent)((TextComponent)((TextComponent)line.append((Component)worldName)).append((Component)dash)).append((Component)coords);
            Translatable spawnCost = Translatable.of("msg_spawn_cost_free");
            if (TownyEconomyHandler.isActive()) {
                spawnCost = Translatable.of("msg_spawn_cost", TownyEconomyHandler.getFormattedBalance(town.getSpawnCost()));
            }
            outpostsFormatted[i % 10] = line = (TextComponent)line.hoverEvent((HoverEventSource)HoverEvent.showText((Component)Translatable.of("msg_click_spawn", name.equalsIgnoreCase("") ? "outpost" : name).append("\n").append(spawnCost).locale((CommandSender)player).component()));
        }
        TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(translator.of("outpost_plu")));
        for (TextComponent textComponent : outpostsFormatted) {
            player.sendMessage((Component)textComponent);
        }
        Component pageFooter = TownyMessaging.getPageNavigationFooter("towny:town outpost list", page, "", total, translator);
        player.sendMessage(pageFooter);
    }

    public static /* bridge */ /* synthetic */ void sendJailList(Player player, Town town, int page, int total) {
        TownyMessaging.sendJailList((CommandSender)player, town, page, total);
    }

    public static void sendJailList(CommandSender sender, Town town, int page, int total) {
        Translator translator = Translator.locale(sender);
        ArrayList jails = town.getJails() == null ? new ArrayList() : new ArrayList<Jail>(town.getJails());
        int jailCount = jails.size();
        int iMax = Math.min(page * 10, jailCount);
        TextComponent[] jailsFormatted = page * 10 > jailCount ? new TextComponent[jailCount % 10] : new TextComponent[10];
        String headerMsg = String.valueOf(ChatColor.GOLD) + "# " + String.valueOf(ChatColor.DARK_GRAY) + "- " + String.valueOf(ChatColor.GREEN) + "Jail Name " + String.valueOf(ChatColor.DARK_GRAY) + "- " + String.valueOf(ChatColor.BLUE) + "Coord " + String.valueOf(ChatColor.DARK_GRAY) + "- " + String.valueOf(ChatColor.YELLOW) + "Cell Count " + String.valueOf(ChatColor.DARK_GRAY) + "- " + String.valueOf(ChatColor.RED) + "Primary Jail";
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            TextComponent[] jail = (TextComponent[])jails.get(i);
            TextComponent name = Component.text((String)jail.getName(), (TextColor)NamedTextColor.GREEN);
            TextComponent coord = Component.text((String)jail.getTownBlock().getWorldCoord().toString(), (TextColor)NamedTextColor.BLUE);
            TextComponent cellCount = Component.text((int)jail.getJailCellCount(), (TextColor)NamedTextColor.YELLOW);
            TextComponent dash = Component.text((String)" - ", (TextColor)NamedTextColor.DARK_GRAY);
            TextComponent line = Component.text((String)Integer.toString(i + 1), (TextColor)NamedTextColor.GOLD);
            if (jail.hasName()) {
                line = (TextComponent)((TextComponent)line.append((Component)dash)).append((Component)name);
            }
            line = (TextComponent)((TextComponent)((TextComponent)((TextComponent)line.append((Component)dash)).append((Component)coord)).append((Component)dash)).append((Component)cellCount);
            Jail primaryJail = town.getPrimaryJail();
            if (primaryJail != null && primaryJail.getUUID().equals(jail.getUUID())) {
                line = (TextComponent)((TextComponent)line.append((Component)dash)).append((Component)Component.text((String)"(Primary Jail)", (TextColor)NamedTextColor.RED));
            }
            jailsFormatted[i % 10] = line;
        }
        CommandSender audience = sender;
        TownyMessaging.sendMessage((Object)sender, ChatTools.formatTitle(Translatable.of("jail_plu").forLocale(sender)));
        TownyMessaging.sendMessage((Object)sender, headerMsg);
        for (TextComponent textComponent : jailsFormatted) {
            audience.sendMessage((Component)textComponent);
        }
        Component pageFooter = TownyMessaging.getPageNavigationFooter("towny:town jail list", page, "", total, translator);
        audience.sendMessage(pageFooter);
    }

    public static void sendPlotGroupList(CommandSender sender, Town town, int page, int total) {
        Translator translator = Translator.locale(sender);
        int groupCount = town.getPlotGroups().size();
        int iMax = Math.min(page * 10, groupCount);
        ArrayList<PlotGroup> groups = new ArrayList<PlotGroup>(town.getPlotGroups());
        TextComponent[] groupsFormatted = page * 10 > groupCount ? new TextComponent[groupCount % 10] : new TextComponent[10];
        String headerMsg = String.valueOf(ChatColor.GOLD) + "# " + String.valueOf(ChatColor.DARK_GRAY) + "- " + String.valueOf(ChatColor.GREEN) + "Group Name " + String.valueOf(ChatColor.DARK_GRAY) + "- " + String.valueOf(ChatColor.YELLOW) + "Plot Size " + String.valueOf(ChatColor.DARK_GRAY) + "- " + String.valueOf(ChatColor.BLUE) + "For Sale";
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            TextComponent[] group = (TextComponent[])groups.get(i);
            TextComponent name = Component.text((String)group.getFormattedName(), (TextColor)NamedTextColor.GREEN);
            TextComponent size = Component.text((String)String.valueOf(group.getTownBlocks().size()), (TextColor)NamedTextColor.YELLOW);
            TextComponent dash = Component.text((String)" - ", (TextColor)NamedTextColor.DARK_GRAY);
            TextComponent line = Component.text((String)Integer.toString(i + 1), (TextColor)NamedTextColor.GOLD);
            line = (TextComponent)((TextComponent)((TextComponent)((TextComponent)line.append((Component)dash)).append((Component)name)).append((Component)dash)).append((Component)size);
            if (TownyEconomyHandler.isActive() && group.getPrice() != -1.0) {
                line = (TextComponent)((TextComponent)line.append((Component)dash)).append(((TextComponent)Component.text((String)"(", (TextColor)NamedTextColor.BLUE).append(translator.component("towny_map_forsale"))).append((Component)Component.text((String)(": " + TownyEconomyHandler.getFormattedBalance(group.getPrice()) + ")"), (TextColor)NamedTextColor.BLUE)));
            }
            groupsFormatted[i % 10] = line;
        }
        CommandSender audience = sender;
        TownyMessaging.sendMessage((Object)sender, ChatTools.formatTitle(town.getName() + " " + translator.of("plotgroup_plu")));
        TownyMessaging.sendMessage((Object)sender, headerMsg);
        for (TextComponent textComponent : groupsFormatted) {
            audience.sendMessage((Component)textComponent);
        }
        Component pageFooter = TownyMessaging.getPageNavigationFooter("towny:town plotgrouplist " + town.getName(), page, "", total, translator);
        audience.sendMessage(pageFooter);
    }

    public static void sendPlotList(CommandSender sender, Resident resident, int page, int totalPages) {
        Translator translator = Translator.locale(sender);
        boolean hasTPPermission = TownyUniverse.getInstance().getPermissionSource().testPermission((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TPPLOT.getNode());
        int plotCount = resident.getTownBlocks().size();
        int iMax = Math.min(page * 10, plotCount);
        ArrayList<TownBlock> townblocks = new ArrayList<TownBlock>(resident.getTownBlocks());
        Component[] plotsFormatted = page * 10 > plotCount ? new Component[plotCount % 10] : new Component[10];
        String headerMsg = String.valueOf(ChatColor.GOLD) + "# " + String.valueOf(ChatColor.DARK_GRAY) + "-    " + String.valueOf(ChatColor.GREEN) + "Coord " + String.valueOf(ChatColor.DARK_GRAY) + "    -    " + String.valueOf(ChatColor.AQUA) + "Town" + String.valueOf(ChatColor.DARK_GRAY) + "    -    " + String.valueOf(ChatColor.GREEN) + "Type" + String.valueOf(ChatColor.DARK_GRAY) + "    -    " + String.valueOf(ChatColor.YELLOW) + "Name";
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            Component[] tb = (Component[])townblocks.get(i);
            String tbName = tb.getName().isEmpty() ? translator.of("msg_unnamed") : tb.getName();
            TextComponent coord = Component.text((String)tb.getWorldCoord().toString(), (TextColor)NamedTextColor.GREEN);
            TextComponent town = Component.text((String)tb.getTownOrNull().getName(), (TextColor)NamedTextColor.AQUA);
            TextComponent type = Component.text((String)tb.getTypeName(), (TextColor)NamedTextColor.GREEN);
            TextComponent name = Component.text((String)tbName, (TextColor)NamedTextColor.YELLOW);
            TextComponent dash = Component.text((String)" - ", (TextColor)NamedTextColor.DARK_GRAY);
            TextComponent line = Component.text((String)Integer.toString(i + 1), (TextColor)NamedTextColor.GOLD);
            line = line.append((Component)dash).append((Component)coord).append((Component)dash).append((Component)town).append((Component)dash).append((Component)type).append((Component)dash).append((Component)name);
            if (hasTPPermission) {
                line = line.clickEvent(ClickEvent.runCommand((String)("/towny:ta tpplot " + tb.getWorld().getName() + " " + tb.getX() + " " + tb.getZ())));
                line = line.hoverEvent((HoverEventSource)HoverEvent.showText((Component)Translatable.of("msg_click_spawn", tb.getWorldCoord()).locale(sender).component()));
            }
            plotsFormatted[i % 10] = line;
        }
        CommandSender audience = sender;
        TownyMessaging.sendMessage((Object)sender, ChatTools.formatTitle(resident.getName() + " " + translator.of("townblock_plu")));
        TownyMessaging.sendMessage((Object)sender, headerMsg);
        for (Component component : plotsFormatted) {
            audience.sendMessage(component);
        }
        Component pageFooter = TownyMessaging.getPageNavigationFooter("towny:resident plotlist " + resident.getName(), page, "", totalPages, translator);
        audience.sendMessage(pageFooter);
    }

    public static void sendMsg(CommandSender sender, Translatable ... translatables) {
        TownyMessaging.sendMsg(sender, Translation.translateTranslatables(sender, translatables));
    }

    public static void sendMsg(CommandSender sender, Translatable translatable) {
        TownyMessaging.sendMsg(sender, translatable.locale(sender).translate());
    }

    public static void sendMessage(CommandSender sender, Translatable ... translatables) {
        TownyMessaging.sendMessage((Object)sender, Translation.translateTranslatables(sender, translatables));
    }

    public static void sendMessage(CommandSender sender, Translatable translatable) {
        TownyMessaging.sendMessage((Object)sender, translatable.locale(sender).translate());
    }

    public static void sendErrorMsg(CommandSender sender, Translatable ... translatables) {
        TownyMessaging.sendErrorMsg((Object)sender, Translation.translateTranslatables(sender, translatables));
    }

    public static void sendErrorMsg(CommandSender sender, Translatable translatable) {
        TownyMessaging.sendErrorMsg((Object)sender, translatable.locale(sender).translate());
    }

    public static void sendGlobalMessage(Translatable translatable) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player == null || !TownyAPI.getInstance().isTownyWorld(player.getWorld())) continue;
            TownyMessaging.sendMsg((CommandSender)player, translatable);
        }
        LOGGER.info("[Global Message] " + translatable.stripColors(true).translate());
    }

    public static void sendPrefixedNationMessage(Nation nation, Translatable message) {
        LOGGER.info(Colors.strip("[Nation Msg] " + StringMgmt.remUnderscore(nation.getName()) + ": " + message.translate()));
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(nation)) {
            TownyMessaging.sendMessage((CommandSender)player, Translatable.of("default_nation_prefix", StringMgmt.remUnderscore(nation.getName())).append(message));
        }
    }

    public static void sendPrefixedTownMessage(Town town, Translatable message) {
        LOGGER.info(Colors.strip("[Town Msg] " + StringMgmt.remUnderscore(town.getName()) + ": " + message.translate()));
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(town)) {
            TownyMessaging.sendMessage((CommandSender)player, Translatable.of("default_town_prefix", StringMgmt.remUnderscore(town.getName())).append(message));
        }
    }

    public static void sendPrefixedTownMessage(Resident resident, Translatable message) {
        Town town = resident.getTownOrNull();
        if (town == null) {
            TownyMessaging.sendMsg(resident, message);
        } else {
            TownyMessaging.sendPrefixedTownMessage(town, message);
        }
    }

    public static void sendNationMessagePrefixed(Nation nation, Translatable message) {
        LOGGER.info(Colors.strip("[Nation Msg] " + StringMgmt.remUnderscore(nation.getName()) + ": " + message.translate()));
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(nation)) {
            TownyMessaging.sendMsg((CommandSender)player, message);
        }
    }

    public static void sendTownMessagePrefixed(Town town, Translatable message) {
        LOGGER.info(Colors.strip("[Town Msg] " + StringMgmt.remUnderscore(town.getName())) + ": " + message.translate());
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(town)) {
            TownyMessaging.sendMsg((CommandSender)player, message);
        }
    }

    public static void sendMsg(Resident resident, Translatable message) {
        if (resident.isOnline()) {
            TownyMessaging.sendMsg((CommandSender)resident.getPlayer(), message);
        }
    }

    public static void sendMsg(Translatable message) {
        LOGGER.info(message.stripColors(true).translate());
    }

    public static void sendErrorMsg(Translatable message) {
        LOGGER.warn("Error: " + message.stripColors(true).translate());
    }

    public static void sendMsgToOnlineAdmins(Translatable message) {
        TownyMessaging.sendMsg(message);
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!TownyUniverse.getInstance().getPermissionSource().isTownyAdmin((Permissible)player)) continue;
            TownyMessaging.sendMsg((CommandSender)player, message);
        }
    }

    public static void sendStatusScreen(CommandSender sender, StatusScreen screen) {
        sender.sendMessage(screen.getFormattedStatusScreen());
    }

    public static void sendActionBarMessageToPlayer(Player player, String message) {
        TownyMessaging.sendActionBarMessageToPlayer(player, TownyComponents.miniMessage(message));
    }

    public static void sendActionBarMessageToPlayer(Player player, Component component) {
        player.sendActionBar(component);
    }

    public static void sendBossBarMessageToPlayer(Player player, String message, float progress, BossBar.Color color, BossBar.Overlay overlay) {
        TownyMessaging.sendBossBarMessageToPlayer(player, TownyComponents.miniMessage(message), progress, color, overlay);
    }

    public static void sendBossBarMessageToPlayer(Player player, Component component, float progress, BossBar.Color color, BossBar.Overlay overlay) {
        player.showBossBar(BossBar.bossBar((Component)component, (float)progress, (BossBar.Color)color, (BossBar.Overlay)overlay));
    }

    public static void sendBossBarMessageToPlayer(Player player, BossBar bossBar) {
        player.showBossBar(bossBar);
    }
}

