/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.scheduling.ScheduledTask;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.tasks.DrawSmokeTask;
import com.palmergames.bukkit.towny.tasks.DrawSpawnPointsTask;
import com.palmergames.bukkit.towny.tasks.HealthRegenTimerTask;
import com.palmergames.bukkit.towny.tasks.HourlyTimerTask;
import com.palmergames.bukkit.towny.tasks.MobRemovalTimerTask;
import com.palmergames.bukkit.towny.tasks.NewDayScheduler;
import com.palmergames.bukkit.towny.tasks.RepeatingTimerTask;
import com.palmergames.bukkit.towny.tasks.ShortTimerTask;
import com.palmergames.bukkit.towny.tasks.TeleportWarmupTimerTask;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.TimeTools;

public class TownyTimerHandler {
    private static Towny plugin;
    private static ScheduledTask townyRepeatingTask;
    private static ScheduledTask hourlyTask;
    private static ScheduledTask shortTask;
    private static ScheduledTask mobRemoveTask;
    private static ScheduledTask healthRegenTask;
    private static ScheduledTask teleportWarmupTask;
    private static ScheduledTask cooldownTimerTask;
    private static ScheduledTask drawSmokeTask;
    private static ScheduledTask drawSpawnPointsTask;

    public static void initialize(Towny plugin) {
        TownyTimerHandler.plugin = plugin;
    }

    public static void newHour() {
        if (!TownyTimerHandler.isHourlyTimerRunning()) {
            TownyTimerHandler.toggleHourlyTimer(true);
        }
        plugin.getScheduler().run(new HourlyTimerTask(plugin));
    }

    public static void toggleTownyRepeatingTimer(boolean on) {
        if (on && !TownyTimerHandler.isTownyRepeatingTaskRunning()) {
            townyRepeatingTask = plugin.getScheduler().runRepeating(new RepeatingTimerTask(plugin), 1L, TimeTools.convertToTicks(1L));
        } else if (!on && TownyTimerHandler.isTownyRepeatingTaskRunning()) {
            townyRepeatingTask.cancel();
            townyRepeatingTask = null;
        }
    }

    public static void toggleMobRemoval(boolean on) {
        if (on && !TownyTimerHandler.isMobRemovalRunning() && !plugin.isFolia()) {
            mobRemoveTask = plugin.getScheduler().runRepeating(new MobRemovalTimerTask(plugin), 1L, TimeTools.convertToTicks(TownySettings.getMobRemovalSpeed()));
        } else if (!on && TownyTimerHandler.isMobRemovalRunning()) {
            mobRemoveTask.cancel();
            mobRemoveTask = null;
        }
    }

    public static void toggleDailyTimer(boolean on) {
        if (on && !NewDayScheduler.isNewDaySchedulerRunning()) {
            plugin.getScheduler().runAsync(new NewDayScheduler(plugin));
        } else if (!on && NewDayScheduler.isNewDaySchedulerRunning()) {
            NewDayScheduler.cancelScheduledNewDay();
        }
    }

    public static void toggleHourlyTimer(boolean on) {
        if (on && !TownyTimerHandler.isHourlyTimerRunning()) {
            hourlyTask = plugin.getScheduler().runAsyncRepeating(new HourlyTimerTask(plugin), TimeTools.convertToTicks(TownyTimerHandler.getTimeUntilNextHourInSeconds()), TimeTools.convertToTicks(TownySettings.getHourInterval()));
        } else if (!on && TownyTimerHandler.isHourlyTimerRunning()) {
            hourlyTask.cancel();
            hourlyTask = null;
        }
    }

    public static void toggleShortTimer(boolean on) {
        if (on && !TownyTimerHandler.isShortTimerRunning()) {
            long delayTicks = TimeTools.convertToTicks(60L);
            shortTask = plugin.getScheduler().runAsyncRepeating(new ShortTimerTask(plugin), delayTicks, TimeTools.convertToTicks(TownySettings.getShortInterval()));
        } else if (!on && TownyTimerHandler.isShortTimerRunning()) {
            shortTask.cancel();
            shortTask = null;
        }
    }

    public static void toggleHealthRegen(boolean on) {
        if (on && !TownyTimerHandler.isHealthRegenRunning()) {
            healthRegenTask = plugin.getScheduler().runAsyncRepeating(new HealthRegenTimerTask(plugin, BukkitTools.getServer()), 1L, TimeTools.convertToTicks(TownySettings.getHealthRegenSpeed()));
        } else if (!on && TownyTimerHandler.isHealthRegenRunning()) {
            healthRegenTask.cancel();
            healthRegenTask = null;
        }
    }

    public static void toggleTeleportWarmup(boolean on) {
        if (on && !TownyTimerHandler.isTeleportWarmupRunning()) {
            teleportWarmupTask = plugin.getScheduler().runRepeating(new TeleportWarmupTimerTask(plugin), 1L, 20L);
        } else if (!on && TownyTimerHandler.isTeleportWarmupRunning()) {
            teleportWarmupTask.cancel();
            teleportWarmupTask = null;
        }
    }

    public static void toggleCooldownTimer(boolean on) {
        if (on && !TownyTimerHandler.isCooldownTimerRunning()) {
            cooldownTimerTask = plugin.getScheduler().runAsyncRepeating(new CooldownTimerTask(plugin), 1L, 20L);
        } else if (!on && TownyTimerHandler.isCooldownTimerRunning()) {
            cooldownTimerTask.cancel();
            cooldownTimerTask = null;
        }
    }

    public static void toggleDrawSmokeTask(boolean on) {
        if (on && !TownyTimerHandler.isDrawSmokeTaskRunning()) {
            drawSmokeTask = plugin.getScheduler().runAsyncRepeating(new DrawSmokeTask(plugin), 1L, 40L);
        } else if (!on && TownyTimerHandler.isDrawSmokeTaskRunning()) {
            drawSmokeTask.cancel();
            drawSmokeTask = null;
        }
    }

    public static void toggleDrawSpointsTask(boolean on) {
        if (on && !TownyTimerHandler.isDrawSpawnPointsTaskRunning()) {
            drawSpawnPointsTask = plugin.getScheduler().runAsyncRepeating(new DrawSpawnPointsTask(plugin), 40L, 48L);
        } else if (!on && TownyTimerHandler.isDrawSpawnPointsTaskRunning()) {
            drawSpawnPointsTask.cancel();
            drawSpawnPointsTask = null;
        }
    }

    public static boolean isTownyRepeatingTaskRunning() {
        return townyRepeatingTask != null && !townyRepeatingTask.isCancelled();
    }

    public static boolean isMobRemovalRunning() {
        return mobRemoveTask != null && !mobRemoveTask.isCancelled();
    }

    public static boolean isHourlyTimerRunning() {
        return hourlyTask != null && !hourlyTask.isCancelled();
    }

    public static boolean isShortTimerRunning() {
        return shortTask != null && !shortTask.isCancelled();
    }

    public static boolean isHealthRegenRunning() {
        return healthRegenTask != null && !healthRegenTask.isCancelled();
    }

    public static boolean isTeleportWarmupRunning() {
        return teleportWarmupTask != null && !teleportWarmupTask.isCancelled();
    }

    public static boolean isCooldownTimerRunning() {
        return cooldownTimerTask != null && !cooldownTimerTask.isCancelled();
    }

    public static boolean isDrawSmokeTaskRunning() {
        return drawSmokeTask != null && !drawSmokeTask.isCancelled();
    }

    public static boolean isDrawSpawnPointsTaskRunning() {
        return drawSpawnPointsTask != null && !drawSpawnPointsTask.isCancelled();
    }

    public static Long getTimeUntilNextHourInSeconds() {
        long timeSinceLastHourMillis = System.currentTimeMillis() % 3600000L;
        long timeSinceLastHourSeconds = timeSinceLastHourMillis / 1000L;
        return 3600L - timeSinceLastHourSeconds;
    }

    static {
        townyRepeatingTask = null;
        hourlyTask = null;
        shortTask = null;
        mobRemoveTask = null;
        healthRegenTask = null;
        teleportWarmupTask = null;
        cooldownTimerTask = null;
        drawSmokeTask = null;
        drawSpawnPointsTask = null;
    }
}

