/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.object.Nameable;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.util.StringMgmt;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class InviteCommand
extends BaseCommand
implements CommandExecutor {
    private static final List<String> inviteTabCompletes = Arrays.asList(TownySettings.getAcceptCommand(), TownySettings.getDenyCommand());
    private final Towny plugin;

    public InviteCommand(Towny instance) {
        this.plugin = instance;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return switch (args.length) {
            case 1 -> NameUtil.filterByStart(inviteTabCompletes, args[0]);
            case 2 -> {
                switch (args[0].toLowerCase(Locale.ROOT)) {
                    case "accept": 
                    case "deny": {
                        if (sender instanceof Player) {
                            Player player = (Player)sender;
                            Resident res = TownyUniverse.getInstance().getResident(player.getUniqueId());
                            if (res != null) {
                                yield NameUtil.filterByStart(res.getReceivedInvites().stream().map(Invite::getSender).map(Nameable::getName).collect(Collectors.toList()), args[1]);
                            }
                        }
                        yield Collections.emptyList();
                    }
                }
                yield Collections.emptyList();
            }
            default -> Collections.emptyList();
        };
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.plugin.isError()) {
                TownyMessaging.sendErrorMsg((Object)sender, "Locked in Safe mode!");
                return false;
            }
            if (command.getName().equalsIgnoreCase("invite")) {
                this.parseInviteCommand(player, args);
            }
        } else {
            HelpMenu.INVITE_HELP.send(sender);
        }
        return true;
    }

    private void parseInviteCommand(Player player, String[] split) {
        if (split.length == 0 || split[0].equalsIgnoreCase("help") || split[0].equalsIgnoreCase("?")) {
            HelpMenu.INVITE_HELP.send((CommandSender)player);
        } else if (split[0].equalsIgnoreCase("list")) {
            InviteCommand.parseInviteList(player, split);
        } else if (split[0].equalsIgnoreCase(TownySettings.getAcceptCommand())) {
            InviteCommand.parseAccept(player, StringMgmt.remFirstArg(split));
        } else if (split[0].equalsIgnoreCase(TownySettings.getDenyCommand())) {
            InviteCommand.parseDeny(player, StringMgmt.remFirstArg(split));
        }
    }

    private static void parseInviteList(Player player, String[] split) {
        Resident resident = TownyAPI.getInstance().getResident(player);
        if (resident == null) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_registered"));
            return;
        }
        String received = Translatable.of("player_received_invites").forLocale((CommandSender)player).replace("%a", Integer.toString(resident.getReceivedInvites().size())).replace("%m", Integer.toString(InviteHandler.getReceivedInvitesMaxAmount(resident)));
        try {
            int page;
            if (!resident.getReceivedInvites().isEmpty()) {
                page = 1;
                if (split != null && split.length >= 2) {
                    try {
                        page = Integer.parseInt(split[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            } else {
                throw new TownyException(Translatable.of("msg_err_player_no_invites"));
            }
            InviteCommand.sendInviteList(player, (List<Invite>)resident.getReceivedInvites(), page, false);
            TownyMessaging.sendMessage((Object)player, received);
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg(player, x.getMessage((CommandSender)player));
        }
    }

    public static void parseDeny(Player player, String[] args) {
        Town town;
        Resident resident = TownyAPI.getInstance().getResident(player);
        if (resident == null) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_registered"));
            return;
        }
        Collection invites = resident.getReceivedInvites();
        if (invites.isEmpty()) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_player_no_invites"));
            return;
        }
        if (args.length >= 1) {
            if (args[0].equalsIgnoreCase("all")) {
                InviteCommand.denyAllInvites(new ArrayList<Invite>(invites));
                TownyMessaging.sendMsg(resident, Translatable.of("msg_player_denied_all_invites"));
                return;
            }
            town = TownyAPI.getInstance().getTown(args[0]);
            if (town == null) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_invalid_name"));
                return;
            }
        } else if (invites.size() == 1) {
            town = (Town)((Invite)invites.get(0)).getSender();
        } else {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_player_has_multiple_invites"));
            InviteCommand.parseInviteList(player, null);
            return;
        }
        Invite toDecline = null;
        for (Invite invite : InviteHandler.getActiveInvites()) {
            if (!invite.getSender().equals(town) || !invite.getReceiver().equals(resident)) continue;
            toDecline = invite;
            break;
        }
        if (toDecline != null) {
            try {
                InviteHandler.declineInvite(toDecline, false);
            }
            catch (InvalidObjectException e) {
                Towny.getPlugin().getLogger().log(Level.WARNING, "unknown exception occurred while denying invite", e);
            }
        } else {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_specify_name"));
        }
    }

    private static void denyAllInvites(List<Invite> invites) {
        for (Invite invite : invites) {
            try {
                InviteHandler.declineInvite(invite, true);
            }
            catch (InvalidObjectException invalidObjectException) {}
        }
    }

    public static void parseAccept(Player player, String[] args) {
        block14: {
            Town town;
            Resident resident = TownyAPI.getInstance().getResident(player);
            if (resident == null) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_registered"));
                return;
            }
            Collection invites = resident.getReceivedInvites();
            if (invites.isEmpty()) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_player_no_invites"));
                return;
            }
            if (args.length >= 1) {
                town = TownyAPI.getInstance().getTown(args[0]);
                if (town == null) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_invalid_name"));
                    return;
                }
            } else if (invites.size() == 1) {
                town = (Town)((Invite)invites.get(0)).getSender();
            } else {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_player_has_multiple_invites"));
                InviteCommand.parseInviteList(player, null);
                return;
            }
            Invite toAccept = null;
            for (Invite invite : InviteHandler.getActiveInvites()) {
                if (!invite.getSender().equals(town) || !invite.getReceiver().equals(resident)) continue;
                toAccept = invite;
                break;
            }
            if (toAccept != null) {
                try {
                    if (!town.isAllowedThisAmountOfResidents(town.getNumResidents() + 1, town.isCapital())) {
                        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_err_max_residents_per_town_reached", TownySettings.getMaxResidentsForTown(town)));
                        break block14;
                    }
                    if (town.getNationOrNull() != null && TownySettings.getMaxResidentsPerNation() > 0 && town.getNationOrNull().getResidents().size() >= TownySettings.getMaxResidentsPerNation()) {
                        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_err_cannot_join_nation_over_resident_limit", TownySettings.getMaxResidentsPerNation()));
                        break block14;
                    }
                    InviteHandler.acceptInvite(toAccept);
                }
                catch (TownyException | InvalidObjectException e) {
                    Towny.getPlugin().getLogger().log(Level.WARNING, "unknown exception occurred while accepting invite", e);
                }
            } else {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_specify_name"));
            }
        }
    }

    public static void sendInviteList(Player player, List<Invite> list, int page, boolean fromSender) {
        if (page < 0) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_negative"));
            return;
        }
        if (page == 0) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_error_must_be_int"));
            return;
        }
        int total = (int)Math.ceil((double)list.size() / 10.0);
        if (page > total) {
            return;
        }
        ArrayList<String> invitesFormatted = new ArrayList<String>();
        int iMax = page * 10;
        if (page * 10 > list.size()) {
            iMax = list.size();
        }
        Translatable object = Translatable.literal("null");
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            String output;
            Invite invite = list.get(i);
            String name = invite.getSenderName();
            if (fromSender) {
                output = "\u00a73" + invite.getReceiver().getName() + "\u00a78 - \u00a72" + name;
                if (invite.getSender() instanceof Town) {
                    object = Translatable.of("player_sing");
                }
                if (invite.getSender() instanceof Nation) {
                    if (invite.getReceiver() instanceof Town) {
                        object = Translatable.of("town_sing");
                    }
                    if (invite.getReceiver() instanceof Nation) {
                        object = Translatable.of("nation_sing");
                    }
                }
            } else {
                output = "\u00a73" + invite.getSender().getName() + "\u00a78 - \u00a72" + name;
                if (invite.getReceiver() instanceof Resident) {
                    object = Translatable.of("town_sing");
                }
                if (invite.getReceiver() instanceof Town || invite.getReceiver() instanceof Nation) {
                    object = Translatable.of("nation_sing");
                }
            }
            invitesFormatted.add(output);
        }
        TownyMessaging.sendMessage((Object)player, ChatTools.formatList(Translatable.of("invite_plu").forLocale((CommandSender)player), "\u00a73" + object.forLocale((CommandSender)player) + "\u00a78 - \u00a7b" + Translatable.of("invite_sent_by").forLocale((CommandSender)player), invitesFormatted, Translatable.of("LIST_PAGE", page, total).forLocale((CommandSender)player)));
    }
}

