/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyCommandAddonAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.command.InviteCommand;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.confirmations.ConfirmationTransaction;
import com.palmergames.bukkit.towny.event.DeleteNationEvent;
import com.palmergames.bukkit.towny.event.NationAcceptAllyRequestEvent;
import com.palmergames.bukkit.towny.event.NationAddEnemyEvent;
import com.palmergames.bukkit.towny.event.NationDenyAllyRequestEvent;
import com.palmergames.bukkit.towny.event.NationInviteTownEvent;
import com.palmergames.bukkit.towny.event.NationPreAddEnemyEvent;
import com.palmergames.bukkit.towny.event.NationPreAddTownEvent;
import com.palmergames.bukkit.towny.event.NationPreRemoveEnemyEvent;
import com.palmergames.bukkit.towny.event.NationPreRenameEvent;
import com.palmergames.bukkit.towny.event.NationRemoveAllyEvent;
import com.palmergames.bukkit.towny.event.NationRemoveEnemyEvent;
import com.palmergames.bukkit.towny.event.NationRequestAllyNationEvent;
import com.palmergames.bukkit.towny.event.NewNationEvent;
import com.palmergames.bukkit.towny.event.nation.NationKingChangeEvent;
import com.palmergames.bukkit.towny.event.nation.NationMergeEvent;
import com.palmergames.bukkit.towny.event.nation.NationPreAddAllyEvent;
import com.palmergames.bukkit.towny.event.nation.NationPreInviteTownEvent;
import com.palmergames.bukkit.towny.event.nation.NationPreMergeEvent;
import com.palmergames.bukkit.towny.event.nation.NationPreTownKickEvent;
import com.palmergames.bukkit.towny.event.nation.NationPreTownLeaveEvent;
import com.palmergames.bukkit.towny.event.nation.NationRankAddEvent;
import com.palmergames.bukkit.towny.event.nation.NationRankRemoveEvent;
import com.palmergames.bukkit.towny.event.nation.NationSanctionTownAddEvent;
import com.palmergames.bukkit.towny.event.nation.NationSanctionTownRemoveEvent;
import com.palmergames.bukkit.towny.event.nation.NationSetSpawnEvent;
import com.palmergames.bukkit.towny.event.nation.NationTownLeaveEvent;
import com.palmergames.bukkit.towny.event.nation.PreNewNationEvent;
import com.palmergames.bukkit.towny.event.nation.toggle.NationToggleNeutralEvent;
import com.palmergames.bukkit.towny.event.nation.toggle.NationToggleOpenEvent;
import com.palmergames.bukkit.towny.event.nation.toggle.NationTogglePublicEvent;
import com.palmergames.bukkit.towny.event.nation.toggle.NationToggleTaxPercentEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.invites.exceptions.TooManyInvitesException;
import com.palmergames.bukkit.towny.object.Nameable;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnType;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translator;
import com.palmergames.bukkit.towny.object.comparators.ComparatorCaches;
import com.palmergames.bukkit.towny.object.comparators.ComparatorType;
import com.palmergames.bukkit.towny.object.inviteobjects.NationAllyNationInvite;
import com.palmergames.bukkit.towny.object.inviteobjects.TownJoinNationInvite;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.utils.MoneyUtil;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.towny.utils.ProximityUtil;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.towny.utils.SpawnUtil;
import com.palmergames.bukkit.util.BookFactory;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.MathUtil;
import com.palmergames.util.Pair;
import com.palmergames.util.StringMgmt;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class NationCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    @VisibleForTesting
    public static final List<String> nationTabCompletes;
    @VisibleForTesting
    public static final List<String> nationSetTabCompletes;
    private static final List<String> nationSetBoardTabCompletes;
    private static final List<String> nationListTabCompletes;
    static final List<String> nationToggleTabCompletes;
    private static final List<String> nationEnemyTabCompletes;
    private static final List<String> nationAllyTabCompletes;
    private static final List<String> nationKingTabCompletes;
    private static final List<String> nationConsoleTabCompletes;

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        block96: {
            block95: {
                if (!(sender instanceof Player)) break block95;
                Player player = (Player)sender;
                Resident res = TownyUniverse.getInstance().getResident(player.getUniqueId());
                if (res == null) {
                    return Collections.emptyList();
                }
                Nation nation = res.getNationOrNull();
                switch (args[0].toLowerCase(Locale.ROOT)) {
                    case "toggle": {
                        if (args.length == 2) {
                            return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.NATION_TOGGLE, nationToggleTabCompletes), args[1]);
                        }
                        if (args.length == 3) {
                            return NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[2]);
                        }
                        break block96;
                    }
                    case "king": 
                    case "leader": {
                        if (args.length == 2) {
                            return NameUtil.filterByStart(nationKingTabCompletes, args[1]);
                        }
                        break block96;
                    }
                    case "townlist": 
                    case "allylist": 
                    case "enemylist": 
                    case "ranklist": 
                    case "online": 
                    case "join": 
                    case "delete": 
                    case "merge": 
                    case "baltop": {
                        if (args.length == 2) {
                            return NationCommand.getTownyStartingWith(args[1], "n");
                        }
                        break block96;
                    }
                    case "spawn": {
                        if (args.length == 2) {
                            List<String> nationOrIgnore = NationCommand.getTownyStartingWith(args[1], "n");
                            nationOrIgnore.add("-ignore");
                            return NameUtil.filterByStart(nationOrIgnore, args[1]);
                        }
                        if (args.length == 3) {
                            return Collections.singletonList("-ignore");
                        }
                        break block96;
                    }
                    case "sanctiontown": {
                        if (nation == null) break;
                        if (args.length == 2) {
                            return NameUtil.filterByStart(Arrays.asList("add", "remove", "list"), args[1]);
                        }
                        if (args.length == 3 && (args[1].equalsIgnoreCase("add") || args[1].equalsIgnoreCase("remove"))) {
                            return NameUtil.filterByStart(TownyUniverse.getInstance().getTowns().stream().filter(t -> !nation.hasTown((Town)t)).map(TownyObject::getName).collect(Collectors.toList()), args[2]);
                        }
                        if (args.length == 3 && args[1].equalsIgnoreCase("list")) {
                            return NationCommand.getTownyStartingWith(args[2], "n");
                        }
                        break block96;
                    }
                    case "add": {
                        return NationCommand.getTownyStartingWith(args[args.length - 1], "t");
                    }
                    case "kick": {
                        if (res.hasNation()) {
                            return NameUtil.filterByStart(NameUtil.getNames(res.getNationOrNull().getTowns()), args[args.length - 1]);
                        }
                        break block96;
                    }
                    case "ally": {
                        if (!res.hasNation()) break;
                        if (args.length == 2) {
                            return NameUtil.filterByStart(nationAllyTabCompletes, args[1]);
                        }
                        if (args.length > 2) {
                            switch (args[1].toLowerCase(Locale.ROOT)) {
                                case "add": {
                                    if (args[args.length - 1].startsWith("-")) {
                                        return NameUtil.filterByStart(nation.getSentAllyInvites().stream().map(Invite::getReceiver).map(Nameable::getName).collect(Collectors.toList()), args[args.length - 1].substring(1)).stream().map(e -> "-" + e).collect(Collectors.toList());
                                    }
                                    return NationCommand.getTownyStartingWith(args[args.length - 1], "n");
                                }
                                case "remove": {
                                    return NameUtil.filterByStart(NameUtil.getNames(nation.getAllies()), args[args.length - 1]);
                                }
                                case "accept": 
                                case "deny": {
                                    return NameUtil.filterByStart(nation.getReceivedInvites().stream().map(Invite::getSender).map(Nameable::getName).collect(Collectors.toList()), args[args.length - 1]);
                                }
                            }
                            return Collections.emptyList();
                        }
                        break block96;
                    }
                    case "rank": {
                        if (!res.hasNation()) break;
                        block48 : switch (args.length) {
                            case 2: {
                                return NameUtil.filterByStart(nationEnemyTabCompletes, args[1]);
                            }
                            case 3: {
                                return NationCommand.getNationResidentNamesOfPlayerStartingWith(player, args[2]);
                            }
                            case 4: {
                                switch (args[1].toLowerCase(Locale.ROOT)) {
                                    case "add": {
                                        if (nation == null) {
                                            return Collections.emptyList();
                                        }
                                        return NameUtil.filterByStart(TownyPerms.getNationRanks(nation), args[3]);
                                    }
                                    case "remove": {
                                        Resident rankHaver = TownyUniverse.getInstance().getResident(args[2]);
                                        if (rankHaver == null) break block48;
                                        return rankHaver.getNationRanks().isEmpty() ? Collections.emptyList() : NameUtil.filterByStart(rankHaver.getNationRanks(), args[3]);
                                    }
                                }
                                return Collections.emptyList();
                            }
                        }
                        return Collections.emptyList();
                    }
                    case "enemy": {
                        if (!res.hasNation()) break;
                        if (args.length == 2) {
                            return NameUtil.filterByStart(nationEnemyTabCompletes, args[1]);
                        }
                        if (args.length >= 3) {
                            switch (args[1].toLowerCase(Locale.ROOT)) {
                                case "add": {
                                    return NationCommand.getTownyStartingWith(args[2], "n");
                                }
                                case "remove": {
                                    return NameUtil.filterByStart(NameUtil.getNames(nation.getEnemies()), args[2]);
                                }
                            }
                            return Collections.emptyList();
                        }
                        break block96;
                    }
                    case "set": {
                        if (!res.hasNation()) {
                            return Collections.emptyList();
                        }
                        return NationCommand.nationSetTabComplete(sender, nation, args);
                    }
                    case "list": {
                        switch (args.length) {
                            case 2: {
                                return Collections.singletonList("by");
                            }
                            case 3: {
                                return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.NATION_LIST_BY, nationListTabCompletes), args[2]);
                            }
                        }
                        return Collections.emptyList();
                    }
                    default: {
                        if (args.length == 1) {
                            List<String> nationNames = NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.NATION, nationTabCompletes), args[0]);
                            if (nationNames.size() > 0) {
                                return nationNames;
                            }
                            return NationCommand.getTownyStartingWith(args[0], "n");
                        }
                        if (args.length > 1 && TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.NATION, args[0])) {
                            return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.NATION, args[0]).getTabCompletion(sender, args), args[args.length - 1]);
                        }
                        break block96;
                    }
                }
                break block96;
            }
            if (args.length == 1) {
                return NationCommand.filterByStartOrGetTownyStartingWith(nationConsoleTabCompletes, args[0], "n");
            }
        }
        return Collections.emptyList();
    }

    static List<String> nationSetTabComplete(CommandSender sender, Nation nation, String[] args) {
        if (args.length == 2) {
            return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.NATION_SET, nationSetTabCompletes), args[1]);
        }
        if (args.length > 2) {
            if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.NATION_SET, args[1])) {
                return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.NATION_SET, args[1]).getTabCompletion(sender, StringMgmt.remFirstArg(args)), args[args.length - 1]);
            }
            switch (args[1].toLowerCase(Locale.ROOT)) {
                case "king": 
                case "leader": 
                case "title": 
                case "surname": {
                    return NameUtil.filterByStart(NameUtil.getNames(nation.getResidents()), args[2]);
                }
                case "capital": {
                    return NameUtil.filterByStart(NameUtil.getNames(nation.getTowns()), args[2]);
                }
                case "tag": {
                    if (args.length != 3) break;
                    return NameUtil.filterByStart(Collections.singletonList("clear"), args[2]);
                }
                case "mapcolor": {
                    if (args.length != 3) break;
                    return NameUtil.filterByStart(TownySettings.getNationColorsMap().keySet().stream().collect(Collectors.toList()), args[2]);
                }
                case "board": {
                    if (args.length != 3) break;
                    return NameUtil.filterByStart(nationSetBoardTabCompletes, args[2]);
                }
                default: {
                    return Collections.emptyList();
                }
            }
        }
        return Collections.emptyList();
    }

    public NationCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            if (plugin.isError()) {
                TownyMessaging.sendErrorMsg((Object)sender, "Locked in Safe mode!");
                return false;
            }
            Player player = (Player)sender;
            try {
                this.parseNationCommand(player, args);
            }
            catch (TownyException te) {
                TownyMessaging.sendErrorMsg(player, te.getMessage((CommandSender)player));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(player, e.getMessage());
            }
        } else {
            this.parseNationCommandForConsole(sender, args);
        }
        return true;
    }

    private static Nation getPlayerNationOrNationFromArg(Player player, String[] args) throws TownyException {
        return args.length == 0 ? NationCommand.getNationFromPlayerOrThrow(player) : NationCommand.getNationOrThrow(args[0]);
    }

    private void parseNationCommandForConsole(CommandSender sender, String[] split) {
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.NATION_HELP_CONSOLE.send(sender);
        } else if (split[0].equalsIgnoreCase("list")) {
            try {
                this.listNations(sender, split);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
            }
        } else {
            Nation nation = TownyUniverse.getInstance().getNation(split[0]);
            if (nation != null) {
                this.nationStatusScreen(sender, nation);
            } else {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_not_registered_1", split[0]));
            }
        }
    }

    public void parseNationCommand(Player player, String[] split) throws TownyException, Exception {
        if (split.length == 0) {
            this.nationStatusScreen((CommandSender)player, NationCommand.getNationFromPlayerOrThrow(player));
            return;
        }
        if (split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.NATION_HELP.send((CommandSender)player);
            return;
        }
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "list": {
                this.listNations((CommandSender)player, split);
                break;
            }
            case "townlist": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_TOWNLIST.getNode());
                this.nationTownList(player, NationCommand.getPlayerNationOrNationFromArg(player, StringMgmt.remFirstArg(split)));
                break;
            }
            case "allylist": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_ALLYLIST.getNode());
                this.nationAllyList(player, NationCommand.getPlayerNationOrNationFromArg(player, StringMgmt.remFirstArg(split)));
                break;
            }
            case "enemylist": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_ENEMYLIST.getNode());
                this.nationEnemyList(player, NationCommand.getPlayerNationOrNationFromArg(player, StringMgmt.remFirstArg(split)));
                break;
            }
            case "new": 
            case "create": {
                this.newNation(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "join": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_JOIN.getNode());
                this.parseNationJoin(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "merge": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_MERGE.getNode());
                this.mergeNation(player, split);
                break;
            }
            case "withdraw": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_WITHDRAW.getNode());
                TownyEconomyHandler.economyExecutor().execute(() -> NationCommand.nationTransaction(player, StringMgmt.remFirstArg(split), true));
                break;
            }
            case "leave": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_LEAVE.getNode());
                this.nationLeave(player);
                break;
            }
            case "spawn": {
                boolean ignoreWarning = split.length > 1 && split[1].equals("-ignore") || split.length > 2 && split[2].equals("-ignore");
                NationCommand.nationSpawn(player, StringMgmt.remFirstArg(split), ignoreWarning);
                break;
            }
            case "deposit": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_DEPOSIT.getNode());
                TownyEconomyHandler.economyExecutor().execute(() -> NationCommand.nationTransaction(player, StringMgmt.remFirstArg(split), false));
                break;
            }
            case "rank": {
                this.nationRank(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "ranklist": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_RANKLIST.getNode());
                TownyMessaging.sendMessage((Object)player, TownyFormatter.getRanksForNation(NationCommand.getPlayerNationOrNationFromArg(player, StringMgmt.remFirstArg(split)), Translator.locale((CommandSender)player)));
                break;
            }
            case "king": 
            case "leader": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_LEADER.getNode());
                this.nationKing(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "add": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_INVITE_ADD.getNode());
                this.nationAdd(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "invite": 
            case "invites": {
                this.parseInviteCommand(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "kick": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_KICK.getNode());
                this.nationKick(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "sanctiontown": {
                NationCommand.nationSanctionTown((CommandSender)player, null, StringMgmt.remFirstArg(split));
                break;
            }
            case "set": {
                NationCommand.nationSet((CommandSender)player, StringMgmt.remFirstArg(split), false, null);
                break;
            }
            case "toggle": {
                NationCommand.nationToggle((CommandSender)player, StringMgmt.remFirstArg(split), false, null);
                break;
            }
            case "ally": {
                this.nationAlly(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "enemy": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_ENEMY.getNode());
                this.nationEnemy(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "delete": {
                this.nationDelete(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "online": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_ONLINE.getNode());
                this.parseNationOnlineCommand(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "say": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_SAY.getNode());
                this.nationSay(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "bankhistory": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_BANKHISTORY.getNode());
                this.nationBankHistory(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "baltop": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_BALTOP.getNode());
                NationCommand.parseNationBaltop(player, NationCommand.getPlayerNationOrNationFromArg(player, StringMgmt.remFirstArg(split)));
                break;
            }
            default: {
                if (NationCommand.tryNationAddonCommand(player, split)) {
                    return;
                }
                if (this.tryNationStatusScreen(player, split)) {
                    return;
                }
                throw new TownyException(Translatable.of("msg_err_invalid_sub"));
            }
        }
    }

    private boolean tryNationStatusScreen(Player player, String[] split) throws TownyException {
        Nation nation = TownyUniverse.getInstance().getNation(split[0]);
        if (nation != null) {
            if (!nation.hasResident(player.getName())) {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_OTHERNATION.getNode());
            }
            this.nationStatusScreen((CommandSender)player, nation);
            return true;
        }
        return false;
    }

    private static boolean tryNationAddonCommand(Player player, String[] split) {
        if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.NATION, split[0])) {
            TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.NATION, split[0]).execute((CommandSender)player, "nation", split);
            return true;
        }
        return false;
    }

    private void nationSay(Player player, String[] split) throws TownyException {
        if (split.length == 0) {
            throw new TownyException("ex: /n say [message here]");
        }
        NationCommand.getNationFromPlayerOrThrow(player).playerBroadCastMessageToNation(player, StringMgmt.join(split));
    }

    private void nationBankHistory(Player player, String[] split) throws TownyException {
        int pages = 10;
        if (split.length > 0) {
            try {
                pages = Integer.parseInt(split[0]);
            }
            catch (NumberFormatException e) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_error_must_be_int"));
                return;
            }
        }
        NationCommand.getNationFromPlayerOrThrow(player).generateBankHistoryBook(player, pages);
    }

    private void nationTownList(Player player, Nation nation) {
        TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(nation.getName() + " " + Translatable.of("town_plu").forLocale((CommandSender)player)));
        TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedTownyObjects(Translatable.of("status_nation_towns").forLocale((CommandSender)player), new ArrayList<TownyObject>(nation.getTowns())));
    }

    private void nationAllyList(Player player, Nation nation) throws TownyException {
        if (nation.getAllies().isEmpty()) {
            throw new TownyException(Translatable.of("msg_error_nation_has_no_allies"));
        }
        TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(nation.getName() + " " + Translatable.of("status_nation_allies").forLocale((CommandSender)player)));
        TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedTownyObjects(Translatable.of("status_nation_allies").forLocale((CommandSender)player), new ArrayList<TownyObject>(nation.getAllies())));
    }

    private void nationEnemyList(Player player, Nation nation) throws TownyException {
        if (nation.getEnemies().isEmpty()) {
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_error_nation_has_no_enemies"));
        } else {
            TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(nation.getName() + " " + Translatable.of("status_nation_enemies").forLocale((CommandSender)player)));
            TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedTownyObjects(Translatable.of("status_nation_enemies").forLocale((CommandSender)player), new ArrayList<TownyObject>(nation.getEnemies())));
        }
        List enemiedByList = TownyAPI.getInstance().getNations().stream().filter(n -> n.hasEnemy(nation)).collect(Collectors.toList());
        if (!enemiedByList.isEmpty()) {
            TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedTownyObjects(Translatable.of("status_nation_enemied_by").forLocale((CommandSender)player), new ArrayList<TownyObject>(enemiedByList)));
        }
    }

    private void parseInviteCommand(Player player, String[] newSplit) throws TownyException {
        Nation nation = NationCommand.getNationFromPlayerOrThrow(player);
        String sent = Translatable.of("nation_sent_invites").forLocale((CommandSender)player).replace("%a", Integer.toString(nation.getSentInvites().size())).replace("%m", Integer.toString(InviteHandler.getSentInvitesMaxAmount(nation)));
        if (newSplit.length == 0) {
            NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_INVITE_SEE_HOME.getNode());
            HelpMenu.NATION_INVITE.send((CommandSender)player);
            TownyMessaging.sendMessage((Object)player, sent);
            return;
        }
        if (newSplit.length >= 1) {
            if (newSplit[0].equalsIgnoreCase("help") || newSplit[0].equalsIgnoreCase("?")) {
                HelpMenu.NATION_INVITE.send((CommandSender)player);
                return;
            }
            if (newSplit[0].equalsIgnoreCase("sent")) {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_INVITE_LIST_SENT.getNode());
                Collection sentinvites = nation.getSentInvites();
                InviteCommand.sendInviteList(player, (List<Invite>)sentinvites, this.getPage(newSplit, 1), true);
                TownyMessaging.sendMessage((Object)player, sent);
                return;
            }
            NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_INVITE_ADD.getNode());
            this.nationAdd(player, newSplit);
        }
    }

    private void parseNationOnlineCommand(Player player, String[] split) throws TownyException {
        if (split.length > 0) {
            Nation nation = NationCommand.getNationOrThrow(split[0]);
            List<Resident> onlineResidents = ResidentUtil.getOnlineResidentsViewable(player, nation);
            if (onlineResidents.size() > 0) {
                TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedOnlineResidents(Translatable.of("msg_nation_online").forLocale((CommandSender)player), nation, player));
            } else {
                TownyMessaging.sendMessage((Object)player, "\u00a7f0 " + Translatable.of("res_list").forLocale((CommandSender)player) + " " + Translatable.of("msg_nation_online").forLocale((CommandSender)player) + ": " + String.valueOf(nation));
            }
        } else {
            Nation nation = NationCommand.getNationFromPlayerOrThrow(player);
            TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedOnlineResidents(Translatable.of("msg_nation_online").forLocale((CommandSender)player), nation, player));
        }
    }

    public void nationRank(Player player, String[] split) throws TownyException {
        if (split.length < 3 || !split[0].equalsIgnoreCase("add") && !split[0].equalsIgnoreCase("remove")) {
            HelpMenu.NATION_RANK.send((CommandSender)player);
            return;
        }
        Resident resident = NationCommand.getResidentOrThrow(player);
        Resident target = NationCommand.getResidentOrThrow(split[1]);
        Nation nation = NationCommand.getNationFromResidentOrThrow(resident);
        if (!nation.hasResident(target)) {
            throw new TownyException(Translatable.of("msg_err_not_same_nation", target.getName()));
        }
        String rank = TownyPerms.matchNationRank(split[2]);
        if (rank == null) {
            throw new TownyException(Translatable.of("msg_unknown_rank_available_ranks", split[2], StringMgmt.join(TownyPerms.getNationRanks(), ", ")));
        }
        NationCommand.checkPermOrThrowWithMessage((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_RANK.getNode(rank.toLowerCase(Locale.ROOT)), Translatable.of("msg_no_permission_to_give_rank"));
        Translatable nationWord = Translatable.of("nation_sing");
        if (split[0].equalsIgnoreCase("add")) {
            int levelNumber;
            int rankLevelReq;
            if (target.hasNationRank(rank)) {
                throw new TownyException(Translatable.of("msg_resident_already_has_rank", target.getName(), nationWord));
            }
            if (TownyPerms.ranksWithNationLevelRequirementPresent() && (rankLevelReq = TownyPerms.getRankNationLevelReq(rank)) > (levelNumber = target.getNationOrNull().getLevelNumber())) {
                throw new TownyException(Translatable.of("msg_town_or_nation_level_not_high_enough_for_this_rank", nationWord, rank, nationWord, levelNumber, rankLevelReq));
            }
            BukkitTools.ifCancelledThenThrow(new NationRankAddEvent(nation, rank, target));
            target.addNationRank(rank);
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_you_have_given_rank", nationWord, rank, target.getName()));
            if (target.isOnline()) {
                TownyMessaging.sendMsg((CommandSender)target.getPlayer(), Translatable.of("msg_you_have_been_given_rank", nationWord, rank));
                plugin.deleteCache(TownyAPI.getInstance().getPlayer(target));
            }
        }
        if (split[0].equalsIgnoreCase("remove")) {
            if (!target.hasNationRank(rank)) {
                throw new TownyException(Translatable.of("msg_resident_doesnt_have_rank", target.getName(), nationWord));
            }
            BukkitTools.ifCancelledThenThrow(new NationRankRemoveEvent(nation, rank, target));
            target.removeNationRank(rank);
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_you_have_taken_rank_from", nationWord, rank, target.getName()));
            if (target.isOnline()) {
                TownyMessaging.sendMsg((CommandSender)target.getPlayer(), Translatable.of("msg_you_have_had_rank_taken", nationWord, rank));
                plugin.deleteCache(TownyAPI.getInstance().getPlayer(target));
            }
        }
        target.save();
    }

    public void listNations(CommandSender sender, String[] split) throws TownyException {
        boolean console = true;
        Player player = null;
        if (split.length == 2 && split[1].equals("?")) {
            HelpMenu.NATION_LIST.send(sender);
            return;
        }
        if (sender instanceof Player) {
            console = false;
            player = (Player)sender;
        }
        if (split.length < 2 && !console) {
            NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_LIST_RESIDENTS.getNode());
        }
        int page = 1;
        boolean pageSet = false;
        boolean comparatorSet = false;
        ComparatorType type = ComparatorType.RESIDENTS;
        for (int i = 1; i < split.length; ++i) {
            if (split[i].equalsIgnoreCase("by")) {
                if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.NATION_LIST_BY, split[i + 1])) {
                    TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.NATION_LIST_BY, split[i + 1]).execute(sender, "nation", split);
                    return;
                }
                if (comparatorSet) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_error_multiple_comparators_nation"));
                    return;
                }
                if (++i < split.length) {
                    comparatorSet = true;
                    if (split[i].equalsIgnoreCase("resident")) {
                        split[i] = "residents";
                    }
                    if (!console) {
                        NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_LIST.getNode(split[i]));
                    }
                    if (!nationListTabCompletes.contains(split[i].toLowerCase(Locale.ROOT))) {
                        throw new TownyException(Translatable.of("msg_error_invalid_comparator_nation", nationListTabCompletes.stream().filter(comp -> sender.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_LIST.getNode((String)comp))).collect(Collectors.joining(", "))));
                    }
                } else {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_error_missing_comparator"));
                    return;
                }
                type = ComparatorType.valueOf(split[i].toUpperCase(Locale.ROOT));
                comparatorSet = true;
                continue;
            }
            if (pageSet) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_error_too_many_pages"));
                return;
            }
            page = MathUtil.getPositiveIntOrThrow(split[i]);
            if (page == 0) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_error_must_be_int"));
                return;
            }
            pageSet = true;
        }
        ComparatorType finalType = type;
        int pageNumber = page;
        plugin.getScheduler().runAsync(() -> {
            List<Pair<UUID, Component>> list = ComparatorCaches.getNationListCache(finalType);
            int total = (int)Math.ceil((double)list.size() / 10.0);
            if (pageNumber > total) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("LIST_ERR_NOT_ENOUGH_PAGES", total));
                return;
            }
            TownyMessaging.sendNationList(sender, list, finalType, pageNumber, total);
        });
    }

    private void newNation(Player player, String[] split) throws TownyException {
        NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_NEW.getNode());
        if (split.length == 0) {
            throw new TownyException(Translatable.of("msg_specify_nation_name"));
        }
        String nationName = String.join((CharSequence)"_", split);
        if (TownySettings.getTownAutomaticCapitalisationEnabled()) {
            nationName = StringMgmt.capitalizeStrings(nationName);
        }
        Town town = this.getTownForNationCapital(player);
        boolean noCharge = TownySettings.getNewNationPrice() == 0.0 || !TownyEconomyHandler.isActive();
        NationCommand.newNation((CommandSender)player, nationName, town, noCharge);
    }

    private Town getTownForNationCapital(Player player) throws TownyException {
        Resident resident = NationCommand.getResidentOrThrow(player);
        Town town = NationCommand.getTownFromResidentOrThrow(resident);
        if (!town.hasEnoughResidentsToBeANationCapital()) {
            throw new TownyException(Translatable.of("msg_err_not_enough_residents_new_nation"));
        }
        if (!resident.isMayor() && !town.hasResidentWithRank(resident, "assistant")) {
            throw new TownyException(Translatable.of("msg_peasant_right"));
        }
        return town;
    }

    public static void newNation(CommandSender sender, String name, Town capitalTown, boolean noCharge) throws TownyException {
        if (capitalTown.hasNation()) {
            throw new TownyException(Translatable.of("msg_err_already_nation"));
        }
        String filteredName = NameValidation.checkAndFilterNationNameOrThrow(name);
        if (TownyUniverse.getInstance().hasNation(filteredName)) {
            throw new TownyException(Translatable.of("msg_err_name_validation_name_already_in_use", filteredName));
        }
        BukkitTools.ifCancelledThenThrow(new PreNewNationEvent(capitalTown, filteredName));
        if (noCharge || !TownyEconomyHandler.isActive()) {
            Nation nation = NationCommand.newNation(filteredName, capitalTown);
            TownyMessaging.sendGlobalMessage(Translatable.of("msg_new_nation", sender.getName(), nation.getFormattedName()));
            return;
        }
        double cost = TownySettings.getNewNationPrice();
        if (!capitalTown.getAccount().canPayFromHoldings(cost)) {
            throw new TownyException(Translatable.of("msg_no_funds_new_nation2", NationCommand.prettyMoney(cost)));
        }
        Confirmation.runOnAccept(() -> {
            try {
                Nation nation = NationCommand.newNation(filteredName, capitalTown);
                TownyMessaging.sendGlobalMessage(Translatable.of("msg_new_nation", sender.getName(), nation.getFormattedName()));
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
            }
        }).setCost(new ConfirmationTransaction(TownySettings::getNewNationPrice, capitalTown, "New Nation Cost", Translatable.of("msg_no_funds_new_nation2", NationCommand.prettyMoney(cost)))).setTitle(Translatable.of("msg_confirm_purchase", NationCommand.prettyMoney(cost))).sendTo(sender);
    }

    public static Nation newNation(String name, Town town) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        UUID nationUUID = UUID.randomUUID();
        townyUniverse.getDataSource().newNation(name, nationUUID);
        Nation nation = townyUniverse.getNation(nationUUID);
        if (nation == null) {
            TownyMessaging.sendErrorMsg(String.format("Error fetching new nation with name %s; it was not properly registered!", name));
            throw new TownyException(Translatable.of("msg_err_not_registered_1", name));
        }
        nation.setRegistered(System.currentTimeMillis());
        nation.setMapColorHexCode(TownySettings.getDefaultNationMapColor());
        town.setNation(nation);
        nation.setCapital(town);
        nation.setSpawn(town.getSpawnOrNull());
        if (TownyEconomyHandler.isActive()) {
            nation.getAccount().setBalance(0.0, "New Nation Account");
        }
        if (TownySettings.isNationTagSetAutomatically()) {
            nation.setTag(NameUtil.getTagFromName(name));
        }
        town.save();
        nation.save();
        BukkitTools.fireEvent(new NewNationEvent(nation));
        return nation;
    }

    public void mergeNation(Player player, String[] split) throws TownyException {
        NationCommand.mergeNation((CommandSender)player, StringMgmt.remFirstArg(split), NationCommand.getNationFromPlayerOrThrow(player), false);
    }

    public static void mergeNation(CommandSender sender, String[] split, @NotNull Nation remainingNation, boolean admin) throws TownyException {
        Player player;
        if (split.length == 0) {
            throw new TownyException(Translatable.of("msg_specify_nation_name"));
        }
        String name = split[0];
        if (!admin && sender instanceof Player && !NationCommand.getResidentOrThrow(player = (Player)sender).isKing()) {
            throw new TownyException(Translatable.of("msg_err_merging_for_kings_only"));
        }
        Nation nation = TownyUniverse.getInstance().getNation(name);
        if (nation == null || remainingNation.getName().equalsIgnoreCase(name)) {
            throw new TownyException(Translatable.of("msg_err_invalid_name", name));
        }
        Resident king = nation.getKing();
        if (!king.isOnline()) {
            throw new TownyException(Translatable.of("msg_err_king_of_that_nation_is_not_online", name, king.getName()));
        }
        TownyMessaging.sendMsg(king, Translatable.of("msg_would_you_merge_your_nation_into_other_nation", nation, remainingNation, remainingNation));
        if (TownySettings.getNationProximityToCapital() > 0.0) {
            ArrayList<Town> towns = new ArrayList<Town>(nation.getTowns());
            towns.addAll(remainingNation.getTowns());
            List<Town> removedTowns = ProximityUtil.gatherOutOfRangeTowns(remainingNation);
            if (!removedTowns.isEmpty()) {
                TownyMessaging.sendMsg(nation.getKing(), Translatable.of("msg_warn_the_following_towns_will_be_removed_from_your_nation", StringMgmt.join(removedTowns, ", ")));
                TownyMessaging.sendMsg(remainingNation.getKing(), Translatable.of("msg_warn_the_following_towns_will_be_removed_from_the_merged_nation", StringMgmt.join(removedTowns, ", ")));
            }
        }
        Confirmation.runOnAccept(() -> {
            BukkitTools.fireEvent(new NationMergeEvent(nation, remainingNation));
            TownyUniverse.getInstance().getDataSource().mergeNation(nation, remainingNation);
            TownyMessaging.sendGlobalMessage(Translatable.of("nation1_has_merged_with_nation2", nation, remainingNation));
            if (TownySettings.getNationProximityToCapital() > 0.0) {
                ProximityUtil.removeOutOfRangeTowns(remainingNation);
            }
        }).runOnCancel(() -> {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_town_merge_request_denied"));
            TownyMessaging.sendMsg(nation.getKing(), Translatable.of("msg_town_merge_cancelled"));
        }).setCancellableEvent(new NationPreMergeEvent(nation, remainingNation)).sendTo((CommandSender)BukkitTools.getPlayerExact(king.getName()));
    }

    public void nationLeave(Player player) throws TownyException {
        boolean tooManyResidents;
        Resident resident = NationCommand.getResidentOrThrow(player);
        Town town = NationCommand.getTownFromResidentOrThrow(resident);
        Nation nation = NationCommand.getNationFromResidentOrThrow(resident);
        BukkitTools.ifCancelledThenThrow(new NationPreTownLeaveEvent(nation, town));
        boolean bl = tooManyResidents = town.isCapital() && town.isAllowedThisAmountOfResidents(town.getNumResidents(), false);
        if (tooManyResidents) {
            int maxResidentsPerTown = town.getMaxAllowedNumberOfResidentsWithoutNation();
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_deleting_nation_will_result_in_losing_residents", maxResidentsPerTown, town.getNumResidents() - maxResidentsPerTown));
        }
        Confirmation.runOnAccept(() -> {
            BukkitTools.fireEvent(new NationTownLeaveEvent(nation, town));
            town.removeNation();
            if (tooManyResidents) {
                ResidentUtil.reduceResidentCountToFitTownMaxPop(town);
            }
            plugin.resetCache();
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_town_left", StringMgmt.remUnderscore(town.getName())));
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_left_nation", StringMgmt.remUnderscore(nation.getName())));
            ProximityUtil.removeOutOfRangeTowns(nation);
        }).sendTo((CommandSender)player);
    }

    public void nationDelete(Player player, String[] split) throws TownyException {
        if (split.length == 0) {
            boolean tooManyResidents;
            NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_DELETE.getNode());
            Town town = NationCommand.getTownFromPlayerOrThrow(player);
            Nation nation = NationCommand.getNationFromTownOrThrow(town);
            boolean bl = tooManyResidents = !town.isAllowedThisAmountOfResidents(town.getNumResidents(), false);
            if (tooManyResidents) {
                int maxResidentsPerTown = town.getMaxAllowedNumberOfResidentsWithoutNation();
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_deleting_nation_will_result_in_losing_residents", maxResidentsPerTown, town.getNumResidents() - maxResidentsPerTown));
            }
            Confirmation.runOnAccept(() -> {
                if (TownyUniverse.getInstance().getDataSource().removeNation(nation, DeleteNationEvent.Cause.COMMAND, (CommandSender)player)) {
                    TownyMessaging.sendGlobalMessage(Translatable.of("msg_del_nation", nation.getName()));
                    if (tooManyResidents) {
                        ResidentUtil.reduceResidentCountToFitTownMaxPop(town);
                    }
                }
            }).sendTo((CommandSender)player);
            return;
        }
        NationCommand.checkPermOrThrowWithMessage((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_NATION_DELETE.getNode(), Translatable.of("msg_err_admin_only_delete_nation"));
        Nation nation = NationCommand.getNationOrThrow(split[0]);
        Confirmation.runOnAccept(() -> {
            TownyUniverse.getInstance().getDataSource().removeNation(nation, DeleteNationEvent.Cause.ADMIN_COMMAND, (CommandSender)player);
            TownyMessaging.sendGlobalMessage(Translatable.of("msg_del_nation", nation.getName()));
        }).sendTo((CommandSender)player);
    }

    public void nationKing(Player player, String[] split) {
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            HelpMenu.KING_HELP.send((CommandSender)player);
        }
    }

    private void parseNationJoin(Player player, String[] args) throws TownyException {
        if (args.length < 1) {
            throw new TownyException(Translatable.of("msg_usage", "/nation join [nation]"));
        }
        Town town = NationCommand.getTownFromPlayerOrThrow(player);
        Nation nation = NationCommand.getNationOrThrow(args[0]);
        if (!nation.isOpen()) {
            throw new TownyException(Translatable.of("msg_err_nation_not_open", nation.getFormattedName()));
        }
        this.testNationAddTownOrThrow(town, nation);
        NationCommand.nationAdd(nation, town);
    }

    private void testNationAddTownOrThrow(Town town, Nation nation) throws TownyException {
        if (nation.hasTown(town) || town.hasNation()) {
            throw new TownyException(Translatable.of("msg_err_already_in_town", town.getName(), town.getNationOrNull().getName()));
        }
        if (!town.hasEnoughResidentsToJoinANation()) {
            throw new TownyException(Translatable.of("msg_err_not_enough_residents_join_nation", town.getName()));
        }
        if (nation.hasSanctionedTown(town)) {
            throw new TownyException(Translatable.of("msg_err_cannot_join_nation_sanctioned_town", nation.getName()));
        }
        if (nation.hasReachedMaxTowns()) {
            throw new TownyException(Translatable.of("msg_err_nation_over_town_limit", TownySettings.getMaxTownsPerNation()));
        }
        if (!nation.canAddResidents(town.getNumResidents())) {
            throw new TownyException(Translatable.of("msg_err_cannot_join_nation_over_resident_limit", TownySettings.getMaxResidentsPerNation()));
        }
        if (TownySettings.getNationProximityToCapital() > 0.0) {
            ProximityUtil.testTownProximityToNation(town, nation);
        }
        BukkitTools.ifCancelledThenThrow(new NationPreAddTownEvent(nation, town));
    }

    public void nationAdd(Player player, String[] names) throws TownyException {
        if (names.length < 1) {
            throw new TownyException("Eg: /nation add [names]");
        }
        Nation nation = NationCommand.getNationFromPlayerOrThrow(player);
        ArrayList<String> nameList = new ArrayList<String>(Arrays.asList(names));
        nameList.stream().filter(name -> name.startsWith("-") || nation.hasTown((String)name)).map(name -> name.startsWith("-") ? name.substring(1) : name).filter(name -> TownyAPI.getInstance().getTown((String)name) != null).map(name -> TownyAPI.getInstance().getTown((String)name)).filter(town -> nation.getSentInvites().stream().anyMatch(invite -> town.equals(invite.getReceiver()))).forEach(town -> NationCommand.nationRevokeInviteTown((CommandSender)player, nation, town));
        List invitedNames = nameList.stream().filter(name -> !name.startsWith("-")).filter(name -> TownyAPI.getInstance().getTown((String)name) != null).map(name -> TownyAPI.getInstance().getTown((String)name)).filter(town -> {
            try {
                this.testNationAddTownOrThrow((Town)town, nation);
                NationCommand.nationInviteTown(player, nation, town);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
                return false;
            }
            return true;
        }).map(town -> town.getName()).collect(Collectors.toList());
        if (!invitedNames.isEmpty()) {
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_invited_join_nation", player.getName(), String.join((CharSequence)", ", invitedNames)));
        }
    }

    private static void nationRevokeInviteTown(CommandSender sender, Nation nation, Town town) {
        InviteHandler.getActiveInvitesFor(nation, town).forEach(invite -> {
            try {
                InviteHandler.declineInvite(invite, true);
                TownyMessaging.sendMsg(sender, Translatable.of("nation_revoke_invite_successful"));
            }
            catch (InvalidObjectException e) {
                plugin.getLogger().log(Level.WARNING, "unknown exception occurred while revoking invite", e);
            }
        });
    }

    @Deprecated
    public static void nationAdd(Nation nation, List<Town> towns) {
        for (Town town : towns) {
            NationCommand.nationAdd(nation, town);
        }
    }

    public static void nationAdd(Nation nation, Town town) {
        if (town.hasNation()) {
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_err_town_already_belong_nation", town.getName(), town.getNationOrNull().getName()));
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_err_already_belong_nation"));
            return;
        }
        if (!town.hasEnoughResidentsToJoinANation()) {
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_err_not_enough_residents_join_nation", town.getName()));
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_err_not_enough_residents_join_nation", town.getName()));
            return;
        }
        if (nation.hasSanctionedTown(town)) {
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_err_cannot_add_sanctioned_town", town.getName()));
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_err_cannot_join_nation_sanctioned_town", nation.getName()));
            return;
        }
        if (nation.hasReachedMaxTowns()) {
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_err_nation_over_town_limit", TownySettings.getMaxTownsPerNation()));
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_err_cannot_join_nation_over_town_limit", TownySettings.getMaxTownsPerNation()));
            return;
        }
        if (!nation.canAddResidents(town.getNumResidents())) {
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_err_cannot_add_nation_over_resident_limit", TownySettings.getMaxResidentsPerNation(), town.getName()));
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_err_cannot_join_nation_over_resident_limit", TownySettings.getMaxResidentsPerNation()));
            return;
        }
        if (TownySettings.getNationProximityToCapital() > 0.0) {
            try {
                ProximityUtil.testTownProximityToNation(town, nation);
            }
            catch (TownyException e) {
                TownyMessaging.sendPrefixedNationMessage(nation, e.getMessage());
                TownyMessaging.sendPrefixedTownMessage(town, e.getMessage());
                return;
            }
        }
        try {
            town.setNation(nation);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        town.save();
        TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_join_nation", StringMgmt.remUnderscore(town.getName())));
        TownyAPI.getInstance().getOnlinePlayers(town).forEach(p -> plugin.resetCache((Player)p));
    }

    private static void nationInviteTown(Player player, Nation nation, Town town) throws TownyException {
        TownJoinNationInvite invite = new TownJoinNationInvite((CommandSender)player, town, nation);
        BukkitTools.ifCancelledThenThrow(new NationPreInviteTownEvent(invite));
        try {
            if (!InviteHandler.inviteIsActive(invite)) {
                town.newReceivedInvite(invite);
                nation.newSentInvite(invite);
                InviteHandler.addInvite(invite);
                Player mayor = TownyAPI.getInstance().getPlayer(town.getMayor());
                if (mayor != null) {
                    TownyMessaging.sendRequestMessage((CommandSender)mayor, invite);
                }
            } else {
                throw new TownyException(Translatable.of("msg_err_town_already_invited", town.getName()));
            }
            BukkitTools.fireEvent(new NationInviteTownEvent(invite));
        }
        catch (TooManyInvitesException e) {
            town.deleteReceivedInvite(invite);
            nation.deleteSentInvite(invite);
            throw new TownyException(e.getMessage());
        }
    }

    public void nationKick(Player player, String[] names) throws TownyException {
        if (names.length < 1) {
            TownyMessaging.sendErrorMsg(player, "Eg: /nation kick [names]");
            return;
        }
        Nation nation = NationCommand.getNationFromPlayerOrThrow(player);
        NationCommand.nationKick((CommandSender)player, nation, TownyAPI.getInstance().getTowns(names));
    }

    public static void nationKick(CommandSender sender, Nation nation, List<Town> kicking) {
        ArrayList<Town> remove = new ArrayList<Town>();
        for (Town town : kicking) {
            if (town.isCapital() || !nation.hasTown(town)) {
                remove.add(town);
                continue;
            }
            NationPreTownKickEvent event = new NationPreTownKickEvent(nation, town);
            if (BukkitTools.isEventCancelled(event)) {
                TownyMessaging.sendErrorMsg((Object)sender, event.getCancelMessage());
                remove.add(town);
                continue;
            }
            town.removeNation();
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_nation_kicked_by", sender.getName()));
            TownyMessaging.sendMsg(sender, Translatable.of("msg_nation_you_kicked", town.getName()));
        }
        for (Town town : remove) {
            kicking.remove(town);
        }
        if (kicking.size() > 0) {
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_kicked", sender.getName(), StringMgmt.join(kicking, ", ")));
            plugin.resetCache();
        } else {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_invalid_name"));
        }
    }

    public static void nationSanctionTown(CommandSender sender, Nation nation, String[] args) throws TownyException {
        if (args.length == 0 || args[0].equals("?")) {
            HelpMenu.NATION_SANCTIONTOWN.send(sender);
            return;
        }
        if (nation == null && sender instanceof Player) {
            Player player = (Player)sender;
            nation = NationCommand.getNationFromPlayerOrThrow(player);
        }
        if (nation == null) {
            throw new TownyException(Translatable.of("msg_err_no_nation_cannot_do"));
        }
        if (args[0].toLowerCase(Locale.ROOT).equals("list")) {
            if (args.length == 2) {
                nation = NationCommand.getNationOrThrow(args[1]);
            }
            NationCommand.nationSanctionTownList(sender, nation);
            return;
        }
        if (args.length != 2) {
            HelpMenu.NATION_SANCTIONTOWN.send(sender);
            return;
        }
        NationCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_SANCTIONTOWN.getNode());
        Town town = NationCommand.getTownOrThrow(args[1]);
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "add": {
                NationCommand.nationSanctionTownAdd(sender, nation, town);
                break;
            }
            case "remove": {
                NationCommand.nationSactionTownRemove(sender, nation, town);
                break;
            }
            default: {
                HelpMenu.NATION_SANCTIONTOWN.send(sender);
            }
        }
    }

    private static void nationSanctionTownList(CommandSender sender, Nation nation) {
        if (nation.getSanctionedTowns().isEmpty()) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_err_nation_has_no_sanctioned_towns"));
            return;
        }
        Translator translator = Translator.locale(sender);
        TownyMessaging.sendMessage((Object)sender, ChatTools.formatTitle(nation.getName() + " " + translator.of("title_nation_sanctioned_towns")));
        TownyMessaging.sendMessage((Object)sender, TownyFormatter.getFormattedTownyObjects(translator.of("title_nation_sanctioned_towns"), new ArrayList<TownyObject>(nation.getSanctionedTowns())));
    }

    private static void nationSanctionTownAdd(CommandSender sender, Nation nation, Town town) throws TownyException {
        if (nation.hasTown(town)) {
            throw new TownyException(Translatable.of("msg_err_nation_cannot_sanction_own_town"));
        }
        if (nation.hasSanctionedTown(town)) {
            throw new TownyException(Translatable.of("msg_err_nation_town_already_sanctioned"));
        }
        BukkitTools.ifCancelledThenThrow(new NationSanctionTownAddEvent(nation, town));
        nation.addSanctionedTown(town);
        nation.save();
        TownyMessaging.sendMsg(sender, Translatable.of("msg_err_nation_town_sanctioned", town.getName()));
    }

    private static void nationSactionTownRemove(CommandSender sender, Nation nation, Town town) throws TownyException {
        if (!nation.hasSanctionedTown(town)) {
            throw new TownyException(Translatable.of("msg_err_nation_town_isnt_sanctioned"));
        }
        BukkitTools.ifCancelledThenThrow(new NationSanctionTownRemoveEvent(nation, town));
        nation.removeSanctionedTown(town);
        nation.save();
        TownyMessaging.sendMsg(sender, Translatable.of("msg_err_nation_town_unsanctioned", town.getName()));
    }

    private void nationAlly(Player player, String[] split) throws TownyException {
        if (split.length == 0) {
            HelpMenu.ALLIES_STRING.send((CommandSender)player);
            return;
        }
        Resident resident = NationCommand.getResidentOrThrow(player);
        Nation nation = NationCommand.getNationFromResidentOrThrow(resident);
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "add": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY_ADD.getNode());
                this.nationAllyAdd(player, resident, nation, StringMgmt.remFirstArg(split));
                break;
            }
            case "remove": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY_REMOVE.getNode());
                this.nationAllyRemove(player, resident, nation, StringMgmt.remFirstArg(split));
                break;
            }
            case "sent": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY_LIST_SENT.getNode());
                this.nationAllySent(player, nation, StringMgmt.remFirstArg(split));
                break;
            }
            case "received": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY_LIST_RECEIVED.getNode());
                this.nationAllyReceived(player, nation, StringMgmt.remFirstArg(split));
                break;
            }
            case "accept": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY_ACCEPT.getNode());
                this.nationAllyAccept(player, nation, split);
                break;
            }
            case "deny": {
                NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY_DENY.getNode());
                this.nationAllyDeny(player, nation, split);
                break;
            }
            default: {
                HelpMenu.ALLIES_STRING.send((CommandSender)player);
            }
        }
    }

    private void nationAllyAdd(Player player, Resident resident, Nation nation, String[] names) throws TownyException {
        if (names.length == 0) {
            throw new TownyException(Translatable.of("msg_usage", "/n ally add [names]"));
        }
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        ArrayList<Nation> list = new ArrayList<Nation>();
        ArrayList<Nation> remlist = new ArrayList<Nation>();
        for (String name : names) {
            Nation ally = townyUniverse.getNation(name);
            if (ally != null) {
                if (nation.equals(ally)) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_own_nation_disallow"));
                    continue;
                }
                if (nation.isAlliedWith(ally)) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_already_ally", ally));
                    continue;
                }
                list.add(ally);
                continue;
            }
            if (name.startsWith("-")) {
                ally = townyUniverse.getNation(name.substring(1));
                if (ally != null) {
                    if (nation.equals(ally)) {
                        TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_own_nation_disallow"));
                        continue;
                    }
                    remlist.add(ally);
                    continue;
                }
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_name", name));
                continue;
            }
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_name", name));
        }
        if (!list.isEmpty()) {
            this.nationAddOrRemoveAlly(resident, nation, list, true);
        }
        if (!remlist.isEmpty()) {
            this.nationRemoveAllyRequest((CommandSender)player, nation, remlist);
        }
    }

    private void nationAllyRemove(Player player, Resident resident, Nation nation, String[] names) throws TownyException {
        if (names.length == 0) {
            throw new TownyException(Translatable.of("msg_usage", "/n ally add [names]"));
        }
        ArrayList<Nation> list = new ArrayList<Nation>();
        for (String name : names) {
            Nation ally = TownyUniverse.getInstance().getNation(name);
            if (ally == null) continue;
            if (nation.equals(ally)) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_own_nation_disallow"));
                continue;
            }
            if (!nation.isAlliedWith(ally)) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_nation_not_allied_with", ally.getName()));
                continue;
            }
            list.add(ally);
        }
        if (!list.isEmpty()) {
            this.nationAddOrRemoveAlly(resident, nation, list, false);
        }
    }

    private void nationAllySent(Player player, Nation nation, String[] split) {
        String sent = Translatable.of("nation_sent_ally_requests").forLocale((CommandSender)player).replace("%a", Integer.toString(nation.getSentAllyInvites().size())).replace("%m", Integer.toString(InviteHandler.getSentAllyRequestsMaxAmount(nation)));
        InviteCommand.sendInviteList(player, nation.getSentAllyInvites(), this.getPage(split, 0), true);
        TownyMessaging.sendMessage((Object)player, sent);
    }

    private void nationAllyReceived(Player player, Nation nation, String[] split) {
        String received = Translatable.of("nation_received_requests").forLocale((CommandSender)player).replace("%a", Integer.toString(nation.getReceivedInvites().size())).replace("%m", Integer.toString(InviteHandler.getReceivedInvitesMaxAmount(nation)));
        InviteCommand.sendInviteList(player, (List<Invite>)nation.getReceivedInvites(), this.getPage(split, 0), false);
        TownyMessaging.sendMessage((Object)player, received);
    }

    private void nationAllyAccept(Player player, Nation nation, String[] split) throws TownyException {
        Nation sendernation;
        Collection invites = nation.getReceivedInvites();
        if (invites.size() == 0) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_nation_no_requests"));
            return;
        }
        if (split.length >= 2) {
            sendernation = TownyUniverse.getInstance().getNation(split[1]);
            if (sendernation == null) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_invalid_name"));
                return;
            }
        } else {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_nation_specify_invite"));
            InviteCommand.sendInviteList(player, (List<Invite>)invites, 1, false);
            return;
        }
        Invite toAccept = null;
        for (Invite invite : InviteHandler.getActiveInvites()) {
            if (!invite.getSender().equals(sendernation) || !invite.getReceiver().equals(nation)) continue;
            toAccept = invite;
            break;
        }
        if (toAccept != null) {
            if (nation.hasReachedMaximumAllies()) {
                toAccept.getReceiver().deleteReceivedInvite(toAccept);
                toAccept.getSender().deleteSentInvite(toAccept);
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_ally_limit_reached"));
                return;
            }
            if (sendernation.hasReachedMaximumAllies()) {
                toAccept.getReceiver().deleteReceivedInvite(toAccept);
                toAccept.getSender().deleteSentInvite(toAccept);
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_ally_limit_reached_cannot_accept", sendernation));
                return;
            }
            try {
                NationAcceptAllyRequestEvent acceptAllyRequestEvent = new NationAcceptAllyRequestEvent((Nation)toAccept.getSender(), (Nation)toAccept.getReceiver());
                if (BukkitTools.isEventCancelled(acceptAllyRequestEvent)) {
                    toAccept.getReceiver().deleteReceivedInvite(toAccept);
                    toAccept.getSender().deleteSentInvite(toAccept);
                    TownyMessaging.sendErrorMsg(player, acceptAllyRequestEvent.getCancelMessage());
                    return;
                }
                InviteHandler.acceptInvite(toAccept);
            }
            catch (InvalidObjectException e) {
                plugin.getLogger().log(Level.WARNING, "unknown exception occurred while accepting invite", e);
            }
        }
    }

    private void nationAllyDeny(Player player, Nation nation, String[] split) {
        Nation sendernation;
        Collection invites = nation.getReceivedInvites();
        if (invites.size() == 0) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_nation_no_requests"));
            return;
        }
        if (split.length >= 2) {
            sendernation = TownyUniverse.getInstance().getNation(split[1]);
            if (sendernation == null) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_invalid_name"));
                return;
            }
        } else {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_nation_specify_invite"));
            InviteCommand.sendInviteList(player, (List<Invite>)invites, 1, false);
            return;
        }
        Invite toDecline = null;
        for (Invite invite : InviteHandler.getActiveInvites()) {
            if (!invite.getSender().equals(sendernation) || !invite.getReceiver().equals(nation)) continue;
            toDecline = invite;
            break;
        }
        if (toDecline != null) {
            try {
                NationDenyAllyRequestEvent denyAllyRequestEvent = new NationDenyAllyRequestEvent(nation, sendernation);
                if (BukkitTools.isEventCancelled(denyAllyRequestEvent)) {
                    sendernation.deleteSentAllyInvite(toDecline);
                    nation.deleteReceivedInvite(toDecline);
                    TownyMessaging.sendErrorMsg(player, denyAllyRequestEvent.getCancelMessage());
                    return;
                }
                InviteHandler.declineInvite(toDecline, false);
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("successful_deny_request"));
            }
            catch (InvalidObjectException e) {
                plugin.getLogger().log(Level.WARNING, "unknown exception occurred while declining invite", e);
            }
        }
    }

    private void nationRemoveAllyRequest(CommandSender sender, Nation invitingNation, ArrayList<Nation> remlist) {
        block2: for (Nation invitedNation : remlist) {
            if (!InviteHandler.inviteIsActive(invitingNation, invitedNation)) continue;
            for (Invite receivedInvite : invitedNation.getReceivedInvites()) {
                if (!receivedInvite.getSender().equals(invitingNation)) continue;
                try {
                    InviteHandler.declineInvite(receivedInvite, true);
                    TownyMessaging.sendMsg(sender, Translatable.of("nation_revoke_ally_successful"));
                    continue block2;
                }
                catch (InvalidObjectException e) {
                    plugin.getLogger().log(Level.WARNING, "An exception occurred while revoking invites for nation " + invitedNation.getName(), e);
                }
            }
        }
    }

    public void nationAddOrRemoveAlly(Resident resident, Nation nation, List<Nation> targetNations, boolean add) throws TownyException {
        ArrayList<Nation> remove = new ArrayList<Nation>();
        for (Nation targetNation : targetNations) {
            if (add) {
                try {
                    this.nationAddAlly(resident, nation, targetNation);
                }
                catch (TownyException e) {
                    TownyMessaging.sendErrorMsg(resident, e.getMessage());
                    remove.add(targetNation);
                }
                continue;
            }
            try {
                this.nationRemoveAlly(resident, nation, targetNation);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg(resident, e.getMessage());
                remove.add(targetNation);
            }
        }
        for (Nation removedNation : remove) {
            targetNations.remove(removedNation);
        }
        if (targetNations.size() > 0) {
            TownyUniverse.getInstance().getDataSource().saveNations();
            plugin.resetCache();
        }
    }

    private void nationAddAlly(Resident resident, Nation nation, Nation targetNation) throws TownyException {
        Player player = resident.getPlayer();
        if (player == null) {
            throw new TownyException("Could not add " + String.valueOf(targetNation) + " as Ally because your Player is null! This shouldn't be possible!");
        }
        if (nation.hasAlly(targetNation)) {
            throw new TownyException(Translatable.of("msg_already_ally", targetNation));
        }
        if (nation.hasReachedMaximumAllies()) {
            throw new TownyException(Translatable.of("msg_err_ally_limit_reached_cannot_send", targetNation));
        }
        if (targetNation.hasReachedMaximumAllies()) {
            throw new TownyException(Translatable.of("msg_err_ally_limit_reached_cannot_send_targetNation", targetNation, targetNation));
        }
        if (!targetNation.hasEnemy(nation)) {
            BukkitTools.ifCancelledThenThrow(new NationPreAddAllyEvent(nation, targetNation));
            if (!targetNation.getCapital().getMayor().isNPC()) {
                this.nationCreateAllyRequest((CommandSender)player, nation, targetNation);
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_ally_req_sent", targetNation));
            } else {
                this.nationAddNPCNationAsAlly(player, resident, nation, targetNation);
            }
        } else {
            throw new TownyException(Translatable.of("msg_unable_ally_enemy", targetNation));
        }
    }

    private void nationCreateAllyRequest(CommandSender sender, Nation sendingNation, Nation receivingNation) throws TownyException {
        NationAllyNationInvite invite = new NationAllyNationInvite(sender, receivingNation, sendingNation);
        try {
            if (!InviteHandler.inviteIsActive(invite)) {
                receivingNation.newReceivedInvite(invite);
                sendingNation.newSentAllyInvite(invite);
                InviteHandler.addInvite(invite);
                Player king = receivingNation.getKing().getPlayer();
                if (king != null) {
                    TownyMessaging.sendRequestMessage((CommandSender)king, invite);
                }
                for (Player player : TownyAPI.getInstance().getOnlinePlayers(receivingNation)) {
                    if (player.getUniqueId().equals(receivingNation.getKing().getUUID()) || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_ALLY_ACCEPT.getNode())) continue;
                    TownyMessaging.sendRequestMessage((CommandSender)player, invite);
                }
            } else {
                throw new TownyException(Translatable.of("msg_err_ally_already_requested", receivingNation));
            }
            BukkitTools.fireEvent(new NationRequestAllyNationEvent(invite));
        }
        catch (TooManyInvitesException e) {
            receivingNation.deleteReceivedInvite(invite);
            sendingNation.deleteSentAllyInvite(invite);
            throw new TownyException(e.getMessage());
        }
    }

    private void nationAddNPCNationAsAlly(Player player, Resident resident, Nation nation, Nation targetNation) throws TownyException {
        if (!TownyUniverse.getInstance().getPermissionSource().isTownyAdmin((Permissible)player)) {
            throw new TownyException(Translatable.of("msg_unable_ally_npc", nation.getName()));
        }
        targetNation.addAlly(nation);
        nation.addAlly(targetNation);
        TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_allied_nations", resident, targetNation));
        TownyMessaging.sendPrefixedNationMessage(targetNation, Translatable.of("msg_added_ally", nation));
    }

    private void nationRemoveAlly(Resident resident, Nation nation, Nation targetNation) throws TownyException {
        if (nation.hasAlly(targetNation)) {
            BukkitTools.ifCancelledThenThrow(new NationRemoveAllyEvent(nation, targetNation));
            nation.removeAlly(targetNation);
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_removed_ally", targetNation));
            TownyMessaging.sendMsg(resident, Translatable.of("msg_ally_removed_successfully"));
            if (targetNation.hasAlly(nation)) {
                BukkitTools.ifCancelledThenThrow(new NationRemoveAllyEvent(targetNation, nation));
                targetNation.removeAlly(nation);
                TownyMessaging.sendPrefixedNationMessage(targetNation, Translatable.of("msg_removed_ally", nation.getName()));
            }
        }
    }

    public void nationEnemy(Player player, String[] split) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg(player, "Eg: /nation enemy [add/remove] [name]");
            return;
        }
        Resident resident = NationCommand.getResidentOrThrow(player);
        Nation nation = NationCommand.getNationFromResidentOrThrow(resident);
        ArrayList<Nation> list = new ArrayList<Nation>();
        String test = split[0];
        String[] newSplit = StringMgmt.remFirstArg(split);
        boolean add = test.equalsIgnoreCase("add");
        if ((test.equalsIgnoreCase("remove") || test.equalsIgnoreCase("add")) && newSplit.length > 0) {
            for (String name : newSplit) {
                Nation enemy = townyUniverse.getNation(name);
                if (enemy == null) {
                    throw new TownyException(Translatable.of("msg_err_no_nation_with_that_name", name));
                }
                if (nation.equals(enemy)) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_own_nation_disallow"));
                    continue;
                }
                if (add && nation.hasEnemy(enemy)) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_nation_already_enemies_with", enemy.getName()));
                    continue;
                }
                if (!add && !nation.hasEnemy(enemy)) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_nation_not_enemies_with", enemy.getName()));
                    continue;
                }
                list.add(enemy);
            }
            if (!list.isEmpty()) {
                this.nationEnemy(player, nation, list, add);
            }
        } else {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_property", "[add/remove]"));
        }
    }

    public void nationEnemy(Player player, Nation nation, List<Nation> enemies, boolean add) {
        ArrayList<Nation> remove = new ArrayList<Nation>();
        for (Nation targetNation : enemies) {
            if (add) {
                if (!nation.getEnemies().contains(targetNation)) {
                    NationPreAddEnemyEvent npaee = new NationPreAddEnemyEvent(nation, targetNation);
                    if (BukkitTools.isEventCancelled(npaee)) {
                        TownyMessaging.sendErrorMsg(player, npaee.getCancelMessage());
                        remove.add(targetNation);
                        continue;
                    }
                    nation.addEnemy(targetNation);
                    BukkitTools.fireEvent(new NationAddEnemyEvent(nation, targetNation));
                    if (nation.hasAlly(targetNation)) {
                        nation.removeAlly(targetNation);
                        BukkitTools.fireEvent(new NationRemoveAllyEvent(nation, targetNation));
                        TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_removed_ally", targetNation));
                        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_ally_removed_successfully"));
                    }
                    if (targetNation.hasAlly(nation)) {
                        targetNation.removeAlly(nation);
                        BukkitTools.fireEvent(new NationRemoveAllyEvent(targetNation, nation));
                        TownyMessaging.sendPrefixedNationMessage(targetNation, Translatable.of("msg_removed_ally", nation));
                        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_ally_removed_successfully"));
                    }
                    TownyMessaging.sendPrefixedNationMessage(targetNation, Translatable.of("msg_added_enemy", nation));
                } else {
                    remove.add(targetNation);
                }
            }
            if (add) continue;
            if (nation.getEnemies().contains(targetNation)) {
                NationPreRemoveEnemyEvent npree = new NationPreRemoveEnemyEvent(nation, targetNation);
                if (BukkitTools.isEventCancelled(npree)) {
                    TownyMessaging.sendErrorMsg(player, npree.getCancelMessage());
                    remove.add(targetNation);
                    continue;
                }
                nation.removeEnemy(targetNation);
                BukkitTools.fireEvent(new NationRemoveEnemyEvent(nation, targetNation));
                TownyMessaging.sendPrefixedNationMessage(targetNation, Translatable.of("msg_removed_enemy", nation));
                continue;
            }
            remove.add(targetNation);
        }
        for (Nation newEnemy : remove) {
            enemies.remove(newEnemy);
        }
        if (enemies.size() > 0) {
            Object msg = "";
            for (Nation newEnemy : enemies) {
                msg = (String)msg + newEnemy.getName() + ", ";
            }
            msg = ((String)msg).substring(0, ((String)msg).length() - 2);
            if (add) {
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_enemy_nations", player.getName(), msg));
            } else {
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_enemy_to_neutral", player.getName(), msg));
            }
            TownyUniverse.getInstance().getDataSource().saveNations();
            plugin.resetCache();
        } else {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_invalid_name"));
        }
    }

    public static void nationSet(CommandSender sender, String[] split, boolean admin, Nation nation) throws TownyException {
        Resident resident;
        if (split.length == 0) {
            HelpMenu.NATION_SET.send(sender);
            return;
        }
        try {
            if (!admin && sender instanceof Player) {
                Player player = (Player)sender;
                resident = NationCommand.getResidentOrThrow(player);
                nation = NationCommand.getNationFromResidentOrThrow(resident);
            } else {
                resident = nation.getKing();
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)sender, x.getMessage(sender));
            return;
        }
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "leader": 
            case "king": {
                NationCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_SET_KING.getNode());
                NationCommand.nationSetKing(sender, nation, split, admin);
                break;
            }
            case "capital": {
                NationCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_SET_CAPITAL.getNode());
                NationCommand.nationSetCapital(sender, nation, split, admin);
                break;
            }
            case "spawn": {
                Player player = NationCommand.catchConsole(sender);
                NationCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_SET_SPAWN.getNode());
                NationCommand.parseNationSetSpawnCommand(player, nation, admin);
                break;
            }
            case "taxes": {
                NationCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_SET_TAXES.getNode());
                NationCommand.nationSetTaxes(sender, nation, split, admin);
                break;
            }
            case "taxpercentcap": {
                NationCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_SET_TAXPERCENTCAP.getNode());
                NationCommand.nationSetTaxPercentCap(sender, split, nation);
                break;
            }
            case "conqueredtax": {
                NationCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_SET_CONQUEREDTAX.getNode());
                NationCommand.nationSetConqueredTax(sender, split, nation);
                break;
            }
            case "spawncost": {
                NationCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_SET_SPAWNCOST.getNode());
                NationCommand.nationSetSpawnCost(sender, nation, split, admin);
                break;
            }
            case "name": {
                NationCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_SET_NAME.getNode());
                NationCommand.nationSetName(sender, nation, split, admin);
                break;
            }
            case "tag": {
                NationCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_SET_TAG.getNode());
                NationCommand.nationSetTag(sender, nation, split, admin);
                break;
            }
            case "title": {
                NationCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_SET_TITLE.getNode());
                NationCommand.nationSetTitle(sender, nation, resident, split, admin);
                break;
            }
            case "surname": {
                NationCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_SET_SURNAME.getNode());
                NationCommand.nationSetSurname(sender, nation, resident, split, admin);
                break;
            }
            case "board": {
                NationCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_SET_BOARD.getNode());
                NationCommand.nationSetBoard(sender, nation, StringMgmt.join(StringMgmt.remFirstArg(split), " "));
                break;
            }
            case "mapcolor": {
                NationCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_SET_MAPCOLOR.getNode());
                NationCommand.nationSetMapColor(sender, nation, split, admin);
                break;
            }
            default: {
                if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.NATION_SET, split[0])) {
                    TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.NATION_SET, split[0]).execute(sender, "nation", split);
                    return;
                }
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_property", split[0]));
                return;
            }
        }
        nation.save();
    }

    private static void nationSetMapColor(CommandSender sender, Nation nation, String[] split, boolean admin) throws TownyException {
        if (split.length < 2) {
            throw new TownyException("Eg: /nation set mapcolor brown.");
        }
        String color = StringMgmt.join(StringMgmt.remFirstArg(split), " ").toLowerCase(Locale.ROOT);
        if (!TownySettings.getNationColorsMap().containsKey(color)) {
            throw new TownyException(Translatable.of("msg_err_invalid_nation_map_color", TownySettings.getNationColorsMap().keySet().toString()));
        }
        double cost = TownySettings.getNationSetMapColourCost();
        if (cost > 0.0) {
            Confirmation.runOnAccept(() -> NationCommand.setNationMapColor(nation, color, admin, sender)).setTitle(Translatable.of("msg_confirm_purchase", NationCommand.prettyMoney(cost))).setCost(new ConfirmationTransaction(() -> cost, nation, "Cost of setting nation map color.")).sendTo(sender);
        } else {
            NationCommand.setNationMapColor(nation, color, admin, sender);
        }
    }

    private static void setNationMapColor(Nation nation, String color, boolean admin, CommandSender sender) {
        nation.setMapColorHexCode(TownySettings.getNationColorsMap().get(color));
        nation.save();
        TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_map_color_changed", color));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_nation_map_color_changed", color));
        }
    }

    private static void nationSetBoard(CommandSender sender, Nation nation, String board) throws TownyException {
        if (board.isEmpty()) {
            throw new TownyException("Eg: /nation set board " + Translatable.of("town_help_9").forLocale(sender));
        }
        if (board.equalsIgnoreCase("reset")) {
            board = TownySettings.getNationDefaultBoard();
            TownyMessaging.sendMsg(sender, Translatable.of("msg_nation_board_reset"));
        } else if (board.equals("none")) {
            board = "";
        } else {
            if (!NameValidation.isValidBoardString(board)) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_string_nationboard_not_set"));
                return;
            }
            if (board.length() > TownySettings.getMaxBoardLength()) {
                board = board.substring(0, TownySettings.getMaxBoardLength());
            }
        }
        nation.setBoard(board);
        TownyMessaging.sendNationBoard(sender, nation);
    }

    private static void nationSetSurname(CommandSender sender, Nation nation, Resident resident, String[] split, boolean admin) throws TownyException {
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)sender, "Eg: /nation set surname bilbo the dwarf ");
        } else {
            resident = NationCommand.getResidentOrThrow(split[1]);
        }
        if (!nation.hasResident(resident)) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_not_same_nation", resident.getName()));
            return;
        }
        String surname = NameValidation.checkAndFilterTitlesSurnameOrThrow(StringMgmt.remArgs(split, 2));
        if (TownySettings.doesSenderRequirePermissionNodeToAddColourToTitleOrSurname() && Colors.containsColourCode(surname)) {
            NationCommand.checkPermOrThrowWithMessage((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_SET_TITLE_COLOUR.getNode(), Translatable.of("msg_err_you_dont_have_permission_to_use_colours"));
        }
        resident.setSurname(surname);
        resident.save();
        if (resident.hasSurname()) {
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_set_surname", resident.getName(), Colors.translateColorCodes(resident.getSurname())));
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_set_surname", resident.getName(), Colors.translateColorCodes(resident.getSurname())));
            }
        } else {
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_clear_title_surname", "Surname", resident.getName()));
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_clear_title_surname", "Surname", resident.getName()));
            }
        }
    }

    private static void nationSetTitle(CommandSender sender, Nation nation, Resident resident, String[] split, boolean admin) throws TownyException {
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)sender, "Eg: /nation set title bilbo Jester ");
        } else {
            resident = NationCommand.getResidentOrThrow(split[1]);
        }
        if (!nation.hasResident(resident)) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_not_same_nation", resident.getName()));
            return;
        }
        String title = NameValidation.checkAndFilterTitlesSurnameOrThrow(StringMgmt.remArgs(split, 2));
        if (TownySettings.doesSenderRequirePermissionNodeToAddColourToTitleOrSurname() && Colors.containsColourCode(title)) {
            NationCommand.checkPermOrThrowWithMessage((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_SET_TITLE_COLOUR.getNode(), Translatable.of("msg_err_you_dont_have_permission_to_use_colours"));
        }
        resident.setTitle(title);
        resident.save();
        if (resident.hasTitle()) {
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_set_title", resident.getName(), Colors.translateColorCodes(resident.getTitle())));
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_set_title", resident.getName(), Colors.translateColorCodes(resident.getTitle())));
            }
        } else {
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_clear_title_surname", "Title", resident.getName()));
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_clear_title_surname", "Title", resident.getName()));
            }
        }
    }

    private static void nationSetTag(CommandSender sender, Nation nation, String[] split, boolean admin) throws TownyException {
        String name;
        String string = name = sender instanceof Player ? sender.getName() : "Console";
        if (split.length < 2) {
            throw new TownyException("Eg: /nation set tag PLT");
        }
        if (split[1].equalsIgnoreCase("clear")) {
            nation.setTag(" ");
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_reset_nation_tag", name));
        } else {
            String tag = NameValidation.checkAndFilterTagOrThrow(split[1]);
            nation.setTag(tag);
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_set_nation_tag", name, nation.getTag()));
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_set_nation_tag", name, nation.getTag()));
            }
        }
    }

    private static void nationSetName(CommandSender sender, Nation nation, String[] split, boolean admin) throws TownyException {
        if (admin || !(sender instanceof Player)) {
            throw new TownyException("Use /ta nation [nation] rename");
        }
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)sender, "Eg: /nation set name Plutoria");
        } else {
            String name = String.join((CharSequence)"_", StringMgmt.remFirstArg(split));
            name = NameValidation.checkAndFilterGovernmentNameOrThrow(name, nation);
            if (TownyUniverse.getInstance().hasNation(name)) {
                throw new TownyException(Translatable.of("msg_err_name_validation_name_already_in_use", name));
            }
            if (TownySettings.getTownAutomaticCapitalisationEnabled()) {
                name = StringMgmt.capitalizeStrings(name);
            }
            if (TownyEconomyHandler.isActive() && TownySettings.getNationRenameCost() > 0.0) {
                if (!nation.getAccount().canPayFromHoldings(TownySettings.getNationRenameCost())) {
                    throw new TownyException(Translatable.of("msg_err_no_money", TownyEconomyHandler.getFormattedBalance(TownySettings.getNationRenameCost())));
                }
                Nation finalNation = nation;
                String finalName = name;
                Confirmation.runOnAccept(() -> NationCommand.nationRename((Player)sender, finalNation, finalName)).setTitle(Translatable.of("msg_confirm_purchase", TownyEconomyHandler.getFormattedBalance(TownySettings.getNationRenameCost()))).sendTo(sender);
            } else {
                NationCommand.nationRename((Player)sender, nation, name);
            }
        }
    }

    private static void nationSetSpawnCost(CommandSender sender, Nation nation, String[] split, boolean admin) throws TownyException {
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)sender, "Eg: /nation set spawncost 70");
        } else {
            double amount = MoneyUtil.getMoneyAboveZeroOrThrow(split[1]);
            if (TownySettings.getSpawnTravelCost() < amount) {
                throw new TownyException(Translatable.of("msg_err_cannot_set_spawn_cost_more_than", TownySettings.getSpawnTravelCost()));
            }
            nation.setSpawnCost(amount);
            String name = sender instanceof Player ? sender.getName() : "Console";
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_spawn_cost_set_to", name, Translatable.of("nation_sing"), split[1]));
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_spawn_cost_set_to", name, Translatable.of("nation_sing"), split[1]));
            }
        }
    }

    private static void nationSetTaxes(CommandSender sender, Nation nation, String[] split, boolean admin) throws TownyException {
        if (split.length < 2) {
            throw new TownyException("Eg: /nation set taxes 70");
        }
        Double amount = MathUtil.getDoubleOrThrow(split[1]);
        if (amount < 0.0 && !TownySettings.isNegativeNationTaxAllowed()) {
            throw new TownyException(Translatable.of("msg_err_negative_money"));
        }
        if (nation.isTaxPercentage() && (amount > 100.0 || amount < 0.0)) {
            throw new TownyException(Translatable.of("msg_err_not_percentage"));
        }
        if (!TownySettings.isNegativeNationTaxAllowed() && TownySettings.getNationDefaultTaxMinimumTax() > amount) {
            throw new TownyException(Translatable.of("msg_err_tax_minimum_not_met", TownySettings.getNationDefaultTaxMinimumTax()));
        }
        nation.setTaxes(amount);
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_town_set_nation_tax", sender.getName(), nation.getTaxes()));
        }
        TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_town_set_nation_tax", sender.getName(), nation.getTaxes()));
    }

    public static void nationSetTaxPercentCap(CommandSender sender, String[] split, Nation nation) throws TownyException {
        if (!nation.isTaxPercentage()) {
            throw new TownyException(Translatable.of("msg_max_tax_amount_only_for_percent"));
        }
        if (split.length < 2) {
            throw new TownyException("Eg. /nation set taxpercentcap 10000");
        }
        nation.setMaxPercentTaxAmount(MathUtil.getPositiveIntOrThrow(split[1]));
        TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_town_set_tax_max_percent_amount", sender.getName(), TownyEconomyHandler.getFormattedBalance(nation.getMaxPercentTaxAmount())));
    }

    public static void nationSetConqueredTax(CommandSender sender, String[] split, Nation nation) throws TownyException {
        double max;
        if (split.length < 2) {
            throw new TownyException("Eg. /nation set conqueredtax 10000");
        }
        double input = MathUtil.getPositiveIntOrThrow(split[1]);
        if (input > (max = TownySettings.getMaxNationConqueredTaxAmount())) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_cannot_set_nation_conquere_tax_amount_higher_than", TownyEconomyHandler.getFormattedBalance(max)));
        }
        nation.setConqueredTax(Math.min(input, max));
        TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_set_conquered_tax__amount_set", sender.getName(), TownyEconomyHandler.getFormattedBalance(nation.getConqueredTax())));
    }

    private static void nationSetCapital(CommandSender sender, Nation nation, String[] split, boolean admin) throws TownyException {
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)sender, "Eg: /nation set capital {town name}");
            return;
        }
        Town newCapital = NationCommand.getTownOrThrow(split[1]);
        NationCommand.changeNationOwnership(sender, nation, newCapital, admin);
    }

    private static void changeNationOwnership(CommandSender sender, Nation nation, Town newCapital, boolean admin) throws TownyException {
        boolean capitalTooManyResidents;
        boolean capitalNotEnoughResidents;
        Nation newCapitalNation = newCapital.getNationOrNull();
        if (newCapitalNation == null) {
            if (admin) {
                newCapital.setNation(nation);
            } else {
                throw new TownyException(Translatable.of("msg_err_not_same_nation", nation));
            }
        }
        if (!nation.equals(newCapitalNation)) {
            throw new TownyException(Translatable.of("msg_err_not_same_nation", nation));
        }
        Town existingCapital = nation.getCapital();
        if (existingCapital != null && existingCapital.getUUID().equals(newCapital.getUUID())) {
            throw new TownyException(Translatable.of("msg_warn_town_already_capital", newCapital.getName()));
        }
        boolean bl = capitalNotEnoughResidents = !newCapital.hasEnoughResidentsToBeANationCapital();
        if (capitalNotEnoughResidents && !admin) {
            throw new TownyException(Translatable.of("msg_not_enough_residents_capital", newCapital.getName()));
        }
        boolean bl2 = capitalTooManyResidents = !existingCapital.isAllowedThisAmountOfResidents(existingCapital.getNumResidents(), false);
        if (capitalTooManyResidents && !admin) {
            throw new TownyException(Translatable.of("msg_err_nation_capital_too_many_residents", newCapital.getName()));
        }
        Runnable processCommand = () -> {
            List<Town> removedTowns;
            Resident oldKing = nation.getKing();
            Resident newKing = newCapital.getMayor();
            NationKingChangeEvent nationKingChangeEvent = new NationKingChangeEvent(oldKing, newKing);
            if (TownySettings.getNationProximityToCapital() > 0.0 && !(removedTowns = ProximityUtil.gatherOutOfRangeTowns(nation, newCapital)).isEmpty()) {
                Confirmation.runOnAccept(() -> {
                    if (BukkitTools.isEventCancelled(nationKingChangeEvent) && !admin) {
                        TownyMessaging.sendErrorMsg((Object)sender, nationKingChangeEvent.getCancelMessage());
                        return;
                    }
                    nation.setCapital(newCapital);
                    ProximityUtil.removeOutOfRangeTowns(nation);
                    plugin.resetCache();
                    TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_new_king", newCapital.getMayor().getName(), nation.getName()));
                    if (admin) {
                        TownyMessaging.sendMsg(sender, Translatable.of("msg_new_king", newCapital.getMayor().getName(), nation.getName()));
                    }
                    nation.save();
                }).setTitle(Translatable.of("msg_warn_the_following_towns_will_be_removed_from_your_nation", StringMgmt.join(removedTowns, ", "))).sendTo(sender);
                return;
            }
            Confirmation.runOnAccept(() -> {
                if (BukkitTools.isEventCancelled(nationKingChangeEvent) && !admin) {
                    TownyMessaging.sendErrorMsg((Object)sender, nationKingChangeEvent.getCancelMessage());
                    return;
                }
                nation.setCapital(newCapital);
                plugin.resetCache();
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_new_king", newCapital.getMayor().getName(), nation.getName()));
                if (admin) {
                    TownyMessaging.sendMsg(sender, Translatable.of("msg_new_king", newCapital.getMayor().getName(), nation.getName()));
                }
                nation.save();
            }).setTitle(Translatable.of("msg_warn_are_you_sure_you_want_to_transfer_nation_ownership", newCapital.getMayor().getName())).sendTo(sender);
        };
        if (capitalNotEnoughResidents || capitalTooManyResidents) {
            Confirmation.runOnAccept(processCommand).setTitle(Translatable.of("msg_warn_overriding_server_config")).sendTo(sender);
        } else {
            processCommand.run();
        }
    }

    private static void nationSetKing(CommandSender sender, Nation nation, String[] split, boolean admin) {
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)sender, "Eg: /nation set leader Dumbo");
        } else {
            try {
                Resident newKing = NationCommand.getResidentOrThrow(split[1]);
                if (!nation.hasResident(newKing)) {
                    throw new TownyException(Translatable.of("msg_err_king_not_in_nation"));
                }
                if (!newKing.isMayor()) {
                    throw new TownyException(Translatable.of("msg_err_new_king_notmayor"));
                }
                NationCommand.changeNationOwnership(sender, nation, NationCommand.getResidentOrThrow(split[1]).getTown(), admin);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
            }
        }
    }

    private static void parseNationSetSpawnCommand(Player player, Nation nation, boolean admin) throws TownyException {
        if (TownyAPI.getInstance().isWilderness(player.getLocation())) {
            throw new TownyException(Translatable.of("msg_cache_block_error_wild", "set spawn"));
        }
        NationSetSpawnEvent event = new NationSetSpawnEvent(nation, player, player.getLocation());
        if (BukkitTools.isEventCancelled(event) && !admin) {
            throw new TownyException(event.getCancelMessage());
        }
        Location newSpawn = admin ? player.getLocation() : event.getNewSpawn();
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(newSpawn);
        Town town = townBlock.getTownOrNull();
        if (nation.getCapital() != null && TownySettings.isNationSpawnOnlyAllowedInCapital() && !town.getUUID().equals(nation.getCapital().getUUID())) {
            throw new TownyException(Translatable.of("msg_err_spawn_not_within_capital"));
        }
        if (!nation.getTowns().contains(town)) {
            throw new TownyException(Translatable.of("msg_err_spawn_not_within_nationtowns"));
        }
        if (nation.hasSpawn()) {
            TownyUniverse.getInstance().removeSpawnPoint(nation.getSpawn());
        }
        nation.setSpawn(newSpawn);
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_set_nation_spawn"));
    }

    private static void parseNationBaltop(Player player, Nation nation) {
        plugin.getScheduler().runAsync(() -> {
            StringBuilder sb = new StringBuilder();
            ArrayList<Resident> residents = new ArrayList<Resident>(nation.getResidents());
            residents.sort(Comparator.comparingDouble(res -> res.getAccount().getCachedBalance()).reversed());
            int i = 0;
            for (Resident res2 : residents) {
                sb.append(Translatable.of("msg_baltop_book_format", ++i, res2.getName(), TownyEconomyHandler.getFormattedBalance(res2.getAccount().getCachedBalance())).forLocale((CommandSender)player) + "\n");
            }
            plugin.getScheduler().run((Entity)player, () -> player.openBook(BookFactory.makeBook("Nation Baltop", nation.getName(), sb.toString())));
        });
    }

    public static void nationToggle(CommandSender sender, String[] split, boolean admin, Nation nation) throws TownyException {
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.NATION_TOGGLE_HELP.send(sender);
            return;
        }
        if (!admin) {
            Resident resident = NationCommand.getResidentOrThrow((Player)sender);
            nation = NationCommand.getNationFromResidentOrThrow(resident);
        } else {
            Resident resident = nation.getKing();
        }
        Optional<Boolean> choice = Optional.empty();
        if (split.length == 2) {
            choice = BaseCommand.parseToggleChoice(split[1]);
        }
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "peaceful": 
            case "neutral": {
                NationCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_TOGGLE_NEUTRAL.getNode());
                NationCommand.nationTogglePeaceful(sender, nation, choice, admin);
                break;
            }
            case "public": {
                NationCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_TOGGLE_PUBLIC.getNode());
                NationCommand.nationTogglePublic(sender, nation, choice, admin);
                break;
            }
            case "open": {
                NationCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_TOGGLE_OPEN.getNode());
                NationCommand.nationToggleOpen(sender, nation, choice, admin);
                break;
            }
            case "taxpercent": {
                NationCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_TOGGLE_TAXPERCENT.getNode());
                NationCommand.nationToggleTaxPercent(sender, nation, choice, admin);
                break;
            }
            default: {
                if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.NATION_TOGGLE, split[0])) {
                    TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.NATION_TOGGLE, split[0]).execute(sender, "nation", split);
                    return;
                }
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_property", split[0]));
                return;
            }
        }
        nation.save();
    }

    private static void nationTogglePeaceful(CommandSender sender, Nation nation, Optional<Boolean> choice, boolean admin) throws TownyException {
        boolean peacefulState = choice.orElse(!nation.isNeutral());
        double cost = TownySettings.getNationNeutralityCost(nation);
        if (nation.isNeutral() && peacefulState) {
            throw new TownyException(Translatable.of("msg_nation_already_peaceful"));
        }
        if (!nation.isNeutral() && !peacefulState) {
            throw new TownyException(Translatable.of("msg_nation_already_not_peaceful"));
        }
        if (peacefulState && TownyEconomyHandler.isActive() && !nation.getAccount().canPayFromHoldings(cost)) {
            throw new TownyException(Translatable.of("msg_nation_cant_peaceful", TownyEconomyHandler.getFormattedBalance(cost)));
        }
        String uuid = nation.getUUID().toString();
        if (TownySettings.getPeacefulCoolDownTime() > 0 && !admin && CooldownTimerTask.hasCooldown(uuid, CooldownTimerTask.CooldownType.NEUTRALITY) && !TownyUniverse.getInstance().getPermissionSource().isTownyAdmin((Permissible)sender)) {
            throw new TownyException(Translatable.of("msg_err_cannot_toggle_neutral_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(uuid, CooldownTimerTask.CooldownType.NEUTRALITY)));
        }
        NationToggleNeutralEvent preEvent = new NationToggleNeutralEvent(sender, nation, admin, peacefulState);
        if (BukkitTools.isEventCancelled(preEvent)) {
            throw new TownyException(preEvent.getCancelMessage());
        }
        if (peacefulState && TownyEconomyHandler.isActive() && cost > 0.0) {
            nation.getAccount().withdraw(cost, "Peaceful Nation Cost");
            TownyMessaging.sendMsg(sender, Translatable.of("msg_you_paid", TownyEconomyHandler.getFormattedBalance(cost)));
        }
        nation.setNeutral(peacefulState);
        TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_peaceful").append(nation.isNeutral() ? "\u00a72" : "\u00a74 not").append(" peaceful."));
        if (TownySettings.getPeacefulCoolDownTime() > 0 && !admin && !TownyUniverse.getInstance().getPermissionSource().isTownyAdmin((Permissible)sender)) {
            CooldownTimerTask.addCooldownTimer(uuid, CooldownTimerTask.CooldownType.NEUTRALITY);
        }
        if (TownyPerms.hasPeacefulNodes()) {
            TownyPerms.updateNationPerms(nation);
        }
    }

    private static void nationTogglePublic(CommandSender sender, Nation nation, Optional<Boolean> choice, boolean admin) throws TownyException {
        NationTogglePublicEvent preEvent = new NationTogglePublicEvent(sender, nation, admin, choice.orElse(!nation.isPublic()));
        if (BukkitTools.isEventCancelled(preEvent)) {
            throw new TownyException(preEvent.getCancelMessage());
        }
        nation.setPublic(preEvent.getFutureState());
        TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_changed_public", nation.isPublic() ? Translatable.of("enabled") : Translatable.of("disabled")));
    }

    private static void nationToggleOpen(CommandSender sender, Nation nation, Optional<Boolean> choice, boolean admin) throws TownyException {
        NationToggleOpenEvent preEvent = new NationToggleOpenEvent(sender, nation, admin, choice.orElse(!nation.isOpen()));
        if (BukkitTools.isEventCancelled(preEvent)) {
            throw new TownyException(preEvent.getCancelMessage());
        }
        nation.setOpen(preEvent.getFutureState());
        TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_changed_open", nation.isOpen() ? Translatable.of("enabled") : Translatable.of("disabled")));
    }

    private static void nationToggleTaxPercent(CommandSender sender, Nation nation, Optional<Boolean> choice, boolean admin) throws TownyException {
        NationToggleTaxPercentEvent preEvent = new NationToggleTaxPercentEvent(sender, nation, admin, choice.orElse(!nation.isTaxPercentage()));
        if (BukkitTools.isEventCancelled(preEvent)) {
            throw new TownyException(preEvent.getCancelMessage());
        }
        nation.setTaxPercentage(preEvent.getFutureState());
        TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_changed_taxpercent", nation.isTaxPercentage() ? Translatable.of("enabled") : Translatable.of("disabled")));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_taxpercent", nation.isTaxPercentage() ? Translatable.of("enabled") : Translatable.of("disabled")));
        }
    }

    public static void nationRename(Player player, Nation nation, String newName) {
        try {
            BukkitTools.ifCancelledThenThrow(new NationPreRenameEvent(nation, newName));
            double renameCost = TownySettings.getNationRenameCost();
            if (TownyEconomyHandler.isActive() && renameCost > 0.0 && !nation.getAccount().withdraw(renameCost, String.format("Nation renamed to: %s", newName))) {
                throw new TownyException(Translatable.of("msg_err_no_money", TownyEconomyHandler.getFormattedBalance(renameCost)));
            }
            TownyUniverse.getInstance().getDataSource().renameNation(nation, newName);
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_set_name", player.getName(), nation.getName()));
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
        }
    }

    public static void nationSpawn(Player player, String[] split, boolean ignoreWarning) throws TownyException {
        Town town;
        Nation nation = NationCommand.getPlayerNationOrNationFromArg(player, split);
        if (TownySettings.isConqueredTownsDeniedNationSpawn() && (town = TownyAPI.getInstance().getTown(player)) != null && nation.hasTown(town) && town.isConquered()) {
            throw new TownyException(Translatable.of("nation_spawn_not_allowed_for_conquered_towns"));
        }
        String notAffordMSG = split.length == 0 ? Translatable.of("msg_err_cant_afford_tp").forLocale((CommandSender)player) : Translatable.of("msg_err_cant_afford_tp_nation", nation.getName()).forLocale((CommandSender)player);
        SpawnUtil.sendToTownySpawn(player, split, nation, notAffordMSG, false, ignoreWarning, SpawnType.NATION);
    }

    private static void nationTransaction(Player player, String[] args, boolean withdraw) {
        try {
            Resident resident = NationCommand.getResidentOrThrow(player);
            Nation nation = NationCommand.getNationFromResidentOrThrow(resident);
            if (args.length < 1 || args.length > 2) {
                throw new TownyException(Translatable.of("msg_must_specify_amnt", "/nation" + (withdraw ? " withdraw" : " deposit")));
            }
            int amount = "all".equalsIgnoreCase(args[0].trim()) ? (int)Math.floor(withdraw ? nation.getAccount().getHoldingBalance() : resident.getAccount().getHoldingBalance()) : MathUtil.getIntOrThrow(args[0].trim());
            if (amount == 0) {
                throw new TownyException(Translatable.of("msg_err_amount_must_be_greater_than_zero"));
            }
            if (args.length == 1) {
                if (withdraw) {
                    MoneyUtil.nationWithdraw(player, resident, nation, amount);
                } else {
                    MoneyUtil.nationDeposit(player, resident, nation, amount);
                }
                return;
            }
            if (withdraw) {
                throw new TownyException(Translatable.of("msg_must_specify_amnt", "/nation withdraw"));
            }
            NationCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_NATION_DEPOSIT_OTHER.getNode());
            Town town = NationCommand.getTownOrThrow(args[1]);
            if (!nation.hasTown(town)) {
                throw new TownyException(Translatable.of("msg_err_not_same_nation", town.getName()));
            }
            MoneyUtil.townDeposit(player, resident, town, nation, amount);
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
        }
    }

    private void nationStatusScreen(CommandSender sender, Nation nation) {
        TownyEconomyHandler.economyExecutor().execute(() -> TownyMessaging.sendStatusScreen(sender, TownyFormatter.getStatus(nation, sender)));
    }

    private int getPage(String[] split, int i) {
        int page = 1;
        if (split.length > i) {
            try {
                page = Integer.parseInt(split[i]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return page;
    }

    static {
        nationTabCompletes = Arrays.asList("list", "online", "leave", "withdraw", "deposit", "new", "create", "add", "kick", "delete", "enemy", "rank", "ranklist", "say", "set", "toggle", "invite", "join", "merge", "townlist", "allylist", "enemylist", "ally", "spawn", "sanctiontown", "king", "leader", "bankhistory", "baltop");
        nationSetTabCompletes = Arrays.asList("king", "leader", "capital", "board", "taxes", "name", "spawn", "spawncost", "title", "surname", "tag", "mapcolor", "conqueredtax", "taxpercentcap");
        nationSetBoardTabCompletes = Arrays.asList("none", "reset");
        nationListTabCompletes = Arrays.asList("residents", "balance", "founded", "name", "online", "open", "public", "townblocks", "towns", "upkeep");
        nationToggleTabCompletes = Arrays.asList("neutral", "peaceful", "public", "open", "taxpercent");
        nationEnemyTabCompletes = Arrays.asList("add", "remove");
        nationAllyTabCompletes = Arrays.asList("add", "remove", "sent", "received", "accept", "deny");
        nationKingTabCompletes = Collections.singletonList("?");
        nationConsoleTabCompletes = Arrays.asList("?", "help", "list");
    }
}

